/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.codecs;

import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.plugins.codecs.HTML4Decoder;
import org.codehaus.groovy.grails.plugins.codecs.HTML4Encoder;
import org.codehaus.groovy.grails.plugins.codecs.HTMLEncoder;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsApplicationAware;
import org.codehaus.groovy.grails.support.encoding.CodecFactory;
import org.codehaus.groovy.grails.support.encoding.CodecIdentifier;
import org.codehaus.groovy.grails.support.encoding.Decoder;
import org.codehaus.groovy.grails.support.encoding.Encoder;
import org.springframework.beans.factory.InitializingBean;

public final class HTMLCodec
implements CodecFactory,
GrailsApplicationAware,
InitializingBean {
    public static final String CONFIG_PROPERTY_GSP_HTMLCODEC = "grails.views.gsp.htmlcodec";
    static final String CODEC_NAME = "HTML";
    private GrailsApplication grailsApplication;
    private Encoder encoder;
    static final Encoder xml_encoder = new HTMLEncoder();
    static final Encoder html4_encoder = new HTML4Encoder(){

        public CodecIdentifier getCodecIdentifier() {
            return HTMLEncoder.HTML_CODEC_IDENTIFIER;
        }
    };
    static final Decoder decoder = new HTML4Decoder(){

        public CodecIdentifier getCodecIdentifier() {
            return HTMLEncoder.HTML_CODEC_IDENTIFIER;
        }
    };

    public HTMLCodec() {
        this.setUseLegacyEncoder(true);
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public Decoder getDecoder() {
        return decoder;
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    public void afterPropertiesSet() {
        if (this.grailsApplication == null || this.grailsApplication.getFlatConfig() == null) {
            return;
        }
        Object htmlCodecSetting = this.grailsApplication.getFlatConfig().get(CONFIG_PROPERTY_GSP_HTMLCODEC);
        if (htmlCodecSetting == null) {
            return;
        }
        String htmlCodecSettingStr = htmlCodecSetting.toString().toLowerCase();
        if (htmlCodecSettingStr.startsWith("xml") || "xhtml".equalsIgnoreCase(htmlCodecSettingStr)) {
            this.setUseLegacyEncoder(false);
        }
    }

    public void setUseLegacyEncoder(boolean useLegacyEncoder) {
        this.encoder = useLegacyEncoder ? html4_encoder : xml_encoder;
    }
}

