/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.codecs;

import org.codehaus.groovy.grails.plugins.codecs.AbstractCharReplacementEncoder;
import org.codehaus.groovy.grails.support.encoding.CodecIdentifier;
import org.codehaus.groovy.grails.support.encoding.DefaultCodecIdentifier;

public class XMLEncoder
extends AbstractCharReplacementEncoder {
    private static final String ESCAPED_APOS = "&#39;";
    private static final String ESCAPED_QUOTE = "&quot;";
    private static final String ESCAPED_GT = "&gt;";
    private static final String ESCAPED_LT = "&lt;";
    private static final String ESCAPED_AMP = "&amp;";
    private static final String ESCAPED_BACKSLASH = "&#92;";
    private static final char NBSP = '\u00a0';
    private static final String ESCAPED_NON_BREAKING_SPACE = "&#160;";
    private static final String ESCAPED_BACKTICK = "&#96;";
    private static final String ESCAPED_AT = "&#64;";
    public static final CodecIdentifier XML_CODEC_IDENTIFIER = new DefaultCodecIdentifier("XML");

    public XMLEncoder() {
        super(XML_CODEC_IDENTIFIER);
    }

    protected XMLEncoder(CodecIdentifier codecIdentifier) {
        super(codecIdentifier);
    }

    protected String escapeCharacter(char ch, char previousChar) {
        if (ch < ' ' && ch != '\t' && ch != '\n' && ch != '\r') {
            return "";
        }
        switch (ch) {
            case '&': {
                return ESCAPED_AMP;
            }
            case '<': {
                return ESCAPED_LT;
            }
            case '>': {
                return ESCAPED_GT;
            }
            case '\"': {
                return ESCAPED_QUOTE;
            }
            case '\'': {
                return ESCAPED_APOS;
            }
            case '\\': {
                return ESCAPED_BACKSLASH;
            }
            case '@': {
                return ESCAPED_AT;
            }
            case '`': {
                return ESCAPED_BACKTICK;
            }
            case '\u00a0': {
                return ESCAPED_NON_BREAKING_SPACE;
            }
        }
        return null;
    }
}

