/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.proxy;

import groovy.lang.DelegatingMetaClass;
import groovy.lang.MetaClass;
import java.io.Serializable;
import org.grails.datastore.mapping.core.Session;
import org.springframework.dao.DataIntegrityViolationException;

public class ProxyInstanceMetaClass
extends DelegatingMetaClass {
    private Session session;
    private Object proxyTarget;
    private Serializable key;

    public ProxyInstanceMetaClass(MetaClass delegate, Session session, Serializable key) {
        super(delegate);
        this.session = session;
        this.key = key;
    }

    public Object getProxyTarget() {
        if (this.proxyTarget == null) {
            this.proxyTarget = this.session.retrieve(this.getTheClass(), this.getKey());
            if (this.proxyTarget == null) {
                throw new DataIntegrityViolationException("Error loading association [" + String.valueOf(this.getKey()) + "] of type [" + String.valueOf(this.getTheClass()) + "]. Associated instance no longer exists.");
            }
        }
        return this.proxyTarget;
    }

    public Object invokeMethod(Object o, String methodName, Object[] arguments) {
        boolean resolveTarget = true;
        if (methodName.equals("isProxy")) {
            return true;
        }
        if (methodName.equals("getId")) {
            return this.getKey();
        }
        if (methodName.equals("isInitialized")) {
            return this.isProxyInitiated();
        }
        if (methodName.equals("getTarget") || methodName.equals("initialize")) {
            return this.getProxyTarget();
        }
        if (methodName.equals("getMetaClass")) {
            return this;
        }
        if (methodName.equals("getClass") || methodName.equals("getDomainClass")) {
            resolveTarget = this.isProxyInitiated();
        } else if (methodName.equals("setMetaClass") && arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof MetaClass)) {
            resolveTarget = false;
        }
        return this.delegate.invokeMethod(resolveTarget ? this.getProxyTarget() : o, methodName, arguments);
    }

    public Serializable getKey() {
        return this.key;
    }

    public boolean isProxyInitiated() {
        return this.proxyTarget != null;
    }

    public Object getProperty(Object object, String property) {
        if (property.equals("id")) {
            return this.getKey();
        }
        if (property.equals("proxy")) {
            return true;
        }
        if (property.equals("initialized")) {
            return this.isProxyInitiated();
        }
        if (property.equals("target")) {
            return this.getProxyTarget();
        }
        if (property.equals("metaClass")) {
            return this;
        }
        if (property.equals("class") || property.equals("domainClass")) {
            return this.delegate.getProperty(this.isProxyInitiated() ? this.proxyTarget : object, property);
        }
        return this.delegate.getProperty(this.getProxyTarget(), property);
    }

    public void setProperty(Object object, String property, Object newValue) {
        boolean resolveTarget = true;
        if (property.equals("metaClass") && (newValue == null || newValue instanceof MetaClass)) {
            resolveTarget = false;
        }
        this.delegate.setProperty(resolveTarget ? this.getProxyTarget() : object, property, newValue);
    }

    public Object getAttribute(Object object, String attribute) {
        if (attribute.equals("id")) {
            return this.getKey();
        }
        if (attribute.equals("initialized")) {
            return this.isProxyInitiated();
        }
        if (attribute.equals("target")) {
            return this.getProxyTarget();
        }
        return this.delegate.getAttribute(this.getProxyTarget(), attribute);
    }

    public void setAttribute(Object object, String attribute, Object newValue) {
        this.delegate.setAttribute(this.getProxyTarget(), attribute, newValue);
    }
}

