/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.events;

import grails.gorm.annotation.AutoTimestamp;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.grails.datastore.gorm.timestamp.DefaultTimestampProvider;
import org.grails.datastore.gorm.timestamp.TimestampProvider;
import org.grails.datastore.mapping.config.Entity;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.event.AbstractPersistenceEvent;
import org.grails.datastore.mapping.engine.event.AbstractPersistenceEventListener;
import org.grails.datastore.mapping.engine.event.EventType;
import org.grails.datastore.mapping.engine.event.PreInsertEvent;
import org.grails.datastore.mapping.engine.event.PreUpdateEvent;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;

public class AutoTimestampEventListener
extends AbstractPersistenceEventListener
implements MappingContext.Listener {
    @Value(value="${grails.gorm.events.autoTimestampInsertOverwrite:true}")
    boolean insertOverwrite = true;
    public static final String DATE_CREATED_PROPERTY = "dateCreated";
    public static final String LAST_UPDATED_PROPERTY = "lastUpdated";
    protected Map<String, Optional<Set<String>>> entitiesWithDateCreated = new ConcurrentHashMap<String, Optional<Set<String>>>();
    protected Map<String, Optional<Set<String>>> entitiesWithLastUpdated = new ConcurrentHashMap<String, Optional<Set<String>>>();
    protected Collection<String> uninitializedEntities = new ConcurrentLinkedQueue<String>();
    private TimestampProvider timestampProvider = new DefaultTimestampProvider();

    public AutoTimestampEventListener(Datastore datastore) {
        super(datastore);
        MappingContext mappingContext = datastore.getMappingContext();
        this.initForMappingContext(mappingContext);
    }

    protected AutoTimestampEventListener(MappingContext mappingContext) {
        super(null);
        this.initForMappingContext(mappingContext);
    }

    protected void initForMappingContext(MappingContext mappingContext) {
        for (PersistentEntity persistentEntity : mappingContext.getPersistentEntities()) {
            this.storeDateCreatedAndLastUpdatedInfo(persistentEntity);
        }
        mappingContext.addMappingContextListener((MappingContext.Listener)this);
    }

    protected void onPersistenceEvent(AbstractPersistenceEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        if (event.getEventType() == EventType.PreInsert) {
            this.beforeInsert(event.getEntity(), event.getEntityAccess());
        } else if (event.getEventType() == EventType.PreUpdate) {
            this.beforeUpdate(event.getEntity(), event.getEntityAccess());
        }
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return PreInsertEvent.class.isAssignableFrom(eventType) || PreUpdateEvent.class.isAssignableFrom(eventType);
    }

    public boolean beforeInsert(PersistentEntity entity, EntityAccess ea) {
        String name = entity.getName();
        this.initializeIfNecessary(entity, name);
        Class dateCreatedType = null;
        Object timestamp = null;
        Set<String> props = this.getDateCreatedPropertyNames(name);
        if (props != null) {
            for (String prop : props) {
                if (!this.insertOverwrite && ea.getPropertyValue(prop) != null) continue;
                dateCreatedType = ea.getPropertyType(prop);
                timestamp = this.timestampProvider.createTimestamp(dateCreatedType);
                ea.setProperty(prop, timestamp);
            }
        }
        if ((props = this.getLastUpdatedPropertyNames(name)) != null) {
            for (String prop : props) {
                if (!this.insertOverwrite && ea.getPropertyValue(prop) != null) continue;
                Class lastUpdateType = ea.getPropertyType(prop);
                if (dateCreatedType == null || !lastUpdateType.isAssignableFrom(dateCreatedType)) {
                    timestamp = this.timestampProvider.createTimestamp(lastUpdateType);
                }
                ea.setProperty(prop, timestamp);
            }
        }
        return true;
    }

    private void initializeIfNecessary(PersistentEntity entity, String name) {
        if (this.uninitializedEntities.contains(name)) {
            this.storeDateCreatedAndLastUpdatedInfo(entity);
            this.uninitializedEntities.remove(name);
        }
    }

    public boolean beforeUpdate(PersistentEntity entity, EntityAccess ea) {
        Set<String> props = this.getLastUpdatedPropertyNames(entity.getName());
        if (props != null) {
            for (String prop : props) {
                Class lastUpdateType = ea.getPropertyType(prop);
                Object timestamp = this.timestampProvider.createTimestamp(lastUpdateType);
                ea.setProperty(prop, timestamp);
            }
        }
        return true;
    }

    protected Set<String> getLastUpdatedPropertyNames(String entityName) {
        Optional<Set<String>> properties = this.entitiesWithLastUpdated.get(entityName);
        return properties == null ? null : (Set)properties.orElse(null);
    }

    protected Set<String> getDateCreatedPropertyNames(String entityName) {
        Optional<Set<String>> properties = this.entitiesWithDateCreated.get(entityName);
        return properties == null ? null : (Set)properties.orElse(null);
    }

    private static Field getFieldFromHierarchy(PersistentEntity persistentEntity, String fieldName) {
        Class clazz = persistentEntity.getJavaClass();
        while (clazz != null) {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                persistentEntity = persistentEntity.getParentEntity();
                clazz = persistentEntity == null ? null : persistentEntity.getJavaClass();
            }
        }
        return null;
    }

    protected void storeDateCreatedAndLastUpdatedInfo(PersistentEntity persistentEntity) {
        if (persistentEntity.isInitialized()) {
            ClassMapping classMapping = persistentEntity.getMapping();
            Entity mappedForm = classMapping.getMappedForm();
            if (mappedForm == null || mappedForm.isAutoTimestamp()) {
                for (PersistentProperty property : persistentEntity.getPersistentProperties()) {
                    if (property.getName().equals(LAST_UPDATED_PROPERTY)) {
                        this.storeTimestampAvailability(this.entitiesWithLastUpdated, persistentEntity, property);
                        continue;
                    }
                    if (property.getName().equals(DATE_CREATED_PROPERTY)) {
                        this.storeTimestampAvailability(this.entitiesWithDateCreated, persistentEntity, property);
                        continue;
                    }
                    Field field = AutoTimestampEventListener.getFieldFromHierarchy(persistentEntity, property.getName());
                    if (field == null || !field.isAnnotationPresent(AutoTimestamp.class)) continue;
                    AutoTimestamp autoTimestamp = field.getAnnotation(AutoTimestamp.class);
                    if (autoTimestamp.value() == AutoTimestamp.EventType.UPDATED) {
                        this.storeTimestampAvailability(this.entitiesWithLastUpdated, persistentEntity, property);
                        continue;
                    }
                    this.storeTimestampAvailability(this.entitiesWithDateCreated, persistentEntity, property);
                }
            }
        } else {
            this.uninitializedEntities.add(persistentEntity.getName());
        }
    }

    protected void storeTimestampAvailability(Map<String, Optional<Set<String>>> timestampAvailabilityMap, PersistentEntity persistentEntity, PersistentProperty<?> property) {
        if (property != null && this.timestampProvider.supportsCreating(property.getType())) {
            Optional timestampProperties = timestampAvailabilityMap.computeIfAbsent(persistentEntity.getName(), k -> Optional.of(new HashSet()));
            if (timestampProperties.isPresent()) {
                ((Set)timestampProperties.get()).add(property.getName());
            } else {
                throw new IllegalStateException("Timestamp properties for entity [" + persistentEntity.getName() + "] have been disabled. Cannot add property [" + property.getName() + "]");
            }
        }
    }

    public void persistentEntityAdded(PersistentEntity entity) {
        this.storeDateCreatedAndLastUpdatedInfo(entity);
    }

    public TimestampProvider getTimestampProvider() {
        return this.timestampProvider;
    }

    public void setTimestampProvider(TimestampProvider timestampProvider) {
        this.timestampProvider = timestampProvider;
    }

    private void processAllEntries(Set<Map.Entry<String, Optional<Set<String>>>> entries, Runnable runnable) {
        LinkedHashMap<String, Optional<Set<String>>> originalValues = new LinkedHashMap<String, Optional<Set<String>>>();
        for (Map.Entry<String, Optional<Set<String>>> entry : entries) {
            originalValues.put(entry.getKey(), entry.getValue());
            entry.setValue(Optional.empty());
        }
        runnable.run();
        for (Map.Entry<String, Optional<Set<String>>> entry : entries) {
            entry.setValue((Optional)originalValues.get(entry.getKey()));
        }
    }

    private void processEntries(List<Class> classes, Map<String, Optional<Set<String>>> entities, Runnable runnable) {
        HashSet<Map.Entry<String, Optional<Set<String>>>> entries = new HashSet<Map.Entry<String, Optional<Set<String>>>>();
        ArrayList<String> classNames = new ArrayList<String>(classes.size());
        for (Class clazz : classes) {
            classNames.add(clazz.getName());
        }
        for (Map.Entry entry : entities.entrySet()) {
            if (!classNames.contains(entry.getKey())) continue;
            entries.add(entry);
        }
        this.processAllEntries(entries, runnable);
    }

    public void withoutLastUpdated(Runnable runnable) {
        this.processAllEntries(this.entitiesWithLastUpdated.entrySet(), runnable);
    }

    public void withoutLastUpdated(List<Class> classes, Runnable runnable) {
        this.processEntries(classes, this.entitiesWithLastUpdated, runnable);
    }

    public void withoutLastUpdated(Class clazz, Runnable runnable) {
        ArrayList<Class> list = new ArrayList<Class>(1);
        list.add(clazz);
        this.withoutLastUpdated(list, runnable);
    }

    public void withoutDateCreated(Runnable runnable) {
        this.processAllEntries(this.entitiesWithDateCreated.entrySet(), runnable);
    }

    public void withoutDateCreated(List<Class> classes, Runnable runnable) {
        this.processEntries(classes, this.entitiesWithDateCreated, runnable);
    }

    public void withoutDateCreated(Class clazz, Runnable runnable) {
        ArrayList<Class> list = new ArrayList<Class>(1);
        list.add(clazz);
        this.withoutDateCreated(list, runnable);
    }

    public void withoutTimestamps(Runnable runnable) {
        this.withoutDateCreated(() -> this.withoutLastUpdated(runnable));
    }

    public void withoutTimestamps(List<Class> classes, Runnable runnable) {
        this.withoutDateCreated(classes, () -> this.withoutLastUpdated(classes, runnable));
    }

    public void withoutTimestamps(Class clazz, Runnable runnable) {
        this.withoutDateCreated(clazz, () -> this.withoutLastUpdated(clazz, runnable));
    }
}

