/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.jdbc.connections;

import javax.sql.DataSource;
import org.grails.datastore.gorm.jdbc.connections.DataSourceConnectionSource;
import org.grails.datastore.gorm.jdbc.connections.DataSourceConnectionSourceFactory;
import org.grails.datastore.gorm.jdbc.connections.DataSourceSettings;
import org.grails.datastore.mapping.core.connections.ConnectionSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringDataSourceConnectionSourceFactory
extends DataSourceConnectionSourceFactory
implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public ConnectionSource<DataSource, DataSourceSettings> create(String name, DataSourceSettings settings) {
        Object dataSourceName = "DEFAULT".equals(name) ? "dataSource" : "dataSource_" + name;
        dataSourceName = "dataSource".equals(name) ? "dataSource" : dataSourceName;
        try {
            DataSource springDataSource = (DataSource)this.applicationContext.getBean((String)dataSourceName, DataSource.class);
            return new DataSourceConnectionSource(name, springDataSource, settings);
        }
        catch (NoSuchBeanDefinitionException e) {
            return super.create(name, settings);
        }
    }
}

