/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.finders;

import groovy.lang.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.Restrictions;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.Assert;

public abstract class MethodExpression {
    protected String propertyName;
    protected Object[] arguments;
    protected int argumentsRequired = 1;
    @Deprecated
    protected Class<?> targetClass;

    public abstract Query.Criterion createCriterion();

    protected MethodExpression(Class<?> targetClass, String propertyName) {
        this.propertyName = propertyName;
    }

    protected MethodExpression(String propertyName) {
        this.propertyName = propertyName;
    }

    public int getArgumentsRequired() {
        return this.argumentsRequired;
    }

    public void convertArguments(PersistentEntity persistentEntity) {
        ConversionService conversionService = persistentEntity.getMappingContext().getConversionService();
        PersistentProperty prop = persistentEntity.getPropertyByName(this.propertyName);
        if (prop == null && this.propertyName.equals(persistentEntity.getIdentity().getName())) {
            prop = persistentEntity.getIdentity();
        }
        if (prop != null && this.arguments != null && this.argumentsRequired > 0) {
            Class type = prop.getType();
            for (int i = 0; i < this.argumentsRequired; ++i) {
                TypeDescriptor typeDescriptor;
                Object arg = this.arguments[i];
                if (arg == null || type.isAssignableFrom(arg.getClass())) continue;
                if (arg instanceof CharSequence && arg.getClass() != String.class) {
                    this.arguments[i] = arg = arg.toString();
                    if (type.isAssignableFrom(arg.getClass())) break;
                }
                if (((typeDescriptor = TypeDescriptor.valueOf((Class)type)).isArray() || typeDescriptor.isCollection()) && (typeDescriptor.getElementTypeDescriptor() == null || typeDescriptor.getElementTypeDescriptor().getType().isAssignableFrom(arg.getClass()))) break;
                if (!conversionService.canConvert(arg.getClass(), type)) continue;
                this.arguments[i] = conversionService.convert(arg, type);
            }
        }
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    public Object[] getArguments() {
        return Arrays.copyOf(this.arguments, this.arguments.length);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    private static void convertArgumentsForProp(PersistentEntity persistentEntity, PersistentProperty<?> prop, String propertyName, Object[] arguments, ConversionService conversionService) {
        if (prop == null && propertyName.equals(persistentEntity.getIdentity().getName())) {
            prop = persistentEntity.getIdentity();
        }
        if (prop != null) {
            List converted;
            Class type = prop.getType();
            Collection collection = (Collection)arguments[0];
            if (collection == null) {
                converted = Collections.emptyList();
            } else {
                converted = new ArrayList(collection.size());
                for (Object o : collection) {
                    if (o != null && !type.isAssignableFrom(o.getClass())) {
                        o = conversionService.convert(o, type);
                    }
                    converted.add(o);
                }
            }
            arguments[0] = converted;
        }
    }

    public static class NotEqual
    extends MethodExpression {
        public NotEqual(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
        }

        public NotEqual(String propertyName) {
            super(propertyName);
        }

        @Override
        public Query.Criterion createCriterion() {
            Object argument = this.arguments[0];
            if (argument != null) {
                return Restrictions.ne((String)this.propertyName, (Object)this.arguments[0]);
            }
            return Restrictions.isNotNull((String)this.propertyName);
        }
    }

    public static class Equal
    extends MethodExpression {
        public Equal(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
        }

        public Equal(String propertyName) {
            super(propertyName);
        }

        @Override
        public Query.Criterion createCriterion() {
            Object argument = this.arguments[0];
            if (argument != null) {
                return Restrictions.eq((String)this.propertyName, (Object)argument);
            }
            return Restrictions.isNull((String)this.propertyName);
        }
    }

    public static class IsNotEmpty
    extends MethodExpression {
        public IsNotEmpty(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
            this.argumentsRequired = 0;
        }

        public IsNotEmpty(String propertyName) {
            super(propertyName);
            this.argumentsRequired = 0;
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.isNotEmpty((String)this.propertyName);
        }
    }

    public static class IsEmpty
    extends MethodExpression {
        public IsEmpty(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
            this.argumentsRequired = 0;
        }

        public IsEmpty(String propertyName) {
            super(propertyName);
            this.argumentsRequired = 0;
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.isEmpty((String)this.propertyName);
        }
    }

    public static class IsNotNull
    extends MethodExpression {
        public IsNotNull(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
            this.argumentsRequired = 0;
        }

        public IsNotNull(String propertyName) {
            super(propertyName);
            this.argumentsRequired = 0;
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.isNotNull((String)this.propertyName);
        }
    }

    public static class IsNull
    extends MethodExpression {
        public IsNull(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
            this.argumentsRequired = 0;
        }

        public IsNull(String propertyName) {
            super(propertyName);
            this.argumentsRequired = 0;
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.isNull((String)this.propertyName);
        }
    }

    public static class InRange
    extends MethodExpression {
        public InRange(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
            this.argumentsRequired = 1;
        }

        public InRange(String propertyName) {
            super(propertyName);
            this.argumentsRequired = 1;
        }

        @Override
        public Query.Criterion createCriterion() {
            Range range = (Range)this.arguments[0];
            return Restrictions.between((String)this.propertyName, (Object)range.getFrom(), (Object)range.getTo());
        }

        @Override
        public void convertArguments(PersistentEntity persistentEntity) {
        }

        @Override
        public void setArguments(Object[] arguments) {
            Assert.isTrue((arguments.length == 1 ? 1 : 0) != 0, (String)"An 'inRange' query requires exactly 1 argument");
            Assert.isTrue((boolean)(arguments[0] instanceof Range), (String)"An 'inRange' query requires a Range argument");
            super.setArguments(arguments);
        }
    }

    public static class Between
    extends MethodExpression {
        public Between(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
            this.argumentsRequired = 2;
        }

        public Between(String propertyName) {
            super(propertyName);
            this.argumentsRequired = 2;
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.between((String)this.propertyName, (Object)this.arguments[0], (Object)this.arguments[1]);
        }

        @Override
        public void setArguments(Object[] arguments) {
            Assert.isTrue((arguments.length > 1 ? 1 : 0) != 0, (String)"A 'between' query requires at least two arguments");
            Assert.isTrue((arguments[0] instanceof Comparable && arguments[1] instanceof Comparable ? 1 : 0) != 0, (String)"A 'between' query requires that both arguments are comparable");
            super.setArguments(arguments);
        }
    }

    public static class InList
    extends MethodExpression {
        public InList(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
        }

        public InList(String propertyName) {
            super(propertyName);
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.in((String)this.propertyName, (Collection)((Collection)this.arguments[0]));
        }

        @Override
        public void setArguments(Object[] arguments) {
            Assert.isTrue((arguments.length > 0 ? 1 : 0) != 0, (String)"Only a collection of elements is supported in an 'in' query");
            Object arg = arguments[0];
            Assert.isTrue((arg instanceof Collection || arg == null ? 1 : 0) != 0, (String)"Only a collection of elements is supported in an 'in' query");
            super.setArguments(arguments);
        }

        @Override
        public void convertArguments(PersistentEntity persistentEntity) {
            ConversionService conversionService = persistentEntity.getMappingContext().getConversionService();
            PersistentProperty prop = persistentEntity.getPropertyByName(this.propertyName);
            MethodExpression.convertArgumentsForProp(persistentEntity, prop, this.propertyName, this.arguments, conversionService);
        }
    }

    public static class NotInList
    extends MethodExpression {
        public NotInList(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
        }

        public NotInList(String propertyName) {
            super(propertyName);
        }

        @Override
        public Query.Criterion createCriterion() {
            Query.Negation negation = new Query.Negation();
            negation.add((Query.Criterion)Restrictions.in((String)this.propertyName, (Collection)((Collection)this.arguments[0])));
            return negation;
        }

        @Override
        public void setArguments(Object[] arguments) {
            Assert.isTrue((arguments.length > 0 ? 1 : 0) != 0, (String)"Only a collection of elements is supported in an 'in' query");
            Object arg = arguments[0];
            Assert.isTrue((arg instanceof Collection || arg == null ? 1 : 0) != 0, (String)"Only a collection of elements is supported in an 'in' query");
            super.setArguments(arguments);
        }

        @Override
        public void convertArguments(PersistentEntity persistentEntity) {
            ConversionService conversionService = persistentEntity.getMappingContext().getConversionService();
            String propertyName = this.propertyName;
            PersistentProperty prop = persistentEntity.getPropertyByName(propertyName);
            Object[] arguments = this.arguments;
            MethodExpression.convertArgumentsForProp(persistentEntity, prop, propertyName, arguments, conversionService);
        }
    }

    public static class Rlike
    extends MethodExpression {
        public Rlike(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
        }

        public Rlike(String propertyName) {
            super(propertyName);
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.rlike((String)this.propertyName, (String)this.arguments[0].toString());
        }
    }

    public static class Ilike
    extends MethodExpression {
        public Ilike(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
        }

        public Ilike(String propertyName) {
            super(propertyName);
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.ilike((String)this.propertyName, (String)this.arguments[0].toString());
        }
    }

    public static class Like
    extends MethodExpression {
        public Like(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
        }

        public Like(String propertyName) {
            super(propertyName);
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.like((String)this.propertyName, (String)this.arguments[0].toString());
        }
    }

    public static class LessThanEquals
    extends MethodExpression {
        public LessThanEquals(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
        }

        public LessThanEquals(String propertyName) {
            super(propertyName);
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.lte((String)this.propertyName, (Object)this.arguments[0]);
        }
    }

    public static class LessThan
    extends MethodExpression {
        public LessThan(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
        }

        public LessThan(String propertyName) {
            super(propertyName);
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.lt((String)this.propertyName, (Object)this.arguments[0]);
        }
    }

    public static class GreaterThanEquals
    extends MethodExpression {
        public GreaterThanEquals(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
        }

        public GreaterThanEquals(String propertyName) {
            super(propertyName);
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.gte((String)this.propertyName, (Object)this.arguments[0]);
        }
    }

    public static class GreaterThan
    extends MethodExpression {
        public GreaterThan(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
        }

        public GreaterThan(String propertyName) {
            super(propertyName);
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.gt((String)this.propertyName, (Object)this.arguments[0]);
        }
    }
}

