/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.grails.datastore.gorm.timestamp.DefaultTimestampProvider;
import org.grails.datastore.gorm.timestamp.TimestampProvider;
import org.grails.datastore.mapping.config.Entity;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.event.AbstractPersistenceEvent;
import org.grails.datastore.mapping.engine.event.AbstractPersistenceEventListener;
import org.grails.datastore.mapping.engine.event.EventType;
import org.grails.datastore.mapping.engine.event.PreInsertEvent;
import org.grails.datastore.mapping.engine.event.PreUpdateEvent;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.springframework.context.ApplicationEvent;

public class AutoTimestampEventListener
extends AbstractPersistenceEventListener
implements MappingContext.Listener {
    public static final String DATE_CREATED_PROPERTY = "dateCreated";
    public static final String LAST_UPDATED_PROPERTY = "lastUpdated";
    protected Map<String, Boolean> entitiesWithDateCreated = new ConcurrentHashMap<String, Boolean>();
    protected Map<String, Boolean> entitiesWithLastUpdated = new ConcurrentHashMap<String, Boolean>();
    protected Collection<String> uninitializedEntities = new ConcurrentLinkedQueue<String>();
    private TimestampProvider timestampProvider = new DefaultTimestampProvider();

    public AutoTimestampEventListener(Datastore datastore) {
        super(datastore);
        MappingContext mappingContext = datastore.getMappingContext();
        this.initForMappingContext(mappingContext);
    }

    protected AutoTimestampEventListener(MappingContext mappingContext) {
        super(null);
        this.initForMappingContext(mappingContext);
    }

    protected void initForMappingContext(MappingContext mappingContext) {
        for (PersistentEntity persistentEntity : mappingContext.getPersistentEntities()) {
            this.storeDateCreatedAndLastUpdatedInfo(persistentEntity);
        }
        mappingContext.addMappingContextListener((MappingContext.Listener)this);
    }

    protected void onPersistenceEvent(AbstractPersistenceEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        if (event.getEventType() == EventType.PreInsert) {
            this.beforeInsert(event.getEntity(), event.getEntityAccess());
        } else if (event.getEventType() == EventType.PreUpdate) {
            this.beforeUpdate(event.getEntity(), event.getEntityAccess());
        }
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return PreInsertEvent.class.isAssignableFrom(eventType) || PreUpdateEvent.class.isAssignableFrom(eventType);
    }

    public boolean beforeInsert(PersistentEntity entity, EntityAccess ea) {
        String name = entity.getName();
        this.initializeIfNecessary(entity, name);
        Class dateCreatedType = null;
        Object timestamp = null;
        if (this.hasDateCreated(name)) {
            dateCreatedType = ea.getPropertyType(DATE_CREATED_PROPERTY);
            timestamp = this.timestampProvider.createTimestamp(dateCreatedType);
            ea.setProperty(DATE_CREATED_PROPERTY, timestamp);
        }
        if (this.hasLastUpdated(name)) {
            Class lastUpdateType = ea.getPropertyType(LAST_UPDATED_PROPERTY);
            if (dateCreatedType == null || !lastUpdateType.isAssignableFrom(dateCreatedType)) {
                timestamp = this.timestampProvider.createTimestamp(lastUpdateType);
            }
            ea.setProperty(LAST_UPDATED_PROPERTY, timestamp);
        }
        return true;
    }

    private void initializeIfNecessary(PersistentEntity entity, String name) {
        if (this.uninitializedEntities.contains(name)) {
            this.storeDateCreatedAndLastUpdatedInfo(entity);
            this.uninitializedEntities.remove(name);
        }
    }

    public boolean beforeUpdate(PersistentEntity entity, EntityAccess ea) {
        if (this.hasLastUpdated(entity.getName())) {
            Class lastUpdateType = ea.getPropertyType(LAST_UPDATED_PROPERTY);
            Object timestamp = this.timestampProvider.createTimestamp(lastUpdateType);
            ea.setProperty(LAST_UPDATED_PROPERTY, timestamp);
        }
        return true;
    }

    protected boolean hasLastUpdated(PersistentEntity entity) {
        return this.hasLastUpdated(entity.getName());
    }

    protected boolean hasLastUpdated(String n) {
        return this.entitiesWithLastUpdated.containsKey(n) && this.entitiesWithLastUpdated.get(n) != false;
    }

    protected boolean hasDateCreated(PersistentEntity entity) {
        return this.hasDateCreated(entity.getName());
    }

    protected boolean hasDateCreated(String n) {
        return this.entitiesWithDateCreated.containsKey(n) && this.entitiesWithDateCreated.get(n) != false;
    }

    protected void storeDateCreatedAndLastUpdatedInfo(PersistentEntity persistentEntity) {
        if (persistentEntity.isInitialized()) {
            ClassMapping classMapping = persistentEntity.getMapping();
            Entity mappedForm = classMapping.getMappedForm();
            if (mappedForm == null || mappedForm.isAutoTimestamp()) {
                this.storeTimestampAvailability(this.entitiesWithDateCreated, persistentEntity, persistentEntity.getPropertyByName(DATE_CREATED_PROPERTY));
                this.storeTimestampAvailability(this.entitiesWithLastUpdated, persistentEntity, persistentEntity.getPropertyByName(LAST_UPDATED_PROPERTY));
            }
        } else {
            this.uninitializedEntities.add(persistentEntity.getName());
        }
    }

    protected void storeTimestampAvailability(Map<String, Boolean> timestampAvailabilityMap, PersistentEntity persistentEntity, PersistentProperty<?> property) {
        timestampAvailabilityMap.put(persistentEntity.getName(), property != null && this.timestampProvider.supportsCreating(property.getType()));
    }

    public void persistentEntityAdded(PersistentEntity entity) {
        this.storeDateCreatedAndLastUpdatedInfo(entity);
    }

    public TimestampProvider getTimestampProvider() {
        return this.timestampProvider;
    }

    public void setTimestampProvider(TimestampProvider timestampProvider) {
        this.timestampProvider = timestampProvider;
    }

    private void processAllEntries(Set<Map.Entry<String, Boolean>> entries, Runnable runnable) {
        LinkedHashMap<String, Boolean> originalValues = new LinkedHashMap<String, Boolean>();
        for (Map.Entry<String, Boolean> entry : entries) {
            originalValues.put(entry.getKey(), entry.getValue());
            entry.setValue(false);
        }
        runnable.run();
        for (Map.Entry<String, Boolean> entry : entries) {
            entry.setValue((Boolean)originalValues.get(entry.getKey()));
        }
    }

    private void processEntries(List<Class> classes, Map<String, Boolean> entities, Runnable runnable) {
        HashSet<Map.Entry<String, Boolean>> entries = new HashSet<Map.Entry<String, Boolean>>();
        ArrayList<String> classNames = new ArrayList<String>(classes.size());
        for (Class clazz : classes) {
            classNames.add(clazz.getName());
        }
        for (Map.Entry entry : entities.entrySet()) {
            if (!classNames.contains(entry.getKey())) continue;
            entries.add(entry);
        }
        this.processAllEntries(entries, runnable);
    }

    public void withoutLastUpdated(Runnable runnable) {
        this.processAllEntries(this.entitiesWithLastUpdated.entrySet(), runnable);
    }

    public void withoutLastUpdated(List<Class> classes, Runnable runnable) {
        this.processEntries(classes, this.entitiesWithLastUpdated, runnable);
    }

    public void withoutLastUpdated(Class clazz, Runnable runnable) {
        ArrayList<Class> list = new ArrayList<Class>(1);
        list.add(clazz);
        this.withoutLastUpdated(list, runnable);
    }

    public void withoutDateCreated(Runnable runnable) {
        this.processAllEntries(this.entitiesWithDateCreated.entrySet(), runnable);
    }

    public void withoutDateCreated(List<Class> classes, Runnable runnable) {
        this.processEntries(classes, this.entitiesWithDateCreated, runnable);
    }

    public void withoutDateCreated(Class clazz, Runnable runnable) {
        ArrayList<Class> list = new ArrayList<Class>(1);
        list.add(clazz);
        this.withoutDateCreated(list, runnable);
    }

    public void withoutTimestamps(final Runnable runnable) {
        this.withoutDateCreated(new Runnable(){

            @Override
            public void run() {
                AutoTimestampEventListener.this.withoutLastUpdated(runnable);
            }
        });
    }

    public void withoutTimestamps(final List<Class> classes, final Runnable runnable) {
        this.withoutDateCreated(classes, new Runnable(){

            @Override
            public void run() {
                AutoTimestampEventListener.this.withoutLastUpdated(classes, runnable);
            }
        });
    }

    public void withoutTimestamps(final Class clazz, final Runnable runnable) {
        this.withoutDateCreated(clazz, new Runnable(){

            @Override
            public void run() {
                AutoTimestampEventListener.this.withoutLastUpdated(clazz, runnable);
            }
        });
    }
}

