/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.query;

import java.io.Closeable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractResultList
extends AbstractList
implements Closeable {
    protected int offset = 0;
    protected final List initializedObjects;
    private int internalIndex;
    private Integer size;
    protected boolean initialized = false;
    protected Iterator<Object> cursor;

    public AbstractResultList(int offset, Iterator<Object> cursor) {
        this(offset, -1, cursor);
    }

    public AbstractResultList(int offset, Integer size, Iterator<Object> cursor) {
        boolean hasSize;
        this.offset = offset;
        boolean bl = hasSize = size != null && size > -1;
        if (hasSize) {
            this.size = size;
        }
        this.cursor = cursor;
        this.initialized = !cursor.hasNext();
        this.initializedObjects = hasSize ? new ArrayList(size) : new ArrayList();
    }

    public Iterator<Object> getCursor() {
        return this.cursor;
    }

    protected void initializeFully() {
        if (this.initialized) {
            return;
        }
        while (this.cursor.hasNext()) {
            this.convertObject();
        }
        this.initialized = true;
    }

    @Override
    public boolean isEmpty() {
        if (this.initialized) {
            return this.initializedObjects.isEmpty();
        }
        return this.initializedObjects.isEmpty() && !this.cursor.hasNext();
    }

    @Override
    public Object get(int index) {
        List initializedObjects = this.initializedObjects;
        int initializedSize = initializedObjects.size();
        if (initializedSize > index) {
            return initializedObjects.get(index);
        }
        if (!this.initialized) {
            while (this.cursor.hasNext()) {
                Object o = this.convertObject();
                if (index == this.internalIndex) {
                    return o;
                }
                if (index >= initializedSize) continue;
                return initializedObjects.get(index);
            }
            this.initialized = true;
        }
        return initializedObjects.get(index);
    }

    protected Object convertObject() {
        Object next = this.convertObject(this.nextDecoded());
        if (!this.cursor.hasNext()) {
            this.initialized = true;
        }
        this.initializedObjects.add(next);
        this.internalIndex = this.initializedObjects.size();
        return next;
    }

    protected Object convertObject(Object o) {
        return o;
    }

    protected abstract Object nextDecoded();

    @Override
    public Object set(int index, Object o) {
        Object previous = this.get(index);
        this.initializedObjects.set(index, o);
        return previous;
    }

    @Override
    public void add(int index, Object element) {
        this.initializeFully();
        this.initializedObjects.add(index, element);
    }

    @Override
    public Object remove(int index) {
        this.initializeFully();
        return this.initializedObjects.remove(index);
    }

    @Override
    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator listIterator(int index) {
        this.initializeFully();
        return this.initializedObjects.listIterator(index);
    }

    @Override
    public Iterator iterator() {
        if (this.initialized || !this.initializedObjects.isEmpty()) {
            if (!this.initialized) {
                this.initializeFully();
            }
            return this.initializedObjects.iterator();
        }
        return new Iterator(){
            int iteratorIndex = 0;
            Object current;

            @Override
            public boolean hasNext() {
                if (this.iteratorIndex < AbstractResultList.this.internalIndex) {
                    return true;
                }
                if (!AbstractResultList.this.initialized) {
                    boolean hasMore = AbstractResultList.this.cursor.hasNext();
                    if (!hasMore) {
                        AbstractResultList.this.initialized = true;
                    }
                    return hasMore;
                }
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object next() {
                this.current = this.iteratorIndex < AbstractResultList.this.internalIndex ? AbstractResultList.this.initializedObjects.get(this.iteratorIndex) : AbstractResultList.this.convertObject();
                try {
                    Object object = this.current;
                    return object;
                }
                finally {
                    ++this.iteratorIndex;
                }
            }

            @Override
            public void remove() {
                if (this.current != null) {
                    AbstractResultList.this.initializedObjects.remove(this.current);
                }
            }
        };
    }

    @Override
    public int size() {
        if (this.initialized) {
            return this.initializedObjects.size();
        }
        if (this.size == null) {
            this.initializeFully();
            this.size = this.initializedObjects.size();
        }
        return this.size;
    }
}

