/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.multitenancy;

import grails.gorm.multitenancy.Tenants;
import java.io.Serializable;
import org.grails.datastore.gorm.GormEnhancer;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.engine.event.PersistenceEventListener;
import org.grails.datastore.mapping.engine.event.PreInsertEvent;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.types.TenantId;
import org.grails.datastore.mapping.multitenancy.exceptions.TenantException;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.event.PostQueryEvent;
import org.grails.datastore.mapping.query.event.PreQueryEvent;
import org.grails.datastore.mapping.reflect.EntityReflector;
import org.springframework.context.ApplicationEvent;

public class MultiTenantEventListener
implements PersistenceEventListener {
    protected final Datastore datastore;

    public MultiTenantEventListener(Datastore datastore) {
        this.datastore = datastore;
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return PreQueryEvent.class.isAssignableFrom(eventType) || PostQueryEvent.class.isAssignableFrom(eventType) || PreInsertEvent.class.isAssignableFrom(eventType);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return Datastore.class.isAssignableFrom(sourceType);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.supportsEventType(event.getClass())) {
            PreInsertEvent preInsertEvent;
            PersistentEntity entity;
            Datastore datastore = (Datastore)event.getSource();
            if (event instanceof PreQueryEvent) {
                PreQueryEvent preQueryEvent = (PreQueryEvent)event;
                Query query = preQueryEvent.getQuery();
                PersistentEntity entity2 = query.getEntity();
                if (entity2.isMultiTenant()) {
                    TenantId tenantId;
                    if (datastore == null) {
                        datastore = GormEnhancer.findDatastore(entity2.getJavaClass());
                    }
                    if (this.supportsSourceType(datastore.getClass()) && this.datastore.equals(datastore) && (tenantId = entity2.getTenantId()) != null) {
                        Serializable currentId = Tenants.currentId(datastore.getClass());
                        query.eq(tenantId.getName(), (Object)currentId);
                    }
                }
            } else if (event instanceof PreInsertEvent && (entity = (preInsertEvent = (PreInsertEvent)event).getEntity()).isMultiTenant()) {
                Serializable currentId;
                TenantId tenantId = entity.getTenantId();
                EntityReflector reflector = entity.getReflector();
                if (datastore == null) {
                    datastore = GormEnhancer.findDatastore(entity.getJavaClass());
                }
                if (this.supportsSourceType(datastore.getClass()) && this.datastore.equals(datastore) && (currentId = Tenants.currentId(datastore.getClass())) != null) {
                    try {
                        reflector.setProperty(preInsertEvent.getEntityObject(), tenantId.getName(), (Object)currentId);
                    }
                    catch (Exception e) {
                        throw new TenantException("Could not assigned tenant id [" + currentId + "] to property [" + tenantId + "], probably due to a type mismatch. You should return a type from the tenant resolver that matches the property type of the tenant id!: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    public int getOrder() {
        return 0x3FFFFFFF;
    }
}

