/*
 * Decompiled with CFR 0.152.
 */
package grails.gorm;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.grails.datastore.mapping.query.Query;

public class PagedResultList<E>
implements Serializable,
List<E> {
    private static final long serialVersionUID = -5820655628956173929L;
    private Query query;
    protected List<E> resultList;
    protected int totalCount = Integer.MIN_VALUE;

    public PagedResultList(Query query) {
        this.query = query;
    }

    public int getTotalCount() {
        this.initialize();
        if (this.totalCount == Integer.MIN_VALUE) {
            Query newQuery = (Query)this.query.clone();
            newQuery.projections().count();
            Number result = (Number)newQuery.singleResult();
            this.totalCount = result == null ? 0 : result.intValue();
        }
        return this.totalCount;
    }

    @Override
    public E get(int i) {
        this.initialize();
        return this.resultList.get(i);
    }

    @Override
    public E set(int i, E o) {
        this.initialize();
        return this.resultList.set(i, o);
    }

    @Override
    public E remove(int i) {
        this.initialize();
        return this.resultList.remove(i);
    }

    @Override
    public int indexOf(Object o) {
        this.initialize();
        return this.resultList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        this.initialize();
        return this.resultList.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        this.initialize();
        return this.resultList.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        this.initialize();
        return this.resultList.listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        this.initialize();
        return this.resultList.subList(fromIndex, toIndex);
    }

    @Override
    public void add(int i, E o) {
        this.initialize();
        this.resultList.add(i, o);
    }

    protected void initialize() {
        if (this.resultList == null) {
            this.resultList = this.query.list();
        }
    }

    @Override
    public int size() {
        this.initialize();
        return this.resultList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        this.initialize();
        return this.resultList.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        this.initialize();
        return this.resultList.iterator();
    }

    @Override
    public Object[] toArray() {
        this.initialize();
        return this.resultList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.initialize();
        return this.resultList.toArray(a);
    }

    @Override
    public boolean add(E e) {
        this.initialize();
        return this.resultList.add(e);
    }

    @Override
    public boolean remove(Object o) {
        this.initialize();
        return this.resultList.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.initialize();
        return this.resultList.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.initialize();
        return this.resultList.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.initialize();
        return this.resultList.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.initialize();
        return this.resultList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.initialize();
        return this.resultList.retainAll(c);
    }

    @Override
    public void clear() {
        this.resultList = new ArrayList();
    }

    @Override
    public boolean equals(Object o) {
        this.initialize();
        return this.resultList.equals(o);
    }

    @Override
    public int hashCode() {
        this.initialize();
        return this.resultList.hashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.getTotalCount();
        out.defaultWriteObject();
    }
}

