/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.events;

import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.dirty.checking.DirtyCheckable;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.event.AbstractPersistenceEvent;
import org.grails.datastore.mapping.engine.event.AbstractPersistenceEventListener;
import org.grails.datastore.mapping.engine.event.PostDeleteEvent;
import org.grails.datastore.mapping.engine.event.PostInsertEvent;
import org.grails.datastore.mapping.engine.event.PostLoadEvent;
import org.grails.datastore.mapping.engine.event.PostUpdateEvent;
import org.grails.datastore.mapping.engine.event.PreDeleteEvent;
import org.grails.datastore.mapping.engine.event.PreInsertEvent;
import org.grails.datastore.mapping.engine.event.PreLoadEvent;
import org.grails.datastore.mapping.engine.event.PreUpdateEvent;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.springframework.context.ApplicationEvent;
import org.springframework.util.ReflectionUtils;

public class DomainEventListener
extends AbstractPersistenceEventListener
implements MappingContext.Listener {
    private Map<PersistentEntity, Map<String, Method>> entityEvents = new ConcurrentHashMap<PersistentEntity, Map<String, Method>>();
    public static final Class[] ZERO_PARAMS = new Class[0];
    public static final String EVENT_BEFORE_INSERT = "beforeInsert";
    private static final String EVENT_BEFORE_UPDATE = "beforeUpdate";
    private static final String EVENT_BEFORE_DELETE = "beforeDelete";
    private static final String EVENT_BEFORE_LOAD = "beforeLoad";
    private static final String EVENT_AFTER_INSERT = "afterInsert";
    private static final String EVENT_AFTER_UPDATE = "afterUpdate";
    private static final String EVENT_AFTER_DELETE = "afterDelete";
    private static final String EVENT_AFTER_LOAD = "afterLoad";
    private static final List<String> REFRESH_EVENTS = Arrays.asList("beforeInsert", "beforeUpdate", "beforeDelete");

    public DomainEventListener(Datastore datastore) {
        super(datastore);
        for (PersistentEntity entity : datastore.getMappingContext().getPersistentEntities()) {
            this.createEventCaches(entity);
        }
        datastore.getMappingContext().addMappingContextListener((MappingContext.Listener)this);
    }

    protected void onPersistenceEvent(AbstractPersistenceEvent event) {
        switch (event.getEventType()) {
            case PreInsert: {
                if (this.beforeInsert(event.getEntity(), event.getEntityAccess(), (PreInsertEvent)event)) break;
                event.cancel();
                break;
            }
            case PostInsert: {
                this.afterInsert(event.getEntity(), event.getEntityAccess(), (PostInsertEvent)event);
                break;
            }
            case PreUpdate: {
                if (this.beforeUpdate(event.getEntity(), event.getEntityAccess(), (PreUpdateEvent)event)) break;
                event.cancel();
                break;
            }
            case PostUpdate: {
                this.afterUpdate(event.getEntity(), event.getEntityAccess(), (PostUpdateEvent)event);
                break;
            }
            case PreDelete: {
                if (this.beforeDelete(event.getEntity(), event.getEntityAccess(), (PreDeleteEvent)event)) break;
                event.cancel();
                break;
            }
            case PostDelete: {
                this.afterDelete(event.getEntity(), event.getEntityAccess(), (PostDeleteEvent)event);
                break;
            }
            case PreLoad: {
                this.beforeLoad(event.getEntity(), event.getEntityAccess(), (PreLoadEvent)event);
                break;
            }
            case PostLoad: {
                this.afterLoad(event.getEntity(), event.getEntityAccess(), (PostLoadEvent)event);
                break;
            }
            case SaveOrUpdate: {
                break;
            }
            case Validation: {
                break;
            }
        }
    }

    public boolean beforeInsert(PersistentEntity entity, EntityAccess ea) {
        return this.beforeInsert(entity, ea, null);
    }

    public boolean beforeInsert(PersistentEntity entity, EntityAccess ea, PreInsertEvent event) {
        if (entity.isVersioned()) {
            try {
                this.setVersion(ea);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return this.invokeEvent(EVENT_BEFORE_INSERT, entity, ea, (ApplicationEvent)event);
    }

    protected void setVersion(EntityAccess ea) {
        Class versionType = ea.getPersistentEntity().getVersion().getType();
        if (Number.class.isAssignableFrom(versionType)) {
            ea.setProperty("version", (Object)0);
        } else if (Timestamp.class.isAssignableFrom(versionType)) {
            ea.setProperty("version", (Object)new Timestamp(System.currentTimeMillis()));
        } else if (Date.class.isAssignableFrom(versionType)) {
            ea.setProperty("version", (Object)new Date());
        }
    }

    public boolean beforeUpdate(PersistentEntity entity, EntityAccess ea) {
        return this.invokeEvent(EVENT_BEFORE_UPDATE, entity, ea, null);
    }

    public boolean beforeUpdate(PersistentEntity entity, EntityAccess ea, PreUpdateEvent event) {
        return this.invokeEvent(EVENT_BEFORE_UPDATE, entity, ea, (ApplicationEvent)event);
    }

    public boolean beforeDelete(PersistentEntity entity, EntityAccess ea) {
        return this.invokeEvent(EVENT_BEFORE_DELETE, entity, ea, null);
    }

    public boolean beforeDelete(PersistentEntity entity, EntityAccess ea, PreDeleteEvent event) {
        return this.invokeEvent(EVENT_BEFORE_DELETE, entity, ea, (ApplicationEvent)event);
    }

    public void beforeLoad(PersistentEntity entity, EntityAccess ea) {
        this.beforeLoad(entity, ea, null);
    }

    public void beforeLoad(PersistentEntity entity, EntityAccess ea, PreLoadEvent event) {
        this.invokeEvent(EVENT_BEFORE_LOAD, entity, ea, (ApplicationEvent)event);
    }

    public void afterDelete(PersistentEntity entity, EntityAccess ea) {
        this.afterDelete(entity, ea, null);
    }

    public void afterDelete(PersistentEntity entity, EntityAccess ea, PostDeleteEvent event) {
        this.invokeEvent(EVENT_AFTER_DELETE, entity, ea, (ApplicationEvent)event);
    }

    public void afterInsert(PersistentEntity entity, EntityAccess ea) {
        this.afterInsert(entity, ea, null);
    }

    public void afterInsert(PersistentEntity entity, EntityAccess ea, PostInsertEvent event) {
        this.activateDirtyChecking(ea);
        this.invokeEvent(EVENT_AFTER_INSERT, entity, ea, (ApplicationEvent)event);
    }

    private void activateDirtyChecking(EntityAccess ea) {
        Object e = ea.getEntity();
        if (e instanceof DirtyCheckable) {
            ((DirtyCheckable)e).trackChanges();
        }
    }

    public void afterUpdate(PersistentEntity entity, EntityAccess ea) {
        this.afterUpdate(entity, ea, null);
    }

    public void afterUpdate(PersistentEntity entity, EntityAccess ea, PostUpdateEvent event) {
        this.activateDirtyChecking(ea);
        this.invokeEvent(EVENT_AFTER_UPDATE, entity, ea, (ApplicationEvent)event);
    }

    public void afterLoad(PersistentEntity entity, EntityAccess ea) {
        this.afterLoad(entity, ea, null);
    }

    public void afterLoad(PersistentEntity entity, EntityAccess ea, PostLoadEvent event) {
        this.activateDirtyChecking(ea);
        if (entity != null && entity.getMapping().getMappedForm().isAutowire()) {
            this.autowireBeanProperties(ea.getEntity());
        }
        this.invokeEvent(EVENT_AFTER_LOAD, entity, ea, (ApplicationEvent)event);
    }

    protected void autowireBeanProperties(Object entity) {
        this.datastore.getApplicationContext().getAutowireCapableBeanFactory().autowireBeanProperties(entity, 1, false);
    }

    public void persistentEntityAdded(PersistentEntity entity) {
        this.createEventCaches(entity);
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return AbstractPersistenceEvent.class.isAssignableFrom(eventType);
    }

    private boolean invokeEvent(String eventName, PersistentEntity entity, EntityAccess ea, ApplicationEvent event) {
        boolean booleanResult;
        Object result;
        Map<String, Method> events = this.entityEvents.get(entity);
        if (events == null) {
            return true;
        }
        Method eventMethod = events.get(eventName);
        if (eventMethod == null) {
            return true;
        }
        if (ea != null) {
            Object o = ea.getEntity();
            result = eventMethod.getParameterTypes().length == 1 ? ReflectionUtils.invokeMethod((Method)eventMethod, (Object)o, (Object[])new Object[]{event}) : ReflectionUtils.invokeMethod((Method)eventMethod, (Object)o);
        } else {
            result = null;
        }
        boolean bl = booleanResult = result instanceof Boolean ? (Boolean)result : true;
        if (booleanResult && REFRESH_EVENTS.contains(eventName)) {
            ea.refresh();
        }
        return booleanResult;
    }

    private void createEventCaches(PersistentEntity entity) {
        Class javaClass = entity.getJavaClass();
        ConcurrentHashMap<String, Method> events = new ConcurrentHashMap<String, Method>();
        this.entityEvents.put(entity, events);
        this.findAndCacheEvent(EVENT_BEFORE_INSERT, javaClass, events);
        this.findAndCacheEvent(EVENT_BEFORE_UPDATE, javaClass, events);
        this.findAndCacheEvent(EVENT_BEFORE_DELETE, javaClass, events);
        this.findAndCacheEvent(EVENT_BEFORE_LOAD, javaClass, events);
        this.findAndCacheEvent(EVENT_AFTER_INSERT, javaClass, events);
        this.findAndCacheEvent(EVENT_AFTER_UPDATE, javaClass, events);
        this.findAndCacheEvent(EVENT_AFTER_DELETE, javaClass, events);
        this.findAndCacheEvent(EVENT_AFTER_LOAD, javaClass, events);
    }

    private void findAndCacheEvent(String event, Class<?> javaClass, Map<String, Method> events) {
        Method method = ReflectionUtils.findMethod(javaClass, (String)event);
        if (method != null) {
            events.put(event, method);
        }
    }
}

