/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm;

import groovy.lang.Closure;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaMethod;
import groovy.lang.Reference;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.metaclass.MethodSelectionException;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.gorm.AbstractGormApi;
import org.grails.datastore.gorm.GormInstanceApi;
import org.grails.datastore.gorm.GormStaticApi;
import org.grails.datastore.gorm.GormValidationApi;
import org.grails.datastore.gorm.finders.CountByFinder;
import org.grails.datastore.gorm.finders.FindAllByBooleanFinder;
import org.grails.datastore.gorm.finders.FindAllByFinder;
import org.grails.datastore.gorm.finders.FindByBooleanFinder;
import org.grails.datastore.gorm.finders.FindByFinder;
import org.grails.datastore.gorm.finders.FindOrCreateByFinder;
import org.grails.datastore.gorm.finders.FindOrSaveByFinder;
import org.grails.datastore.gorm.finders.FinderMethod;
import org.grails.datastore.gorm.finders.ListOrderByFinder;
import org.grails.datastore.gorm.internal.InstanceMethodInvokingClosure;
import org.grails.datastore.gorm.internal.StaticMethodInvokingClosure;
import org.grails.datastore.gorm.query.GormQueryOperations;
import org.grails.datastore.gorm.query.NamedQueriesBuilder;
import org.grails.datastore.mapping.config.Entity;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.config.GormProperties;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.grails.datastore.mapping.reflect.MetaClassUtils;
import org.grails.datastore.mapping.reflect.NameUtils;
import org.springframework.transaction.PlatformTransactionManager;

public class GormEnhancer
implements Closeable,
GroovyObject {
    private static final Map<String, Map<String, GormQueryOperations>> NAMED_QUERIES;
    private static final Map<String, Map<String, GormStaticApi>> STATIC_APIS;
    private static final Map<String, Map<String, GormInstanceApi>> INSTANCE_APIS;
    private static final Map<String, Map<String, GormValidationApi>> VALIDATION_APIS;
    private static final Map<String, Map<String, Datastore>> DATASTORES;
    private final Datastore datastore;
    private PlatformTransactionManager transactionManager;
    private List<FinderMethod> finders;
    private final boolean failOnError;
    private boolean includeExternal;
    private boolean dynamicEnhance;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Log log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public GormEnhancer(Datastore datastore) {
        this(datastore, null);
    }

    /*
     * WARNING - void declaration
     */
    public GormEnhancer(Datastore datastore, PlatformTransactionManager platformTransactionManager, boolean bl) {
        void transactionManager;
        void failOnError;
        void datastore2;
        MetaClass metaClass;
        boolean bl2;
        boolean bl3;
        this.includeExternal = bl3 = true;
        this.dynamicEnhance = bl2 = false;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var7_7 = datastore2;
        this.datastore = var7_7;
        void var8_8 = failOnError;
        this.failOnError = var8_8;
        void var9_9 = transactionManager;
        this.transactionManager = var9_9;
        if (datastore2 != null) {
            this.registerConstraints((Datastore)datastore2);
        }
        NAMED_QUERIES.clear();
        PersistentEntity entity = null;
        Iterator iterator = datastore2.getMappingContext().getPersistentEntities().iterator();
        while (iterator.hasNext()) {
            entity = (PersistentEntity)ScriptBytecodeAdapter.castToType(iterator.next(), PersistentEntity.class);
            if (!this.appliesToDatastore((Datastore)datastore2, entity)) continue;
            Class cls = entity.getJavaClass();
            Set<String> qualifiers = this.allQualifiers((Datastore)datastore2, entity);
            String qualifier = null;
            Iterator<String> iterator2 = qualifiers.iterator();
            while (iterator2.hasNext()) {
                qualifier = ShortTypeHandling.castToString((Object)iterator2.next());
                GormStaticApi staticApi = this.getStaticApi(cls);
                String name = entity.getName();
                STATIC_APIS.get(qualifier).put(name, staticApi);
                GormInstanceApi instanceApi = this.getInstanceApi(cls);
                INSTANCE_APIS.get(qualifier).put(name, instanceApi);
                GormValidationApi validationApi = this.getValidationApi(cls);
                VALIDATION_APIS.get(qualifier).put(name, validationApi);
                DATASTORES.get(qualifier).put(name, (Datastore)datastore2);
            }
        }
    }

    public GormEnhancer(Datastore datastore, PlatformTransactionManager transactionManager) {
        this(datastore, transactionManager, false);
    }

    public Set<String> allQualifiers(Datastore datastore, PersistentEntity entity) {
        return (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{Entity.DEFAULT_DATA_SOURCE}), Set.class);
    }

    protected boolean appliesToDatastore(Datastore datastore, PersistentEntity entity) {
        return !entity.isExternal();
    }

    public static GormQueryOperations findNamedQuery(Class entity, String queryName) {
        String className = entity.getName();
        Map<String, GormQueryOperations> namedQueries = (Map<String, GormQueryOperations>)ScriptBytecodeAdapter.castToType(NAMED_QUERIES.get(className), Map.class);
        if (namedQueries == null) {
            ClassPropertyFetcher cpf = ClassPropertyFetcher.forClass((Class)entity);
            Closure closure = (Closure)ScriptBytecodeAdapter.castToType((Object)cpf.getStaticPropertyValue(GormProperties.NAMED_QUERIES, Closure.class), Closure.class);
            if (closure != null) {
                Map<String, GormQueryOperations> map;
                NamedQueriesBuilder evaluator = new NamedQueriesBuilder(GormEnhancer.findEntity(entity), GormEnhancer.findStaticApi(entity).getGormDynamicFinders());
                namedQueries = map = evaluator.evaluate(closure);
                NAMED_QUERIES.put(className, namedQueries);
                return (GormQueryOperations)ScriptBytecodeAdapter.castToType((Object)namedQueries.get(queryName), GormQueryOperations.class);
            }
        } else {
            return (GormQueryOperations)ScriptBytecodeAdapter.castToType(namedQueries.get(queryName), GormQueryOperations.class);
        }
        NAMED_QUERIES.put(className, new LinkedHashMap());
        return (GormQueryOperations)ScriptBytecodeAdapter.castToType(null, GormQueryOperations.class);
    }

    public static <D> GormStaticApi<D> findStaticApi(Class<D> entity, String qualifier) {
        Map<String, GormStaticApi> map = STATIC_APIS.get(qualifier);
        GormStaticApi staticApi = (GormStaticApi)ScriptBytecodeAdapter.castToType(map != null ? map.get(NameUtils.getClassName(entity)) : null, GormStaticApi.class);
        if (staticApi == null) {
            throw (Throwable)GormEnhancer.stateException(entity);
        }
        return staticApi;
    }

    private static IllegalStateException stateException(Class entity) {
        return new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{entity.getName()}, new String[]{"Either class [", "] is not a domain class or GORM has not been initialized correctly or has already been shutdown. If you are unit testing your entities using the mocking APIs"})));
    }

    public static GormInstanceApi findInstanceApi(Class entity, String qualifier) {
        Map<String, GormInstanceApi> map = INSTANCE_APIS.get(qualifier);
        GormInstanceApi instanceApi = (GormInstanceApi)ScriptBytecodeAdapter.castToType(map != null ? map.get(NameUtils.getClassName((Class)entity)) : null, GormInstanceApi.class);
        if (instanceApi == null) {
            throw (Throwable)GormEnhancer.stateException(entity);
        }
        return instanceApi;
    }

    public static GormValidationApi findValidationApi(Class entity, String qualifier) {
        Map<String, GormValidationApi> map = VALIDATION_APIS.get(qualifier);
        GormValidationApi instanceApi = (GormValidationApi)ScriptBytecodeAdapter.castToType(map != null ? map.get(NameUtils.getClassName((Class)entity)) : null, GormValidationApi.class);
        if (instanceApi == null) {
            throw (Throwable)GormEnhancer.stateException(entity);
        }
        return instanceApi;
    }

    public static Datastore findDatastore(Class entity, String qualifier) {
        Map<String, Datastore> map = DATASTORES.get(qualifier);
        Datastore datastore = (Datastore)ScriptBytecodeAdapter.castToType(map != null ? map.get(entity.getName()) : null, Datastore.class);
        if (datastore == null) {
            throw (Throwable)GormEnhancer.stateException(entity);
        }
        return datastore;
    }

    public static PersistentEntity findEntity(Class entity) {
        return GormEnhancer.findDatastore(entity).getMappingContext().getPersistentEntity(entity.getName());
    }

    @Override
    public void close() throws IOException {
        this.removeConstraints();
        MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
        PersistentEntity entity = null;
        Iterator iterator = this.datastore.getMappingContext().getPersistentEntities().iterator();
        while (iterator.hasNext()) {
            entity = (PersistentEntity)ScriptBytecodeAdapter.castToType(iterator.next(), PersistentEntity.class);
            Set<String> qualifiers = this.allQualifiers(this.datastore, entity);
            Class cls = entity.getJavaClass();
            String className = cls.getName();
            String q = null;
            Iterator<String> iterator2 = qualifiers.iterator();
            while (iterator2.hasNext()) {
                q = ShortTypeHandling.castToString((Object)iterator2.next());
                NAMED_QUERIES.remove(className);
                Map<String, GormStaticApi> map = STATIC_APIS.get(q);
                GormStaticApi gormStaticApi = map != null ? map.remove(className) : null;
                Map<String, GormInstanceApi> map2 = INSTANCE_APIS.get(q);
                GormInstanceApi gormInstanceApi = map2 != null ? map2.remove(className) : null;
                Map<String, GormValidationApi> map3 = VALIDATION_APIS.get(q);
                GormValidationApi gormValidationApi = map3 != null ? map3.remove(className) : null;
                Map<String, Datastore> map4 = DATASTORES.get(q);
                Datastore datastore = map4 != null ? map4.remove(this.datastore) : null;
            }
            registry.removeMetaClass(cls);
        }
    }

    protected void removeConstraints() {
        CallSite[] callSiteArray = GormEnhancer.$getCallSiteArray();
        try {
            callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].callGetProperty(callSiteArray[3].call(Thread.class)), (Object)"org.codehaus.groovy.grails.validation.ConstrainedProperty"), (Object)"unique");
        }
        catch (Throwable e) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].call((Object)log)) ? callSiteArray[5].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[6].callGetProperty((Object)e)}, new String[]{"Error removing applied constraints on shutdown. ", ""}), (Object)e) : null;
        }
    }

    protected void registerConstraints(Datastore datastore) {
        block5: {
            try {
                DefaultGroovyMethods.newInstance(Thread.currentThread().getContextClassLoader().loadClass("org.grails.datastore.gorm.support.ConstraintRegistrar"), (Object[])new Object[]{datastore});
            }
            catch (Throwable e) {
                Object v0;
                if (log.isErrorEnabled()) {
                    log.error((Object)new GStringImpl(new Object[]{e.getMessage()}, new String[]{"Unable to register GORM constraints: ", ""}), e);
                    v0 = null;
                    break block5;
                }
                v0 = null;
            }
        }
    }

    public List<FinderMethod> getFinders() {
        if (this.finders == null) {
            List<FinderMethod> list = Collections.unmodifiableList(this.createDynamicFinders());
            this.finders = list;
        }
        return this.finders;
    }

    public void enhance(boolean onlyExtendedMethods) {
        if (this.dynamicEnhance) {
            PersistentEntity e = null;
            Iterator iterator = this.datastore.getMappingContext().getPersistentEntities().iterator();
            while (iterator.hasNext()) {
                e = (PersistentEntity)ScriptBytecodeAdapter.castToType(iterator.next(), PersistentEntity.class);
                if (e.isExternal() && !this.includeExternal) continue;
                this.enhance(e, onlyExtendedMethods);
            }
        }
    }

    public void enhance(PersistentEntity e, boolean onlyExtendedMethods) {
        if (!GroovyObject.class.isAssignableFrom(e.getJavaClass()) || this.dynamicEnhance) {
            this.addInstanceMethods(e, onlyExtendedMethods);
            this.addStaticMethods(e, onlyExtendedMethods);
        }
    }

    protected void addStaticMethods(PersistentEntity e, boolean onlyExtendedMethods) {
        Class cls = e.getJavaClass();
        ExpandoMetaClass mc = MetaClassUtils.getExpandoMetaClass((Class)cls);
        GormStaticApi staticApiProvider = this.getStaticApi(cls);
        Method m = null;
        Iterator<Method> iterator = (onlyExtendedMethods ? staticApiProvider.getExtendedMethods() : staticApiProvider.getMethods()).iterator();
        while (iterator.hasNext()) {
            Method method = m = (Method)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Method.class);
            if (!(method != null)) continue;
            String methodName = method.getName();
            Class[] parameterTypes = method.getParameterTypes();
            if (!(parameterTypes != null)) continue;
            boolean realMethodExists = GormEnhancer.doesRealMethodExist((MetaClass)mc, methodName, parameterTypes, true);
            if (!(!realMethodExists)) continue;
            this.registerStaticMethod(mc, methodName, parameterTypes, staticApiProvider);
        }
    }

    protected void registerStaticMethod(ExpandoMetaClass mc, String methodName, Class[] parameterTypes, GormStaticApi staticApiProvider) {
        CallSite[] callSiteArray = GormEnhancer.$getCallSiteArray();
        Object callable = callSiteArray[7].callConstructor(StaticMethodInvokingClosure.class, (Object)staticApiProvider, (Object)methodName, (Object)parameterTypes);
        Object object = callable;
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[8].callGroovyObjectGetProperty((Object)mc), (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{methodName}, new String[]{"", ""})));
    }

    protected <D> List<AbstractGormApi<D>> getInstanceMethodApiProviders(Class cls) {
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{this.getInstanceApi(cls), this.getValidationApi(cls)});
    }

    protected void addInstanceMethods(PersistentEntity e, boolean onlyExtendedMethods) {
        Class cls = e.getJavaClass();
        ExpandoMetaClass mc = MetaClassUtils.getExpandoMetaClass((Class)cls);
        AbstractGormApi apiProvider = null;
        Iterator iterator = this.getInstanceMethodApiProviders(cls).iterator();
        while (iterator.hasNext()) {
            apiProvider = (AbstractGormApi)ScriptBytecodeAdapter.castToType(iterator.next(), AbstractGormApi.class);
            Method method = null;
            Iterator<Method> iterator2 = (onlyExtendedMethods ? apiProvider.getExtendedMethods() : apiProvider.getMethods()).iterator();
            while (iterator2.hasNext()) {
                method = (Method)ScriptBytecodeAdapter.castToType((Object)iterator2.next(), Method.class);
                String methodName = method.getName();
                Class[] parameterTypes = method.getParameterTypes();
                if (!DefaultTypeTransformation.booleanUnbox(parameterTypes)) continue;
                List list = parameterTypes.length == 1 ? ScriptBytecodeAdapter.createList((Object[])new Object[0]) : DefaultGroovyMethods.getAt((Object[])((Object[])ScriptBytecodeAdapter.castToType(parameterTypes, Object[].class)), (IntRange)new IntRange(true, 1, Integer.valueOf(-1).intValue()));
                parameterTypes = (Class[])ScriptBytecodeAdapter.castToType((Object)list, Class[].class);
                boolean realMethodExists = GormEnhancer.doesRealMethodExist((MetaClass)mc, methodName, parameterTypes, false);
                if (!(!realMethodExists)) continue;
                this.registerInstanceMethod(cls, mc, apiProvider, methodName, parameterTypes);
            }
        }
    }

    protected Object registerInstanceMethod(Class cls, ExpandoMetaClass mc, AbstractGormApi apiProvider, String methodName, Class ... parameterTypes) {
        InstanceMethodInvokingClosure tooCall = new InstanceMethodInvokingClosure((Object)apiProvider, cls, methodName, parameterTypes);
        Class[] pt = parameterTypes;
        GroovyObject closureMethod = new GroovyObject(this, methodName, cls, (Object)tooCall, pt){
            public /* synthetic */ GormEnhancer this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                GormEnhancer gormEnhancer;
                this.this$0 = gormEnhancer = p0;
                super(ShortTypeHandling.castToString((Object)p2), ShortTypeHandling.castToClass((Object)p3), (Closure)ScriptBytecodeAdapter.castToType((Object)p4, Closure.class), (Class[])ScriptBytecodeAdapter.castToType((Object)p5, Class[].class));
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public int getModifiers() {
                return Modifier.PUBLIC;
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$1(name, args);
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                this.this$0.this$dist$set$1(name, val);
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$1(name);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        };
        mc.registerInstanceMethod((MetaMethod)closureMethod);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected static boolean doesRealMethodExist(MetaClass mc, String methodName, Class[] parameterTypes, boolean staticScope) {
        void var2_2;
        Reference methodName2 = new Reference((Object)methodName);
        Reference parameterTypes2 = new Reference((Object)var2_2);
        Reference staticScope2 = new Reference((Object)staticScope);
        boolean realMethodExists = false;
        try {
            MetaMethod existingMethod = mc.pickMethod((String)methodName2.get(), (Class[])parameterTypes2.get());
            if (DefaultTypeTransformation.booleanUnbox((Object)existingMethod) && ScriptBytecodeAdapter.compareEqual((Object)existingMethod.isStatic(), (Object)DefaultTypeTransformation.booleanUnbox((Object)staticScope2.get())) && GormEnhancer.isRealMethod(existingMethod) && ((Class[])parameterTypes2.get()).length == existingMethod.getParameterTypes().length) {
                boolean bl;
                realMethodExists = bl = true;
            }
        }
        catch (MethodSelectionException mse) {
            boolean bl;
            class _doesRealMethodExist_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference parameterTypes;
                private /* synthetic */ Reference methodName;
                private /* synthetic */ Reference staticScope;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _doesRealMethodExist_closure1(Object _outerInstance, Object _thisObject, Reference parameterTypes, Reference methodName, Reference staticScope) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.parameterTypes = reference3 = parameterTypes;
                    this.methodName = reference2 = methodName;
                    this.staticScope = reference = staticScope;
                }

                public Object doCall(MetaMethod existingMethod) {
                    return ScriptBytecodeAdapter.compareEqual((Object)existingMethod.getName(), (Object)this.methodName.get()) && ScriptBytecodeAdapter.compareEqual((Object)existingMethod.isStatic(), (Object)this.staticScope.get()) && DefaultTypeTransformation.booleanUnbox((Object)InvokerHelper.invokeStaticMethod(GormEnhancer.class, (String)"isRealMethod", (Object)new Object[]{existingMethod})) && (!DefaultTypeTransformation.booleanUnbox((Object)this.parameterTypes.get()) && !DefaultTypeTransformation.booleanUnbox((Object)existingMethod.getParameterTypes()) || ScriptBytecodeAdapter.compareEqual((Object)this.parameterTypes.get(), (Object)existingMethod.getParameterTypes()));
                }

                public Object call(MetaMethod existingMethod) {
                    return this.doCall(existingMethod);
                }

                public Class[] getParameterTypes() {
                    return (Class[])ScriptBytecodeAdapter.castToType((Object)this.parameterTypes.get(), Class[].class);
                }

                public String getMethodName() {
                    return ShortTypeHandling.castToString((Object)this.methodName.get());
                }

                public boolean getStaticScope() {
                    return DefaultTypeTransformation.booleanUnbox((Object)this.staticScope.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _doesRealMethodExist_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            realMethodExists = bl = mc.getMethods().contains((Object)new _doesRealMethodExist_closure1(GormEnhancer.class, GormEnhancer.class, parameterTypes2, methodName2, staticScope2));
        }
        return realMethodExists;
    }

    protected static boolean isRealMethod(MetaMethod existingMethod) {
        return existingMethod instanceof CachedMethod;
    }

    protected <D> GormStaticApi<D> getStaticApi(Class<D> cls) {
        return new GormStaticApi<D>(cls, this.datastore, this.getFinders(), this.transactionManager);
    }

    protected <D> GormInstanceApi<D> getInstanceApi(Class<D> cls) {
        GormInstanceApi<D> instanceApi = new GormInstanceApi<D>(cls, this.datastore);
        boolean bl = this.failOnError;
        instanceApi.setFailOnError(bl);
        return instanceApi;
    }

    protected <D> GormValidationApi<D> getValidationApi(Class<D> cls) {
        return new GormValidationApi<D>(cls, this.datastore);
    }

    protected List<FinderMethod> createDynamicFinders() {
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{new FindOrCreateByFinder(this.datastore), new FindOrSaveByFinder(this.datastore), new FindByFinder(this.datastore), new FindAllByFinder(this.datastore), new FindAllByBooleanFinder(this.datastore), new FindByBooleanFinder(this.datastore), new CountByFinder(this.datastore), new ListOrderByFinder(this.datastore)});
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GormEnhancer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GormEnhancer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, GormEnhancer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(GormEnhancer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static <D> GormStaticApi<D> findStaticApi(Class<D> entity) {
        return GormEnhancer.findStaticApi(entity, Entity.DEFAULT_DATA_SOURCE);
    }

    public static GormInstanceApi findInstanceApi(Class entity) {
        return GormEnhancer.findInstanceApi(entity, Entity.DEFAULT_DATA_SOURCE);
    }

    public static GormValidationApi findValidationApi(Class entity) {
        return GormEnhancer.findValidationApi(entity, Entity.DEFAULT_DATA_SOURCE);
    }

    public static Datastore findDatastore(Class entity) {
        return GormEnhancer.findDatastore(entity, Entity.DEFAULT_DATA_SOURCE);
    }

    public void enhance() {
        this.enhance(false);
    }

    public void enhance(PersistentEntity e) {
        this.enhance(e, false);
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Log log;
        Map map;
        Map map2;
        Map map3;
        Map map4;
        ConcurrentHashMap<String, Map<String, GormQueryOperations>> concurrentHashMap = new ConcurrentHashMap<String, Map<String, GormQueryOperations>>();
        NAMED_QUERIES = concurrentHashMap;
        class __clinit__closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String key) {
                return new ConcurrentHashMap();
            }

            public Object call(String key) {
                return this.doCall(key);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        STATIC_APIS = map4 = DefaultGroovyMethods.withDefault(new ConcurrentHashMap(), (Closure)new __clinit__closure2(GormEnhancer.class, GormEnhancer.class));
        class __clinit__closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String key) {
                return new ConcurrentHashMap();
            }

            public Object call(String key) {
                return this.doCall(key);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        INSTANCE_APIS = map3 = DefaultGroovyMethods.withDefault(new ConcurrentHashMap(), (Closure)new __clinit__closure3(GormEnhancer.class, GormEnhancer.class));
        class __clinit__closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String key) {
                return new ConcurrentHashMap();
            }

            public Object call(String key) {
                return this.doCall(key);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        VALIDATION_APIS = map2 = DefaultGroovyMethods.withDefault(new ConcurrentHashMap(), (Closure)new __clinit__closure4(GormEnhancer.class, GormEnhancer.class));
        class __clinit__closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String key) {
                return new ConcurrentHashMap();
            }

            public Object call(String key) {
                return this.doCall(key);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DATASTORES = map = DefaultGroovyMethods.withDefault(new ConcurrentHashMap(), (Closure)new __clinit__closure5(GormEnhancer.class, GormEnhancer.class));
        GormEnhancer.log = log = LogFactory.getLog((String)"org.grails.datastore.gorm.GormEnhancer");
    }

    public final Datastore getDatastore() {
        return this.datastore;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager platformTransactionManager) {
        this.transactionManager = platformTransactionManager;
    }

    public void setFinders(List<FinderMethod> list) {
        this.finders = list;
    }

    public final boolean getFailOnError() {
        return this.failOnError;
    }

    public final boolean isFailOnError() {
        return this.failOnError;
    }

    public boolean getIncludeExternal() {
        return this.includeExternal;
    }

    public boolean isIncludeExternal() {
        return this.includeExternal;
    }

    public void setIncludeExternal(boolean bl) {
        this.includeExternal = bl;
    }

    public boolean getDynamicEnhance() {
        return this.dynamicEnhance;
    }

    public boolean isDynamicEnhance() {
        return this.dynamicEnhance;
    }

    public void setDynamicEnhance(boolean bl) {
        this.dynamicEnhance = bl;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "removeConstraint";
        stringArray[1] = "loadClass";
        stringArray[2] = "contextClassLoader";
        stringArray[3] = "currentThread";
        stringArray[4] = "isWarnEnabled";
        stringArray[5] = "warn";
        stringArray[6] = "message";
        stringArray[7] = "<$constructor$>";
        stringArray[8] = "static";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[9];
        GormEnhancer.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(GormEnhancer.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = GormEnhancer.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

