/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.query.transform;

import grails.gorm.DetachedCriteria;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.LocatedMessage;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.syntax.CSTNode;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.trait.Traits;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.criteria.FunctionCallingCriterion;
import org.grails.datastore.mapping.reflect.AstUtils;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.grails.datastore.mapping.reflect.NameUtils;
import org.grails.datastore.mapping.reflect.ReflectionUtils;

public class DetachedCriteriaTransformer
extends ClassCodeVisitorSupport {
    private static final Class<?>[] EMPTY_JAVA_CLASS_ARRAY = new Class[0];
    public static final String AND_OPERATOR = "&";
    public static final String OR_OPERATOR = "|";
    public static final ClassNode DETACHED_CRITERIA_CLASS_NODE = ClassHelper.make(DetachedCriteria.class);
    public static final Set<String> CANDIDATE_METHODS_WHERE_ONLY = DetachedCriteriaTransformer.newSet("where");
    public static final ClassNode FUNCTION_CALL_CRITERION = new ClassNode(FunctionCallingCriterion.class);
    public static final String EQUALS_OPERATOR = "==";
    public static final String IS_NULL_CRITERION = "isNull";
    public static final ConstantExpression WHERE_LAZY = new ConstantExpression((Object)"whereLazy");
    private SourceUnit sourceUnit;
    private static final Set<String> CANDIDATE_METHODS = DetachedCriteriaTransformer.newSet("where", "whereLazy", "whereAny", "findAll", "find");
    private static final Set<String> SUPPORTED_FUNCTIONS = DetachedCriteriaTransformer.newSet("lower", "upper", "trim", "length", "second", "hour", "minute", "day", "month", "year");
    private static final Map<String, String> OPERATOR_TO_CRITERIA_METHOD_MAP = DetachedCriteriaTransformer.newMap("==", "eq", "!=", "ne", ">", "gt", "<", "lt", ">=", "ge", "<=", "le", "==~", "like", "=~", "ilike", "in", "inList");
    private static final Map<String, String> METHOD_TO_SUBQUERY_MAP = DetachedCriteriaTransformer.newMap("eq", "eqAll", "gt", "gtAll", "lt", "ltAll", "ge", "geAll", "le", "leAll");
    private static final Map<String, ClassNode> OPERATOR_TO_CRITERION_METHOD_MAP = DetachedCriteriaTransformer.newMap("==", new ClassNode(Query.Equals.class), "!=", new ClassNode(Query.NotEquals.class), ">", new ClassNode(Query.GreaterThan.class), "<", new ClassNode(Query.LessThan.class), ">=", new ClassNode(Query.GreaterThanEquals.class), "<=", new ClassNode(Query.LessThanEquals.class), "==~", new ClassNode(Query.Like.class), "=~", new ClassNode(Query.ILike.class), "in", new ClassNode(Query.In.class));
    private static final Map<String, String> PROPERTY_COMPARISON_OPERATOR_TO_CRITERIA_METHOD_MAP = DetachedCriteriaTransformer.newMap("==", "eqProperty", "!=", "neProperty", ">", "gtProperty", "<", "ltProperty", ">=", "geProperty", "<=", "leProperty");
    private static final Map<String, String> SIZE_OPERATOR_TO_CRITERIA_METHOD_MAP = DetachedCriteriaTransformer.newMap("==", "sizeEq", "!=", "sizeNe", ">", "sizeGt", "<", "sizeLt", ">=", "sizeGe", "<=", "sizeLe");
    private static final Map<String, String> AGGREGATE_FUNCTIONS = DetachedCriteriaTransformer.newMap("avg", "avg", "max", "max", "min", "min", "sum", "sum", "property", "property", "count", "countDistinct");
    protected Map<String, ClassNode> detachedCriteriaVariables = new HashMap<String, ClassNode>();
    protected Map<String, Object> aliases = new HashMap<String, Object>();
    protected Map<String, ClassNode> staticDetachedCriteriaVariables = new HashMap<String, ClassNode>();
    protected Map<String, Map<String, ClassNode>> cachedClassProperties = new HashMap<String, Map<String, ClassNode>>();
    protected Set<ClosureExpression> transformedExpressions = new HashSet<ClosureExpression>();
    protected Set<Expression> aliasExpressions = new HashSet<Expression>();
    protected ClassNode currentClassNode;

    DetachedCriteriaTransformer(SourceUnit sourceUnit) {
        this.sourceUnit = sourceUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClass(ClassNode node) {
        try {
            this.currentClassNode = node;
            super.visitClass(node);
        }
        catch (Exception e) {
            this.logTransformationError((ASTNode)node, e);
        }
        finally {
            this.currentClassNode = null;
            this.detachedCriteriaVariables.clear();
            this.transformedExpressions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitMethod(MethodNode node) {
        try {
            super.visitMethod(node);
        }
        finally {
            this.detachedCriteriaVariables.clear();
        }
    }

    public void visitField(FieldNode node) {
        ClassNode classNode = node.getOwner();
        if (node.isStatic() && AstUtils.isDomainClass((ClassNode)classNode)) {
            MethodCallExpression mce;
            Expression initialExpression = node.getInitialExpression();
            if (initialExpression instanceof MethodCallExpression && this.isCandidateWhereMethod((mce = (MethodCallExpression)initialExpression).getMethod(), mce.getArguments())) {
                Expression expression;
                ArgumentListExpression args = (ArgumentListExpression)mce.getArguments();
                Expression target = mce.getObjectExpression();
                List argsExpressions = args.getExpressions();
                int totalExpressions = argsExpressions.size();
                if (totalExpressions > 0 && (expression = (Expression)argsExpressions.get(totalExpressions - 1)) instanceof ClosureExpression) {
                    VariableExpression ve;
                    ClassNode type;
                    ClosureExpression closureExpression = (ClosureExpression)expression;
                    this.transformClosureExpression(classNode, closureExpression);
                    if (target instanceof VariableExpression && (type = (ve = (VariableExpression)target).getType()).equals((Object)DETACHED_CRITERIA_CLASS_NODE)) {
                        return;
                    }
                    String buildMethod = mce.getMethodAsString().equals("whereLazy") ? "buildLazy" : "build";
                    ClassNode detachedCriteriaClassNode = this.getParameterizedDetachedCriteriaClassNode(classNode);
                    MethodCallExpression newInitialExpression = new MethodCallExpression((Expression)new ConstructorCallExpression(detachedCriteriaClassNode, (Expression)new ArgumentListExpression((Expression)new ClassExpression(classNode))), buildMethod, (Expression)new ArgumentListExpression((Expression)closureExpression));
                    node.setInitialValueExpression((Expression)newInitialExpression);
                    node.setType(detachedCriteriaClassNode);
                    this.staticDetachedCriteriaVariables.put(node.getName(), classNode);
                }
            }
        } else {
            try {
                Expression initialExpression = node.getInitialExpression();
                ClosureExpression newClosureExpression = this.handleDetachedCriteriaCast(initialExpression);
                if (newClosureExpression != null) {
                    node.setInitialValueExpression((Expression)newClosureExpression);
                }
            }
            catch (Exception e) {
                this.logTransformationError((ASTNode)node, e);
            }
        }
        super.visitField(node);
    }

    protected ClassNode getParameterizedDetachedCriteriaClassNode(ClassNode classNode) {
        ClassNode detachedCriteriaClassNode = DETACHED_CRITERIA_CLASS_NODE.getPlainNodeReference();
        if (classNode != null) {
            detachedCriteriaClassNode.setGenericsTypes(new GenericsType[]{new GenericsType(AstUtils.nonGeneric((ClassNode)classNode))});
        }
        return detachedCriteriaClassNode;
    }

    public void visitDeclarationExpression(DeclarationExpression expression) {
        Expression initializationExpression = expression.getRightExpression();
        if (initializationExpression instanceof MethodCallExpression) {
            MethodCallExpression call = (MethodCallExpression)initializationExpression;
            Expression objectExpression = call.getObjectExpression();
            Expression method = call.getMethod();
            Expression arguments = call.getArguments();
            if (this.isCandidateMethod(method.getText(), arguments, CANDIDATE_METHODS_WHERE_ONLY)) {
                ClassNode classNode = new ClassNode(DetachedCriteria.class);
                ClassNode targetType = objectExpression.getType();
                if (AstUtils.isDomainClass((ClassNode)targetType)) {
                    classNode.setGenericsTypes(new GenericsType[]{new GenericsType(targetType)});
                    VariableExpression variableExpression = expression.getVariableExpression();
                    if (variableExpression.isClosureSharedVariable()) {
                        Variable accessedVariable = variableExpression.getAccessedVariable();
                        if (accessedVariable instanceof VariableExpression) {
                            ((VariableExpression)accessedVariable).setType(classNode);
                        }
                    } else {
                        variableExpression.setType(classNode);
                    }
                    String variableName = expression.getVariableExpression().getName();
                    this.detachedCriteriaVariables.put(variableName, targetType);
                }
            }
        } else if (initializationExpression instanceof ConstructorCallExpression) {
            Expression exp;
            ArgumentListExpression ale;
            Expression arguments;
            String variableName = expression.getVariableExpression().getName();
            ConstructorCallExpression cce = (ConstructorCallExpression)initializationExpression;
            ClassNode type = cce.getType();
            if (DETACHED_CRITERIA_CLASS_NODE.getName().equals(type.getName()) && (arguments = cce.getArguments()) instanceof ArgumentListExpression && (ale = (ArgumentListExpression)arguments).getExpressions().size() == 1 && (exp = ale.getExpression(0)) instanceof ClassExpression) {
                ClassExpression clse = (ClassExpression)exp;
                this.detachedCriteriaVariables.put(variableName, clse.getType());
            }
        } else {
            try {
                ClosureExpression newClosureExpression = this.handleDetachedCriteriaCast(initializationExpression);
                if (newClosureExpression != null) {
                    expression.setRightExpression((Expression)newClosureExpression);
                }
            }
            catch (Exception e) {
                this.logTransformationError((ASTNode)initializationExpression, e);
            }
        }
        super.visitDeclarationExpression(expression);
    }

    private void logTransformationError(ASTNode astNode, Exception e) {
        StringBuilder message = new StringBuilder("Fatal error occurred applying query transformations [ " + e.getMessage() + "] to source [" + this.sourceUnit.getName() + "]. Please report an issue.");
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        message.append(System.getProperty("line.separator"));
        message.append(sw.toString());
        this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage(message.toString(), (CSTNode)Token.newString((String)astNode.getText(), (int)astNode.getLineNumber(), (int)astNode.getColumnNumber()), this.sourceUnit));
    }

    private ClosureExpression handleDetachedCriteriaCast(Expression initializationExpression) {
        ClosureExpression newClosureExpression = null;
        if (initializationExpression instanceof CastExpression && ((CastExpression)initializationExpression).getExpression() instanceof ClosureExpression) {
            GenericsType[] genericsTypes;
            CastExpression ce = (CastExpression)initializationExpression;
            Expression castTarget = ce.getExpression();
            ClosureExpression cle = (ClosureExpression)castTarget;
            ClassNode targetCastType = ce.getType();
            if (targetCastType.getName().equals(DetachedCriteria.class.getName()) && (genericsTypes = targetCastType.getGenericsTypes()).length > 0) {
                ClassNode genericType = genericsTypes[0].getType();
                this.transformClosureExpression(genericType, cle);
                newClosureExpression = cle;
            }
        }
        return newClosureExpression;
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        Expression objectExpression = call.getObjectExpression();
        Expression method = call.getMethod();
        Expression arguments = call.getArguments();
        try {
            if (this.isCandidateMethodCallForTransform(objectExpression, method, arguments)) {
                ClassExpression ce = this.getTargetClassExpresssion(objectExpression);
                if (ce != null) {
                    ClassNode classNode;
                    this.currentClassNode = classNode = ce.getType();
                    this.visitMethodCall(classNode, arguments);
                }
            } else if (objectExpression instanceof VariableExpression) {
                VariableExpression var = (VariableExpression)objectExpression;
                String varName = var.getName();
                ClassNode varType = this.detachedCriteriaVariables.get(varName);
                if (varType != null && this.isCandidateWhereMethod(method, arguments)) {
                    this.currentClassNode = varType;
                    this.visitMethodCall(varType, arguments);
                } else if (var.isThisExpression() && this.currentClassNode != null && this.isCandidateWhereMethod(method.getText(), arguments) && AstUtils.isDomainClass((ClassNode)this.currentClassNode)) {
                    this.visitMethodCall(this.currentClassNode, arguments);
                    call.setMethod((Expression)WHERE_LAZY);
                }
            } else if (objectExpression instanceof PropertyExpression && !(((PropertyExpression)objectExpression).getProperty() instanceof GStringExpression)) {
                ClassNode propertyType;
                PropertyExpression pe = (PropertyExpression)objectExpression;
                String propName = pe.getPropertyAsString();
                ClassNode classNode = pe.getObjectExpression().getType();
                if (AstUtils.isDomainClass((ClassNode)classNode) && (propertyType = this.getPropertyType(classNode, propName)) != null && DETACHED_CRITERIA_CLASS_NODE.equals((Object)propertyType)) {
                    this.visitMethodCall(classNode, arguments);
                }
            }
        }
        catch (Exception e) {
            this.logTransformationError((ASTNode)call, e);
        }
        super.visitMethodCallExpression(call);
    }

    private ClassExpression getTargetClassExpresssion(Expression objectExpression) {
        VariableExpression ve;
        if (objectExpression instanceof ClassExpression) {
            return (ClassExpression)objectExpression;
        }
        if (objectExpression instanceof MethodCallExpression) {
            MethodCallExpression mce = (MethodCallExpression)objectExpression;
            Expression oe = mce.getObjectExpression();
            if (oe instanceof ClassExpression) {
                return (ClassExpression)oe;
            }
        } else if (objectExpression instanceof VariableExpression && (ve = (VariableExpression)objectExpression).isThisExpression() && AstUtils.isDomainClass((ClassNode)this.currentClassNode)) {
            return new ClassExpression(this.currentClassNode);
        }
        return null;
    }

    private boolean isCandidateMethodCallForTransform(Expression objectExpression, Expression method, Expression arguments) {
        return (objectExpression instanceof ClassExpression || this.isObjectExpressionWhereCall(objectExpression)) && this.isCandidateWhereMethod(method, arguments);
    }

    private boolean isObjectExpressionWhereCall(Expression objectExpression) {
        if (objectExpression instanceof MethodCallExpression) {
            MethodCallExpression mce = (MethodCallExpression)objectExpression;
            return this.isCandidateWhereMethod(mce.getMethodAsString(), mce.getArguments());
        }
        return false;
    }

    private void visitMethodCall(ClassNode classNode, Expression arguments) {
        if (AstUtils.isDomainClass((ClassNode)classNode) && arguments instanceof ArgumentListExpression) {
            this.visitMethodCallOnDetachedCriteria(classNode, (ArgumentListExpression)arguments);
        }
    }

    private void visitMethodCallOnDetachedCriteria(ClassNode classNode, ArgumentListExpression arguments) {
        Expression expression;
        if (arguments.getExpressions().size() > 0 && (expression = arguments.getExpression(arguments.getExpressions().size() - 1)) instanceof ClosureExpression) {
            ClosureExpression closureExpression = (ClosureExpression)expression;
            this.transformClosureExpression(classNode, closureExpression);
        }
    }

    private boolean isCandidateWhereMethod(Expression method, Expression arguments) {
        String methodName = method.getText();
        return method instanceof ConstantExpression && this.isCandidateWhereMethod(methodName, arguments);
    }

    private boolean isCandidateWhereMethod(String methodName, Expression arguments) {
        return this.isCandidateMethod(methodName, arguments, CANDIDATE_METHODS);
    }

    private boolean isCandidateMethod(String methodName, Expression arguments, Set<String> candidateMethods) {
        ArgumentListExpression ale;
        List expressions;
        if (candidateMethods.contains(methodName) && arguments instanceof ArgumentListExpression && (expressions = (ale = (ArgumentListExpression)arguments).getExpressions()).size() > 0) {
            VariableExpression ve;
            Expression expression = (Expression)expressions.get(expressions.size() - 1);
            if (expression instanceof ClosureExpression) {
                return true;
            }
            if (expression instanceof VariableExpression && (this.detachedCriteriaVariables.containsKey((ve = (VariableExpression)expression).getName()) || DETACHED_CRITERIA_CLASS_NODE.getName().equals(ve.getType().getName()))) {
                return true;
            }
        }
        return false;
    }

    public void visitStaticMethodCallExpression(StaticMethodCallExpression call) {
        Expression arguments;
        String method = call.getMethod();
        if (this.isCandidateWhereMethod(method, arguments = call.getArguments())) {
            ClassNode classNode = call.getOwnerType();
            this.visitMethodCall(classNode, arguments);
        }
        super.visitStaticMethodCallExpression(call);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transformClosureExpression(ClassNode classNode, ClosureExpression closureExpression) {
        if (this.transformedExpressions.contains(closureExpression)) {
            return;
        }
        ClassNode previousClassNode = this.currentClassNode;
        try {
            this.currentClassNode = classNode;
            List<String> propertyNames = this.getPropertyNames(classNode);
            Statement code = closureExpression.getCode();
            BlockStatement newCode = new BlockStatement();
            boolean addAll = false;
            if (code instanceof BlockStatement) {
                BlockStatement bs = (BlockStatement)code;
                this.addBlockStatementToNewQuery(bs, newCode, addAll, propertyNames, closureExpression.getVariableScope());
                newCode.setVariableScope(bs.getVariableScope());
            }
            if (!newCode.getStatements().isEmpty()) {
                this.transformedExpressions.add(closureExpression);
                closureExpression.setCode((Statement)newCode);
            }
        }
        finally {
            this.currentClassNode = previousClassNode;
        }
    }

    private List<String> getPropertyNames(ClassNode classNode) {
        String className = classNode.getName();
        Map<String, ClassNode> cachedProperties = this.cachedClassProperties.get(className);
        if (cachedProperties == null) {
            cachedProperties = new HashMap<String, ClassNode>();
            cachedProperties.put("id", new ClassNode(Long.class));
            cachedProperties.put("version", new ClassNode(Long.class));
            this.cachedClassProperties.put(className, cachedProperties);
            for (ClassNode currentNode = classNode; currentNode != null && !currentNode.equals((Object)ClassHelper.OBJECT_TYPE); currentNode = currentNode.getSuperClass()) {
                this.populatePropertiesForClassNode(currentNode, cachedProperties);
            }
        }
        return new ArrayList<String>(cachedProperties.keySet());
    }

    private void populatePropertiesForClassNode(ClassNode classNode, Map<String, ClassNode> cachedProperties) {
        String propertyName;
        List methods = classNode.getMethods();
        for (MethodNode method : methods) {
            String methodName = method.getName();
            if (method.isAbstract() || !this.isGetter(methodName, method)) continue;
            propertyName = NameUtils.getPropertyNameForGetterOrSetter((String)methodName);
            if ("hasMany".equals(propertyName) || "belongsTo".equals(propertyName) || "hasOne".equals(propertyName)) {
                FieldNode field = classNode.getField(propertyName);
                if (field == null) continue;
                this.populatePropertiesForInitialExpression(cachedProperties, field.getInitialExpression());
                continue;
            }
            if (method.isStatic()) continue;
            cachedProperties.put(propertyName, method.getReturnType());
        }
        List properties = classNode.getProperties();
        for (PropertyNode property : properties) {
            propertyName = property.getName();
            if ("hasMany".equals(propertyName) || "belongsTo".equals(propertyName) || "hasOne".equals(propertyName)) {
                Expression initialExpression = property.getInitialExpression();
                this.populatePropertiesForInitialExpression(cachedProperties, initialExpression);
                continue;
            }
            cachedProperties.put(propertyName, property.getType());
        }
        if (classNode.isResolved()) {
            ClassPropertyFetcher propertyFetcher = ClassPropertyFetcher.forClass((Class)classNode.getTypeClass());
            this.cachePropertiesForAssociationMetadata(cachedProperties, propertyFetcher, "hasMany");
            this.cachePropertiesForAssociationMetadata(cachedProperties, propertyFetcher, "belongsTo");
            this.cachePropertiesForAssociationMetadata(cachedProperties, propertyFetcher, "hasOne");
        }
    }

    private void cachePropertiesForAssociationMetadata(Map<String, ClassNode> cachedProperties, ClassPropertyFetcher propertyFetcher, String associationMetadataName) {
        Object propertyValue;
        if (propertyFetcher.isReadableProperty(associationMetadataName) && (propertyValue = propertyFetcher.getPropertyValue(associationMetadataName)) instanceof Map) {
            Map hasManyMap = (Map)propertyValue;
            for (Object propertyName : hasManyMap.keySet()) {
                Object val = hasManyMap.get(propertyName);
                if (!(val instanceof Class)) continue;
                cachedProperties.put(propertyName.toString(), ClassHelper.make((Class)((Class)val)).getPlainNodeReference());
            }
        }
    }

    private void populatePropertiesForInitialExpression(Map<String, ClassNode> cachedProperties, Expression initialExpression) {
        if (initialExpression instanceof MapExpression) {
            MapExpression me = (MapExpression)initialExpression;
            List mapEntryExpressions = me.getMapEntryExpressions();
            for (MapEntryExpression mapEntryExpression : mapEntryExpressions) {
                Expression keyExpression = mapEntryExpression.getKeyExpression();
                Expression valueExpression = mapEntryExpression.getValueExpression();
                if (!(valueExpression instanceof ClassExpression)) continue;
                cachedProperties.put(keyExpression.getText(), valueExpression.getType());
            }
        }
    }

    private void addBlockStatementToNewQuery(BlockStatement blockStatement, BlockStatement newCode, boolean addAll, List<String> propertyNames, VariableScope variableScope) {
        List statements = blockStatement.getStatements();
        for (Statement statement : statements) {
            this.addStatementToNewQuery(statement, newCode, addAll, propertyNames, variableScope);
        }
    }

    private void addStatementToNewQuery(Statement statement, BlockStatement newCode, boolean addAll, List<String> propertyNames, VariableScope variableScope) {
        if (statement instanceof BlockStatement) {
            this.addBlockStatementToNewQuery((BlockStatement)statement, newCode, addAll, propertyNames, variableScope);
        } else if (statement instanceof ExpressionStatement) {
            ExpressionStatement es = (ExpressionStatement)statement;
            Expression expression = es.getExpression();
            if (expression instanceof DeclarationExpression) {
                DeclarationExpression de = (DeclarationExpression)expression;
                Expression leftExpression = de.getLeftExpression();
                Expression rightExpression = de.getRightExpression();
                if (leftExpression instanceof VariableExpression && rightExpression instanceof ClassExpression) {
                    ClassExpression classExpression = (ClassExpression)rightExpression;
                    if (this.currentClassNode.equals((Object)classExpression.getType())) {
                        ArgumentListExpression arguments = new ArgumentListExpression();
                        String aliasName = leftExpression.getText();
                        this.aliases.put(aliasName, this.currentClassNode);
                        arguments.addExpression((Expression)new ConstantExpression((Object)aliasName));
                        MethodCallExpression setAliasMethodCall = new MethodCallExpression((Expression)new VariableExpression("this"), "setAlias", (Expression)arguments);
                        newCode.addStatement((Statement)new ExpressionStatement((Expression)setAliasMethodCall));
                    }
                    newCode.addStatement((Statement)es);
                } else if (leftExpression instanceof VariableExpression && rightExpression instanceof VariableExpression) {
                    String referencedProperty = rightExpression.getText();
                    if (propertyNames.contains(referencedProperty)) {
                        ArgumentListExpression arguments = new ArgumentListExpression();
                        arguments.addExpression((Expression)new ConstantExpression((Object)referencedProperty));
                        String aliasName = leftExpression.getText();
                        this.aliases.put(aliasName, referencedProperty);
                        arguments.addExpression((Expression)new ConstantExpression((Object)aliasName));
                        MethodCallExpression createAliasMethodCall = new MethodCallExpression((Expression)new VariableExpression("this"), "createAlias", (Expression)arguments);
                        newCode.addStatement((Statement)new ExpressionStatement((Expression)createAliasMethodCall));
                    }
                    newCode.addStatement((Statement)es);
                } else {
                    newCode.addStatement((Statement)es);
                }
            } else if (expression instanceof BinaryExpression) {
                BinaryExpression be = (BinaryExpression)expression;
                this.addBinaryExpressionToNewBody(propertyNames, newCode, be, addAll, variableScope);
            } else if (expression instanceof NotExpression) {
                NotExpression not = (NotExpression)expression;
                this.handleNegation(propertyNames, newCode, not, variableScope);
            } else if (expression instanceof MethodCallExpression) {
                MethodCallExpression methodCall = (MethodCallExpression)expression;
                this.handleAssociationMethodCallExpression(newCode, methodCall, propertyNames, variableScope);
            }
        } else if (statement instanceof IfStatement) {
            IfStatement ifs = (IfStatement)statement;
            Statement ifb = ifs.getIfBlock();
            BlockStatement newIfBlock = new BlockStatement();
            this.addStatementToNewQuery(ifb, newIfBlock, addAll, propertyNames, variableScope);
            ifs.setIfBlock(this.flattenStatementIfNecessary(newIfBlock));
            Statement elseBlock = ifs.getElseBlock();
            if (elseBlock != null) {
                BlockStatement newElseBlock = new BlockStatement();
                this.addStatementToNewQuery(elseBlock, newElseBlock, addAll, propertyNames, variableScope);
                ifs.setElseBlock(this.flattenStatementIfNecessary(newElseBlock));
            }
            newCode.addStatement((Statement)ifs);
        } else if (statement instanceof SwitchStatement) {
            SwitchStatement sw = (SwitchStatement)statement;
            List caseStatements = sw.getCaseStatements();
            for (CaseStatement caseStatement : caseStatements) {
                Statement existingCode = caseStatement.getCode();
                BlockStatement newCaseCode = new BlockStatement();
                this.addStatementToNewQuery(existingCode, newCaseCode, addAll, propertyNames, variableScope);
                caseStatement.setCode(this.flattenStatementIfNecessary(newCaseCode));
            }
            newCode.addStatement((Statement)sw);
        } else if (statement instanceof ForStatement) {
            ForStatement fs = (ForStatement)statement;
            Statement loopBlock = fs.getLoopBlock();
            BlockStatement newLoopBlock = new BlockStatement();
            this.addStatementToNewQuery(loopBlock, newLoopBlock, addAll, propertyNames, variableScope);
            fs.setLoopBlock(this.flattenStatementIfNecessary(newLoopBlock));
            newCode.addStatement((Statement)fs);
        } else if (statement instanceof WhileStatement) {
            WhileStatement ws = (WhileStatement)statement;
            Statement loopBlock = ws.getLoopBlock();
            BlockStatement newLoopBlock = new BlockStatement();
            this.addStatementToNewQuery(loopBlock, newLoopBlock, addAll, propertyNames, variableScope);
            ws.setLoopBlock(this.flattenStatementIfNecessary(newLoopBlock));
            newCode.addStatement((Statement)ws);
        } else if (statement instanceof TryCatchStatement) {
            TryCatchStatement tcs = (TryCatchStatement)statement;
            Statement tryStatement = tcs.getTryStatement();
            BlockStatement newTryStatement = new BlockStatement();
            this.addStatementToNewQuery(tryStatement, newTryStatement, addAll, propertyNames, variableScope);
            tcs.setTryStatement(this.flattenStatementIfNecessary(newTryStatement));
            List catchStatements = tcs.getCatchStatements();
            for (CatchStatement catchStatement : catchStatements) {
                BlockStatement newCatchStatement = new BlockStatement();
                Statement code = catchStatement.getCode();
                this.addStatementToNewQuery(code, newCatchStatement, addAll, propertyNames, variableScope);
                catchStatement.setCode(this.flattenStatementIfNecessary(newCatchStatement));
            }
            Statement finallyStatement = tcs.getFinallyStatement();
            if (finallyStatement != null) {
                BlockStatement newFinallyStatement = new BlockStatement();
                this.addStatementToNewQuery(finallyStatement, newFinallyStatement, addAll, propertyNames, variableScope);
                tcs.setFinallyStatement(this.flattenStatementIfNecessary(newFinallyStatement));
            }
            newCode.addStatement((Statement)tcs);
        } else if (statement instanceof ReturnStatement) {
            ReturnStatement rs = (ReturnStatement)statement;
            this.addStatementToNewQuery((Statement)new ExpressionStatement(rs.getExpression()), newCode, addAll, propertyNames, variableScope);
        } else {
            newCode.addStatement(statement);
        }
    }

    private Statement flattenStatementIfNecessary(BlockStatement blockStatement) {
        if (blockStatement.getStatements().size() == 1) {
            return (Statement)blockStatement.getStatements().get(0);
        }
        return blockStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleAssociationMethodCallExpression(BlockStatement newCode, MethodCallExpression methodCall, List<String> propertyNames, VariableScope variableScope) {
        ArgumentListExpression arguments;
        Expression method = methodCall.getMethod();
        String methodName = method.getText();
        ArgumentListExpression argumentListExpression = arguments = methodCall.getArguments() instanceof ArgumentListExpression ? (ArgumentListExpression)methodCall.getArguments() : null;
        if (methodName.equals("call") && this.hasClosureArgument(arguments)) {
            methodName = methodCall.getObjectExpression().getText();
        }
        if (this.isAssociationMethodCall(propertyNames, methodName, arguments)) {
            ClassNode associationTypeFromGenerics;
            ClosureAndArguments closureAndArguments = new ClosureAndArguments(variableScope);
            ClosureExpression associationQuery = (ClosureExpression)arguments.getExpression(0);
            BlockStatement currentBody = closureAndArguments.getCurrentBody();
            ArgumentListExpression argList = closureAndArguments.getArguments();
            newCode.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new VariableExpression("delegate"), methodName, (Expression)argList)));
            Statement associationCode = associationQuery.getCode();
            if (!(associationCode instanceof BlockStatement)) return;
            List<String> associationPropertyNames = null;
            ClassNode type = this.getPropertyType(methodName);
            if (!AstUtils.isDomainClass((ClassNode)type) && (associationTypeFromGenerics = this.getAssociationTypeFromGenerics(type)) != null) {
                type = associationTypeFromGenerics;
                associationPropertyNames = this.getPropertyNamesForAssociation(associationTypeFromGenerics);
            }
            if (associationPropertyNames == null) {
                associationPropertyNames = this.getPropertyNames(type);
            }
            ClassNode existing = this.currentClassNode;
            try {
                if (!associationPropertyNames.isEmpty() && !AstUtils.isDomainClass((ClassNode)type) && (type = this.getAssociationTypeFromGenerics(type)) != null) {
                    associationPropertyNames = this.getPropertyNames(type);
                }
                if (type == null) return;
                this.currentClassNode = type;
                this.addBlockStatementToNewQuery((BlockStatement)associationCode, currentBody, associationPropertyNames.isEmpty(), associationPropertyNames, variableScope);
                return;
            }
            finally {
                this.currentClassNode = existing;
            }
        } else {
            newCode.addStatement((Statement)new ExpressionStatement((Expression)methodCall));
        }
    }

    private List<String> getPropertyNamesForAssociation(ClassNode type) {
        List<String> associationPropertyNames = Collections.emptyList();
        if (type != null) {
            if (AstUtils.isDomainClass((ClassNode)type)) {
                associationPropertyNames = this.getPropertyNames(type);
            } else {
                ClassNode associationType = this.getAssociationTypeFromGenerics(type);
                if (associationType != null) {
                    associationPropertyNames = this.getPropertyNames(associationType);
                }
            }
        }
        return associationPropertyNames;
    }

    private ClassNode getAssociationTypeFromGenerics(ClassNode type) {
        GenericsType[] genericsTypes = type.getGenericsTypes();
        ClassNode associationType = null;
        if (genericsTypes != null && genericsTypes.length == 1) {
            GenericsType genericType = genericsTypes[0];
            associationType = genericType.getType();
        }
        return associationType;
    }

    private ClassNode getPropertyType(String prop) {
        ClassNode classNode = this.currentClassNode;
        return this.getPropertyType(classNode, prop);
    }

    private ClassNode getPropertyType(ClassNode classNode, String prop) {
        Map<String, ClassNode> cachedProperties = this.cachedClassProperties.get(classNode.getName());
        if (cachedProperties != null && cachedProperties.containsKey(prop)) {
            return cachedProperties.get(prop);
        }
        ClassNode type = null;
        PropertyNode property = classNode.getProperty(prop);
        if (property != null) {
            type = property.getType();
        } else {
            MethodNode methodNode = this.currentClassNode.getMethod(NameUtils.getGetterName((String)prop), new Parameter[0]);
            if (methodNode != null) {
                type = methodNode.getReturnType();
            } else {
                FieldNode fieldNode = classNode.getDeclaredField(prop);
                if (fieldNode != null) {
                    type = fieldNode.getType();
                }
            }
        }
        return type;
    }

    private boolean isAssociationMethodCall(List<String> propertyNames, String methodName, ArgumentListExpression arguments) {
        return propertyNames.contains(methodName) && this.hasClosureArgument(arguments);
    }

    private boolean hasClosureArgument(ArgumentListExpression arguments) {
        return arguments != null && arguments.getExpressions().size() == 1 && arguments.getExpression(0) instanceof ClosureExpression;
    }

    private void handleNegation(List<String> propertyNames, BlockStatement newCode, NotExpression not, VariableScope variableScope) {
        Expression subExpression = not.getExpression();
        if (subExpression instanceof BinaryExpression) {
            ArgumentListExpression arguments = new ArgumentListExpression();
            BlockStatement currentBody = new BlockStatement();
            ClosureExpression newClosureExpression = new ClosureExpression(new Parameter[0], (Statement)currentBody);
            newClosureExpression.setVariableScope(new VariableScope());
            arguments.addExpression((Expression)newClosureExpression);
            this.addBinaryExpressionToNewBody(propertyNames, currentBody, (BinaryExpression)subExpression, false, variableScope);
            newCode.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new VariableExpression("this"), "not", (Expression)arguments)));
        } else {
            this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("You can only negate a binary expressions in queries.", (CSTNode)Token.newString((String)not.getText(), (int)not.getLineNumber(), (int)not.getColumnNumber()), this.sourceUnit));
        }
    }

    private void addBinaryExpressionToNewBody(List<String> propertyNames, BlockStatement newCode, BinaryExpression be, boolean addAll, VariableScope variableScope) {
        block19: {
            Expression rightExpression;
            Expression leftExpression;
            String operator;
            Token operation;
            block17: {
                String propertyName;
                block18: {
                    operation = be.getOperation();
                    operator = operation.getRootText();
                    leftExpression = be.getLeftExpression();
                    rightExpression = be.getRightExpression();
                    if (!(leftExpression instanceof VariableExpression)) break block17;
                    VariableExpression leftVariable = (VariableExpression)leftExpression;
                    propertyName = leftVariable.getText();
                    if (!propertyNames.contains(propertyName) && !addAll) break block18;
                    if (OPERATOR_TO_CRITERIA_METHOD_MAP.containsKey(operator)) {
                        this.addCriteriaCallMethodExpression(newCode, operator, leftExpression, rightExpression, propertyName, propertyNames, addAll, variableScope);
                    } else {
                        this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("Unsupported operator [" + operator + "] used in query", (CSTNode)operation, this.sourceUnit));
                    }
                    break block19;
                }
                if (this.sourceUnit == null) break block19;
                this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("Cannot query on property \"" + propertyName + "\" - no such property on class " + this.currentClassNode.getName() + " exists.", (CSTNode)Token.newString((String)propertyName, (int)leftExpression.getLineNumber(), (int)leftExpression.getColumnNumber()), this.sourceUnit));
                break block19;
            }
            if (leftExpression instanceof MethodCallExpression) {
                MethodCallExpression mce = (MethodCallExpression)leftExpression;
                String methodName = mce.getMethodAsString();
                Expression objectExpression = mce.getObjectExpression();
                if ("size".equals(methodName) && objectExpression instanceof VariableExpression) {
                    String propertyName = objectExpression.getText();
                    if (propertyNames.contains(propertyName)) {
                        String sizeOperator = SIZE_OPERATOR_TO_CRITERIA_METHOD_MAP.get(operator);
                        if (sizeOperator != null) {
                            this.addCriteriaCall(newCode, operator, (Expression)mce, rightExpression, propertyName, propertyNames, addAll, sizeOperator, variableScope);
                        } else {
                            this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("Unsupported operator [" + operator + "] used in size() query", (CSTNode)operation, this.sourceUnit));
                        }
                    } else {
                        this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("Cannot query size of property \"" + propertyName + "\" - no such property on class " + this.currentClassNode.getName() + " exists.", (CSTNode)Token.newString((String)propertyName, (int)leftExpression.getLineNumber(), (int)leftExpression.getColumnNumber()), this.sourceUnit));
                    }
                    return;
                }
                boolean isFunctionCall = this.isFunctionCall(mce, methodName, objectExpression);
                if (isFunctionCall) {
                    String functionName = methodName;
                    ArgumentListExpression existingArgs = (ArgumentListExpression)mce.getArguments();
                    Expression propertyNameExpression = existingArgs.getExpression(0);
                    if (propertyNameExpression instanceof PropertyExpression) {
                        this.handleAssociationQueryViaPropertyExpression((PropertyExpression)propertyNameExpression, rightExpression, operator, newCode, propertyNames, functionName, variableScope);
                    } else {
                        this.handleFunctionCall(newCode, operator, rightExpression, functionName, propertyNameExpression);
                    }
                    return;
                }
            }
            String methodNameToCall = null;
            if (operator.contains(AND_OPERATOR)) {
                methodNameToCall = "and";
            } else if (operator.contains(OR_OPERATOR)) {
                methodNameToCall = "or";
            }
            ArgumentListExpression arguments = new ArgumentListExpression();
            BlockStatement currentBody = new BlockStatement();
            this.handleBinaryExpressionSide(leftExpression, rightExpression, operator, currentBody, addAll, propertyNames, variableScope);
            this.handleBinaryExpressionSide(rightExpression, rightExpression, operator, currentBody, addAll, propertyNames, variableScope);
            ClosureExpression newClosureExpression = new ClosureExpression(new Parameter[0], (Statement)currentBody);
            newClosureExpression.setVariableScope(variableScope);
            arguments.addExpression((Expression)newClosureExpression);
            if (methodNameToCall != null) {
                newCode.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new VariableExpression("this"), methodNameToCall, (Expression)arguments)));
            } else {
                List statements = currentBody.getStatements();
                for (Statement statement : statements) {
                    newCode.addStatement(statement);
                }
            }
        }
    }

    private boolean isFunctionCall(MethodCallExpression mce) {
        boolean isThis = "this".equals(mce.getObjectExpression().getText());
        Expression arguments = mce.getArguments();
        boolean hasOneArg = arguments instanceof ArgumentListExpression ? ((ArgumentListExpression)arguments).getExpressions().size() == 1 : false;
        return isThis && hasOneArg && SUPPORTED_FUNCTIONS.contains(mce.getMethodAsString());
    }

    private boolean isFunctionCall(MethodCallExpression mce, String methodName, Expression objectExpression) {
        boolean isThis = "this".equals(objectExpression.getText());
        Expression arguments = mce.getArguments();
        boolean hasOneArg = arguments instanceof ArgumentListExpression ? ((ArgumentListExpression)arguments).getExpressions().size() == 1 : false;
        return isThis && hasOneArg && SUPPORTED_FUNCTIONS.contains(methodName);
    }

    private void handleFunctionCall(BlockStatement newCode, String operator, Expression rightExpression, String functionName, Expression propertyNameExpression) {
        ArgumentListExpression newArgs = new ArgumentListExpression();
        ArgumentListExpression constructorArgs = new ArgumentListExpression();
        constructorArgs.addExpression((Expression)new ConstantExpression((Object)functionName));
        ClassNode criterionClassNode = OPERATOR_TO_CRITERION_METHOD_MAP.get(operator);
        if (criterionClassNode != null) {
            ArgumentListExpression criterionConstructorArguments = new ArgumentListExpression();
            if (!(propertyNameExpression instanceof ConstantExpression)) {
                propertyNameExpression = new ConstantExpression((Object)propertyNameExpression.getText());
            }
            criterionConstructorArguments.addExpression(propertyNameExpression);
            criterionConstructorArguments.addExpression(rightExpression);
            constructorArgs.addExpression((Expression)new ConstructorCallExpression(criterionClassNode, (Expression)criterionConstructorArguments));
            ConstructorCallExpression constructorCallExpression = new ConstructorCallExpression(FUNCTION_CALL_CRITERION, (Expression)constructorArgs);
            newArgs.addExpression((Expression)constructorCallExpression);
            newCode.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new VariableExpression("this"), "add", (Expression)newArgs)));
        } else {
            this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("Unsupported operator [" + operator + "] used with function call [" + functionName + "] in query", (CSTNode)Token.newString((String)functionName, (int)rightExpression.getLineNumber(), (int)rightExpression.getColumnNumber()), this.sourceUnit));
        }
    }

    private void handleBinaryExpressionSide(Expression expressionSide, Expression oppositeSide, String operator, BlockStatement newCode, boolean addAll, List<String> propertyNames, VariableScope variableScope) {
        if (this.aliasExpressions.contains(expressionSide)) {
            return;
        }
        if (expressionSide instanceof BinaryExpression) {
            this.addBinaryExpressionToNewBody(propertyNames, newCode, (BinaryExpression)expressionSide, addAll, variableScope);
        } else if (expressionSide instanceof NotExpression) {
            this.handleNegation(propertyNames, newCode, (NotExpression)expressionSide, variableScope);
        } else if (expressionSide instanceof MethodCallExpression) {
            MethodCallExpression methodCallExpression = (MethodCallExpression)expressionSide;
            this.handleAssociationMethodCallExpression(newCode, methodCallExpression, propertyNames, variableScope);
        } else if (expressionSide instanceof PropertyExpression) {
            PropertyExpression pe = (PropertyExpression)expressionSide;
            this.handleAssociationQueryViaPropertyExpression(pe, oppositeSide, operator, newCode, propertyNames, null, variableScope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAssociationQueryViaPropertyExpression(PropertyExpression pe, Expression oppositeSide, String operator, BlockStatement newCode, List<String> propertyNames, String functionName, VariableScope variableScope) {
        Expression objectExpression = pe.getObjectExpression();
        if (objectExpression instanceof PropertyExpression) {
            ArrayList<String> associationMethodCalls = new ArrayList<String>();
            while (objectExpression instanceof PropertyExpression) {
                PropertyExpression currentPe = (PropertyExpression)objectExpression;
                associationMethodCalls.add(currentPe.getPropertyAsString());
                objectExpression = currentPe.getObjectExpression();
            }
            if (objectExpression instanceof VariableExpression) {
                VariableExpression ve = (VariableExpression)objectExpression;
                String propertyName = ve.getName();
                if (!propertyName.equals("$self") || !Traits.isTrait((ClassNode)objectExpression.getType())) {
                    associationMethodCalls.add(propertyName);
                }
                Collections.reverse(associationMethodCalls);
                ClassNode currentType = this.currentClassNode;
                BlockStatement currentBody = newCode;
                VariableExpression delegateExpression = new VariableExpression("delegate");
                Iterator iterator = associationMethodCalls.iterator();
                while (iterator.hasNext()) {
                    String associationMethodCall = (String)iterator.next();
                    ClosureAndArguments closureAndArguments = new ClosureAndArguments(variableScope);
                    ArgumentListExpression arguments = closureAndArguments.getArguments();
                    ClassNode type = this.getPropertyTypeFromGenerics(associationMethodCall, currentType);
                    if (type != null) {
                        currentType = type;
                        currentBody.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)delegateExpression, associationMethodCall, (Expression)arguments)));
                        currentBody = closureAndArguments.getCurrentBody();
                        if (iterator.hasNext()) continue;
                        String associationProperty = pe.getPropertyAsString();
                        List<String> associationPropertyNames = this.getPropertyNamesForAssociation(type);
                        ClassNode existing = this.currentClassNode;
                        try {
                            this.currentClassNode = type;
                            boolean hasNoProperties = associationPropertyNames.isEmpty();
                            if (functionName != null) {
                                this.handleFunctionCall(currentBody, operator, oppositeSide, functionName, (Expression)new ConstantExpression((Object)associationProperty));
                                continue;
                            }
                            this.addCriteriaCallMethodExpression(currentBody, operator, (Expression)pe, oppositeSide, associationProperty, associationPropertyNames, hasNoProperties, variableScope);
                            continue;
                        }
                        finally {
                            this.currentClassNode = existing;
                            continue;
                        }
                    }
                    break;
                }
            }
        } else if (objectExpression instanceof VariableExpression) {
            String propertyName = objectExpression.getText();
            if (propertyName.equals("$self") && Traits.isTrait((ClassNode)objectExpression.getType())) {
                propertyName = pe.getPropertyAsString();
            }
            Object aliased = this.aliases.get(propertyName);
            if (propertyNames.contains(propertyName) || aliased != null && propertyNames.contains(aliased)) {
                ClassNode classNode;
                String associationProperty = pe.getPropertyAsString();
                String actualPropertyName = aliased != null ? aliased.toString() : propertyName;
                ClassNode type = this.getPropertyTypeFromGenerics(actualPropertyName, classNode = this.currentClassNode);
                if (!AstUtils.isDomainClass((ClassNode)type)) {
                    this.addCriteriaCallMethodExpression(newCode, operator, (Expression)pe, oppositeSide, associationProperty, Collections.emptyList(), false, variableScope);
                } else {
                    List<String> associationPropertyNames = this.getPropertyNamesForAssociation(type);
                    if (associationPropertyNames == null) {
                        associationPropertyNames = this.getPropertyNamesForAssociation(classNode);
                    }
                    ClosureAndArguments closureAndArguments = new ClosureAndArguments(variableScope);
                    BlockStatement currentBody = closureAndArguments.getCurrentBody();
                    ArgumentListExpression arguments = closureAndArguments.getArguments();
                    boolean hasNoProperties = associationPropertyNames.isEmpty();
                    if (!hasNoProperties && !associationPropertyNames.contains(associationProperty)) {
                        this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("Cannot query property \"" + associationProperty + "\" - no such property on class " + type.getName() + " exists.", (CSTNode)Token.newString((String)propertyName, (int)pe.getLineNumber(), (int)pe.getColumnNumber()), this.sourceUnit));
                    }
                    ClassNode existing = this.currentClassNode;
                    try {
                        this.currentClassNode = type;
                        if (functionName != null) {
                            this.handleFunctionCall(currentBody, operator, oppositeSide, functionName, (Expression)new ConstantExpression((Object)associationProperty));
                        } else {
                            this.addCriteriaCallMethodExpression(currentBody, operator, (Expression)pe, oppositeSide, associationProperty, associationPropertyNames, hasNoProperties, variableScope);
                        }
                    }
                    finally {
                        this.currentClassNode = existing;
                    }
                    newCode.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new VariableExpression("delegate"), actualPropertyName, (Expression)arguments)));
                }
            } else if (aliased instanceof ClassNode && oppositeSide instanceof PropertyExpression) {
                String rootReference = pe.getText();
                PropertyExpression oppositeProperty = (PropertyExpression)oppositeSide;
                String targetObject = oppositeProperty.getObjectExpression().getText();
                if (this.aliases.containsKey(targetObject)) {
                    String methodToCall = PROPERTY_COMPARISON_OPERATOR_TO_CRITERIA_METHOD_MAP.get(operator);
                    ArgumentListExpression args = new ArgumentListExpression();
                    args.addExpression((Expression)new ConstantExpression((Object)rootReference));
                    args.addExpression((Expression)new ConstantExpression((Object)oppositeProperty.getText()));
                    newCode.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new VariableExpression("this"), methodToCall, (Expression)args)));
                }
            } else if (!variableScope.isReferencedLocalVariable(propertyName)) {
                this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("Cannot query property \"" + propertyName + "\" - no such property on class " + this.currentClassNode.getName() + " exists.", (CSTNode)Token.newString((String)propertyName, (int)pe.getLineNumber(), (int)pe.getColumnNumber()), this.sourceUnit));
            }
        }
    }

    private ClassNode getPropertyTypeFromGenerics(String propertyName, ClassNode classNode) {
        ClassNode associationTypeFromGenerics;
        ClassNode type = this.getPropertyType(classNode, propertyName);
        if (type != null && !AstUtils.isDomainClass((ClassNode)type) && (associationTypeFromGenerics = this.getAssociationTypeFromGenerics(type)) != null && AstUtils.isDomainClass((ClassNode)associationTypeFromGenerics)) {
            type = associationTypeFromGenerics;
        }
        return type;
    }

    private void addCriteriaCallMethodExpression(BlockStatement newCode, String operator, Expression leftExpression, Expression rightExpression, String propertyName, List<String> propertyNames, boolean addAll, VariableScope variableScope) {
        String methodToCall = OPERATOR_TO_CRITERIA_METHOD_MAP.get(operator);
        if (methodToCall == null) {
            this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("Unsupported operator [" + operator + "] used in query", (CSTNode)Token.newString((String)rightExpression.getText(), (int)rightExpression.getLineNumber(), (int)rightExpression.getColumnNumber()), this.sourceUnit));
        }
        this.addCriteriaCall(newCode, operator, leftExpression, rightExpression, propertyName, propertyNames, addAll, methodToCall, variableScope);
    }

    private void addCriteriaCall(BlockStatement newCode, String operator, Expression leftExpression, Expression rightExpression, String propertyName, List<String> propertyNames, boolean addAll, String methodToCall, VariableScope variableScope) {
        ArgumentListExpression arguments;
        if (rightExpression instanceof VariableExpression) {
            String rightPropertyName = rightExpression.getText();
            if (!variableScope.isReferencedLocalVariable(rightPropertyName) && (propertyNames.contains(rightPropertyName) || addAll) && PROPERTY_COMPARISON_OPERATOR_TO_CRITERIA_METHOD_MAP.containsKey(operator)) {
                methodToCall = PROPERTY_COMPARISON_OPERATOR_TO_CRITERIA_METHOD_MAP.get(operator);
                rightExpression = new ConstantExpression((Object)rightPropertyName);
            }
        } else if (rightExpression instanceof MethodCallExpression) {
            MethodCallExpression aggregateMethodCall = (MethodCallExpression)rightExpression;
            Expression methodTarget = aggregateMethodCall.getObjectExpression();
            String methodName = aggregateMethodCall.getMethodAsString();
            String aggregateFunctionName = AGGREGATE_FUNCTIONS.get(methodName);
            if ("of".equals(methodName) && aggregateMethodCall.getObjectExpression() instanceof MethodCallExpression) {
                ArgumentListExpression arguments2 = (ArgumentListExpression)aggregateMethodCall.getArguments();
                if (arguments2.getExpressions().size() == 1 && arguments2.getExpression(0) instanceof ClosureExpression) {
                    ClosureExpression ce = (ClosureExpression)arguments2.getExpression(0);
                    this.transformClosureExpression(this.currentClassNode, ce);
                    aggregateMethodCall = (MethodCallExpression)aggregateMethodCall.getObjectExpression();
                    aggregateFunctionName = AGGREGATE_FUNCTIONS.get(aggregateMethodCall.getMethodAsString());
                    ArgumentListExpression aggregateMethodCallArguments = (ArgumentListExpression)aggregateMethodCall.getArguments();
                    if (aggregateFunctionName != null && aggregateMethodCallArguments.getExpressions().size() == 1) {
                        boolean validProperty;
                        Expression expression = aggregateMethodCallArguments.getExpression(0);
                        String aggregatePropertyName = null;
                        if (expression instanceof VariableExpression || expression instanceof ConstantExpression) {
                            aggregatePropertyName = expression.getText();
                        }
                        boolean bl = validProperty = aggregatePropertyName != null && propertyNames.contains(aggregatePropertyName);
                        if (validProperty) {
                            BlockStatement bs = (BlockStatement)ce.getCode();
                            this.addProjectionToCurrentBody(bs, aggregateFunctionName, aggregatePropertyName, variableScope);
                            rightExpression = new MethodCallExpression((Expression)new ConstructorCallExpression(this.getParameterizedDetachedCriteriaClassNode(null), (Expression)new ArgumentListExpression((Expression)new ClassExpression(this.currentClassNode))), "build", (Expression)new ArgumentListExpression((Expression)ce));
                        }
                    }
                }
            } else if (aggregateFunctionName != null) {
                ArgumentListExpression argList;
                List expressions;
                int argCount;
                Expression arguments3;
                if (methodTarget instanceof VariableExpression && ((VariableExpression)methodTarget).isThisExpression() && (arguments3 = aggregateMethodCall.getArguments()) instanceof ArgumentListExpression && (argCount = (expressions = (argList = (ArgumentListExpression)arguments3).getExpressions()).size()) == 1) {
                    boolean validProperty;
                    Expression expression = (Expression)expressions.get(0);
                    String aggregatePropertyName = null;
                    if (!(expression instanceof VariableExpression) && !(expression instanceof ConstantExpression)) {
                        this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("Cannot use aggregate function " + aggregateFunctionName + " on expressions \"" + expression.getText() + "\".", (CSTNode)Token.newString((String)propertyName, (int)aggregateMethodCall.getLineNumber(), (int)aggregateMethodCall.getColumnNumber()), this.sourceUnit));
                        return;
                    }
                    aggregatePropertyName = expression.getText();
                    boolean bl = validProperty = aggregatePropertyName != null && propertyNames.contains(aggregatePropertyName);
                    if (validProperty) {
                        ClosureAndArguments closureAndArguments = new ClosureAndArguments(variableScope);
                        BlockStatement currentBody = closureAndArguments.getCurrentBody();
                        this.addProjectionToCurrentBody(currentBody, aggregateFunctionName, aggregatePropertyName, variableScope);
                        rightExpression = closureAndArguments.getClosureExpression();
                        if ("property".equals(aggregateFunctionName) && METHOD_TO_SUBQUERY_MAP.containsKey(methodToCall)) {
                            methodToCall = methodToCall + "All";
                        }
                    } else {
                        this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("Cannot use aggregate function " + aggregateFunctionName + " on property \"" + aggregatePropertyName + "\" - no such property on class " + this.currentClassNode.getName() + " exists.", (CSTNode)Token.newString((String)propertyName, (int)aggregateMethodCall.getLineNumber(), (int)aggregateMethodCall.getColumnNumber()), this.sourceUnit));
                    }
                }
            } else if (this.isFunctionCall(aggregateMethodCall)) {
                ArgumentListExpression existingArgs = (ArgumentListExpression)aggregateMethodCall.getArguments();
                Expression propertyNameExpression = existingArgs.getExpression(0);
                this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("Function call " + aggregateFunctionName + " not allowed on property \"" + propertyNameExpression.getText() + "\". Function calls can currently only be used on the left-hand side of expressions", (CSTNode)Token.newString((String)propertyName, (int)aggregateMethodCall.getLineNumber(), (int)aggregateMethodCall.getColumnNumber()), this.sourceUnit));
                return;
            }
        } else if ("like".equals(methodToCall) && rightExpression instanceof BitwiseNegationExpression) {
            methodToCall = "rlike";
            BitwiseNegationExpression bne = (BitwiseNegationExpression)rightExpression;
            rightExpression = bne.getExpression();
        } else if ("inList".equals(methodToCall) && rightExpression instanceof RangeExpression) {
            methodToCall = "between";
            RangeExpression re = (RangeExpression)rightExpression;
            ArgumentListExpression betweenArgs = new ArgumentListExpression();
            betweenArgs.addExpression((Expression)new ConstantExpression((Object)propertyName)).addExpression(re.getFrom()).addExpression(re.getTo());
            rightExpression = betweenArgs;
        }
        if (rightExpression instanceof ArgumentListExpression) {
            arguments = (ArgumentListExpression)rightExpression;
        } else if (rightExpression instanceof ConstantExpression) {
            ConstantExpression constant = (ConstantExpression)rightExpression;
            if (constant.getValue() == null) {
                boolean singleArg = false;
                if (operator.equals(EQUALS_OPERATOR)) {
                    singleArg = true;
                    methodToCall = IS_NULL_CRITERION;
                } else if (operator.equals("!=")) {
                    singleArg = true;
                    methodToCall = "isNotNull";
                }
                arguments = new ArgumentListExpression();
                arguments.addExpression((Expression)new ConstantExpression((Object)propertyName));
                if (!singleArg) {
                    arguments.addExpression(rightExpression);
                }
            } else {
                arguments = new ArgumentListExpression();
                arguments.addExpression((Expression)new ConstantExpression((Object)propertyName)).addExpression(rightExpression);
            }
        } else if (rightExpression instanceof PropertyExpression) {
            PropertyExpression pe = (PropertyExpression)rightExpression;
            String property = pe.getObjectExpression().getText();
            if (leftExpression instanceof PropertyExpression && this.aliases.containsKey(property)) {
                this.aliasExpressions.add((Expression)pe);
                arguments = new ArgumentListExpression();
                arguments.addExpression((Expression)new ConstantExpression((Object)((PropertyExpression)leftExpression).getPropertyAsString()));
                arguments.addExpression((Expression)new ConstantExpression((Object)pe.getText()));
                methodToCall = PROPERTY_COMPARISON_OPERATOR_TO_CRITERIA_METHOD_MAP.get(operator);
            } else {
                arguments = new ArgumentListExpression();
                arguments.addExpression((Expression)new ConstantExpression((Object)propertyName)).addExpression(rightExpression);
            }
        } else {
            arguments = new ArgumentListExpression();
            arguments.addExpression((Expression)new ConstantExpression((Object)propertyName)).addExpression(rightExpression);
        }
        newCode.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new VariableExpression("this"), methodToCall, (Expression)arguments)));
    }

    private void addProjectionToCurrentBody(BlockStatement currentBody, String functionName, String aggregatePropertyName, VariableScope variableScope) {
        ClosureAndArguments projectionsBody = new ClosureAndArguments(variableScope);
        ArgumentListExpression aggregateArgs = new ArgumentListExpression();
        aggregateArgs.addExpression((Expression)new ConstantExpression((Object)aggregatePropertyName));
        VariableExpression thisExpression = new VariableExpression("this");
        projectionsBody.getCurrentBody().addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)thisExpression, functionName, (Expression)aggregateArgs)));
        currentBody.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)thisExpression, "projections", (Expression)projectionsBody.getArguments())));
    }

    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    private boolean isGetter(String methodName, MethodNode declaredMethod) {
        return declaredMethod.getParameters().length == 0 && ReflectionUtils.isGetter((String)methodName, (Class[])EMPTY_JAVA_CLASS_ARRAY);
    }

    private static <K, V> Map newMap(Object ... keysAndValues) {
        if (keysAndValues == null) {
            return Collections.emptyMap();
        }
        if (keysAndValues.length % 2 == 1) {
            throw new IllegalArgumentException("Must have an even number of keys and values");
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < keysAndValues.length; i += 2) {
            map.put(keysAndValues[i], keysAndValues[i + 1]);
        }
        return map;
    }

    private static <T> Set<T> newSet(T ... values) {
        if (values == null) {
            return Collections.emptySet();
        }
        return new HashSet<T>(Arrays.asList(values));
    }

    private class ClosureAndArguments {
        private BlockStatement currentBody;
        private ArgumentListExpression arguments;
        private ClosureExpression closureExpression;
        private VariableScope variableScope;

        private ClosureAndArguments(VariableScope variableScope) {
            this.variableScope = variableScope;
            this.build();
        }

        public BlockStatement getCurrentBody() {
            return this.currentBody;
        }

        public ArgumentListExpression getArguments() {
            return this.arguments;
        }

        private ClosureAndArguments build() {
            this.currentBody = new BlockStatement();
            this.closureExpression = new ClosureExpression(new Parameter[0], (Statement)this.currentBody);
            this.closureExpression.setVariableScope(this.variableScope);
            this.closureExpression.setCode((Statement)this.currentBody);
            this.arguments = new ArgumentListExpression();
            this.arguments.addExpression((Expression)this.closureExpression);
            return this;
        }

        public ClosureExpression getClosureExpression() {
            return this.closureExpression;
        }
    }
}

