/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.events;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.grails.datastore.gorm.timestamp.DefaultTimestampProvider;
import org.grails.datastore.gorm.timestamp.TimestampProvider;
import org.grails.datastore.mapping.config.Entity;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.event.AbstractPersistenceEvent;
import org.grails.datastore.mapping.engine.event.AbstractPersistenceEventListener;
import org.grails.datastore.mapping.engine.event.EventType;
import org.grails.datastore.mapping.engine.event.PreInsertEvent;
import org.grails.datastore.mapping.engine.event.PreUpdateEvent;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.springframework.context.ApplicationEvent;

public class AutoTimestampEventListener
extends AbstractPersistenceEventListener
implements MappingContext.Listener {
    public static final String DATE_CREATED_PROPERTY = "dateCreated";
    public static final String LAST_UPDATED_PROPERTY = "lastUpdated";
    protected Map<PersistentEntity, Boolean> entitiesWithDateCreated = new ConcurrentHashMap<PersistentEntity, Boolean>();
    protected Map<PersistentEntity, Boolean> entitiesWithLastUpdated = new ConcurrentHashMap<PersistentEntity, Boolean>();
    private TimestampProvider timestampProvider = new DefaultTimestampProvider();

    public AutoTimestampEventListener(Datastore datastore) {
        super(datastore);
        for (PersistentEntity persistentEntity : datastore.getMappingContext().getPersistentEntities()) {
            this.storeDateCreatedAndLastUpdatedInfo(persistentEntity);
        }
        datastore.getMappingContext().addMappingContextListener((MappingContext.Listener)this);
    }

    protected void onPersistenceEvent(AbstractPersistenceEvent event) {
        if (event.getEventType() == EventType.PreInsert) {
            this.beforeInsert(event.getEntity(), event.getEntityAccess());
        } else if (event.getEventType() == EventType.PreUpdate) {
            this.beforeUpdate(event.getEntity(), event.getEntityAccess());
        }
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return PreInsertEvent.class.isAssignableFrom(eventType) || PreUpdateEvent.class.isAssignableFrom(eventType);
    }

    public boolean beforeInsert(PersistentEntity entity, EntityAccess ea) {
        Class dateCreatedType = null;
        Object timestamp = null;
        if (this.hasDateCreated(entity)) {
            dateCreatedType = ea.getPropertyType(DATE_CREATED_PROPERTY);
            timestamp = this.timestampProvider.createTimestamp(dateCreatedType);
            ea.setProperty(DATE_CREATED_PROPERTY, timestamp);
        }
        if (this.hasLastupdated(entity)) {
            Class lastUpdateType = ea.getPropertyType(LAST_UPDATED_PROPERTY);
            if (dateCreatedType == null || !lastUpdateType.isAssignableFrom(dateCreatedType)) {
                timestamp = this.timestampProvider.createTimestamp(lastUpdateType);
            }
            ea.setProperty(LAST_UPDATED_PROPERTY, timestamp);
        }
        return true;
    }

    public boolean beforeUpdate(PersistentEntity entity, EntityAccess ea) {
        if (this.hasLastupdated(entity)) {
            Class lastUpdateType = ea.getPropertyType(LAST_UPDATED_PROPERTY);
            Object timestamp = this.timestampProvider.createTimestamp(lastUpdateType);
            ea.setProperty(LAST_UPDATED_PROPERTY, timestamp);
        }
        return true;
    }

    protected boolean hasLastupdated(PersistentEntity entity) {
        return this.entitiesWithLastUpdated.containsKey(entity) && this.entitiesWithLastUpdated.get(entity) != false;
    }

    protected boolean hasDateCreated(PersistentEntity entity) {
        return this.entitiesWithDateCreated.containsKey(entity) && this.entitiesWithDateCreated.get(entity) != false;
    }

    protected void storeDateCreatedAndLastUpdatedInfo(PersistentEntity persistentEntity) {
        ClassMapping classMapping = persistentEntity.getMapping();
        Entity mappedForm = classMapping.getMappedForm();
        if (mappedForm == null || mappedForm.isAutoTimestamp()) {
            this.storeTimestampAvailability(this.entitiesWithDateCreated, persistentEntity, persistentEntity.getPropertyByName(DATE_CREATED_PROPERTY));
            this.storeTimestampAvailability(this.entitiesWithLastUpdated, persistentEntity, persistentEntity.getPropertyByName(LAST_UPDATED_PROPERTY));
        }
    }

    protected void storeTimestampAvailability(Map<PersistentEntity, Boolean> timestampAvailabilityMap, PersistentEntity persistentEntity, PersistentProperty<?> property) {
        timestampAvailabilityMap.put(persistentEntity, property != null ? this.timestampProvider.supportsCreating(property.getType()) : false);
    }

    public void persistentEntityAdded(PersistentEntity entity) {
        this.storeDateCreatedAndLastUpdatedInfo(entity);
    }

    public TimestampProvider getTimestampProvider() {
        return this.timestampProvider;
    }

    public void setTimestampProvider(TimestampProvider timestampProvider) {
        this.timestampProvider = timestampProvider;
    }
}

