/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.config;

import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.grails.datastore.gorm.config.GrailsDomainClassPersistentEntity;
import org.grails.datastore.mapping.model.AbstractMappingContext;
import org.grails.datastore.mapping.model.MappingConfigurationStrategy;
import org.grails.datastore.mapping.model.MappingFactory;
import org.grails.datastore.mapping.model.PersistentEntity;

public class GrailsDomainClassMappingContext
extends AbstractMappingContext {
    private GrailsApplication grailsApplication;

    public GrailsDomainClassMappingContext(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
        GrailsClass[] artefacts = grailsApplication.getArtefacts("Domain");
        Class[] persistentClasses = new Class[artefacts.length];
        int i = 0;
        for (GrailsClass grailsClass : artefacts) {
            persistentClasses[i++] = grailsClass.getClazz();
        }
        this.addPersistentEntities(persistentClasses);
    }

    public GrailsApplication getGrailsApplication() {
        return this.grailsApplication;
    }

    public MappingConfigurationStrategy getMappingSyntaxStrategy() {
        throw new UnsupportedOperationException("MappingConfigurationStrategy not supported by implementation. Defined by Grails itself.");
    }

    public MappingFactory getMappingFactory() {
        throw new UnsupportedOperationException("MappingFactory not supported by implementation. Defined by Grails itself.");
    }

    protected PersistentEntity createPersistentEntity(Class javaClass) {
        GrailsDomainClass domainClass = (GrailsDomainClass)this.grailsApplication.getArtefact("Domain", javaClass.getName());
        return new GrailsDomainClassPersistentEntity(domainClass, this);
    }
}

