/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler.gorm;

import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.grails.compiler.injection.ASTValidationErrorsHelper;
import org.codehaus.groovy.grails.compiler.injection.AbstractGrailsArtefactTransformer;
import org.codehaus.groovy.grails.compiler.injection.AstTransformer;
import org.codehaus.groovy.grails.io.support.GrailsResourceUtils;
import org.grails.datastore.gorm.GormValidationApi;

@AstTransformer
public class GormValidationTransformer
extends AbstractGrailsArtefactTransformer {
    public static final String HAS_ERRORS_METHOD = "hasErrors";
    private static final List<String> EXCLUDES = Arrays.asList("setErrors", "getErrors", "hasErrors", "getBeforeValidateHelper", "setBeforeValidateHelper", "getValidator", "setValidator");

    protected boolean requiresStaticLookupMethod() {
        return true;
    }

    public String getArtefactType() {
        return "Domain";
    }

    public Class<?> getInstanceImplementation() {
        return GormValidationApi.class;
    }

    public Class<?> getStaticImplementation() {
        return null;
    }

    public boolean shouldInject(URL url) {
        return GrailsResourceUtils.isDomainClass((URL)url);
    }

    protected boolean isCandidateInstanceMethod(ClassNode classNode, MethodNode declaredMethod) {
        return !EXCLUDES.contains(declaredMethod.getName()) && super.isCandidateInstanceMethod(classNode, declaredMethod);
    }

    protected void performInjectionInternal(String apiInstanceProperty, SourceUnit source, ClassNode classNode) {
        PropertyNode errorsProperty = classNode.getProperty("errors");
        if (errorsProperty == null) {
            this.addErrorsProperty(classNode);
        }
    }

    private void addErrorsProperty(ClassNode classNode) {
        ASTValidationErrorsHelper errorsHelper = new ASTValidationErrorsHelper();
        errorsHelper.injectErrorsCode(classNode);
    }
}

