/*
 * Decompiled with CFR 0.152.
 */
package grails.gorm;

import grails.gorm.DetachedCriteria;
import grails.gorm.PagedResultList;
import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovySystem;
import groovy.lang.MetaMethod;
import groovy.lang.MetaObjectProtocol;
import groovy.lang.MissingMethodException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.grails.datastore.gorm.finders.DynamicFinder;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.query.AssociationQuery;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.Restrictions;
import org.grails.datastore.mapping.query.api.Criteria;
import org.grails.datastore.mapping.query.api.ProjectionList;
import org.grails.datastore.mapping.query.api.QueryableCriteria;
import org.springframework.util.Assert;

public class CriteriaBuilder
extends GroovyObjectSupport
implements Criteria,
ProjectionList {
    public static final String ORDER_DESCENDING = "desc";
    public static final String ORDER_ASCENDING = "asc";
    private static final String ROOT_DO_CALL = "doCall";
    private static final String ROOT_CALL = "call";
    private static final String SCROLL_CALL = "scroll";
    protected Class targetClass;
    protected Session session;
    protected Query query;
    private boolean uniqueResult = false;
    private boolean paginationEnabledList;
    protected List<Query.Order> orderEntries = new ArrayList<Query.Order>();
    private List<Query.Junction> logicalExpressionStack = new ArrayList<Query.Junction>();
    protected MetaObjectProtocol queryMetaClass;
    protected Query.ProjectionList projectionList;
    protected PersistentEntity persistentEntity;

    public CriteriaBuilder(Class targetClass, Session session) {
        Assert.notNull((Object)targetClass, (String)"Argument [targetClass] cannot be null");
        Assert.notNull((Object)session, (String)"Argument [session] cannot be null");
        this.persistentEntity = session.getDatastore().getMappingContext().getPersistentEntity(targetClass.getName());
        if (this.persistentEntity == null) {
            throw new IllegalArgumentException("Class [" + targetClass.getName() + "] is not a persistent entity");
        }
        this.targetClass = targetClass;
        this.session = session;
    }

    public CriteriaBuilder(Class targetClass, Session session, Query query) {
        this(targetClass, session);
        this.query = query;
    }

    public void setUniqueResult(boolean uniqueResult) {
        this.uniqueResult = uniqueResult;
    }

    public Criteria cache(boolean cache) {
        this.query.cache(cache);
        return this;
    }

    public Criteria join(String property) {
        this.query.join(property);
        return this;
    }

    public Query.ProjectionList id() {
        if (this.projectionList != null) {
            this.projectionList.id();
        }
        return this.projectionList;
    }

    public Query.ProjectionList count() {
        if (this.projectionList != null) {
            this.projectionList.count();
        }
        return this.projectionList;
    }

    public ProjectionList countDistinct(String property) {
        if (this.projectionList != null) {
            this.projectionList.countDistinct(property);
        }
        return this.projectionList;
    }

    public ProjectionList distinct() {
        if (this.projectionList != null) {
            this.projectionList.distinct();
        }
        return this.projectionList;
    }

    public ProjectionList distinct(String property) {
        if (this.projectionList != null) {
            this.projectionList.distinct(property);
        }
        return this.projectionList;
    }

    public ProjectionList rowCount() {
        return this.count();
    }

    public ProjectionList property(String name) {
        if (this.projectionList != null) {
            this.projectionList.property(name);
        }
        return this.projectionList;
    }

    public ProjectionList sum(String name) {
        if (this.projectionList != null) {
            this.projectionList.sum(name);
        }
        return this.projectionList;
    }

    public ProjectionList min(String name) {
        if (this.projectionList != null) {
            this.projectionList.min(name);
        }
        return this.projectionList;
    }

    public ProjectionList max(String name) {
        if (this.projectionList != null) {
            this.projectionList.max(name);
        }
        return this.projectionList;
    }

    public ProjectionList avg(String name) {
        if (this.projectionList != null) {
            this.projectionList.avg(name);
        }
        return this.projectionList;
    }

    public List list(Closure callable) {
        this.initializeQuery();
        this.invokeClosureNode(callable);
        return this.query.list();
    }

    public Object get(Closure callable) {
        this.initializeQuery();
        this.invokeClosureNode(callable);
        this.uniqueResult = true;
        return this.query.singleResult();
    }

    public List listDistinct(Closure callable) {
        this.initializeQuery();
        this.invokeClosureNode(callable);
        this.query.projections().distinct();
        return this.query.list();
    }

    public List list(Map paginateParams, Closure callable) {
        this.initializeQuery();
        this.paginationEnabledList = true;
        this.orderEntries = new ArrayList<Query.Order>();
        this.invokeClosureNode(callable);
        DynamicFinder.populateArgumentsForCriteria(this.targetClass, this.query, paginateParams);
        for (Query.Order orderEntry : this.orderEntries) {
            this.query.order(orderEntry);
        }
        return new PagedResultList(this.query);
    }

    public Number count(Closure callable) {
        this.initializeQuery();
        this.invokeClosureNode(callable);
        this.uniqueResult = true;
        this.query.projections().count();
        return (Number)this.query.singleResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeMethod(String name, Object obj) {
        PersistentProperty property;
        Object[] objectArray;
        if (obj.getClass().isArray()) {
            objectArray = (Object[])obj;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = obj;
        }
        Object[] args = objectArray;
        if (this.isCriteriaConstructionMethod(name, args)) {
            this.initializeQuery();
            this.uniqueResult = false;
            this.invokeClosureNode(args[0]);
            Object result = !this.uniqueResult ? this.query.list() : this.query.singleResult();
            this.query = null;
            return result;
        }
        MetaMethod metaMethod = this.getMetaClass().getMetaMethod(name, args);
        if (metaMethod != null) {
            return metaMethod.invoke((Object)this, args);
        }
        metaMethod = this.queryMetaClass.getMetaMethod(name, args);
        if (metaMethod != null) {
            return metaMethod.invoke((Object)this.query, args);
        }
        if (args.length == 1 && args[0] instanceof Closure && (property = this.persistentEntity.getPropertyByName(name)) instanceof Association) {
            Association association = (Association)property;
            Query previousQuery = this.query;
            PersistentEntity previousEntity = this.persistentEntity;
            List<Query.Junction> previousLogicalExpressionStack = this.logicalExpressionStack;
            AssociationQuery associationQuery = null;
            try {
                associationQuery = this.query.createQuery(property.getName());
                if (associationQuery instanceof AssociationQuery) {
                    previousQuery.add((Query.Criterion)associationQuery);
                }
                this.query = associationQuery;
                this.persistentEntity = association.getAssociatedEntity();
                this.logicalExpressionStack = new ArrayList<Query.Junction>();
                this.invokeClosureNode(args[0]);
                Query query = this.query;
                return query;
            }
            finally {
                this.logicalExpressionStack = previousLogicalExpressionStack;
                this.persistentEntity = previousEntity;
                this.query = previousQuery;
            }
        }
        throw new MissingMethodException(name, ((Object)((Object)this)).getClass(), args);
    }

    public ProjectionList projections(Closure callable) {
        this.projectionList = this.query.projections();
        this.invokeClosureNode(callable);
        return this.projectionList;
    }

    public Criteria and(Closure callable) {
        this.handleJunction((Query.Junction)new Query.Conjunction(), callable);
        return this;
    }

    public Criteria or(Closure callable) {
        this.handleJunction((Query.Junction)new Query.Disjunction(), callable);
        return this;
    }

    public Criteria not(Closure callable) {
        this.handleJunction((Query.Junction)new Query.Negation(), callable);
        return this;
    }

    public Criteria idEquals(Object value) {
        this.addToCriteria((Query.Criterion)Restrictions.idEq((Object)value));
        return this;
    }

    public Criteria exists(QueryableCriteria<?> subquery) {
        this.addToCriteria((Query.Criterion)new Query.Exists(subquery));
        return this;
    }

    public Criteria notExists(QueryableCriteria<?> subquery) {
        this.addToCriteria((Query.Criterion)new Query.NotExists(subquery));
        return this;
    }

    public Criteria isEmpty(String propertyName) {
        this.validatePropertyName(propertyName, "isEmpty");
        this.addToCriteria((Query.Criterion)Restrictions.isEmpty((String)propertyName));
        return this;
    }

    public Criteria isNotEmpty(String propertyName) {
        this.validatePropertyName(propertyName, "isNotEmpty");
        this.addToCriteria((Query.Criterion)Restrictions.isNotEmpty((String)propertyName));
        return this;
    }

    public Criteria isNull(String propertyName) {
        this.validatePropertyName(propertyName, "isNull");
        this.addToCriteria((Query.Criterion)Restrictions.isNull((String)propertyName));
        return this;
    }

    public Criteria isNotNull(String propertyName) {
        this.validatePropertyName(propertyName, "isNotNull");
        this.addToCriteria((Query.Criterion)Restrictions.isNotNull((String)propertyName));
        return this;
    }

    public Criteria eq(String propertyName, Object propertyValue) {
        this.validatePropertyName(propertyName, "eq");
        this.addToCriteria((Query.Criterion)Restrictions.eq((String)propertyName, (Object)propertyValue));
        return this;
    }

    public Criteria allEq(Map<String, Object> propertyValues) {
        Query.Conjunction conjunction = new Query.Conjunction();
        for (String property : propertyValues.keySet()) {
            conjunction.add((Query.Criterion)Restrictions.eq((String)property, (Object)propertyValues.get(property)));
        }
        this.addToCriteria((Query.Criterion)conjunction);
        return this;
    }

    public Criteria eqAll(String propertyName, Closure propertyValue) {
        return this.eqAll(propertyName, this.buildQueryableCriteria(propertyValue));
    }

    private QueryableCriteria buildQueryableCriteria(Closure queryClosure) {
        return new DetachedCriteria(this.targetClass).build(queryClosure);
    }

    public Criteria gtAll(String propertyName, Closure propertyValue) {
        return this.gtAll(propertyName, this.buildQueryableCriteria(propertyValue));
    }

    public Criteria ltAll(String propertyName, Closure propertyValue) {
        return this.ltAll(propertyName, this.buildQueryableCriteria(propertyValue));
    }

    public Criteria geAll(String propertyName, Closure propertyValue) {
        return this.geAll(propertyName, this.buildQueryableCriteria(propertyValue));
    }

    public Criteria leAll(String propertyName, Closure propertyValue) {
        return this.leAll(propertyName, this.buildQueryableCriteria(propertyValue));
    }

    public Criteria eqAll(String propertyName, QueryableCriteria propertyValue) {
        this.validatePropertyName(propertyName, "eqAll");
        this.addToCriteria((Query.Criterion)new Query.EqualsAll(propertyName, propertyValue));
        return this;
    }

    public Criteria gtAll(String propertyName, QueryableCriteria propertyValue) {
        this.validatePropertyName(propertyName, "gtAll");
        this.addToCriteria((Query.Criterion)new Query.GreaterThanAll(propertyName, propertyValue));
        return this;
    }

    public Criteria gtSome(String propertyName, QueryableCriteria propertyValue) {
        this.validatePropertyName(propertyName, "gtSome");
        this.addToCriteria((Query.Criterion)new Query.GreaterThanSome(propertyName, propertyValue));
        return this;
    }

    public Criteria gtSome(String propertyName, Closure<?> propertyValue) {
        return this.gtSome(propertyName, this.buildQueryableCriteria(propertyValue));
    }

    public Criteria geSome(String propertyName, QueryableCriteria propertyValue) {
        this.validatePropertyName(propertyName, "geSome");
        this.addToCriteria((Query.Criterion)new Query.GreaterThanEqualsSome(propertyName, propertyValue));
        return this;
    }

    public Criteria geSome(String propertyName, Closure<?> propertyValue) {
        return this.geSome(propertyName, this.buildQueryableCriteria(propertyValue));
    }

    public Criteria ltSome(String propertyName, QueryableCriteria propertyValue) {
        this.validatePropertyName(propertyName, "ltSome");
        this.addToCriteria((Query.Criterion)new Query.LessThanEqualsSome(propertyName, propertyValue));
        return this;
    }

    public Criteria ltSome(String propertyName, Closure<?> propertyValue) {
        return this.ltSome(propertyName, this.buildQueryableCriteria(propertyValue));
    }

    public Criteria leSome(String propertyName, QueryableCriteria propertyValue) {
        this.validatePropertyName(propertyName, "leSome");
        this.addToCriteria((Query.Criterion)new Query.LessThanEqualsSome(propertyName, propertyValue));
        return this;
    }

    public Criteria leSome(String propertyName, Closure<?> propertyValue) {
        return this.leSome(propertyName, this.buildQueryableCriteria(propertyValue));
    }

    public Criteria in(String propertyName, QueryableCriteria<?> subquery) {
        return this.inList(propertyName, subquery);
    }

    public Criteria in(String propertyName, Closure<?> subquery) {
        return this.inList(propertyName, subquery);
    }

    public Criteria inList(String propertyName, QueryableCriteria<?> subquery) {
        this.validatePropertyName(propertyName, "inList");
        this.addToCriteria((Query.Criterion)new Query.In(propertyName, subquery));
        return this;
    }

    public Criteria inList(String propertyName, Closure<?> subquery) {
        return this.inList(propertyName, this.buildQueryableCriteria(subquery));
    }

    public Criteria notIn(String propertyName, QueryableCriteria<?> subquery) {
        this.validatePropertyName(propertyName, "notIn");
        this.addToCriteria((Query.Criterion)new Query.NotIn(propertyName, subquery));
        return this;
    }

    public Criteria notIn(String propertyName, Closure<?> subquery) {
        return this.notIn(propertyName, this.buildQueryableCriteria(subquery));
    }

    public Criteria ltAll(String propertyName, QueryableCriteria propertyValue) {
        this.validatePropertyName(propertyName, "ltAll");
        this.addToCriteria((Query.Criterion)new Query.LessThanAll(propertyName, propertyValue));
        return this;
    }

    public Criteria geAll(String propertyName, QueryableCriteria propertyValue) {
        this.validatePropertyName(propertyName, "geAll");
        this.addToCriteria((Query.Criterion)new Query.GreaterThanEqualsAll(propertyName, propertyValue));
        return this;
    }

    public Criteria leAll(String propertyName, QueryableCriteria propertyValue) {
        this.validatePropertyName(propertyName, "leAll");
        this.addToCriteria((Query.Criterion)new Query.LessThanEqualsAll(propertyName, propertyValue));
        return this;
    }

    public Criteria idEq(Object propertyValue) {
        this.addToCriteria((Query.Criterion)Restrictions.idEq((Object)propertyValue));
        return this;
    }

    public Criteria ne(String propertyName, Object propertyValue) {
        this.validatePropertyName(propertyName, "ne");
        this.addToCriteria((Query.Criterion)Restrictions.ne((String)propertyName, (Object)propertyValue));
        return this;
    }

    public Criteria between(String propertyName, Object start, Object finish) {
        this.validatePropertyName(propertyName, "between");
        this.addToCriteria((Query.Criterion)Restrictions.between((String)propertyName, (Object)start, (Object)finish));
        return this;
    }

    public Criteria gte(String property, Object value) {
        this.validatePropertyName(property, "gte");
        this.addToCriteria((Query.Criterion)Restrictions.gte((String)property, (Object)value));
        return this;
    }

    public Criteria ge(String property, Object value) {
        this.gte(property, value);
        return this;
    }

    public Criteria gt(String property, Object value) {
        this.validatePropertyName(property, "gt");
        this.addToCriteria((Query.Criterion)Restrictions.gt((String)property, (Object)value));
        return this;
    }

    public Criteria lte(String property, Object value) {
        this.validatePropertyName(property, "lte");
        this.addToCriteria((Query.Criterion)Restrictions.lte((String)property, (Object)value));
        return this;
    }

    public Criteria le(String property, Object value) {
        this.lte(property, value);
        return this;
    }

    public Criteria lt(String property, Object value) {
        this.validatePropertyName(property, "lt");
        this.addToCriteria((Query.Criterion)Restrictions.lt((String)property, (Object)value));
        return this;
    }

    public Criteria like(String propertyName, Object propertyValue) {
        this.validatePropertyName(propertyName, "like");
        Assert.notNull((Object)propertyValue, (String)"Cannot use like expression with null value");
        this.addToCriteria((Query.Criterion)Restrictions.like((String)propertyName, (String)propertyValue.toString()));
        return this;
    }

    public Criteria ilike(String propertyName, Object propertyValue) {
        this.validatePropertyName(propertyName, "ilike");
        Assert.notNull((Object)propertyValue, (String)"Cannot use ilike expression with null value");
        this.addToCriteria((Query.Criterion)Restrictions.ilike((String)propertyName, (String)propertyValue.toString()));
        return this;
    }

    public Criteria rlike(String propertyName, Object propertyValue) {
        this.validatePropertyName(propertyName, "like");
        Assert.notNull((Object)propertyValue, (String)"Cannot use like expression with null value");
        this.addToCriteria((Query.Criterion)Restrictions.rlike((String)propertyName, (String)propertyValue.toString()));
        return this;
    }

    public Criteria in(String propertyName, Collection values) {
        this.validatePropertyName(propertyName, "in");
        Assert.notNull((Object)values, (String)"Cannot use in expression with null values");
        this.addToCriteria((Query.Criterion)Restrictions.in((String)propertyName, (Collection)values));
        return this;
    }

    public Criteria inList(String propertyName, Collection values) {
        this.in(propertyName, values);
        return this;
    }

    public Criteria inList(String propertyName, Object[] values) {
        return this.in(propertyName, Arrays.asList(values));
    }

    public Criteria in(String propertyName, Object[] values) {
        return this.in(propertyName, Arrays.asList(values));
    }

    public Criteria sizeEq(String propertyName, int size) {
        this.validatePropertyName(propertyName, "sizeEq");
        this.addToCriteria((Query.Criterion)Restrictions.sizeEq((String)propertyName, (int)size));
        return this;
    }

    public Criteria sizeGt(String propertyName, int size) {
        this.validatePropertyName(propertyName, "sizeGt");
        this.addToCriteria((Query.Criterion)Restrictions.sizeGt((String)propertyName, (int)size));
        return this;
    }

    public Criteria sizeGe(String propertyName, int size) {
        this.validatePropertyName(propertyName, "sizeGe");
        this.addToCriteria((Query.Criterion)Restrictions.sizeGe((String)propertyName, (int)size));
        return this;
    }

    public Criteria sizeLe(String propertyName, int size) {
        this.validatePropertyName(propertyName, "sizeLe");
        this.addToCriteria((Query.Criterion)Restrictions.sizeLe((String)propertyName, (int)size));
        return this;
    }

    public Criteria sizeLt(String propertyName, int size) {
        this.validatePropertyName(propertyName, "sizeLt");
        this.addToCriteria((Query.Criterion)Restrictions.sizeLt((String)propertyName, (int)size));
        return this;
    }

    public Criteria sizeNe(String propertyName, int size) {
        this.validatePropertyName(propertyName, "sizeNe");
        this.addToCriteria((Query.Criterion)Restrictions.sizeNe((String)propertyName, (int)size));
        return this;
    }

    public Criteria eqProperty(String propertyName, String otherPropertyName) {
        this.validatePropertyName(propertyName, "eqProperty");
        this.validatePropertyName(otherPropertyName, "eqProperty");
        this.addToCriteria((Query.Criterion)Restrictions.eqProperty((String)propertyName, (String)otherPropertyName));
        return this;
    }

    public Criteria neProperty(String propertyName, String otherPropertyName) {
        this.validatePropertyName(propertyName, "neProperty");
        this.validatePropertyName(otherPropertyName, "neProperty");
        this.addToCriteria((Query.Criterion)Restrictions.neProperty((String)propertyName, (String)otherPropertyName));
        return this;
    }

    public Criteria gtProperty(String propertyName, String otherPropertyName) {
        this.validatePropertyName(propertyName, "gtProperty");
        this.validatePropertyName(otherPropertyName, "gtProperty");
        this.addToCriteria((Query.Criterion)Restrictions.gtProperty((String)propertyName, (String)otherPropertyName));
        return this;
    }

    public Criteria geProperty(String propertyName, String otherPropertyName) {
        this.validatePropertyName(propertyName, "geProperty");
        this.validatePropertyName(otherPropertyName, "geProperty");
        this.addToCriteria((Query.Criterion)Restrictions.geProperty((String)propertyName, (String)otherPropertyName));
        return this;
    }

    public Criteria ltProperty(String propertyName, String otherPropertyName) {
        this.validatePropertyName(propertyName, "ltProperty");
        this.validatePropertyName(otherPropertyName, "ltProperty");
        this.addToCriteria((Query.Criterion)Restrictions.ltProperty((String)propertyName, (String)otherPropertyName));
        return this;
    }

    public Criteria leProperty(String propertyName, String otherPropertyName) {
        this.validatePropertyName(propertyName, "leProperty");
        this.validatePropertyName(otherPropertyName, "leProperty");
        this.addToCriteria((Query.Criterion)Restrictions.leProperty((String)propertyName, (String)otherPropertyName));
        return this;
    }

    public Criteria order(String propertyName) {
        Query.Order o = Query.Order.asc((String)propertyName);
        if (this.paginationEnabledList) {
            this.orderEntries.add(o);
        } else {
            this.query.order(o);
        }
        return this;
    }

    public Criteria order(String propertyName, String direction) {
        Query.Order o = direction.equals(ORDER_DESCENDING) ? Query.Order.desc((String)propertyName) : Query.Order.asc((String)propertyName);
        if (this.paginationEnabledList) {
            this.orderEntries.add(o);
        } else {
            this.query.order(o);
        }
        return this;
    }

    protected void validatePropertyName(String propertyName, String methodName) {
        if (this.persistentEntity == null) {
            return;
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("Cannot use [" + methodName + "] restriction with null property name");
        }
        PersistentProperty property = this.persistentEntity.getPropertyByName(propertyName);
        if (property == null && this.persistentEntity.getIdentity().getName().equals(propertyName)) {
            property = this.persistentEntity.getIdentity();
        }
        if (property == null && !this.session.getDatastore().isSchemaless()) {
            throw new IllegalArgumentException("Property [" + propertyName + "] is not a valid property of class [" + this.persistentEntity + "]");
        }
    }

    private void initializeQuery() {
        this.query = this.session.createQuery(this.targetClass);
        this.queryMetaClass = GroovySystem.getMetaClassRegistry().getMetaClass(this.query.getClass());
    }

    private boolean isCriteriaConstructionMethod(String name, Object[] args) {
        return name.equals(ROOT_CALL) || name.equals(ROOT_DO_CALL) || name.equals(SCROLL_CALL) && args.length == 1 && args[0] instanceof Closure;
    }

    private void invokeClosureNode(Object args) {
        if (args instanceof Closure) {
            Closure callable = (Closure)args;
            callable.setDelegate((Object)this);
            callable.setResolveStrategy(1);
            callable.call();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleJunction(Query.Junction junction, Closure callable) {
        this.logicalExpressionStack.add(junction);
        try {
            if (callable != null) {
                this.invokeClosureNode(callable);
            }
        }
        finally {
            Query.Junction logicalExpression = this.logicalExpressionStack.remove(this.logicalExpressionStack.size() - 1);
            this.addToCriteria((Query.Criterion)logicalExpression);
        }
    }

    protected Query.Criterion addToCriteria(Query.Criterion c) {
        Query.PropertyCriterion pc;
        Object value;
        if (c instanceof Query.PropertyCriterion && (value = (pc = (Query.PropertyCriterion)c).getValue()) instanceof Closure) {
            pc.setValue((Object)this.buildQueryableCriteria((Closure)value));
        }
        if (!this.logicalExpressionStack.isEmpty()) {
            this.logicalExpressionStack.get(this.logicalExpressionStack.size() - 1).add(c);
        } else {
            if (this.query == null) {
                this.initializeQuery();
            }
            this.query.add(c);
        }
        return c;
    }

    public Query getQuery() {
        return this.query;
    }

    public void build(Closure criteria) {
        if (criteria != null) {
            this.invokeClosureNode(criteria);
        }
    }
}

