/*
 * Decompiled with CFR 0.152.
 */
package grails.gorm;

import java.util.AbstractList;
import java.util.List;
import org.grails.datastore.mapping.query.Query;

public class PagedResultList
extends AbstractList {
    private Query query;
    private List resultList;
    private int totalCount = Integer.MIN_VALUE;

    public PagedResultList(Query query) {
        this.query = query;
    }

    public int getTotalCount() {
        this.initialize();
        if (this.totalCount == Integer.MIN_VALUE) {
            Query newQuery = (Query)this.query.clone();
            newQuery.projections().count();
            Number result = (Number)newQuery.singleResult();
            this.totalCount = result == null ? 0 : result.intValue();
        }
        return this.totalCount;
    }

    @Override
    public Object get(int i) {
        this.initialize();
        return this.resultList.get(i);
    }

    @Override
    public Object set(int i, Object o) {
        this.initialize();
        return this.resultList.set(i, o);
    }

    @Override
    public Object remove(int i) {
        this.initialize();
        return this.resultList.remove(i);
    }

    @Override
    public void add(int i, Object o) {
        this.initialize();
        this.resultList.add(i, o);
    }

    private void initialize() {
        if (this.resultList == null) {
            this.resultList = this.query.list();
        }
    }

    @Override
    public int size() {
        this.initialize();
        return this.resultList.size();
    }
}

