/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler.gorm;

import grails.persistence.Entity;
import grails.persistence.PersistenceMethod;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.compiler.injection.AbstractGrailsArtefactTransformer;
import org.codehaus.groovy.grails.compiler.injection.AstTransformer;
import org.codehaus.groovy.grails.compiler.injection.GrailsASTUtils;
import org.codehaus.groovy.grails.io.support.GrailsResourceUtils;
import org.grails.datastore.gorm.GormInstanceApi;
import org.grails.datastore.gorm.GormStaticApi;

@AstTransformer
public class GormTransformer
extends AbstractGrailsArtefactTransformer {
    public static final String NEW_INSTANCE_METHOD = "newInstance";
    private static final List<String> EXCLUDES = Arrays.asList("create", "setTransactionManager");
    private static final Class<?>[] EMPTY_JAVA_CLASS_ARRAY = new Class[0];
    private static final Class<?>[] OBJECT_CLASS_ARG = new Class[]{Object.class};

    protected boolean isStaticCandidateMethod(ClassNode classNode, MethodNode declaredMethod) {
        String methodName = declaredMethod.getName();
        return !EXCLUDES.contains(methodName) && !this.isGetter(methodName, declaredMethod) && !this.isSetter(methodName, declaredMethod) && super.isStaticCandidateMethod(classNode, declaredMethod);
    }

    private boolean isSetter(String methodName, MethodNode declaredMethod) {
        return declaredMethod.getParameters().length == 2 && GrailsClassUtils.isSetter((String)methodName, (Class[])OBJECT_CLASS_ARG);
    }

    private boolean isGetter(String methodName, MethodNode declaredMethod) {
        return declaredMethod.getParameters().length == 1 && GrailsClassUtils.isGetter((String)methodName, (Class[])EMPTY_JAVA_CLASS_ARRAY);
    }

    public String getArtefactType() {
        return "Domain";
    }

    public Class<?> getInstanceImplementation() {
        return GormInstanceApi.class;
    }

    public Class<?> getStaticImplementation() {
        return GormStaticApi.class;
    }

    protected boolean requiresStaticLookupMethod() {
        return true;
    }

    protected AnnotationNode getMarkerAnnotation() {
        return new AnnotationNode(new ClassNode(PersistenceMethod.class).getPlainNodeReference());
    }

    protected void performInjectionInternal(String apiInstanceProperty, SourceUnit source, ClassNode classNode) {
        classNode.setUsingGenerics(true);
        GrailsASTUtils.addAnnotationIfNecessary((ClassNode)classNode, Entity.class);
        BlockStatement methodBody = new BlockStatement();
        methodBody.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new ClassExpression(classNode), NEW_INSTANCE_METHOD, (Expression)ZERO_ARGS)));
        MethodNode methodNode = classNode.getDeclaredMethod("create", ZERO_PARAMETERS);
        classNode = GrailsASTUtils.nonGeneric((ClassNode)classNode);
        if (methodNode == null) {
            classNode.addMethod(new MethodNode("create", 9, classNode, ZERO_PARAMETERS, null, (Statement)methodBody));
        }
    }

    public boolean shouldInject(URL url) {
        return GrailsResourceUtils.isDomainClass((URL)url);
    }
}

