/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.finders;

import groovy.lang.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.Restrictions;
import org.springframework.core.convert.ConversionService;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MethodExpression {
    protected String propertyName;
    protected Object[] arguments;
    protected int argumentsRequired = 1;
    protected Class<?> targetClass;

    public abstract Query.Criterion createCriterion();

    protected MethodExpression(Class<?> targetClass, String propertyName) {
        this.propertyName = propertyName;
        this.targetClass = targetClass;
    }

    public int getArgumentsRequired() {
        return this.argumentsRequired;
    }

    public void convertArguments(PersistentEntity persistentEntity) {
        ConversionService conversionService = persistentEntity.getMappingContext().getConversionService();
        PersistentProperty prop = persistentEntity.getPropertyByName(this.propertyName);
        if (prop == null && this.propertyName.equals(persistentEntity.getIdentity().getName())) {
            prop = persistentEntity.getIdentity();
        }
        if (prop != null && this.arguments != null && this.argumentsRequired > 0) {
            Class type = prop.getType();
            for (int i = 0; i < this.argumentsRequired; ++i) {
                Object arg = this.arguments[i];
                if (arg == null || type.isAssignableFrom(arg.getClass())) continue;
                this.arguments[i] = conversionService.convert(arg, type);
            }
        }
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    public Object[] getArguments() {
        return Arrays.copyOf(this.arguments, this.arguments.length);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NotEqual
    extends MethodExpression {
        public NotEqual(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.ne((String)this.propertyName, (Object)this.arguments[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Equal
    extends MethodExpression {
        public Equal(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.eq((String)this.propertyName, (Object)this.arguments[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IsNotEmpty
    extends MethodExpression {
        public IsNotEmpty(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
            this.argumentsRequired = 0;
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.isNotEmpty((String)this.propertyName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IsEmpty
    extends MethodExpression {
        public IsEmpty(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
            this.argumentsRequired = 0;
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.isEmpty((String)this.propertyName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IsNotNull
    extends MethodExpression {
        public IsNotNull(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
            this.argumentsRequired = 0;
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.isNotNull((String)this.propertyName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IsNull
    extends MethodExpression {
        public IsNull(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
            this.argumentsRequired = 0;
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.isNull((String)this.propertyName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InRange
    extends MethodExpression {
        public InRange(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
            this.argumentsRequired = 1;
        }

        @Override
        public Query.Criterion createCriterion() {
            Range range = (Range)this.arguments[0];
            return Restrictions.between((String)this.propertyName, (Object)range.getFrom(), (Object)range.getTo());
        }

        @Override
        public void convertArguments(PersistentEntity persistentEntity) {
        }

        @Override
        public void setArguments(Object[] arguments) {
            Assert.isTrue((arguments.length == 1 ? 1 : 0) != 0, (String)"An 'inRange' query requires exactly 1 argument");
            Assert.isTrue((boolean)(arguments[0] instanceof Range), (String)"An 'inRange' query requires a Range argument");
            super.setArguments(arguments);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Between
    extends MethodExpression {
        public Between(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
            this.argumentsRequired = 2;
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.between((String)this.propertyName, (Object)this.arguments[0], (Object)this.arguments[1]);
        }

        @Override
        public void setArguments(Object[] arguments) {
            Assert.isTrue((arguments.length > 1 ? 1 : 0) != 0, (String)"A 'between' query requires at least two arguments");
            Assert.isTrue((arguments[0] instanceof Comparable && arguments[1] instanceof Comparable ? 1 : 0) != 0, (String)"A 'between' query requires that both arguments are comparable");
            super.setArguments(arguments);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InList
    extends MethodExpression {
        public InList(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.in((String)this.propertyName, (Collection)((Collection)this.arguments[0]));
        }

        @Override
        public void setArguments(Object[] arguments) {
            Assert.isTrue((arguments.length > 0 && arguments[0] instanceof Collection ? 1 : 0) != 0, (String)"Only a collection of elements is supported in an 'in' query");
            super.setArguments(arguments);
        }

        @Override
        public void convertArguments(PersistentEntity persistentEntity) {
            ConversionService conversionService = persistentEntity.getMappingContext().getConversionService();
            PersistentProperty prop = persistentEntity.getPropertyByName(this.propertyName);
            if (prop == null && this.propertyName.equals(persistentEntity.getIdentity().getName())) {
                prop = persistentEntity.getIdentity();
            }
            if (prop != null) {
                Class type = prop.getType();
                Collection collection = (Collection)this.arguments[0];
                ArrayList converted = new ArrayList(collection.size());
                for (Object o : collection) {
                    if (o != null && !type.isAssignableFrom(o.getClass())) {
                        o = conversionService.convert(o, type);
                    }
                    converted.add(o);
                }
                this.arguments[0] = converted;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Rlike
    extends MethodExpression {
        public Rlike(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.rlike((String)this.propertyName, (String)this.arguments[0].toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Ilike
    extends MethodExpression {
        public Ilike(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.ilike((String)this.propertyName, (String)this.arguments[0].toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Like
    extends MethodExpression {
        public Like(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.like((String)this.propertyName, (String)this.arguments[0].toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LessThanEquals
    extends MethodExpression {
        public LessThanEquals(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.lte((String)this.propertyName, (Object)this.arguments[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LessThan
    extends MethodExpression {
        public LessThan(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.lt((String)this.propertyName, (Object)this.arguments[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GreaterThanEquals
    extends MethodExpression {
        public GreaterThanEquals(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.gte((String)this.propertyName, (Object)this.arguments[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GreaterThan
    extends MethodExpression {
        public GreaterThan(Class<?> targetClass, String propertyName) {
            super(targetClass, propertyName);
        }

        @Override
        public Query.Criterion createCriterion() {
            return Restrictions.gt((String)this.propertyName, (Object)this.arguments[0]);
        }
    }
}

