/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.query.transform;

import grails.gorm.DetachedCriteria;
import grails.persistence.Entity;
import grails.util.GrailsNameUtils;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.LocatedMessage;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsResourceUtils;
import org.codehaus.groovy.syntax.CSTNode;
import org.codehaus.groovy.syntax.Token;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.criteria.FunctionCallingCriterion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetachedCriteriaTransformer
extends ClassCodeVisitorSupport {
    private static final Class<?>[] EMPTY_JAVA_CLASS_ARRAY = new Class[0];
    private static final VariableExpression THIS_EXPRESSION = new VariableExpression("this");
    private static final VariableExpression DELEGATE_EXPRESSION = new VariableExpression("delegate");
    public static final String AND_OPERATOR = "&";
    public static final String OR_OPERATOR = "|";
    public static final ClassNode DETACHED_CRITERIA_CLASS_NODE = new ClassNode(DetachedCriteria.class);
    public static final HashSet<String> CANDIDATE_METHODS_WHERE_ONLY = new HashSet<String>(){
        {
            this.add("where");
        }
    };
    public static final ClassNode FUNCTION_CALL_CRITERION = new ClassNode(FunctionCallingCriterion.class);
    public static final String EQUALS_OPERATOR = "==";
    public static final String IS_NULL_CRITERION = "isNull";
    private SourceUnit sourceUnit;
    private static final Set<String> CANDIDATE_METHODS = new HashSet<String>(){
        {
            this.add("where");
            this.add("whereAny");
            this.add("findAll");
            this.add("find");
        }
    };
    private static final Set<String> SUPPORTED_FUNCTIONS = new HashSet<String>(){
        {
            this.add("lower");
            this.add("upper");
            this.add("trim");
            this.add("length");
            this.add("second");
            this.add("hour");
            this.add("minute");
            this.add("day");
            this.add("month");
            this.add("year");
        }
    };
    private static final Map<String, String> OPERATOR_TO_CRITERIA_METHOD_MAP = new HashMap<String, String>(){
        {
            this.put(DetachedCriteriaTransformer.EQUALS_OPERATOR, "eq");
            this.put("!=", "ne");
            this.put(">", "gt");
            this.put("<", "lt");
            this.put(">=", "ge");
            this.put("<=", "le");
            this.put("==~", "like");
            this.put("=~", "ilike");
            this.put("in", "inList");
        }
    };
    private static final Map<String, ClassNode> OPERATOR_TO_CRITERION_METHOD_MAP = new HashMap<String, ClassNode>(){
        {
            this.put(DetachedCriteriaTransformer.EQUALS_OPERATOR, new ClassNode(Query.Equals.class));
            this.put("!=", new ClassNode(Query.NotEquals.class));
            this.put(">", new ClassNode(Query.GreaterThan.class));
            this.put("<", new ClassNode(Query.LessThan.class));
            this.put(">=", new ClassNode(Query.GreaterThanEquals.class));
            this.put("<=", new ClassNode(Query.LessThanEquals.class));
            this.put("==~", new ClassNode(Query.Like.class));
            this.put("=~", new ClassNode(Query.ILike.class));
            this.put("in", new ClassNode(Query.In.class));
        }
    };
    private static final Map<String, ClassNode> OPERATOR_TO_PROPERTY_CRITERION_METHOD_MAP = new HashMap<String, ClassNode>(){
        {
            this.put(DetachedCriteriaTransformer.EQUALS_OPERATOR, new ClassNode(Query.EqualsProperty.class));
            this.put("!=", new ClassNode(Query.NotEqualsProperty.class));
            this.put(">", new ClassNode(Query.GreaterThanProperty.class));
            this.put("<", new ClassNode(Query.LessThanProperty.class));
            this.put(">=", new ClassNode(Query.GreaterThanEqualsProperty.class));
            this.put("<=", new ClassNode(Query.LessThanEqualsProperty.class));
        }
    };
    private static final Map<String, String> PROPERTY_COMPARISON_OPERATOR_TO_CRITERIA_METHOD_MAP = new HashMap<String, String>(){
        {
            this.put(DetachedCriteriaTransformer.EQUALS_OPERATOR, "eqProperty");
            this.put("!=", "neProperty");
            this.put(">", "gtProperty");
            this.put("<", "ltProperty");
            this.put(">=", "geProperty");
            this.put("<=", "leProperty");
        }
    };
    private static final Map<String, String> SIZE_OPERATOR_TO_CRITERIA_METHOD_MAP = new HashMap<String, String>(){
        {
            this.put(DetachedCriteriaTransformer.EQUALS_OPERATOR, "sizeEq");
            this.put("!=", "sizeNe");
            this.put(">", "sizeGt");
            this.put("<", "sizeLt");
            this.put(">=", "sizeGe");
            this.put("<=", "sizeLe");
        }
    };
    private static final Map<String, String> AGGREGATE_FUNCTIONS = new HashMap<String, String>(){
        {
            this.put("avg", "avg");
            this.put("max", "max");
            this.put("min", "min");
            this.put("sum", "sum");
            this.put("property", "property");
            this.put("count", "countDistinct");
        }
    };
    private Map<String, ClassNode> detachedCriteriaVariables = new HashMap<String, ClassNode>();
    private Map<String, ClassNode> staticDetachedCriteriaVariables = new HashMap<String, ClassNode>();
    private Map<String, Map<String, ClassNode>> cachedClassProperties = new HashMap<String, Map<String, ClassNode>>();
    private Set<ClosureExpression> transformedExpressions = new HashSet<ClosureExpression>();
    private ClassNode currentClassNode;

    DetachedCriteriaTransformer(SourceUnit sourceUnit) {
        this.sourceUnit = sourceUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClass(ClassNode node) {
        try {
            this.currentClassNode = node;
            super.visitClass(node);
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("Fatal error occurred apply query transformations: " + e.getMessage(), (CSTNode)Token.newString((String)node.getName(), (int)node.getLineNumber(), (int)node.getColumnNumber()), this.sourceUnit));
        }
        finally {
            this.currentClassNode = null;
            this.detachedCriteriaVariables.clear();
            this.transformedExpressions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitMethod(MethodNode node) {
        try {
            super.visitMethod(node);
        }
        finally {
            this.detachedCriteriaVariables.clear();
        }
    }

    public void visitField(FieldNode node) {
        ClassNode classNode = node.getOwner();
        if (node.isStatic() && this.isDomainClass(classNode)) {
            Expression expression;
            ArgumentListExpression args;
            List argsExpressions;
            int totalExpressions;
            MethodCallExpression mce;
            Expression initialExpression = node.getInitialExpression();
            if (initialExpression instanceof MethodCallExpression && this.isCandidateWhereMethod((mce = (MethodCallExpression)initialExpression).getMethod(), mce.getArguments()) && (totalExpressions = (argsExpressions = (args = (ArgumentListExpression)mce.getArguments()).getExpressions()).size()) > 0 && (expression = (Expression)argsExpressions.get(totalExpressions - 1)) instanceof ClosureExpression) {
                ClosureExpression closureExpression = (ClosureExpression)expression;
                this.transformClosureExpression(classNode, closureExpression);
                MethodCallExpression newInitialExpression = new MethodCallExpression((Expression)new ConstructorCallExpression(DETACHED_CRITERIA_CLASS_NODE, (Expression)new ArgumentListExpression((Expression)new ClassExpression(classNode))), "build", (Expression)new ArgumentListExpression((Expression)closureExpression));
                node.setInitialValueExpression((Expression)newInitialExpression);
                node.setType(DETACHED_CRITERIA_CLASS_NODE);
                this.staticDetachedCriteriaVariables.put(node.getName(), classNode);
            }
        } else {
            try {
                Expression initialExpression = node.getInitialExpression();
                ClosureExpression newClosureExpression = this.handleDetachedCriteriaCast(initialExpression);
                if (newClosureExpression != null) {
                    node.setInitialValueExpression((Expression)newClosureExpression);
                }
            }
            catch (Exception e) {
                this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("Fatal error occurred apply query transformations: " + e.getMessage(), (CSTNode)Token.newString((String)node.getName(), (int)node.getLineNumber(), (int)node.getColumnNumber()), this.sourceUnit));
            }
        }
        super.visitField(node);
    }

    public void visitDeclarationExpression(DeclarationExpression expression) {
        Expression initializationExpression = expression.getRightExpression();
        if (initializationExpression instanceof MethodCallExpression) {
            MethodCallExpression call = (MethodCallExpression)initializationExpression;
            Expression objectExpression = call.getObjectExpression();
            Expression method = call.getMethod();
            Expression arguments = call.getArguments();
            if (this.isCandidateMethod(method.getText(), arguments, CANDIDATE_METHODS_WHERE_ONLY)) {
                ClassNode classNode = new ClassNode(DetachedCriteria.class);
                ClassNode targetType = objectExpression.getType();
                if (this.isDomainClass(targetType)) {
                    classNode.setGenericsTypes(new GenericsType[]{new GenericsType(targetType)});
                    VariableExpression variableExpression = expression.getVariableExpression();
                    if (variableExpression.isClosureSharedVariable()) {
                        Variable accessedVariable = variableExpression.getAccessedVariable();
                        if (accessedVariable instanceof VariableExpression) {
                            ((VariableExpression)accessedVariable).setType(classNode);
                        }
                    } else {
                        variableExpression.setType(classNode);
                    }
                    String variableName = expression.getVariableExpression().getName();
                    this.detachedCriteriaVariables.put(variableName, targetType);
                }
            }
        } else if (initializationExpression instanceof ConstructorCallExpression) {
            Expression exp;
            ArgumentListExpression ale;
            Expression arguments;
            String variableName = expression.getVariableExpression().getName();
            ConstructorCallExpression cce = (ConstructorCallExpression)initializationExpression;
            ClassNode type = cce.getType();
            if (DETACHED_CRITERIA_CLASS_NODE.getName().equals(type.getName()) && (arguments = cce.getArguments()) instanceof ArgumentListExpression && (ale = (ArgumentListExpression)arguments).getExpressions().size() == 1 && (exp = ale.getExpression(0)) instanceof ClassExpression) {
                ClassExpression clse = (ClassExpression)exp;
                this.detachedCriteriaVariables.put(variableName, clse.getType());
            }
        } else {
            try {
                ClosureExpression newClosureExpression = this.handleDetachedCriteriaCast(initializationExpression);
                if (newClosureExpression != null) {
                    expression.setRightExpression((Expression)newClosureExpression);
                }
            }
            catch (Exception e) {
                this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("Fatal error occurred apply query transformations [ " + e.getMessage() + "] to source [" + this.sourceUnit.getName() + "]. Please report an issue.", (CSTNode)Token.newString((String)initializationExpression.getText(), (int)initializationExpression.getLineNumber(), (int)initializationExpression.getColumnNumber()), this.sourceUnit));
            }
        }
        super.visitDeclarationExpression(expression);
    }

    private ClosureExpression handleDetachedCriteriaCast(Expression initializationExpression) {
        ClosureExpression newClosureExpression = null;
        if (initializationExpression instanceof CastExpression && ((CastExpression)initializationExpression).getExpression() instanceof ClosureExpression) {
            GenericsType[] genericsTypes;
            CastExpression ce = (CastExpression)initializationExpression;
            Expression castTarget = ce.getExpression();
            ClosureExpression cle = (ClosureExpression)castTarget;
            ClassNode targetCastType = ce.getType();
            if (targetCastType.getName().equals(DetachedCriteria.class.getName()) && (genericsTypes = targetCastType.getGenericsTypes()).length > 0) {
                ClassNode genericType = genericsTypes[0].getType();
                this.transformClosureExpression(genericType, cle);
                newClosureExpression = cle;
            }
        }
        return newClosureExpression;
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        Expression objectExpression = call.getObjectExpression();
        Expression method = call.getMethod();
        Expression arguments = call.getArguments();
        try {
            if (this.isCandidateMethodCallForTransform(objectExpression, method, arguments)) {
                ClassNode classNode;
                ClassExpression ce = (ClassExpression)objectExpression;
                this.currentClassNode = classNode = ce.getType();
                this.visitMethodCall(classNode, (ArgumentListExpression)arguments);
            } else if (objectExpression instanceof VariableExpression) {
                VariableExpression var = (VariableExpression)objectExpression;
                String varName = var.getName();
                ClassNode varType = this.detachedCriteriaVariables.get(varName);
                if (varType != null && this.isCandidateWhereMethod(method, arguments)) {
                    this.currentClassNode = varType;
                    this.visitMethodCall(varType, (ArgumentListExpression)arguments);
                }
            } else if (objectExpression instanceof PropertyExpression) {
                ClassNode propertyType;
                PropertyExpression pe = (PropertyExpression)objectExpression;
                String propName = pe.getPropertyAsString();
                ClassNode classNode = pe.getObjectExpression().getType();
                if (this.isDomainClass(classNode) && (propertyType = this.getPropertyType(classNode, propName)) != null && DETACHED_CRITERIA_CLASS_NODE.equals((Object)propertyType)) {
                    this.visitMethodCall(classNode, (ArgumentListExpression)arguments);
                }
            }
        }
        catch (Exception e) {
            this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("Fatal error occurred apply query transformations: " + e.getMessage(), (CSTNode)Token.newString((String)call.getMethodAsString(), (int)call.getLineNumber(), (int)call.getColumnNumber()), this.sourceUnit));
        }
        super.visitMethodCallExpression(call);
    }

    private boolean isCandidateMethodCallForTransform(Expression objectExpression, Expression method, Expression arguments) {
        return objectExpression instanceof ClassExpression && this.isCandidateWhereMethod(method, arguments);
    }

    private void visitMethodCall(ClassNode classNode, ArgumentListExpression arguments) {
        if (this.isDomainClass(classNode)) {
            this.visitMethodCallOnDetachedCriteria(classNode, arguments);
        }
    }

    private void visitMethodCallOnDetachedCriteria(ClassNode classNode, ArgumentListExpression arguments) {
        Expression expression;
        if (arguments.getExpressions().size() > 0 && (expression = arguments.getExpression(arguments.getExpressions().size() - 1)) instanceof ClosureExpression) {
            ClosureExpression closureExpression = (ClosureExpression)expression;
            this.transformClosureExpression(classNode, closureExpression);
        }
    }

    private boolean isCandidateWhereMethod(Expression method, Expression arguments) {
        String methodName = method.getText();
        return method instanceof ConstantExpression && this.isCandidateWhereMethod(methodName, arguments);
    }

    private boolean isCandidateWhereMethod(String methodName, Expression arguments) {
        return this.isCandidateMethod(methodName, arguments, CANDIDATE_METHODS);
    }

    private boolean isCandidateMethod(String methodName, Expression arguments, Set<String> candidateMethods) {
        return candidateMethods.contains(methodName) && arguments instanceof ArgumentListExpression;
    }

    public void visitStaticMethodCallExpression(StaticMethodCallExpression call) {
        Expression arguments;
        String method = call.getMethod();
        if (this.isCandidateWhereMethod(method, arguments = call.getArguments())) {
            ClassNode classNode = call.getOwnerType();
            this.visitMethodCall(classNode, (ArgumentListExpression)arguments);
        }
        super.visitStaticMethodCallExpression(call);
    }

    protected void transformClosureExpression(ClassNode classNode, ClosureExpression closureExpression) {
        if (this.transformedExpressions.contains(closureExpression)) {
            return;
        }
        List<String> propertyNames = this.getPropertyNames(classNode);
        Statement code = closureExpression.getCode();
        BlockStatement newCode = new BlockStatement();
        boolean addAll = false;
        if (code instanceof BlockStatement) {
            BlockStatement bs = (BlockStatement)code;
            this.addBlockStatementToNewQuery(bs, newCode, addAll, propertyNames, closureExpression.getVariableScope());
            newCode.setVariableScope(bs.getVariableScope());
        }
        if (!newCode.getStatements().isEmpty()) {
            this.transformedExpressions.add(closureExpression);
            closureExpression.setCode((Statement)newCode);
        }
    }

    private List<String> getPropertyNames(ClassNode classNode) {
        String className = classNode.getName();
        Map<String, ClassNode> cachedProperties = this.cachedClassProperties.get(className);
        if (cachedProperties == null) {
            cachedProperties = new HashMap<String, ClassNode>();
            cachedProperties.put("id", new ClassNode(Long.class));
            cachedProperties.put("version", new ClassNode(Long.class));
            this.cachedClassProperties.put(className, cachedProperties);
            for (ClassNode currentNode = classNode; currentNode != null && !currentNode.equals((Object)ClassHelper.OBJECT_TYPE); currentNode = currentNode.getSuperClass()) {
                this.populatePropertiesForClassNode(currentNode, cachedProperties);
            }
        }
        return new ArrayList<String>(cachedProperties.keySet());
    }

    private void populatePropertiesForClassNode(ClassNode classNode, Map<String, ClassNode> cachedProperties) {
        List methods = classNode.getMethods();
        for (MethodNode method : methods) {
            if (method.isAbstract() || method.isStatic() || !this.isGetter(method.getName(), method)) continue;
            String propertyName = GrailsClassUtils.getPropertyForGetter((String)method.getName());
            cachedProperties.put(propertyName, method.getReturnType());
        }
        List properties = classNode.getProperties();
        for (PropertyNode property : properties) {
            String propertyName = property.getName();
            if ("hasMany".equals(propertyName) || "belongsTo".equals(propertyName) || "hasOne".equals(propertyName)) {
                Expression initialExpression = property.getInitialExpression();
                if (!(initialExpression instanceof MapExpression)) continue;
                MapExpression me = (MapExpression)initialExpression;
                List mapEntryExpressions = me.getMapEntryExpressions();
                for (MapEntryExpression mapEntryExpression : mapEntryExpressions) {
                    Expression keyExpression = mapEntryExpression.getKeyExpression();
                    Expression valueExpression = mapEntryExpression.getValueExpression();
                    if (!(valueExpression instanceof ClassExpression)) continue;
                    cachedProperties.put(keyExpression.getText(), valueExpression.getType());
                }
                continue;
            }
            cachedProperties.put(propertyName, property.getType());
        }
    }

    private void addBlockStatementToNewQuery(BlockStatement blockStatement, BlockStatement newCode, boolean addAll, List<String> propertyNames, VariableScope variableScope) {
        List statements = blockStatement.getStatements();
        for (Statement statement : statements) {
            this.addStatementToNewQuery(statement, newCode, addAll, propertyNames, variableScope);
        }
    }

    private void addStatementToNewQuery(Statement statement, BlockStatement newCode, boolean addAll, List<String> propertyNames, VariableScope variableScope) {
        if (statement instanceof BlockStatement) {
            this.addBlockStatementToNewQuery((BlockStatement)statement, newCode, addAll, propertyNames, variableScope);
        } else if (statement instanceof ExpressionStatement) {
            ExpressionStatement es = (ExpressionStatement)statement;
            Expression expression = es.getExpression();
            if (expression instanceof DeclarationExpression) {
                newCode.addStatement((Statement)es);
            } else if (expression instanceof BinaryExpression) {
                BinaryExpression be = (BinaryExpression)expression;
                this.addBinaryExpressionToNewBody(propertyNames, newCode, be, addAll, variableScope);
            } else if (expression instanceof NotExpression) {
                NotExpression not = (NotExpression)expression;
                this.handleNegation(propertyNames, newCode, not, variableScope);
            } else if (expression instanceof MethodCallExpression) {
                MethodCallExpression methodCall = (MethodCallExpression)expression;
                this.handleAssociationMethodCallExpression(newCode, methodCall, propertyNames, variableScope);
            }
        } else if (statement instanceof IfStatement) {
            IfStatement ifs = (IfStatement)statement;
            Statement ifb = ifs.getIfBlock();
            BlockStatement newIfBlock = new BlockStatement();
            this.addStatementToNewQuery(ifb, newIfBlock, addAll, propertyNames, variableScope);
            ifs.setIfBlock(this.flattenStatementIfNecessary(newIfBlock));
            Statement elseBlock = ifs.getElseBlock();
            if (elseBlock != null) {
                BlockStatement newElseBlock = new BlockStatement();
                this.addStatementToNewQuery(elseBlock, newElseBlock, addAll, propertyNames, variableScope);
                ifs.setElseBlock(this.flattenStatementIfNecessary(newElseBlock));
            }
            newCode.addStatement((Statement)ifs);
        } else if (statement instanceof SwitchStatement) {
            SwitchStatement sw = (SwitchStatement)statement;
            List caseStatements = sw.getCaseStatements();
            for (CaseStatement caseStatement : caseStatements) {
                Statement existingCode = caseStatement.getCode();
                BlockStatement newCaseCode = new BlockStatement();
                this.addStatementToNewQuery(existingCode, newCaseCode, addAll, propertyNames, variableScope);
                caseStatement.setCode(this.flattenStatementIfNecessary(newCaseCode));
            }
            newCode.addStatement((Statement)sw);
        } else if (statement instanceof ForStatement) {
            ForStatement fs = (ForStatement)statement;
            Statement loopBlock = fs.getLoopBlock();
            BlockStatement newLoopBlock = new BlockStatement();
            this.addStatementToNewQuery(loopBlock, newLoopBlock, addAll, propertyNames, variableScope);
            fs.setLoopBlock(this.flattenStatementIfNecessary(newLoopBlock));
            newCode.addStatement((Statement)fs);
        } else if (statement instanceof WhileStatement) {
            WhileStatement ws = (WhileStatement)statement;
            Statement loopBlock = ws.getLoopBlock();
            BlockStatement newLoopBlock = new BlockStatement();
            this.addStatementToNewQuery(loopBlock, newLoopBlock, addAll, propertyNames, variableScope);
            ws.setLoopBlock(this.flattenStatementIfNecessary(newLoopBlock));
            newCode.addStatement((Statement)ws);
        } else if (statement instanceof TryCatchStatement) {
            TryCatchStatement tcs = (TryCatchStatement)statement;
            Statement tryStatement = tcs.getTryStatement();
            BlockStatement newTryStatement = new BlockStatement();
            this.addStatementToNewQuery(tryStatement, newTryStatement, addAll, propertyNames, variableScope);
            tcs.setTryStatement(this.flattenStatementIfNecessary(newTryStatement));
            List catchStatements = tcs.getCatchStatements();
            for (CatchStatement catchStatement : catchStatements) {
                BlockStatement newCatchStatement = new BlockStatement();
                Statement code = catchStatement.getCode();
                this.addStatementToNewQuery(code, newCatchStatement, addAll, propertyNames, variableScope);
                catchStatement.setCode(this.flattenStatementIfNecessary(newCatchStatement));
            }
            Statement finallyStatement = tcs.getFinallyStatement();
            if (finallyStatement != null) {
                BlockStatement newFinallyStatement = new BlockStatement();
                this.addStatementToNewQuery(finallyStatement, newFinallyStatement, addAll, propertyNames, variableScope);
                tcs.setFinallyStatement(this.flattenStatementIfNecessary(newFinallyStatement));
            }
            newCode.addStatement((Statement)tcs);
        } else {
            newCode.addStatement(statement);
        }
    }

    private Statement flattenStatementIfNecessary(BlockStatement blockStatement) {
        if (blockStatement.getStatements().size() == 1) {
            return (Statement)blockStatement.getStatements().get(0);
        }
        return blockStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAssociationMethodCallExpression(BlockStatement newCode, MethodCallExpression methodCall, List<String> propertyNames, VariableScope variableScope) {
        ArgumentListExpression arguments;
        Expression method = methodCall.getMethod();
        String methodName = method.getText();
        ArgumentListExpression argumentListExpression = arguments = methodCall.getArguments() instanceof ArgumentListExpression ? (ArgumentListExpression)methodCall.getArguments() : null;
        if (methodName.equals("call") && this.hasClosureArgument(arguments)) {
            methodName = methodCall.getObjectExpression().getText();
        }
        if (this.isAssociationMethodCall(propertyNames, methodName, arguments)) {
            ClosureAndArguments closureAndArguments = new ClosureAndArguments(variableScope);
            ClosureExpression associationQuery = (ClosureExpression)arguments.getExpression(0);
            BlockStatement currentBody = closureAndArguments.getCurrentBody();
            ArgumentListExpression argList = closureAndArguments.getArguments();
            newCode.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)DELEGATE_EXPRESSION, methodName, (Expression)argList)));
            Statement associationCode = associationQuery.getCode();
            if (associationCode instanceof BlockStatement) {
                ClassNode associationTypeFromGenerics;
                List<String> associationPropertyNames = null;
                ClassNode type = this.getPropertyType(methodName);
                if (!this.isDomainClass(type) && (associationTypeFromGenerics = this.getAssociationTypeFromGenerics(type)) != null) {
                    type = associationTypeFromGenerics;
                    associationPropertyNames = this.getPropertyNamesForAssociation(associationTypeFromGenerics);
                }
                if (associationPropertyNames == null) {
                    associationPropertyNames = this.getPropertyNames(type);
                }
                ClassNode existing = this.currentClassNode;
                try {
                    if (!associationPropertyNames.isEmpty() && !this.isDomainClass(type) && (type = this.getAssociationTypeFromGenerics(type)) != null) {
                        associationPropertyNames = this.getPropertyNames(type);
                    }
                    this.currentClassNode = type;
                    this.addBlockStatementToNewQuery((BlockStatement)associationCode, currentBody, associationPropertyNames.isEmpty(), associationPropertyNames, variableScope);
                }
                finally {
                    this.currentClassNode = existing;
                }
            }
        }
    }

    private List<String> getPropertyNamesForAssociation(ClassNode type) {
        List<String> associationPropertyNames = null;
        if (type != null) {
            if (this.isDomainClass(type)) {
                associationPropertyNames = this.getPropertyNames(type);
            } else {
                ClassNode associationType = this.getAssociationTypeFromGenerics(type);
                if (associationType != null) {
                    associationPropertyNames = this.getPropertyNames(associationType);
                }
            }
        }
        return associationPropertyNames;
    }

    private ClassNode getAssociationTypeFromGenerics(ClassNode type) {
        GenericsType[] genericsTypes = type.getGenericsTypes();
        ClassNode associationType = null;
        if (genericsTypes != null && genericsTypes.length == 1) {
            GenericsType genericType = genericsTypes[0];
            associationType = genericType.getType();
        }
        return associationType;
    }

    private ClassNode getPropertyType(String prop) {
        ClassNode classNode = this.currentClassNode;
        return this.getPropertyType(classNode, prop);
    }

    private ClassNode getPropertyType(ClassNode classNode, String prop) {
        Map<String, ClassNode> cachedProperties = this.cachedClassProperties.get(classNode.getName());
        if (cachedProperties != null) {
            return cachedProperties.get(prop);
        }
        ClassNode type = null;
        PropertyNode property = classNode.getProperty(prop);
        if (property != null) {
            type = property.getType();
        } else {
            MethodNode methodNode = this.currentClassNode.getMethod(GrailsNameUtils.getGetterName((String)prop), new Parameter[0]);
            if (methodNode != null) {
                type = methodNode.getReturnType();
            }
        }
        return type;
    }

    private boolean isAssociationMethodCall(List<String> propertyNames, String methodName, ArgumentListExpression arguments) {
        return propertyNames.contains(methodName) && this.hasClosureArgument(arguments);
    }

    private boolean hasClosureArgument(ArgumentListExpression arguments) {
        return arguments != null && arguments.getExpressions().size() == 1 && arguments.getExpression(0) instanceof ClosureExpression;
    }

    private void handleNegation(List<String> propertyNames, BlockStatement newCode, NotExpression not, VariableScope variableScope) {
        Expression subExpression = not.getExpression();
        if (subExpression instanceof BinaryExpression) {
            ArgumentListExpression arguments = new ArgumentListExpression();
            BlockStatement currentBody = new BlockStatement();
            ClosureExpression newClosureExpression = new ClosureExpression(new Parameter[0], (Statement)currentBody);
            newClosureExpression.setVariableScope(new VariableScope());
            arguments.addExpression((Expression)newClosureExpression);
            this.addBinaryExpressionToNewBody(propertyNames, currentBody, (BinaryExpression)subExpression, false, variableScope);
            newCode.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)THIS_EXPRESSION, "not", (Expression)arguments)));
        } else {
            this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("You can only negate a binary expressions in queries.", (CSTNode)Token.newString((String)not.getText(), (int)not.getLineNumber(), (int)not.getColumnNumber()), this.sourceUnit));
        }
    }

    private void addBinaryExpressionToNewBody(List<String> propertyNames, BlockStatement newCode, BinaryExpression be, boolean addAll, VariableScope variableScope) {
        Token operation = be.getOperation();
        String operator = operation.getRootText();
        Expression leftExpression = be.getLeftExpression();
        Expression rightExpression = be.getRightExpression();
        if (leftExpression instanceof VariableExpression) {
            VariableExpression leftVariable = (VariableExpression)leftExpression;
            String propertyName = leftVariable.getText();
            if (propertyNames.contains(propertyName) || addAll) {
                if (OPERATOR_TO_CRITERIA_METHOD_MAP.containsKey(operator)) {
                    this.addCriteriaCallMethodExpression(newCode, operator, rightExpression, propertyName, propertyNames, addAll, variableScope);
                } else {
                    this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("Unsupported operator [" + operator + "] used in query", (CSTNode)operation, this.sourceUnit));
                }
            } else {
                this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("Cannot query on property \"" + propertyName + "\" - no such property on class " + this.currentClassNode.getName() + " exists.", (CSTNode)Token.newString((String)propertyName, (int)leftExpression.getLineNumber(), (int)leftExpression.getColumnNumber()), this.sourceUnit));
            }
        } else {
            if (leftExpression instanceof MethodCallExpression) {
                MethodCallExpression mce = (MethodCallExpression)leftExpression;
                String methodName = mce.getMethodAsString();
                Expression objectExpression = mce.getObjectExpression();
                if ("size".equals(methodName) && objectExpression instanceof VariableExpression) {
                    String propertyName = objectExpression.getText();
                    if (propertyNames.contains(propertyName)) {
                        String sizeOperator = SIZE_OPERATOR_TO_CRITERIA_METHOD_MAP.get(operator);
                        if (sizeOperator != null) {
                            this.addCriteriaCall(newCode, operator, rightExpression, propertyName, propertyNames, addAll, sizeOperator, variableScope);
                        } else {
                            this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("Unsupported operator [" + operator + "] used in size() query", (CSTNode)operation, this.sourceUnit));
                        }
                    } else {
                        this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("Cannot query size of property \"" + propertyName + "\" - no such property on class " + this.currentClassNode.getName() + " exists.", (CSTNode)Token.newString((String)propertyName, (int)leftExpression.getLineNumber(), (int)leftExpression.getColumnNumber()), this.sourceUnit));
                    }
                    return;
                }
                boolean isFunctionCall = this.isFunctionCall(mce, methodName, objectExpression);
                if (isFunctionCall) {
                    String functionName = methodName;
                    ArgumentListExpression existingArgs = (ArgumentListExpression)mce.getArguments();
                    Expression propertyNameExpression = existingArgs.getExpression(0);
                    if (propertyNameExpression instanceof PropertyExpression) {
                        this.handleAssociationQueryViaPropertyExpression((PropertyExpression)propertyNameExpression, rightExpression, operator, newCode, propertyNames, functionName, variableScope);
                    } else {
                        this.handleFunctionCall(newCode, operator, rightExpression, functionName, propertyNameExpression);
                    }
                    return;
                }
            }
            String methodNameToCall = null;
            if (operator.contains(AND_OPERATOR)) {
                methodNameToCall = "and";
            } else if (operator.contains(OR_OPERATOR)) {
                methodNameToCall = "or";
            }
            ArgumentListExpression arguments = new ArgumentListExpression();
            BlockStatement currentBody = new BlockStatement();
            this.handleBinaryExpressionSide(leftExpression, rightExpression, operator, currentBody, addAll, propertyNames, variableScope);
            this.handleBinaryExpressionSide(rightExpression, rightExpression, operator, currentBody, addAll, propertyNames, variableScope);
            ClosureExpression newClosureExpression = new ClosureExpression(new Parameter[0], (Statement)currentBody);
            newClosureExpression.setVariableScope(variableScope);
            arguments.addExpression((Expression)newClosureExpression);
            if (methodNameToCall != null) {
                newCode.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)THIS_EXPRESSION, methodNameToCall, (Expression)arguments)));
            } else {
                List statements = currentBody.getStatements();
                for (Statement statement : statements) {
                    newCode.addStatement(statement);
                }
            }
        }
    }

    private boolean isFunctionCall(MethodCallExpression mce) {
        boolean isThis = "this".equals(mce.getObjectExpression().getText());
        Expression arguments = mce.getArguments();
        boolean hasOneArg = arguments instanceof ArgumentListExpression ? ((ArgumentListExpression)arguments).getExpressions().size() == 1 : false;
        return isThis && hasOneArg && SUPPORTED_FUNCTIONS.contains(mce.getMethodAsString());
    }

    private boolean isFunctionCall(MethodCallExpression mce, String methodName, Expression objectExpression) {
        boolean isThis = "this".equals(objectExpression.getText());
        Expression arguments = mce.getArguments();
        boolean hasOneArg = arguments instanceof ArgumentListExpression ? ((ArgumentListExpression)arguments).getExpressions().size() == 1 : false;
        return isThis && hasOneArg && SUPPORTED_FUNCTIONS.contains(methodName);
    }

    private void handleFunctionCall(BlockStatement newCode, String operator, Expression rightExpression, String functionName, Expression propertyNameExpression) {
        ArgumentListExpression newArgs = new ArgumentListExpression();
        ArgumentListExpression constructorArgs = new ArgumentListExpression();
        constructorArgs.addExpression((Expression)new ConstantExpression((Object)functionName));
        ClassNode criterionClassNode = OPERATOR_TO_CRITERION_METHOD_MAP.get(operator);
        if (criterionClassNode != null) {
            ArgumentListExpression criterionConstructorArguments = new ArgumentListExpression();
            if (!(propertyNameExpression instanceof ConstantExpression)) {
                propertyNameExpression = new ConstantExpression((Object)propertyNameExpression.getText());
            }
            criterionConstructorArguments.addExpression(propertyNameExpression);
            criterionConstructorArguments.addExpression(rightExpression);
            constructorArgs.addExpression((Expression)new ConstructorCallExpression(criterionClassNode, (Expression)criterionConstructorArguments));
            ConstructorCallExpression constructorCallExpression = new ConstructorCallExpression(FUNCTION_CALL_CRITERION, (Expression)constructorArgs);
            newArgs.addExpression((Expression)constructorCallExpression);
            newCode.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)THIS_EXPRESSION, "add", (Expression)newArgs)));
        } else {
            this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("Unsupported operator [" + operator + "] used with function call [" + functionName + "] in query", (CSTNode)Token.newString((String)functionName, (int)rightExpression.getLineNumber(), (int)rightExpression.getColumnNumber()), this.sourceUnit));
        }
    }

    private void handleBinaryExpressionSide(Expression expressionSide, Expression oppositeSide, String operator, BlockStatement newCode, boolean addAll, List<String> propertyNames, VariableScope variableScope) {
        if (expressionSide instanceof BinaryExpression) {
            this.addBinaryExpressionToNewBody(propertyNames, newCode, (BinaryExpression)expressionSide, addAll, variableScope);
        } else if (expressionSide instanceof NotExpression) {
            this.handleNegation(propertyNames, newCode, (NotExpression)expressionSide, variableScope);
        } else if (expressionSide instanceof MethodCallExpression) {
            MethodCallExpression methodCallExpression = (MethodCallExpression)expressionSide;
            this.handleAssociationMethodCallExpression(newCode, methodCallExpression, propertyNames, variableScope);
        } else if (expressionSide instanceof PropertyExpression) {
            PropertyExpression pe = (PropertyExpression)expressionSide;
            this.handleAssociationQueryViaPropertyExpression(pe, oppositeSide, operator, newCode, propertyNames, null, variableScope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAssociationQueryViaPropertyExpression(PropertyExpression pe, Expression oppositeSide, String operator, BlockStatement newCode, List<String> propertyNames, String functionName, VariableScope variableScope) {
        Expression objectExpression = pe.getObjectExpression();
        if (objectExpression instanceof VariableExpression) {
            String propertyName = objectExpression.getText();
            if (propertyNames.contains(propertyName)) {
                ClassNode associationTypeFromGenerics;
                String associationProperty = pe.getPropertyAsString();
                List<String> associationPropertyNames = null;
                ClassNode type = this.getPropertyType(propertyName);
                if (!this.isDomainClass(type) && (associationTypeFromGenerics = this.getAssociationTypeFromGenerics(type)) != null) {
                    type = associationTypeFromGenerics;
                    associationPropertyNames = this.getPropertyNamesForAssociation(associationTypeFromGenerics);
                }
                if (associationPropertyNames == null) {
                    associationPropertyNames = this.getPropertyNamesForAssociation(type);
                }
                ClosureAndArguments closureAndArguments = new ClosureAndArguments(variableScope);
                BlockStatement currentBody = closureAndArguments.getCurrentBody();
                ArgumentListExpression arguments = closureAndArguments.getArguments();
                boolean hasNoProperties = associationPropertyNames.isEmpty();
                if (!hasNoProperties && !associationPropertyNames.contains(associationProperty)) {
                    this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("Cannot query property \"" + associationProperty + "\" - no such property on class " + type.getName() + " exists.", (CSTNode)Token.newString((String)propertyName, (int)pe.getLineNumber(), (int)pe.getColumnNumber()), this.sourceUnit));
                }
                ClassNode existing = this.currentClassNode;
                try {
                    this.currentClassNode = type;
                    if (functionName != null) {
                        this.handleFunctionCall(currentBody, operator, oppositeSide, functionName, (Expression)new ConstantExpression((Object)associationProperty));
                    } else {
                        this.addCriteriaCallMethodExpression(currentBody, operator, oppositeSide, associationProperty, associationPropertyNames, hasNoProperties, variableScope);
                    }
                }
                finally {
                    this.currentClassNode = existing;
                }
                newCode.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)DELEGATE_EXPRESSION, propertyName, (Expression)arguments)));
            } else {
                this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("Cannot query property \"" + propertyName + "\" - no such property on class " + this.currentClassNode.getName() + " exists.", (CSTNode)Token.newString((String)propertyName, (int)pe.getLineNumber(), (int)pe.getColumnNumber()), this.sourceUnit));
            }
        }
    }

    private void addCriteriaCallMethodExpression(BlockStatement newCode, String operator, Expression rightExpression, String propertyName, List<String> propertyNames, boolean addAll, VariableScope variableScope) {
        String methodToCall = OPERATOR_TO_CRITERIA_METHOD_MAP.get(operator);
        if (methodToCall == null) {
            this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("Unsupported operator [" + operator + "] used in query", (CSTNode)Token.newString((String)rightExpression.getText(), (int)rightExpression.getLineNumber(), (int)rightExpression.getColumnNumber()), this.sourceUnit));
        }
        this.addCriteriaCall(newCode, operator, rightExpression, propertyName, propertyNames, addAll, methodToCall, variableScope);
    }

    private void addCriteriaCall(BlockStatement newCode, String operator, Expression rightExpression, String propertyName, List<String> propertyNames, boolean addAll, String methodToCall, VariableScope variableScope) {
        ArgumentListExpression arguments;
        if (rightExpression instanceof VariableExpression) {
            String rightPropertyName = rightExpression.getText();
            if (!variableScope.isReferencedLocalVariable(rightPropertyName) && (propertyNames.contains(rightPropertyName) || addAll) && PROPERTY_COMPARISON_OPERATOR_TO_CRITERIA_METHOD_MAP.containsKey(operator)) {
                methodToCall = PROPERTY_COMPARISON_OPERATOR_TO_CRITERIA_METHOD_MAP.get(operator);
                rightExpression = new ConstantExpression((Object)rightPropertyName);
            }
        } else if (rightExpression instanceof MethodCallExpression) {
            MethodCallExpression aggregateMethodCall = (MethodCallExpression)rightExpression;
            String methodName = aggregateMethodCall.getMethodAsString();
            String aggregateFunctionName = AGGREGATE_FUNCTIONS.get(methodName);
            if ("of".equals(methodName) && aggregateMethodCall.getObjectExpression() instanceof MethodCallExpression) {
                ArgumentListExpression arguments2 = (ArgumentListExpression)aggregateMethodCall.getArguments();
                if (arguments2.getExpressions().size() == 1 && arguments2.getExpression(0) instanceof ClosureExpression) {
                    ClosureExpression ce = (ClosureExpression)arguments2.getExpression(0);
                    this.transformClosureExpression(this.currentClassNode, ce);
                    aggregateMethodCall = (MethodCallExpression)aggregateMethodCall.getObjectExpression();
                    aggregateFunctionName = AGGREGATE_FUNCTIONS.get(aggregateMethodCall.getMethodAsString());
                    ArgumentListExpression aggregateMethodCallArguments = (ArgumentListExpression)aggregateMethodCall.getArguments();
                    if (aggregateFunctionName != null && aggregateMethodCallArguments.getExpressions().size() == 1) {
                        boolean validProperty;
                        Expression expression = aggregateMethodCallArguments.getExpression(0);
                        String aggregatePropertyName = null;
                        if (expression instanceof VariableExpression || expression instanceof ConstantExpression) {
                            aggregatePropertyName = expression.getText();
                        }
                        boolean bl = validProperty = aggregatePropertyName != null && propertyNames.contains(aggregatePropertyName);
                        if (validProperty) {
                            BlockStatement bs = (BlockStatement)ce.getCode();
                            this.addProjectionToCurrentBody(bs, aggregateFunctionName, aggregatePropertyName, variableScope);
                            rightExpression = new MethodCallExpression((Expression)new ConstructorCallExpression(DETACHED_CRITERIA_CLASS_NODE, (Expression)new ArgumentListExpression((Expression)new ClassExpression(this.currentClassNode))), "build", (Expression)new ArgumentListExpression((Expression)ce));
                        }
                    }
                }
            } else if (aggregateFunctionName != null) {
                ArgumentListExpression argList;
                List expressions;
                int argCount;
                Expression arguments3 = aggregateMethodCall.getArguments();
                if (arguments3 instanceof ArgumentListExpression && (argCount = (expressions = (argList = (ArgumentListExpression)arguments3).getExpressions()).size()) == 1) {
                    boolean validProperty;
                    Expression expression = (Expression)expressions.get(0);
                    String aggregatePropertyName = null;
                    if (!(expression instanceof VariableExpression) && !(expression instanceof ConstantExpression)) {
                        this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("Cannot use aggregate function " + aggregateFunctionName + " on expressions \"" + expression.getText() + "\".", (CSTNode)Token.newString((String)propertyName, (int)aggregateMethodCall.getLineNumber(), (int)aggregateMethodCall.getColumnNumber()), this.sourceUnit));
                        return;
                    }
                    aggregatePropertyName = expression.getText();
                    boolean bl = validProperty = aggregatePropertyName != null && propertyNames.contains(aggregatePropertyName);
                    if (validProperty) {
                        ClosureAndArguments closureAndArguments = new ClosureAndArguments(variableScope);
                        BlockStatement currentBody = closureAndArguments.getCurrentBody();
                        this.addProjectionToCurrentBody(currentBody, aggregateFunctionName, aggregatePropertyName, variableScope);
                        rightExpression = closureAndArguments.getClosureExpression();
                        if ("property".equals(aggregateFunctionName)) {
                            methodToCall = methodToCall + "All";
                        }
                    } else {
                        this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("Cannot use aggregate function " + aggregateFunctionName + " on property \"" + aggregatePropertyName + "\" - no such property on class " + this.currentClassNode.getName() + " exists.", (CSTNode)Token.newString((String)propertyName, (int)aggregateMethodCall.getLineNumber(), (int)aggregateMethodCall.getColumnNumber()), this.sourceUnit));
                    }
                }
            } else if (this.isFunctionCall(aggregateMethodCall)) {
                ArgumentListExpression existingArgs = (ArgumentListExpression)aggregateMethodCall.getArguments();
                Expression propertyNameExpression = existingArgs.getExpression(0);
                this.sourceUnit.getErrorCollector().addError((Message)new LocatedMessage("Function call " + aggregateFunctionName + " not allowed on property \"" + propertyNameExpression.getText() + "\". Function calls can currently only be used on the left-hand side of expressions", (CSTNode)Token.newString((String)propertyName, (int)aggregateMethodCall.getLineNumber(), (int)aggregateMethodCall.getColumnNumber()), this.sourceUnit));
                return;
            }
        } else if ("like".equals(methodToCall) && rightExpression instanceof BitwiseNegationExpression) {
            methodToCall = "rlike";
            BitwiseNegationExpression bne = (BitwiseNegationExpression)rightExpression;
            rightExpression = bne.getExpression();
        } else if ("inList".equals(methodToCall) && rightExpression instanceof RangeExpression) {
            methodToCall = "between";
            RangeExpression re = (RangeExpression)rightExpression;
            ArgumentListExpression betweenArgs = new ArgumentListExpression();
            betweenArgs.addExpression((Expression)new ConstantExpression((Object)propertyName)).addExpression(re.getFrom()).addExpression(re.getTo());
            rightExpression = betweenArgs;
        }
        if (rightExpression instanceof ArgumentListExpression) {
            arguments = (ArgumentListExpression)rightExpression;
        } else if (rightExpression instanceof ConstantExpression) {
            ConstantExpression constant = (ConstantExpression)rightExpression;
            if (constant.getValue() == null) {
                boolean singleArg = false;
                if (operator.equals(EQUALS_OPERATOR)) {
                    singleArg = true;
                    methodToCall = IS_NULL_CRITERION;
                } else if (operator.equals("!=")) {
                    singleArg = true;
                    methodToCall = "isNotNull";
                }
                arguments = new ArgumentListExpression();
                arguments.addExpression((Expression)new ConstantExpression((Object)propertyName));
                if (!singleArg) {
                    arguments.addExpression(rightExpression);
                }
            } else {
                arguments = new ArgumentListExpression();
                arguments.addExpression((Expression)new ConstantExpression((Object)propertyName)).addExpression(rightExpression);
            }
        } else {
            arguments = new ArgumentListExpression();
            arguments.addExpression((Expression)new ConstantExpression((Object)propertyName)).addExpression(rightExpression);
        }
        newCode.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)THIS_EXPRESSION, methodToCall, (Expression)arguments)));
    }

    private void addProjectionToCurrentBody(BlockStatement currentBody, String functionName, String aggregatePropertyName, VariableScope variableScope) {
        ClosureAndArguments projectionsBody = new ClosureAndArguments(variableScope);
        ArgumentListExpression aggregateArgs = new ArgumentListExpression();
        aggregateArgs.addExpression((Expression)new ConstantExpression((Object)aggregatePropertyName));
        projectionsBody.getCurrentBody().addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)THIS_EXPRESSION, functionName, (Expression)aggregateArgs)));
        currentBody.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)THIS_EXPRESSION, "projections", (Expression)projectionsBody.getArguments())));
    }

    protected boolean isDomainClass(ClassNode classNode) {
        List annotations;
        String filePath;
        if (classNode == null) {
            return false;
        }
        String string = filePath = classNode.getModule() != null ? classNode.getModule().getDescription() : null;
        if (filePath != null) {
            try {
                if (GrailsResourceUtils.isDomainClass((URL)new File(filePath).toURI().toURL())) {
                    return true;
                }
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if ((annotations = classNode.getAnnotations()) != null && !annotations.isEmpty()) {
            for (AnnotationNode annotation : annotations) {
                String className = annotation.getClassNode().getName();
                if (!Entity.class.getName().equals(className)) continue;
                return true;
            }
        }
        return false;
    }

    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    private boolean isGetter(String methodName, MethodNode declaredMethod) {
        return declaredMethod.getParameters().length == 0 && GrailsClassUtils.isGetter((String)methodName, (Class[])EMPTY_JAVA_CLASS_ARRAY);
    }

    private class ClosureAndArguments {
        private BlockStatement currentBody;
        private ArgumentListExpression arguments;
        private ClosureExpression closureExpression;
        private VariableScope variableScope;

        private ClosureAndArguments(VariableScope variableScope) {
            this.variableScope = variableScope;
            this.build();
        }

        public BlockStatement getCurrentBody() {
            return this.currentBody;
        }

        public ArgumentListExpression getArguments() {
            return this.arguments;
        }

        private ClosureAndArguments build() {
            this.currentBody = new BlockStatement();
            this.closureExpression = new ClosureExpression(new Parameter[0], (Statement)this.currentBody);
            this.closureExpression.setVariableScope(this.variableScope);
            this.closureExpression.setCode((Statement)this.currentBody);
            this.arguments = new ArgumentListExpression();
            this.arguments.addExpression((Expression)this.closureExpression);
            return this;
        }

        public ClosureExpression getClosureExpression() {
            return this.closureExpression;
        }
    }
}

