/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.validation.constraints;

import groovy.lang.IntRange;
import java.lang.reflect.Array;
import java.util.Collection;
import org.grails.datastore.gorm.validation.constraints.AbstractConstraint;
import org.springframework.context.MessageSource;
import org.springframework.validation.Errors;

public class SizeConstraint
extends AbstractConstraint {
    private IntRange range;

    public SizeConstraint(Class<?> constraintOwningClass, String constraintPropertyName, Object constraintParameter, MessageSource messageSource) {
        super(constraintOwningClass, constraintPropertyName, constraintParameter, messageSource);
        this.range = (IntRange)constraintParameter;
    }

    public IntRange getRange() {
        return this.range;
    }

    @Override
    public boolean supports(Class type) {
        return type != null && (String.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type) || type.isArray());
    }

    @Override
    protected Object validateParameter(Object constraintParameter) {
        if (!(constraintParameter instanceof IntRange)) {
            throw new IllegalArgumentException("Parameter for constraint [size] of property [" + this.constraintPropertyName + "] of class [" + this.constraintOwningClass + "] must be a of type [groovy.lang.IntRange]");
        }
        return constraintParameter;
    }

    @Override
    public String getName() {
        return "size";
    }

    @Override
    protected void processValidate(Object target, Object propertyValue, Errors errors) {
        Object[] args = new Object[]{this.constraintPropertyName, this.constraintOwningClass, propertyValue, this.range.getFrom(), this.range.getTo()};
        int size = propertyValue.getClass().isArray() ? Array.getLength(propertyValue) : (propertyValue instanceof Collection ? ((Collection)propertyValue).size() : ((String)propertyValue).length());
        if (!this.range.contains((Object)size)) {
            if (this.range.getFrom().compareTo(size) == 1) {
                this.rejectValue(args, errors, target, ".toosmall");
            } else if (this.range.getTo().compareTo(size) == -1) {
                this.rejectValue(args, errors, target, ".toobig");
            }
        }
    }

    private void rejectValue(Object[] args, Errors errors, Object target, String suffix) {
        this.rejectValue(target, errors, "default.invalid.size.message", "size" + suffix, args);
    }
}

