/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j.engine;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.grails.datastore.gorm.neo4j.GraphPersistentEntity;
import org.grails.datastore.gorm.neo4j.RelationshipPersistentEntity;
import org.grails.datastore.gorm.neo4j.RelationshipUtils;
import org.grails.datastore.mapping.core.impl.PendingOperationAdapter;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.model.types.Association;
import org.neo4j.driver.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipPendingDelete
extends PendingOperationAdapter<Object, Serializable> {
    private static Logger log = LoggerFactory.getLogger(RelationshipPendingDelete.class);
    private final Transaction boltTransaction;
    private final Association association;
    private final Collection<Serializable> targetIdentifiers;
    private final EntityAccess entityAccess;

    public RelationshipPendingDelete(EntityAccess parent, Association association, Collection<Serializable> pendingInserts, Transaction boltTransaction) {
        super(parent.getPersistentEntity(), (Object)((Serializable)parent.getIdentifier()), parent.getEntity());
        this.targetIdentifiers = pendingInserts;
        this.boltTransaction = boltTransaction;
        this.association = association;
        this.entityAccess = parent;
    }

    public void run() {
        GraphPersistentEntity graphParent = (GraphPersistentEntity)this.getEntity();
        Serializable parentId = (Serializable)this.getNativeKey();
        boolean isRelationshipAssociation = graphParent.isRelationshipEntity();
        if (isRelationshipAssociation) {
            if (this.association.getName().equals("from")) {
                RelationshipPersistentEntity relEntity = (RelationshipPersistentEntity)graphParent;
                GraphPersistentEntity graphChild = relEntity.getToEntity();
                graphParent = relEntity.getFromEntity();
                Object endEntity = this.entityAccess.getProperty("to");
                Object startEntity = this.entityAccess.getProperty("from");
                parentId = graphParent.getReflector().getIdentifier(startEntity);
                this.targetIdentifiers.clear();
                this.targetIdentifiers.add(graphChild.getReflector().getIdentifier(endEntity));
            } else {
                return;
            }
        }
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(2);
        if (RelationshipUtils.useReversedMappingFor(this.association)) {
            params.put("id", parentId);
        } else {
            params.put("start", parentId);
            params.put("end", this.targetIdentifiers);
        }
        String cypher = graphParent.formatAssociationDelete(this.association, this.entityAccess.getEntity());
        if (cypher != null) {
            if (log.isDebugEnabled()) {
                log.debug("DELETE Cypher [{}] for parameters [{}]", (Object)cypher, params);
            }
            this.boltTransaction.run(cypher, params);
        }
    }
}

