/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j.engine;

import groovy.lang.GroovyObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.persistence.FetchType;
import javax.persistence.LockModeType;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.grails.datastore.gorm.GormEntity;
import org.grails.datastore.gorm.neo4j.GraphPersistentEntity;
import org.grails.datastore.gorm.neo4j.IdGenerator;
import org.grails.datastore.gorm.neo4j.Neo4jMappingContext;
import org.grails.datastore.gorm.neo4j.Neo4jSession;
import org.grails.datastore.gorm.neo4j.RelationshipPersistentEntity;
import org.grails.datastore.gorm.neo4j.RelationshipUtils;
import org.grails.datastore.gorm.neo4j.collection.Neo4jList;
import org.grails.datastore.gorm.neo4j.collection.Neo4jPersistentList;
import org.grails.datastore.gorm.neo4j.collection.Neo4jPersistentSet;
import org.grails.datastore.gorm.neo4j.collection.Neo4jPersistentSortedSet;
import org.grails.datastore.gorm.neo4j.collection.Neo4jResultList;
import org.grails.datastore.gorm.neo4j.collection.Neo4jSet;
import org.grails.datastore.gorm.neo4j.collection.Neo4jSortedSet;
import org.grails.datastore.gorm.neo4j.engine.Neo4jAssociationQueryExecutor;
import org.grails.datastore.gorm.neo4j.engine.Neo4jModificationTrackingEntityAccess;
import org.grails.datastore.gorm.neo4j.engine.Neo4jQuery;
import org.grails.datastore.gorm.neo4j.mapping.config.DynamicToOneAssociation;
import org.grails.datastore.gorm.neo4j.util.IteratorUtil;
import org.grails.datastore.gorm.schemaless.DynamicAttributes;
import org.grails.datastore.mapping.collection.PersistentCollection;
import org.grails.datastore.mapping.core.IdentityGenerationException;
import org.grails.datastore.mapping.core.impl.PendingDelete;
import org.grails.datastore.mapping.core.impl.PendingDeleteAdapter;
import org.grails.datastore.mapping.core.impl.PendingInsert;
import org.grails.datastore.mapping.core.impl.PendingInsertAdapter;
import org.grails.datastore.mapping.core.impl.PendingOperation;
import org.grails.datastore.mapping.core.impl.PendingOperationAdapter;
import org.grails.datastore.mapping.core.impl.PendingUpdate;
import org.grails.datastore.mapping.core.impl.PendingUpdateAdapter;
import org.grails.datastore.mapping.dirty.checking.DirtyCheckable;
import org.grails.datastore.mapping.dirty.checking.DirtyCheckableCollection;
import org.grails.datastore.mapping.engine.AssociationQueryExecutor;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.EntityPersister;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.Basic;
import org.grails.datastore.mapping.model.types.ManyToMany;
import org.grails.datastore.mapping.model.types.OneToMany;
import org.grails.datastore.mapping.model.types.OneToOne;
import org.grails.datastore.mapping.model.types.Simple;
import org.grails.datastore.mapping.model.types.TenantId;
import org.grails.datastore.mapping.model.types.ToMany;
import org.grails.datastore.mapping.model.types.ToOne;
import org.grails.datastore.mapping.proxy.EntityProxy;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.reflect.EntityReflector;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.summary.SummaryCounters;
import org.neo4j.driver.types.Entity;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.util.Assert;

public class Neo4jEntityPersister
extends EntityPersister {
    public static final String DYNAMIC_ASSOCIATION_PARAM = "org.grails.neo4j.DYNAMIC_ASSOCIATIONS";
    private static Logger log = LoggerFactory.getLogger(Neo4jEntityPersister.class);

    public Neo4jEntityPersister(MappingContext mappingContext, PersistentEntity entity, org.grails.datastore.mapping.core.Session session, ApplicationEventPublisher publisher) {
        super(mappingContext, entity, session, publisher);
    }

    public Neo4jSession getSession() {
        return (Neo4jSession)this.session;
    }

    protected List<Object> retrieveAllEntities(PersistentEntity pe, Serializable[] keys) {
        return this.retrieveAllEntities(pe, Arrays.asList(keys));
    }

    protected List<Object> retrieveAllEntities(PersistentEntity pe, Iterable<Serializable> keys) {
        ArrayList<Query.In> criterions = new ArrayList<Query.In>(1);
        criterions.add(new Query.In("id", (Collection)DefaultGroovyMethods.toList(keys)));
        Query.Conjunction junction = new Query.Conjunction(criterions);
        return new Neo4jQuery(this.getSession(), pe, this).executeQuery(pe, (Query.Junction)junction);
    }

    protected List<Serializable> persistEntities(final PersistentEntity pe, Iterable objs) {
        ArrayList<Serializable> idList;
        block14: {
            block15: {
                Result result;
                GraphPersistentEntity graphPersistentEntity;
                block13: {
                    graphPersistentEntity = (GraphPersistentEntity)pe;
                    idList = new ArrayList<Serializable>();
                    if (!graphPersistentEntity.hasDynamicAssociations()) break block13;
                    for (Object obj : objs) {
                        Serializable id = this.persistEntity(pe, obj);
                        if (id == null) continue;
                        idList.add(id);
                    }
                    break block14;
                }
                if (!graphPersistentEntity.isNativeId() || graphPersistentEntity.isRelationshipEntity()) break block15;
                ArrayList<EntityAccess> entityAccesses = new ArrayList<EntityAccess>();
                Neo4jSession session = this.getSession();
                StringBuilder createCypher = new StringBuilder("CREATE ");
                int listIndex = 0;
                ArrayList<PendingOperation<Object, Serializable>> cascadingOperations = new ArrayList<PendingOperation<Object, Serializable>>();
                HashMap<String, Object> params = new HashMap<String, Object>(1);
                HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
                int insertIndex = 0;
                Iterator iterator = objs.iterator();
                boolean previous = false;
                while (iterator.hasNext()) {
                    boolean isUpdate;
                    EntityAccess entityAccess;
                    Object obj = iterator.next();
                    ++listIndex;
                    if (this.shouldIgnore(session, obj)) {
                        entityAccess = this.createEntityAccess(pe, obj);
                        idList.add((Serializable)entityAccess.getIdentifier());
                        continue;
                    }
                    entityAccess = this.createEntityAccess(pe, obj);
                    GraphPersistentEntity persistentEntity = (GraphPersistentEntity)entityAccess.getPersistentEntity();
                    if (this.getMappingContext().getProxyFactory().isProxy(obj)) {
                        idList.add(((EntityProxy)obj).getProxyKey());
                        continue;
                    }
                    session.registerPending(obj);
                    Serializable identifier = (Serializable)entityAccess.getIdentifier();
                    boolean bl = isUpdate = identifier != null;
                    if (isUpdate) {
                        this.registerPendingUpdate(session, (PersistentEntity)persistentEntity, entityAccess, obj, identifier);
                        idList.add(identifier);
                        continue;
                    }
                    PendingInsertAdapter<Object, Serializable> pendingInsert = new PendingInsertAdapter<Object, Serializable>((PersistentEntity)persistentEntity, identifier, obj, entityAccess){

                        public void run() {
                            if (Neo4jEntityPersister.this.cancelInsert(pe, entityAccess)) {
                                this.setVetoed(true);
                            }
                        }

                        public Serializable getNativeKey() {
                            return (Serializable)entityAccess.getIdentifier();
                        }
                    };
                    pendingInsert.addCascadeOperation((PendingOperation)new PendingOperationAdapter<Object, Serializable>((PersistentEntity)persistentEntity, identifier, obj){

                        public void run() {
                            Neo4jEntityPersister.this.firePostInsertEvent(pe, entityAccess);
                        }
                    });
                    cascadingOperations.addAll(pendingInsert.getCascadeOperations());
                    List preOperations = pendingInsert.getPreOperations();
                    for (PendingOperation preOperation : preOperations) {
                        preOperation.run();
                    }
                    pendingInsert.run();
                    pendingInsert.setExecuted(true);
                    idList.add(null);
                    if (pendingInsert.isVetoed()) continue;
                    session.addPendingInsert((PendingInsert)pendingInsert);
                    indexMap.put(insertIndex++, listIndex - 1);
                    entityAccesses.add(entityAccess);
                    if (previous) {
                        createCypher.append(", ");
                    }
                    session.buildEntityCreateOperation(createCypher, String.valueOf(insertIndex), entityAccess.getPersistentEntity(), (PendingInsert)pendingInsert, params, cascadingOperations);
                    if (!iterator.hasNext()) continue;
                    previous = true;
                }
                if (insertIndex <= 0) break block14;
                Session statementRunner = session.hasTransaction() ? session.getTransaction().getNativeTransaction() : session.getNativeInterface();
                String finalCypher = createCypher.toString() + " RETURN *";
                if (log.isDebugEnabled()) {
                    log.debug("CREATE Cypher [{}] for parameters [{}]", (Object)finalCypher, params);
                }
                if (graphPersistentEntity.hasDynamicAssociations()) {
                    params.remove(DYNAMIC_ASSOCIATION_PARAM);
                }
                if (!(result = statementRunner.run(finalCypher, params)).hasNext()) {
                    throw new IdentityGenerationException("CREATE operation did not generate an identifier for entity " + pe.getJavaClass());
                }
                Record record = result.next();
                for (int j = 0; j < insertIndex; ++j) {
                    Integer targetIndex = (Integer)indexMap.get(j);
                    Assert.notNull((Object)targetIndex, (String)"Should never be null. Please file an issue");
                    Node node = record.get("n" + (j + 1)).asNode();
                    if (node == null) {
                        throw new IdentityGenerationException("CREATE operation did not generate an identifier for entity " + pe.getJavaClass());
                    }
                    long identifier = node.id();
                    EntityAccess entityAccess = (EntityAccess)entityAccesses.get(j);
                    entityAccess.setIdentifier((Object)identifier);
                    idList.set(targetIndex, Long.valueOf(identifier));
                    this.persistAssociationsOfEntity((GraphPersistentEntity)pe, entityAccess, false);
                }
                break block14;
            }
            for (Object obj : objs) {
                EntityAccess entityAccess = this.createEntityAccess(pe, obj);
                Serializable id = this.persistEntity(entityAccess.getPersistentEntity(), obj);
                if (id == null) continue;
                idList.add(id);
            }
        }
        return idList;
    }

    protected Object retrieveEntity(PersistentEntity pe, Serializable key) {
        if (log.isDebugEnabled()) {
            log.debug("Retrieving entity [{}] by node id [{}]", (Object)pe.getJavaClass(), (Object)key);
        }
        Neo4jQuery query = new Neo4jQuery(this.getSession(), pe, this);
        query.idEq(key);
        return query.max(1).singleResult();
    }

    public Object unmarshallOrFromCache(PersistentEntity defaultPersistentEntity, Map<String, Object> resultData) {
        Node data = (Node)resultData.get("data");
        return this.unmarshallOrFromCache(defaultPersistentEntity, data, resultData);
    }

    public Object unmarshallOrFromCache(PersistentEntity defaultPersistentEntity, Node data) {
        return this.unmarshallOrFromCache(defaultPersistentEntity, data, Collections.emptyMap());
    }

    public Object unmarshallOrFromCache(PersistentEntity defaultPersistentEntity, Node data, Map<String, Object> resultData) {
        return this.unmarshallOrFromCache(defaultPersistentEntity, data, resultData, Collections.emptyMap());
    }

    public Object unmarshallOrFromCache(PersistentEntity defaultPersistentEntity, Node data, Map<String, Object> resultData, Map<Association, Object> initializedAssociations) {
        return this.unmarshallOrFromCache(defaultPersistentEntity, data, resultData, initializedAssociations, LockModeType.NONE);
    }

    public Object unmarshallOrFromCache(PersistentEntity defaultPersistentEntity, Node data, Map<String, Object> resultData, Map<Association, Object> initializedAssociations, LockModeType lockModeType) {
        Neo4jSession session = this.getSession();
        if (LockModeType.PESSIMISTIC_WRITE.equals((Object)lockModeType)) {
            if (log.isDebugEnabled()) {
                log.debug("Locking entity [{}] node [{}] for pessimistic write", (Object)defaultPersistentEntity.getName(), (Object)data.id());
            }
            throw new UnsupportedOperationException("Write locks are not supported by the Bolt Java Driver.");
        }
        Iterable labels = data.labels();
        GraphPersistentEntity graphPersistentEntity = (GraphPersistentEntity)defaultPersistentEntity;
        PersistentEntity persistentEntity = this.mostSpecificPersistentEntity(defaultPersistentEntity, labels);
        Serializable id = graphPersistentEntity.readId((Entity)data);
        Object instance = session.getCachedInstance(persistentEntity.getJavaClass(), id);
        if (instance == null) {
            instance = this.unmarshall(persistentEntity, id, (Entity)data, resultData, initializedAssociations);
        }
        return instance;
    }

    public Object unmarshallOrFromCache(PersistentEntity entity, Relationship data, Map<Association, Object> initializedAssociations, Map<Serializable, Node> initializedNodes) {
        Object object = this.unmarshallOrFromCache(entity, (Entity)data, initializedAssociations);
        RelationshipPersistentEntity relEntity = (RelationshipPersistentEntity)entity;
        if (object != null) {
            Object to;
            EntityReflector reflector = entity.getReflector();
            Object from = reflector.getProperty(object, "from");
            if (from == null || from instanceof EntityProxy) {
                long nodeId = data.startNodeId();
                if (initializedNodes.containsKey(nodeId)) {
                    reflector.setProperty(object, "from", this.unmarshallOrFromCache((PersistentEntity)relEntity.getFromEntity(), initializedNodes.get(nodeId)));
                } else {
                    reflector.setProperty(object, "from", this.session.proxy(relEntity.getFrom().getType(), (Serializable)Long.valueOf(nodeId)));
                }
            }
            if ((to = reflector.getProperty(object, "to")) == null || to instanceof EntityProxy) {
                long nodeId = data.endNodeId();
                if (initializedNodes.containsKey(nodeId)) {
                    reflector.setProperty(object, "to", this.unmarshallOrFromCache((PersistentEntity)relEntity.getToEntity(), initializedNodes.get(nodeId)));
                } else {
                    reflector.setProperty(object, "to", this.session.proxy(relEntity.getTo().getType(), (Serializable)Long.valueOf(nodeId)));
                }
            }
            reflector.setProperty(object, "type", (Object)data.type());
        }
        return object;
    }

    public Object unmarshallOrFromCache(PersistentEntity entity, Entity data, Map<Association, Object> initializedAssociations) {
        Neo4jSession session = this.getSession();
        GraphPersistentEntity graphPersistentEntity = (GraphPersistentEntity)entity;
        Serializable id = graphPersistentEntity.readId(data);
        Object instance = session.getCachedInstance(entity.getJavaClass(), id);
        if (instance == null) {
            instance = this.unmarshall(entity, id, data, Collections.emptyMap(), initializedAssociations);
        }
        return instance;
    }

    private PersistentEntity mostSpecificPersistentEntity(PersistentEntity pe, Iterable<String> labels) {
        PersistentEntity result = null;
        int longestInheritenceChain = -1;
        for (String l : labels) {
            int inheritenceChain;
            PersistentEntity persistentEntity = this.findDerivedPersistentEntityWithLabel(pe, l);
            if (persistentEntity == null || (inheritenceChain = this.calcInheritenceChain(persistentEntity)) <= longestInheritenceChain) continue;
            longestInheritenceChain = inheritenceChain;
            result = persistentEntity;
        }
        if (result != null) {
            return result;
        }
        return pe;
    }

    private PersistentEntity findDerivedPersistentEntityWithLabel(PersistentEntity parent, String label) {
        for (PersistentEntity pe : this.getMappingContext().getPersistentEntities()) {
            if (!this.isInParentsChain(parent, pe) || !((GraphPersistentEntity)pe).getLabels().contains(label)) continue;
            return pe;
        }
        return null;
    }

    private boolean isInParentsChain(PersistentEntity parent, PersistentEntity it) {
        if (it == null) {
            return false;
        }
        if (it.equals(parent)) {
            return true;
        }
        return this.isInParentsChain(parent, it.getParentEntity());
    }

    private int calcInheritenceChain(PersistentEntity current) {
        if (current == null) {
            return 0;
        }
        return this.calcInheritenceChain(current.getParentEntity()) + 1;
    }

    protected Object unmarshall(PersistentEntity persistentEntity, Serializable id, Entity node, Map<String, Object> resultData, Map<Association, Object> initializedAssociations) {
        if (log.isDebugEnabled()) {
            log.debug("unmarshalling entity [{}] with id [{}], props {}, {}", new Object[]{persistentEntity.getName(), id, node});
        }
        Neo4jSession session = this.getSession();
        GraphPersistentEntity graphPersistentEntity = (GraphPersistentEntity)persistentEntity;
        Object instance = persistentEntity.newInstance();
        EntityAccess entityAccess = session.createEntityAccess(persistentEntity, instance);
        entityAccess.setIdentifierNoConversion((Object)id);
        PersistentProperty nodeId = graphPersistentEntity.getNodeId();
        if (nodeId != null) {
            ((GroovyObject)entityAccess.getEntity()).setProperty(nodeId.getName(), (Object)node.id());
        }
        Object entity = entityAccess.getEntity();
        session.cacheInstance(persistentEntity.getJavaClass(), id, entity);
        List nodeProperties = DefaultGroovyMethods.toList((Iterable)node.keys());
        for (Object property : entityAccess.getPersistentEntity().getPersistentProperties()) {
            String propertyName = property.getName();
            if (property instanceof Simple || property instanceof TenantId || property instanceof Basic) {
                if (!node.containsKey(propertyName)) continue;
                entityAccess.setProperty(propertyName, node.get(propertyName).asObject());
                nodeProperties.remove(propertyName);
                continue;
            }
            if (property instanceof Association) {
                Association association = (Association)property;
                String associationName = association.getName();
                if (initializedAssociations.containsKey(association)) {
                    entityAccess.setPropertyNoConversion(associationName, initializedAssociations.get(association));
                    continue;
                }
                String associationRelKey = associationName + "Rels";
                String associationNodesKey = associationName + "Nodes";
                String associationIdsKey = associationName + "Ids";
                if (resultData.containsKey(associationNodesKey)) {
                    Association inverseSide;
                    PersistentEntity associatedEntity = association.getAssociatedEntity();
                    if (association instanceof ToOne) {
                        Neo4jEntityPersister associationPersister = session.getEntityPersister(associatedEntity.getJavaClass());
                        Iterable associationNodes = (Iterable)resultData.get(associationNodesKey);
                        Node associationNode = (Node)IteratorUtil.singleOrNull(associationNodes);
                        if (associationNode == null) continue;
                        entityAccess.setPropertyNoConversion(associationName, associationPersister.unmarshallOrFromCache(associatedEntity, associationNode));
                        continue;
                    }
                    if (!(association instanceof ToMany)) continue;
                    Class type = association.getType();
                    boolean isRelationshipEntity = associatedEntity instanceof RelationshipPersistentEntity;
                    Collection associationNodes = isRelationshipEntity && resultData.containsKey(associationRelKey) ? (Collection)resultData.get(associationRelKey) : (Collection)resultData.get(associationNodesKey);
                    Neo4jResultList resultSet = new Neo4jResultList(0, associationNodes.size(), associationNodes.iterator(), session.getEntityPersister(associatedEntity));
                    if (isRelationshipEntity) {
                        RelationshipPersistentEntity relEntity = (RelationshipPersistentEntity)associatedEntity;
                        Association from = relEntity.getFrom();
                        Association to = relEntity.getTo();
                        this.handleRelationshipSide(persistentEntity, resultData, entity, associationNodesKey, resultSet, from);
                        this.handleRelationshipSide(persistentEntity, resultData, entity, associationNodesKey, resultSet, to);
                    } else if (association.isBidirectional() && (inverseSide = association.getInverseSide()) instanceof ToOne) {
                        resultSet.setInitializedAssociations(Collections.singletonMap(inverseSide, entity));
                    }
                    Object values = List.class.isAssignableFrom(type) ? new Neo4jList(entityAccess, association, (List)((Object)resultSet), session) : (SortedSet.class.isAssignableFrom(type) ? new Neo4jSortedSet(entityAccess, association, new TreeSet(resultSet), session) : new Neo4jSet(entityAccess, association, new HashSet(resultSet), session));
                    entityAccess.setPropertyNoConversion(propertyName, values);
                    continue;
                }
                if (resultData.containsKey(associationIdsKey)) {
                    Object associationValues = resultData.get(associationIdsKey);
                    List targetIds = Collections.emptyList();
                    if (associationValues instanceof Collection) {
                        targetIds = (List)associationValues;
                    }
                    if (association instanceof ToOne) {
                        Serializable targetId;
                        ToOne toOne = (ToOne)association;
                        if (targetIds.isEmpty()) continue;
                        try {
                            targetId = (Serializable)IteratorUtil.singleOrNull(targetIds);
                        }
                        catch (NoSuchElementException e) {
                            throw new DataIntegrityViolationException("Single-ended association has more than one associated identifier: " + association);
                        }
                        entityAccess.setPropertyNoConversion(propertyName, this.getMappingContext().getProxyFactory().createProxy(this.session, toOne.getAssociatedEntity().getJavaClass(), targetId));
                        continue;
                    }
                    if (association instanceof ToMany) {
                        Class type = association.getType();
                        GroovyObject values = List.class.isAssignableFrom(type) ? new Neo4jPersistentList(targetIds, session, entityAccess, (ToMany)association) : (SortedSet.class.isAssignableFrom(type) ? new Neo4jPersistentSortedSet(targetIds, session, entityAccess, (ToMany)association) : new Neo4jPersistentSet(targetIds, session, entityAccess, (ToMany)association));
                        entityAccess.setPropertyNoConversion(propertyName, (Object)values);
                        continue;
                    }
                    throw new IllegalArgumentException("association " + associationName + " is of type " + association.getClass().getSuperclass().getName());
                }
                if (association instanceof ToOne) {
                    Neo4jAssociationQueryExecutor associationQueryExecutor = new Neo4jAssociationQueryExecutor(session, association);
                    if (association.getMapping().getMappedForm().getFetchStrategy() == FetchType.LAZY) {
                        Object proxy = this.getMappingContext().getProxyFactory().createProxy(this.session, (AssociationQueryExecutor)associationQueryExecutor, id);
                        entityAccess.setPropertyNoConversion(propertyName, proxy);
                        continue;
                    }
                    List<Object> results = associationQueryExecutor.query(id);
                    if (results.isEmpty()) continue;
                    entityAccess.setPropertyNoConversion(propertyName, results.get(0));
                    continue;
                }
                if (!(association instanceof ToMany)) continue;
                Class type = association.getType();
                GroovyObject values = List.class.isAssignableFrom(type) ? new Neo4jPersistentList(id, session, entityAccess, (ToMany)association) : (SortedSet.class.isAssignableFrom(type) ? new Neo4jPersistentSortedSet(id, session, entityAccess, (ToMany)association) : new Neo4jPersistentSet(id, session, entityAccess, (ToMany)association));
                entityAccess.setPropertyNoConversion(propertyName, (Object)values);
                continue;
            }
            throw new IllegalArgumentException("property " + property.getName() + " is of type " + property.getClass().getSuperclass().getName());
        }
        LinkedHashMap<String, Object> undeclared = new LinkedHashMap<String, Object>();
        if (!nodeProperties.isEmpty()) {
            for (String nodeProperty : nodeProperties) {
                if (nodeProperty.equals("__id__")) continue;
                undeclared.put(nodeProperty, node.get(nodeProperty).asObject());
            }
        }
        Object obj = entity;
        if (!undeclared.isEmpty() && obj instanceof DynamicAttributes) {
            ((DynamicAttributes)obj).attributes(undeclared);
        }
        this.firePostLoadEvent(entityAccess.getPersistentEntity(), entityAccess);
        return obj;
    }

    private void handleRelationshipSide(PersistentEntity persistentEntity, Map<String, Object> resultData, Object entity, String associationNodesKey, Neo4jResultList resultSet, Association association) {
        if (persistentEntity.equals(association.getAssociatedEntity())) {
            resultSet.setInitializedAssociations(Collections.singletonMap(association, entity));
            if (resultData.containsKey(associationNodesKey)) {
                Collection nodes = (Collection)resultData.get(associationNodesKey);
                for (Node n : nodes) {
                    resultSet.addInitializedNode(n);
                }
            }
        }
    }

    private Collection createCollection(Association association) {
        return association.isList() ? new ArrayList() : new HashSet();
    }

    private Collection createDirtyCheckableAwareCollection(EntityAccess entityAccess, Association association, Collection delegate) {
        if (delegate == null) {
            delegate = this.createCollection(association);
        }
        if (!(delegate instanceof DirtyCheckableCollection)) {
            Object entity = entityAccess.getEntity();
            if (entity instanceof DirtyCheckable) {
                Neo4jSession session = this.getSession();
                for (Object o : delegate) {
                    EntityAccess associationAccess = this.getSession().createEntityAccess(association.getAssociatedEntity(), o);
                    Serializable associationId = (Serializable)associationAccess.getIdentifier();
                    if (associationId == null) continue;
                    session.addPendingRelationshipInsert((Serializable)entityAccess.getIdentifier(), association, associationId);
                }
                delegate = association.isList() ? new Neo4jList(entityAccess, association, (List)delegate, session) : new Neo4jSet(entityAccess, association, (Set)delegate, session);
            }
        } else {
            DirtyCheckableCollection dirtyCheckableCollection = (DirtyCheckableCollection)delegate;
            Neo4jSession session = this.getSession();
            if (dirtyCheckableCollection.hasChanged()) {
                for (Object o : (Iterable)dirtyCheckableCollection) {
                    EntityAccess associationAccess = this.getSession().createEntityAccess(association.getAssociatedEntity(), o);
                    session.addPendingRelationshipInsert((Serializable)entityAccess.getIdentifier(), association, (Serializable)associationAccess.getIdentifier());
                }
            }
        }
        return delegate;
    }

    protected Serializable persistEntity(PersistentEntity entity, Object obj, boolean isInsert) {
        if (obj == null) {
            throw new IllegalStateException("obj is null");
        }
        Neo4jSession session = this.getSession();
        if (this.shouldIgnore(session, obj)) {
            EntityAccess entityAccess = this.createEntityAccess(entity, obj);
            return (Serializable)entityAccess.getIdentifier();
        }
        if (this.getMappingContext().getProxyFactory().isProxy(obj)) {
            return ((EntityProxy)obj).getProxyKey();
        }
        final EntityAccess entityAccess = this.createEntityAccess(entity, obj);
        Object identifier = entityAccess.getIdentifier();
        session.registerPending(obj);
        boolean isUpdate = identifier != null && !isInsert;
        GraphPersistentEntity graphPersistentEntity = (GraphPersistentEntity)entity;
        boolean assignedId = graphPersistentEntity.isAssignedId();
        if (assignedId && !session.contains(obj)) {
            isUpdate = false;
        }
        if (isUpdate) {
            this.registerPendingUpdate(session, entity, entityAccess, obj, (Serializable)identifier);
        } else {
            boolean isNativeId = false;
            if (identifier == null) {
                IdGenerator idGenerator = graphPersistentEntity.getIdGenerator();
                boolean bl = isNativeId = idGenerator == null;
                if (!isNativeId) {
                    identifier = idGenerator.nextId();
                    entityAccess.setIdentifier(identifier);
                }
            }
            PendingInsertAdapter<Object, Serializable> pendingInsert = new PendingInsertAdapter<Object, Serializable>(entity, (Serializable)identifier, obj, entityAccess){

                public void run() {
                    if (Neo4jEntityPersister.this.cancelInsert(this.entity, entityAccess)) {
                        this.setVetoed(true);
                    }
                }

                public Serializable getNativeKey() {
                    return (Serializable)entityAccess.getIdentifier();
                }
            };
            pendingInsert.addCascadeOperation((PendingOperation)new PendingOperationAdapter<Object, Serializable>(entity, (Serializable)identifier, obj){

                public void run() {
                    Neo4jEntityPersister.this.firePostInsertEvent(this.entity, entityAccess);
                }
            });
            if (isNativeId && !graphPersistentEntity.isRelationshipEntity()) {
                Result result;
                List preOperations = pendingInsert.getPreOperations();
                for (PendingOperation preOperation : preOperations) {
                    preOperation.run();
                }
                pendingInsert.run();
                pendingInsert.setExecuted(true);
                if (pendingInsert.isVetoed()) {
                    return null;
                }
                HashMap<String, Object> params = new HashMap<String, Object>(1);
                String cypher = session.buildEntityCreateOperation(entity, (PendingInsert)pendingInsert, params, pendingInsert.getCascadeOperations());
                Map dynamicAssociations = null;
                if (graphPersistentEntity.hasDynamicAssociations()) {
                    dynamicAssociations = (Map)params.remove(DYNAMIC_ASSOCIATION_PARAM);
                }
                Session boltSession = session.hasTransaction() ? session.getTransaction().getNativeTransaction() : session.getNativeInterface();
                String finalCypher = cypher + graphPersistentEntity.formatReturnId();
                if (log.isDebugEnabled()) {
                    log.debug("CREATE Cypher [{}] for parameters [{}]", (Object)finalCypher, params);
                }
                if (!(result = boltSession.run(finalCypher, params)).hasNext()) {
                    throw new IdentityGenerationException("CREATE operation did not generate an identifier for entity " + entityAccess.getEntity());
                }
                Record idMap = result.next();
                if (idMap != null) {
                    identifier = idMap.get("id").asObject();
                    if (identifier == null) {
                        throw new IdentityGenerationException("CREATE operation did not generate an identifier for entity " + entityAccess.getEntity());
                    }
                    entityAccess.setIdentifier(identifier);
                    if (obj instanceof DirtyCheckable) {
                        ((DirtyCheckable)obj).trackChanges();
                    }
                    this.persistAssociationsOfEntity(graphPersistentEntity, entityAccess, false);
                    if (dynamicAssociations != null) {
                        this.processDynamicAssociations(graphPersistentEntity, entityAccess, (Neo4jMappingContext)this.getMappingContext(), dynamicAssociations, pendingInsert.getCascadeOperations(), false);
                    }
                } else {
                    throw new IdentityGenerationException("CREATE operation did not generate an identifier for entity " + entityAccess.getEntity());
                }
                session.addPendingInsert((PendingInsert)pendingInsert);
            } else {
                session.addPendingInsert((PendingInsert)pendingInsert);
                this.persistAssociationsOfEntity((GraphPersistentEntity)entity, entityAccess, false);
            }
        }
        return (Serializable)identifier;
    }

    protected Serializable persistEntity(PersistentEntity pe, Object obj) {
        return this.persistEntity(pe, obj, false);
    }

    private void registerPendingUpdate(Neo4jSession session, final PersistentEntity pe, final EntityAccess ea, Object obj, Serializable identifier) {
        final Neo4jModificationTrackingEntityAccess entityAccess = new Neo4jModificationTrackingEntityAccess(ea);
        final Object notEqualMarker = new Object();
        PendingUpdateAdapter<Object, Serializable> pendingUpdate = new PendingUpdateAdapter<Object, Serializable>(pe, identifier, obj, ea){

            public void run() {
                if (Neo4jEntityPersister.this.cancelUpdate(pe, (EntityAccess)entityAccess)) {
                    this.setVetoed(true);
                } else {
                    Object entity = entityAccess.getEntity();
                    if (entity instanceof DirtyCheckable) {
                        DirtyCheckable dirtyCheckable = (DirtyCheckable)entity;
                        for (Map.Entry entry : entityAccess.getModifiedProperties().entrySet()) {
                            dirtyCheckable.markDirty((String)entry.getKey(), notEqualMarker, entry.getValue());
                        }
                    }
                }
            }
        };
        pendingUpdate.addCascadeOperation((PendingOperation)new PendingOperationAdapter<Object, Serializable>(pe, identifier, obj){

            public void run() {
                Neo4jEntityPersister.this.firePostUpdateEvent(pe, ea);
            }
        });
        session.addPendingUpdate((PendingUpdate)pendingUpdate);
        this.persistAssociationsOfEntity((GraphPersistentEntity)pe, ea, true);
    }

    private boolean shouldIgnore(Neo4jSession session, Object obj) {
        boolean isDirty = obj instanceof DirtyCheckable ? ((DirtyCheckable)obj).hasChanged() : true;
        return session.isPendingAlready(obj) || !isDirty;
    }

    public void processDynamicAssociations(GraphPersistentEntity graphEntity, EntityAccess access, Neo4jMappingContext mappingContext, Map<String, List<Object>> dynamicRelProps, List<PendingOperation<Object, Serializable>> cascadingOperations, boolean isUpdate) {
        if (graphEntity.hasDynamicAssociations()) {
            Serializable parentId = (Serializable)access.getIdentifier();
            for (Map.Entry<String, List<Object>> e : dynamicRelProps.entrySet()) {
                for (Object o : e.getValue()) {
                    GraphPersistentEntity associated;
                    if (!((DirtyCheckable)access.getEntity()).hasChanged(e.getKey()) && isUpdate || (associated = (GraphPersistentEntity)mappingContext.getPersistentEntity(o.getClass().getName())) == null) continue;
                    Serializable childId = this.getSession().getEntityPersister(o).getObjectIdentifier(o);
                    if (childId == null) {
                        childId = this.persist(o);
                    }
                    this.getSession().addPendingRelationshipInsert(parentId, (Association)new DynamicToOneAssociation((PersistentEntity)graphEntity, (MappingContext)mappingContext, e.getKey(), (PersistentEntity)associated), childId);
                }
            }
        }
    }

    private void persistAssociationsOfEntity(GraphPersistentEntity graphEntity, EntityAccess entityAccess, boolean isUpdate) {
        Object obj = entityAccess.getEntity();
        DirtyCheckable dirtyCheckable = null;
        if (obj instanceof DirtyCheckable) {
            dirtyCheckable = (DirtyCheckable)obj;
        }
        Neo4jSession neo4jSession = this.getSession();
        if (graphEntity.hasDynamicAssociations()) {
            MappingContext mappingContext = graphEntity.getMappingContext();
            DynamicAttributes dynamicAttributes = (DynamicAttributes)obj;
            Map attributes = dynamicAttributes.attributes();
            for (Map.Entry entry : attributes.entrySet()) {
                Object o;
                Iterator originalValue;
                Object value = entry.getValue();
                if (value == null) {
                    String associationName = (String)entry.getKey();
                    originalValue = ((DirtyCheckable)obj).getOriginalValue(associationName);
                    if (originalValue != null && mappingContext.isPersistentEntity(originalValue)) {
                        this.processDynamicAssociationRemoval(graphEntity, entityAccess, neo4jSession, mappingContext, associationName, originalValue);
                        continue;
                    }
                    if (!(originalValue instanceof Iterable)) continue;
                    Iterable i = (Iterable)((Object)originalValue);
                    for (Object o2 : i) {
                        this.processDynamicAssociationRemoval(graphEntity, entityAccess, neo4jSession, mappingContext, associationName, o2);
                    }
                    continue;
                }
                if (mappingContext.isPersistentEntity(value)) {
                    if (!((DirtyCheckable)value).hasChanged()) continue;
                    neo4jSession.persist(value);
                    continue;
                }
                if (!(value instanceof Iterable)) continue;
                boolean collectionChanged = false;
                originalValue = ((Iterable)value).iterator();
                while (!(!originalValue.hasNext() || mappingContext.isPersistentEntity(o = originalValue.next()) && (collectionChanged = ((DirtyCheckable)o).hasChanged()))) {
                }
                if (!collectionChanged) continue;
                neo4jSession.persist((Iterable)value);
            }
        }
        for (PersistentProperty persistentProperty : graphEntity.getAssociations()) {
            String propertyName = persistentProperty.getName();
            if (persistentProperty instanceof Basic || isUpdate && (dirtyCheckable == null || !dirtyCheckable.hasChanged(propertyName))) continue;
            Object propertyValue = entityAccess.getProperty(propertyName);
            if (persistentProperty instanceof OneToMany || persistentProperty instanceof ManyToMany) {
                Object pc;
                Association association = (Association)persistentProperty;
                if (propertyValue == null || propertyValue instanceof PersistentCollection && !(pc = (PersistentCollection)propertyValue).isInitialized()) continue;
                if (association.isBidirectional()) {
                    pc = ((Iterable)propertyValue).iterator();
                    while (pc.hasNext()) {
                        Object associatedObject = pc.next();
                        EntityAccess assocEntityAccess = this.createEntityAccess(association.getAssociatedEntity(), associatedObject);
                        String referencedPropertyName = association.getReferencedPropertyName();
                        if (association instanceof ManyToMany) {
                            ((GormEntity)associatedObject).addTo(referencedPropertyName, obj);
                            continue;
                        }
                        assocEntityAccess.setPropertyNoConversion(referencedPropertyName, obj);
                        ((DirtyCheckable)associatedObject).markDirty(referencedPropertyName);
                    }
                }
                Collection targets = (Collection)propertyValue;
                this.persistEntities(association.getAssociatedEntity(), targets);
                boolean reversed = RelationshipUtils.useReversedMappingFor(association);
                if (reversed) continue;
                Collection dcc = this.createDirtyCheckableAwareCollection(entityAccess, association, targets);
                entityAccess.setProperty(association.getName(), (Object)dcc);
                continue;
            }
            if (persistentProperty instanceof ToOne) {
                Object previousValue;
                if (propertyValue != null) {
                    ToOne to = (ToOne)persistentProperty;
                    if (to.isBidirectional()) {
                        EntityAccess assocEntityAccess = this.createEntityAccess(to.getAssociatedEntity(), propertyValue);
                        if (to instanceof OneToOne) {
                            assocEntityAccess.setProperty(to.getReferencedPropertyName(), obj);
                        } else {
                            ArrayList<Object> collection = (ArrayList<Object>)assocEntityAccess.getProperty(to.getReferencedPropertyName());
                            if (collection == null) {
                                collection = new ArrayList<Object>();
                                assocEntityAccess.setProperty(to.getReferencedPropertyName(), collection);
                            }
                            if (this.proxyFactory.isInitialized(collection) && !collection.isEmpty()) {
                                boolean found = false;
                                for (Object e : collection) {
                                    if (!e.equals(obj)) continue;
                                    found = true;
                                    break;
                                }
                                if (!found) {
                                    collection.add(obj);
                                }
                            } else {
                                collection.add(obj);
                            }
                        }
                    }
                    this.persistEntity(to.getAssociatedEntity(), propertyValue);
                    Serializable thisId = (Serializable)entityAccess.getIdentifier();
                    EntityAccess associationAccess = neo4jSession.createEntityAccess(to.getAssociatedEntity(), propertyValue);
                    Serializable associationId = (Serializable)associationAccess.getIdentifier();
                    if (graphEntity.isRelationshipEntity() && propertyName.equals("from")) {
                        GraphPersistentEntity toEntity;
                        RelationshipPersistentEntity relEntity = (RelationshipPersistentEntity)graphEntity;
                        thisId = associationId;
                        Object object = entityAccess.getProperty("to");
                        if (object != null && (associationId = (toEntity = relEntity.getToEntity()).getReflector().getIdentifier(object)) == null) {
                            associationId = this.persistEntity((PersistentEntity)toEntity, object);
                        }
                    }
                    if (thisId == null || associationId == null) continue;
                    boolean reversed = RelationshipUtils.useReversedMappingFor((Association)to);
                    if (reversed) {
                        Association association = to.getInverseSide();
                        if (association == null) continue;
                        neo4jSession.addPendingRelationshipInsert(associationId, association, thisId);
                        continue;
                    }
                    neo4jSession.addPendingRelationshipInsert(thisId, (Association)to, associationId);
                    continue;
                }
                if (!isUpdate || (previousValue = dirtyCheckable.getOriginalValue(propertyName)) == null) continue;
                ToOne to = (ToOne)persistentProperty;
                Serializable associationId = neo4jSession.getEntityPersister(previousValue).getObjectIdentifier(previousValue);
                if (associationId == null) continue;
                neo4jSession.addPendingRelationshipDelete((Serializable)entityAccess.getIdentifier(), (Association)to, associationId);
                continue;
            }
            throw new IllegalArgumentException("GORM for Neo4j doesn't support properties of the given type " + persistentProperty + "(" + persistentProperty.getClass().getSuperclass() + ")");
        }
    }

    private void processDynamicAssociationRemoval(GraphPersistentEntity graphEntity, EntityAccess entityAccess, Neo4jSession neo4jSession, MappingContext mappingContext, String associationName, Object originalValue) {
        Serializable childId;
        GraphPersistentEntity associated = (GraphPersistentEntity)mappingContext.getPersistentEntity(originalValue.getClass().getName());
        if (associated != null && (childId = this.getSession().getEntityPersister(originalValue).getObjectIdentifier(originalValue)) != null) {
            Serializable parentId = (Serializable)entityAccess.getIdentifier();
            neo4jSession.addPendingRelationshipDelete(parentId, (Association)new DynamicToOneAssociation((PersistentEntity)graphEntity, mappingContext, associationName, (PersistentEntity)associated), childId);
        }
    }

    protected void deleteEntity(final PersistentEntity pe, Object obj) {
        final EntityAccess entityAccess = this.createEntityAccess(pe, obj);
        Neo4jSession session = this.getSession();
        session.clear(obj);
        PendingDeleteAdapter pendingDelete = this.createPendingDeleteOne(session, pe, entityAccess, obj);
        pendingDelete.addCascadeOperation((PendingOperation)new PendingOperationAdapter<Object, Serializable>(pe, (Serializable)entityAccess.getIdentifier(), obj){

            public void run() {
                Neo4jEntityPersister.this.firePostDeleteEvent(pe, entityAccess);
            }
        });
        session.addPendingDelete((PendingDelete)pendingDelete);
    }

    private PendingDeleteAdapter createPendingDeleteOne(Neo4jSession session, final PersistentEntity pe, final EntityAccess entityAccess, Object obj) {
        return new PendingDeleteAdapter(pe, entityAccess.getIdentifier(), obj){

            public void run() {
                if (Neo4jEntityPersister.this.cancelDelete(pe, entityAccess)) {
                    this.setVetoed(true);
                }
            }
        };
    }

    protected void deleteEntities(PersistentEntity pe, Iterable objects) {
        for (Object object : objects) {
            this.deleteEntity(pe, object);
        }
    }

    public Query createQuery() {
        return new Neo4jQuery(this.getSession(), this.getPersistentEntity(), this);
    }

    public Serializable refresh(Object o) {
        throw new UnsupportedOperationException();
    }

    public static long countUpdates(Result execute) {
        ResultSummary resultSummary = execute.consume();
        SummaryCounters counters = resultSummary.counters();
        if (counters.containsUpdates()) {
            return counters.nodesCreated() + counters.nodesDeleted() + counters.propertiesSet() + counters.relationshipsCreated() + counters.relationshipsDeleted();
        }
        return 0L;
    }
}

