/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j;

import grails.neo4j.Direction;
import grails.neo4j.Relationship;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.gorm.neo4j.GraphPersistentEntity;
import org.grails.datastore.gorm.neo4j.RelationshipPersistentEntity;
import org.grails.datastore.gorm.neo4j.mapping.config.Attribute;
import org.grails.datastore.gorm.neo4j.mapping.config.DynamicAssociation;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PropertyMapping;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.ManyToMany;
import org.grails.datastore.mapping.model.types.ManyToOne;

public class RelationshipUtils
implements GroovyObject {
    private static final char INCOMING_CHAR = '<';
    private static final char OUTGOING_CHAR = '>';
    private static final char OPEN_BRACE = '{';
    private static final char CLOSE_BRACE = '}';
    private static final char COMMA = ',';
    private static final char COLON = ':';
    private static final String SINGLE_QUOTE;
    private static final String START_RELATIONSHIP = "-[";
    private static final String END_RELATIONSHIP = "]-";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public RelationshipUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static boolean useReversedMappingFor(Association association) {
        GraphPersistentEntity entity = (GraphPersistentEntity)((Object)ScriptBytecodeAdapter.castToType((Object)association.getOwner(), GraphPersistentEntity.class));
        if (entity.isRelationshipEntity()) {
            return false;
        }
        PropertyMapping propertyMapping = association.getMapping();
        Attribute attr = (Attribute)((Object)ScriptBytecodeAdapter.castToType((Object)(propertyMapping != null ? propertyMapping.getMappedForm() : null), Attribute.class));
        return RelationshipUtils.isIncomingRelationship(association, attr);
    }

    public static String relationshipTypeUsedFor(Association association) {
        PropertyMapping propertyMapping = association.getMapping();
        Attribute mappedForm = (Attribute)((Object)ScriptBytecodeAdapter.castToType((Object)(propertyMapping != null ? propertyMapping.getMappedForm() : null), Attribute.class));
        return RelationshipUtils.getRelationshipType(association, mappedForm);
    }

    public static String matchForAssociation(Association association, String var, Map<String, String> attributes) {
        PropertyMapping propertyMapping = association.getMapping();
        Attribute mappedForm = (Attribute)((Object)ScriptBytecodeAdapter.castToType((Object)(propertyMapping != null ? propertyMapping.getMappedForm() : null), Attribute.class));
        String relationshipType = RelationshipUtils.getRelationshipType(association, mappedForm);
        boolean reversed = RelationshipUtils.isIncomingRelationship(association, mappedForm);
        StringBuilder sb = new StringBuilder();
        if (reversed) {
            sb.append(INCOMING_CHAR);
        }
        sb.append(START_RELATIONSHIP).append(var).append(COLON).append(relationshipType);
        if (!attributes.isEmpty()) {
            sb.append(OPEN_BRACE);
            Iterator<Map.Entry<String, String>> i = attributes.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)ScriptBytecodeAdapter.castToType(i.next(), Map.Entry.class);
                sb.append(ShortTypeHandling.castToString(entry.getKey())).append(COLON).append(SINGLE_QUOTE).append(ShortTypeHandling.castToString(entry.getValue())).append(SINGLE_QUOTE);
                if (!i.hasNext()) continue;
                sb.append(COMMA);
            }
            sb.append(CLOSE_BRACE);
        }
        sb.append(END_RELATIONSHIP);
        Attribute attribute = mappedForm;
        Direction direction = attribute != null ? attribute.getDirection() : null;
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)direction), (Object)((Object)Direction.OUTGOING)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)direction), (Object)((Object)Direction.BOTH)) || !reversed) {
            sb.append(OUTGOING_CHAR);
        }
        return sb.toString();
    }

    public static String toMatch(Association association, Relationship relationship, String var) {
        PropertyMapping propertyMapping = association.getMapping();
        Attribute mappedForm = (Attribute)((Object)ScriptBytecodeAdapter.castToType((Object)(propertyMapping != null ? propertyMapping.getMappedForm() : null), Attribute.class));
        String relationshipType = relationship.type();
        Direction direction = mappedForm.getDirection();
        Direction direction2 = DefaultTypeTransformation.booleanUnbox((Object)((Object)direction)) ? direction : Direction.OUTGOING;
        boolean reversed = ScriptBytecodeAdapter.compareEqual((Object)((Object)direction2), (Object)((Object)Direction.INCOMING)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)direction2), (Object)((Object)Direction.BOTH));
        StringBuilder sb = new StringBuilder();
        if (reversed) {
            sb.append(INCOMING_CHAR);
        }
        sb.append(START_RELATIONSHIP).append(var).append(COLON).append(relationshipType);
        sb.append(END_RELATIONSHIP);
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)direction2), (Object)((Object)Direction.OUTGOING)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)direction2), (Object)((Object)Direction.BOTH))) {
            sb.append(OUTGOING_CHAR);
        }
        return sb.toString();
    }

    public static String matchForRelationshipEntity(Association association, RelationshipPersistentEntity entity, String var) {
        PropertyMapping propertyMapping = association.getMapping();
        Attribute mappedForm = (Attribute)((Object)ScriptBytecodeAdapter.castToType((Object)(propertyMapping != null ? propertyMapping.getMappedForm() : null), Attribute.class));
        PersistentEntity owningEntity = association.getOwner();
        Direction direction = mappedForm.getDirection();
        Direction direction2 = DefaultTypeTransformation.booleanUnbox((Object)((Object)direction)) ? direction : (ScriptBytecodeAdapter.compareEqual((Object)owningEntity, (Object)entity.getTo().getAssociatedEntity()) ? Direction.INCOMING : Direction.OUTGOING);
        boolean reversed = ScriptBytecodeAdapter.compareEqual((Object)((Object)direction2), (Object)((Object)Direction.INCOMING)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)direction2), (Object)((Object)Direction.BOTH));
        StringBuilder sb = new StringBuilder();
        if (reversed) {
            sb.append(INCOMING_CHAR);
        }
        sb.append(START_RELATIONSHIP).append(var).append(END_RELATIONSHIP);
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)direction2), (Object)((Object)Direction.OUTGOING)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)direction2), (Object)((Object)Direction.BOTH))) {
            sb.append(OUTGOING_CHAR);
        }
        return sb.toString();
    }

    protected static boolean isIncomingRelationship(Association association, Attribute mappedForm) {
        Attribute attribute = mappedForm;
        Direction direction = attribute != null ? attribute.getDirection() : null;
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)direction), (Object)((Object)Direction.INCOMING)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)direction), (Object)((Object)Direction.BOTH))) {
            return true;
        }
        return association.isBidirectional() && (association instanceof ManyToOne || association instanceof ManyToMany && association.isOwningSide());
    }

    protected static String getRelationshipType(Association association, Attribute mappedForm) {
        Attribute attribute = mappedForm;
        String relationshipType = attribute != null ? attribute.getType() : null;
        if (relationshipType != null) {
            return relationshipType;
        }
        if (association instanceof DynamicAssociation) {
            return association.getName();
        }
        boolean reversed = RelationshipUtils.useReversedMappingFor(association);
        String name = reversed ? association.getReferencedPropertyName() : association.getName();
        if (name != null) {
            return name.toUpperCase(Locale.ENGLISH);
        }
        return association.getName().toUpperCase(Locale.ENGLISH);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RelationshipUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public static String matchForAssociation(Association association, String var) {
        return RelationshipUtils.matchForAssociation(association, var, Collections.emptyMap());
    }

    @Generated
    public static String matchForAssociation(Association association) {
        return RelationshipUtils.matchForAssociation(association, "", Collections.emptyMap());
    }

    @Generated
    public static String toMatch(Association association, Relationship relationship) {
        return RelationshipUtils.toMatch(association, relationship, "r");
    }

    @Generated
    public static String matchForRelationshipEntity(Association association, RelationshipPersistentEntity entity) {
        return RelationshipUtils.matchForRelationshipEntity(association, entity, "r");
    }

    @Generated
    @Internal
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        String string;
        SINGLE_QUOTE = string = "'";
    }

    @Generated
    public static char getINCOMING_CHAR() {
        return INCOMING_CHAR;
    }

    @Generated
    public static char getOUTGOING_CHAR() {
        return OUTGOING_CHAR;
    }
}

