/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j.util;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.grails.datastore.mapping.reflect.ClassUtils;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.harness.ServerControls;
import org.neo4j.harness.TestServerBuilder;
import org.neo4j.harness.TestServerBuilders;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Connector;
import org.neo4j.server.ServerStartupException;

public class EmbeddedNeo4jServer {
    public static boolean isAvailable() {
        return ClassUtils.isPresent((String)"org.neo4j.harness.ServerControls", (ClassLoader)EmbeddedNeo4jServer.class.getClassLoader());
    }

    public static ServerControls start(File dataLocation) throws IOException {
        return EmbeddedNeo4jServer.attemptStartServer(0, dataLocation, Collections.emptyMap());
    }

    public static ServerControls start(File dataLocation, Map<String, Object> options) throws IOException {
        return EmbeddedNeo4jServer.attemptStartServer(0, dataLocation, options);
    }

    public static ServerControls start(InetSocketAddress inetAddr) {
        return EmbeddedNeo4jServer.start(inetAddr.getHostName(), inetAddr.getPort(), null);
    }

    public static ServerControls start(InetSocketAddress inetAddr, File dataLocation) {
        return EmbeddedNeo4jServer.start(inetAddr.getHostName(), inetAddr.getPort(), dataLocation);
    }

    public static ServerControls start(InetSocketAddress inetAddr, File dataLocation, Map<String, Object> options) {
        return EmbeddedNeo4jServer.start(inetAddr.getHostName(), inetAddr.getPort(), dataLocation, options);
    }

    public static ServerControls start(String address) {
        URI uri = URI.create(address);
        return EmbeddedNeo4jServer.start(new InetSocketAddress(uri.getHost(), uri.getPort()));
    }

    public static ServerControls start(String address, File dataLocation) {
        URI uri = URI.create(address);
        return EmbeddedNeo4jServer.start(uri.getHost(), uri.getPort(), dataLocation);
    }

    public static ServerControls start(String address, File dataLocation, Map<String, Object> options) {
        URI uri = URI.create(address);
        return EmbeddedNeo4jServer.start(uri.getHost(), uri.getPort(), dataLocation, options);
    }

    public static ServerControls start(String host, int port) {
        return EmbeddedNeo4jServer.start(host, port, null);
    }

    public static ServerControls start(String host, int port, File dataLocation) {
        return EmbeddedNeo4jServer.start(host, port, dataLocation, Collections.emptyMap());
    }

    public static ServerControls start(String host, int port, File dataLocation, Map<String, Object> options) {
        String myBoltAddress = String.format("%s:%d", host, port);
        TestServerBuilder serverBuilder = TestServerBuilders.newInProcessBuilder().withConfig(new BoltConnector((String)"0").enabled, "true").withConfig(new BoltConnector((String)"0").type, Connector.ConnectorType.BOLT.name()).withConfig(new BoltConnector((String)"0").encryption_level, BoltConnector.EncryptionLevel.DISABLED.name()).withConfig(new BoltConnector((String)"0").listen_address, myBoltAddress);
        if (dataLocation != null) {
            serverBuilder = serverBuilder.withConfig(GraphDatabaseSettings.data_directory, dataLocation.getPath());
        }
        for (String name : options.keySet()) {
            serverBuilder.withConfig(name, options.get(name).toString());
        }
        return serverBuilder.newServer();
    }

    private static ServerControls attemptStartServer(int retryCount, File dataLocation, Map<String, Object> options) throws IOException {
        try {
            return EmbeddedNeo4jServer.start("localhost", 0, dataLocation, options);
        }
        catch (ServerStartupException sse) {
            if (retryCount < 4) {
                return EmbeddedNeo4jServer.attemptStartServer(++retryCount, dataLocation, options);
            }
            throw sse;
        }
    }
}

