/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import grails.neo4j.Relationship;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import javax.persistence.CascadeType;
import org.grails.datastore.gorm.neo4j.CypherBuilder;
import org.grails.datastore.gorm.neo4j.GraphPersistentEntity;
import org.grails.datastore.gorm.neo4j.IdGenerator;
import org.grails.datastore.gorm.neo4j.Neo4jDatastore;
import org.grails.datastore.gorm.neo4j.Neo4jMappingContext;
import org.grails.datastore.gorm.neo4j.Neo4jTransaction;
import org.grails.datastore.gorm.neo4j.RelationshipPersistentEntity;
import org.grails.datastore.gorm.neo4j.RelationshipUtils;
import org.grails.datastore.gorm.neo4j.SessionFlushedEvent;
import org.grails.datastore.gorm.neo4j.engine.Neo4jEntityPersister;
import org.grails.datastore.gorm.neo4j.engine.Neo4jQuery;
import org.grails.datastore.gorm.neo4j.engine.RelationshipPendingDelete;
import org.grails.datastore.gorm.neo4j.engine.RelationshipPendingInsert;
import org.grails.datastore.gorm.neo4j.mapping.config.DynamicAssociation;
import org.grails.datastore.gorm.neo4j.mapping.config.DynamicToOneAssociation;
import org.grails.datastore.gorm.schemaless.DynamicAttributes;
import org.grails.datastore.mapping.core.AbstractSession;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.OptimisticLockingException;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.impl.PendingDelete;
import org.grails.datastore.mapping.core.impl.PendingInsert;
import org.grails.datastore.mapping.core.impl.PendingOperation;
import org.grails.datastore.mapping.core.impl.PendingOperationAdapter;
import org.grails.datastore.mapping.core.impl.PendingUpdate;
import org.grails.datastore.mapping.dirty.checking.DirtyCheckable;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.Persister;
import org.grails.datastore.mapping.engine.types.CustomTypeMarshaller;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.Basic;
import org.grails.datastore.mapping.model.types.Custom;
import org.grails.datastore.mapping.model.types.ManyToMany;
import org.grails.datastore.mapping.model.types.Simple;
import org.grails.datastore.mapping.model.types.TenantId;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.Restrictions;
import org.grails.datastore.mapping.query.api.QueryableCriteria;
import org.grails.datastore.mapping.reflect.EntityReflector;
import org.grails.datastore.mapping.transactions.SessionHolder;
import org.grails.datastore.mapping.transactions.Transaction;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.StatementResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class Neo4jSession
extends AbstractSession<org.neo4j.driver.v1.Session> {
    private static Logger log = LoggerFactory.getLogger(Neo4jSession.class);
    private static final RemovalListener<RelationshipUpdateKey, Collection<Serializable>> EXCEPTION_THROWING_INSERT_LISTENER = (key, value, cause) -> {
        if (RemovalCause.SIZE == cause) {
            throw new DataAccessResourceFailureException("Maximum number (5000) of relationship update operations to flush() exceeded. Flush the session periodically to avoid this error for batch operations.");
        }
    };
    protected ConcurrentMap<RelationshipUpdateKey, Collection<Serializable>> pendingRelationshipInserts = Caffeine.newBuilder().executor(Runnable::run).removalListener(EXCEPTION_THROWING_INSERT_LISTENER).maximumSize(5000L).build().asMap();
    protected ConcurrentMap<RelationshipUpdateKey, Collection<Serializable>> pendingRelationshipDeletes = Caffeine.newBuilder().executor(Runnable::run).removalListener(EXCEPTION_THROWING_INSERT_LISTENER).maximumSize(5000L).build().asMap();
    protected final org.neo4j.driver.v1.Session boltSession;
    protected final Driver boltDriver;

    public Neo4jSession(Datastore datastore, MappingContext mappingContext, ApplicationEventPublisher publisher, boolean stateless, Driver boltDriver) {
        super(datastore, mappingContext, publisher, stateless);
        if (log.isDebugEnabled()) {
            log.debug("Session created");
        }
        this.boltDriver = boltDriver;
        this.boltSession = boltDriver.session();
    }

    public void addPendingRelationshipInsert(Serializable parentId, Association association, Serializable id) {
        this.addRelationshipUpdate(parentId, association, id, this.pendingRelationshipInserts);
    }

    public void addPendingRelationshipDelete(Serializable parentId, Association association, Serializable id) {
        this.addRelationshipUpdate(parentId, association, id, this.pendingRelationshipDeletes);
    }

    protected void addRelationshipUpdate(Serializable parentId, Association association, Serializable id, Map<RelationshipUpdateKey, Collection<Serializable>> targetMap) {
        if (id == null || parentId == null) {
            return;
        }
        RelationshipUpdateKey key = new RelationshipUpdateKey(parentId, association);
        Collection<Serializable> inserts = targetMap.get(key);
        if (inserts == null) {
            inserts = new ConcurrentLinkedQueue<Serializable>();
            targetMap.put(key, inserts);
        }
        if (!inserts.contains(id)) {
            inserts.add(id);
        }
    }

    protected void clearPendingOperations() {
        try {
            super.clearPendingOperations();
        }
        finally {
            this.pendingRelationshipInserts.clear();
            this.pendingRelationshipDeletes.clear();
        }
    }

    public Neo4jEntityPersister getEntityPersister(Object o) {
        return (Neo4jEntityPersister)this.getPersister(o);
    }

    protected Persister createPersister(Class cls, MappingContext mappingContext) {
        PersistentEntity entity = mappingContext.getPersistentEntity(cls.getName());
        return entity != null ? new Neo4jEntityPersister(mappingContext, entity, (Session)this, this.publisher) : null;
    }

    protected Transaction beginTransactionInternal() {
        throw new IllegalStateException("Use beingTransaction(TransactionDefinition) instead");
    }

    public Transaction beginTransaction(TransactionDefinition transactionDefinition) {
        return this.beginTransactionInternal(transactionDefinition, false);
    }

    protected Transaction beginTransactionInternal(TransactionDefinition transactionDefinition, boolean sessionCreated) {
        if (this.transaction != null && this.transaction.isActive()) {
            return this.transaction;
        }
        Transaction tx = null;
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.getDatastore());
            tx = sessionHolder.getTransaction();
        }
        if (tx == null || !tx.isActive()) {
            if (transactionDefinition.getName() == null) {
                transactionDefinition = this.createDefaultTransactionDefinition(transactionDefinition);
            }
            tx = new Neo4jTransaction(this.boltDriver, transactionDefinition, sessionCreated);
        }
        this.transaction = tx;
        return this.transaction;
    }

    public void disconnect() {
        if (this.isConnected()) {
            super.disconnect();
            try {
                if (this.transaction != null && !this.isSynchronizedWithTransaction) {
                    Neo4jTransaction transaction = this.getTransaction();
                    transaction.close();
                }
                this.boltSession.close();
            }
            catch (IOException e) {
                log.error("Error closing transaction: " + e.getMessage(), (Throwable)e);
            }
            finally {
                if (log.isDebugEnabled()) {
                    log.debug("Session closed");
                }
                this.transaction = null;
            }
        }
    }

    public Neo4jDatastore getDatastore() {
        return (Neo4jDatastore)super.getDatastore();
    }

    public org.neo4j.driver.v1.Session getNativeInterface() {
        return this.hasTransaction() ? this.getTransaction().getBoltSession() : this.boltSession;
    }

    protected void flushPendingUpdates(Map<PersistentEntity, Collection<PendingUpdate>> updates) {
        Set<PersistentEntity> entities = updates.keySet();
        Neo4jMappingContext mappingContext = this.getMappingContext();
        for (PersistentEntity entity : entities) {
            Collection<PendingUpdate> pendingUpdates = updates.get(entity);
            GraphPersistentEntity graphPersistentEntity = (GraphPersistentEntity)entity;
            boolean isVersioned = entity.isVersioned() && entity.hasProperty("version", Long.class);
            for (PendingUpdate pendingUpdate : pendingUpdates) {
                StatementResult executionResult;
                List preOperations = pendingUpdate.getPreOperations();
                this.executePendings(preOperations);
                pendingUpdate.run();
                if (pendingUpdate.isVetoed()) continue;
                EntityAccess access = pendingUpdate.getEntityAccess();
                ArrayList<PendingOperation<Object, Serializable>> cascadingOperations = new ArrayList<PendingOperation<Object, Serializable>>(pendingUpdate.getCascadeOperations());
                Object object = pendingUpdate.getObject();
                LinkedHashMap<String, Serializable> params = new LinkedHashMap<String, Serializable>(2);
                Serializable id = (Serializable)pendingUpdate.getNativeKey();
                params.put("id", id);
                HashMap<String, Object> simpleProps = new HashMap<String, Object>();
                DirtyCheckable dirtyCheckable = (DirtyCheckable)object;
                List dirtyPropertyNames = dirtyCheckable.listDirtyPropertyNames();
                for (String dirtyPropertyName : dirtyPropertyNames) {
                    PersistentProperty property = entity.getPropertyByName(dirtyPropertyName);
                    if (property == null) continue;
                    if (property instanceof Simple || property instanceof Basic) {
                        String name = property.getName();
                        Object value = access.getProperty(name);
                        if (value != null) {
                            simpleProps.put(name, mappingContext.convertToNative(value));
                            continue;
                        }
                        simpleProps.put(name, null);
                        continue;
                    }
                    if (!(property instanceof Custom)) continue;
                    this.applyCustomType(access, property, simpleProps);
                }
                Map<String, List<Object>> dynamicAssociations = this.amendMapWithUndeclaredProperties(graphPersistentEntity, simpleProps, object, (MappingContext)mappingContext);
                if (graphPersistentEntity.hasDynamicAssociations()) {
                    this.getEntityPersister(object).processDynamicAssociations(graphPersistentEntity, access, mappingContext, dynamicAssociations, cascadingOperations, true);
                }
                this.processPendingRelationshipUpdates(graphPersistentEntity, access, id, cascadingOperations, true);
                boolean hasNoUpdates = simpleProps.isEmpty();
                if (hasNoUpdates) {
                    dirtyCheckable.trackChanges();
                    this.executePendings(cascadingOperations);
                    continue;
                }
                params.put("props", simpleProps);
                if (isVersioned) {
                    Long version = (Long)access.getProperty("version");
                    if (version == null) {
                        version = 0L;
                    }
                    params.put("version", version);
                    long newVersion = version + 1L;
                    simpleProps.put("version", newVersion);
                    access.setProperty("version", (Object)newVersion);
                }
                String cypher = graphPersistentEntity.formatMatchAndUpdate("n", simpleProps);
                if (log.isDebugEnabled()) {
                    log.debug("UPDATE Cypher [{}] for parameters [{}]", (Object)cypher, params);
                }
                if (!(executionResult = this.getTransaction().getNativeTransaction().run(cypher, params)).hasNext() && isVersioned) {
                    throw new OptimisticLockingException(entity, (Object)id);
                }
                dirtyCheckable.trackChanges();
                this.executePendings(cascadingOperations);
            }
        }
    }

    private void processPendingRelationshipUpdates(GraphPersistentEntity entity, EntityAccess access, Serializable id, List<PendingOperation<Object, Serializable>> cascadingOperations, boolean isUpdate) {
        if (entity.isRelationshipEntity()) {
            RelationshipPersistentEntity relEntity = (RelationshipPersistentEntity)entity;
            Object from = access.getPropertyValue("from");
            if (from != null) {
                id = relEntity.getFromEntity().getReflector().getIdentifier(from);
            }
        }
        for (Association association : entity.getAssociations()) {
            if (association.isBasic()) continue;
            this.processPendingRelationshipUpdates(access, id, association, cascadingOperations, isUpdate);
        }
        if (entity.hasDynamicAssociations()) {
            if (!this.pendingRelationshipDeletes.isEmpty()) {
                for (RelationshipUpdateKey relationshipUpdateKey : this.pendingRelationshipDeletes.keySet()) {
                    Association association = relationshipUpdateKey.association;
                    if (!(association instanceof DynamicAssociation) || !association.getOwner().equals((Object)entity) || !relationshipUpdateKey.id.equals(id)) continue;
                    cascadingOperations.add((PendingOperation<Object, Serializable>)new RelationshipPendingDelete(access, association, (Collection)this.pendingRelationshipDeletes.get(relationshipUpdateKey), this.getTransaction().getTransaction()));
                }
            }
            if (!this.pendingRelationshipInserts.isEmpty()) {
                ArrayList relationshipUpdates = new ArrayList(this.pendingRelationshipInserts.keySet());
                Collections.sort(relationshipUpdates, new Comparator<RelationshipUpdateKey>(){

                    @Override
                    public int compare(RelationshipUpdateKey o1, RelationshipUpdateKey o2) {
                        return o1.association.getName().compareTo(o2.association.getName());
                    }
                });
                for (RelationshipUpdateKey relationshipUpdate : relationshipUpdates) {
                    Association association = relationshipUpdate.association;
                    if (!(association instanceof DynamicToOneAssociation) || !association.getOwner().equals((Object)entity) || !relationshipUpdate.id.equals(id)) continue;
                    cascadingOperations.add((PendingOperation<Object, Serializable>)new RelationshipPendingInsert(access, association, (Collection)this.pendingRelationshipInserts.get(relationshipUpdate), this, isUpdate));
                    this.pendingRelationshipInserts.remove(relationshipUpdate);
                }
            }
        }
    }

    private void processPendingRelationshipUpdates(EntityAccess parent, Serializable parentId, Association association, List<PendingOperation<Object, Serializable>> cascadingOperations, boolean isUpdate) {
        Collection pendingDeletes;
        RelationshipUpdateKey key;
        if (RelationshipUtils.useReversedMappingFor(association)) {
            if (association instanceof ManyToMany) {
                return;
            }
            Association inverseSide = association.getInverseSide();
            if (inverseSide != null) {
                Object associated = parent.getPropertyValue(association.getName());
                if (associated == null) {
                    key = new RelationshipUpdateKey(parentId, association);
                } else {
                    PersistentEntity associatedEntity = inverseSide.getOwner();
                    parent = this.createEntityAccess(associatedEntity, associated);
                    Serializable associatedId = (Serializable)parent.getIdentifier();
                    association = inverseSide;
                    key = new RelationshipUpdateKey(associatedId, inverseSide);
                }
            } else {
                key = new RelationshipUpdateKey(parentId, association);
            }
        } else {
            key = new RelationshipUpdateKey(parentId, association);
        }
        Collection pendingInserts = (Collection)this.pendingRelationshipInserts.get(key);
        if (pendingInserts != null && !pendingInserts.isEmpty()) {
            cascadingOperations.add((PendingOperation<Object, Serializable>)new RelationshipPendingInsert(parent, association, pendingInserts, this, isUpdate));
            this.pendingRelationshipInserts.remove(key);
        }
        if ((pendingDeletes = (Collection)this.pendingRelationshipDeletes.get(key)) != null && !pendingDeletes.isEmpty()) {
            cascadingOperations.add((PendingOperation<Object, Serializable>)new RelationshipPendingDelete(parent, association, pendingDeletes, this.getTransaction().getNativeTransaction()));
            this.pendingRelationshipDeletes.remove(key);
        }
    }

    protected void flushPendingInserts(Map<PersistentEntity, Collection<PendingInsert>> inserts) {
        org.neo4j.driver.v1.Transaction neo4jTransaction = this.getTransaction().getNativeTransaction();
        ArrayList<PendingOperation<Object, Serializable>> cascadingOperations = new ArrayList<PendingOperation<Object, Serializable>>();
        for (RelationshipUpdateKey relationshipUpdateKey : this.pendingRelationshipInserts.keySet()) {
            PersistentEntity entity = relationshipUpdateKey.association.getOwner();
            if (!inserts.containsKey(entity)) continue;
            this.processInsertsForEntity(neo4jTransaction, (GraphPersistentEntity)entity, inserts, cascadingOperations);
        }
        Set<PersistentEntity> entities = inserts.keySet();
        for (PersistentEntity entity : entities) {
            this.processInsertsForEntity(neo4jTransaction, (GraphPersistentEntity)entity, inserts, cascadingOperations);
        }
        this.executePendings(cascadingOperations);
    }

    private void processInsertsForEntity(org.neo4j.driver.v1.Transaction neo4jTransaction, GraphPersistentEntity entity, Map<PersistentEntity, Collection<PendingInsert>> inserts, List<PendingOperation<Object, Serializable>> cascadingOperations) {
        Collection<PendingInsert> entityInserts = inserts.get((Object)entity);
        boolean hasDynamicLabels = entity.hasDynamicLabels();
        EntityReflector reflector = entity.getReflector();
        Neo4jMappingContext mappingContext = this.getMappingContext();
        if (!entityInserts.isEmpty()) {
            if (hasDynamicLabels) {
                this.buildAndExecuteCreateStatement(entityInserts, entity, cascadingOperations);
            } else {
                StringBuilder batchCypher = new StringBuilder();
                HashMap<String, Object> params = new HashMap<String, Object>(inserts.size());
                LinkedHashMap<String, String> associationMerges = new LinkedHashMap<String, String>();
                batchCypher.append(entity.getBatchCreateStatement());
                ArrayList rows = new ArrayList();
                for (PendingInsert entityInsert : entityInserts) {
                    EntityAccess entityAccess = entityInsert.getEntityAccess();
                    if (entityInsert.wasExecuted()) {
                        this.processPendingRelationshipUpdates(entity, entityAccess, (Serializable)entityInsert.getNativeKey(), cascadingOperations, false);
                        cascadingOperations.addAll(entityInsert.getCascadeOperations());
                        continue;
                    }
                    if (this.isVetoedAfterPreOperations(entityInsert)) continue;
                    if (entity.isRelationshipEntity()) {
                        RelationshipPersistentEntity relEntity = (RelationshipPersistentEntity)entity;
                        Relationship relationship = (Relationship)entityAccess.getEntity();
                        Object type = entityAccess.getProperty("type");
                        if (relEntity.type().equals(type)) {
                            RelationshipUpdateKey updateKey;
                            Collection childIds;
                            Object from = entityAccess.getPropertyValue("from");
                            Serializable id = null;
                            if (from != null) {
                                id = relEntity.getFromEntity().getReflector().getIdentifier(from);
                            }
                            if (id == null || (childIds = (Collection)this.pendingRelationshipInserts.get(updateKey = new RelationshipUpdateKey(id, relEntity.getFrom()))) == null) continue;
                            this.pendingRelationshipInserts.remove(updateKey);
                            LinkedHashMap<String, Object> rowData = new LinkedHashMap<String, Object>();
                            LinkedHashMap<String, Object> nodeProperties = new LinkedHashMap<String, Object>();
                            for (PersistentProperty pp : relEntity.getPersistentProperties()) {
                                Object v;
                                String propertyName;
                                if (!(pp instanceof Simple) && !(pp instanceof Basic) && !(pp instanceof TenantId) || "type".equals(propertyName = pp.getName()) || (v = reflector.getProperty((Object)relationship, propertyName)) == null) continue;
                                nodeProperties.put(propertyName, mappingContext.convertToNative(v));
                            }
                            nodeProperties.putAll(relationship.attributes());
                            rowData.put("props", nodeProperties);
                            rowData.put("from", id);
                            rowData.put("to", childIds);
                            rows.add(rowData);
                            continue;
                        }
                        this.processPendingRelationshipUpdates(entity, entityAccess, (Serializable)entityInsert.getNativeKey(), cascadingOperations, false);
                        continue;
                    }
                    Object parentId = entityAccess.getIdentifier();
                    if (parentId != null) {
                        Map<String, Object> nodeProperties = this.readNodePropertiesForInsert(entityInsert, entity, entity.getPersistentProperties(), entityAccess);
                        Object obj = entityInsert.getObject();
                        Map<String, List<Object>> dynamicRelProps = this.amendMapWithUndeclaredProperties(entity, nodeProperties, obj, (MappingContext)this.getMappingContext());
                        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
                        data.put("props", nodeProperties);
                        rows.add(data);
                        for (Association association : entity.getAssociations()) {
                            RelationshipUpdateKey key;
                            Collection childIds;
                            if (association.isBasic()) continue;
                            boolean isTree = association.isCircular();
                            if (!association.isOwningSide() && !isTree || (childIds = (Collection)this.pendingRelationshipInserts.get(key = new RelationshipUpdateKey((Serializable)parentId, association))) == null) continue;
                            GraphPersistentEntity associatedEntity = (GraphPersistentEntity)association.getAssociatedEntity();
                            String associationName = association.getName();
                            Collection<PendingInsert> pendingInserts = inserts.get((Object)associatedEntity);
                            if (pendingInserts == null) continue;
                            ArrayList<Map<String, Map<String, Object>>> childRows = new ArrayList<Map<String, Map<String, Object>>>();
                            for (PendingInsert pendingInsert : pendingInserts) {
                                boolean wasExecutedBeforeHand;
                                Serializable childId = (Serializable)pendingInsert.getNativeKey();
                                if (!childIds.contains(childId) || (wasExecutedBeforeHand = pendingInsert.wasExecuted()) || this.isVetoedAfterPreOperations(pendingInsert)) continue;
                                childIds.remove(childId);
                                Map<String, Object> childProperties = this.readNodePropertiesForInsert(pendingInsert, associatedEntity, associatedEntity.getPersistentProperties(), pendingInsert.getEntityAccess());
                                childRows.add(Collections.singletonMap("props", childProperties));
                                cascadingOperations.addAll(pendingInsert.getCascadeOperations());
                            }
                            if (childRows.isEmpty()) continue;
                            String parentVariable = entity.getVariableId();
                            associationMerges.put(associationName, associatedEntity.formatBatchCreate(parentVariable, association));
                            data.put(associationName, childRows);
                        }
                        this.processDynamicAssociationsIfNecessary(entity, entityAccess, obj, entityInsert, cascadingOperations, params, dynamicRelProps);
                        params.remove("org.grails.neo4j.DYNAMIC_ASSOCIATIONS");
                    }
                    cascadingOperations.addAll(entityInsert.getCascadeOperations());
                }
                params.put(entity.getBatchId(), rows);
                if (!associationMerges.isEmpty()) {
                    for (String merge : associationMerges.keySet()) {
                        batchCypher.append((String)associationMerges.get(merge));
                    }
                }
                if (batchCypher.length() > 0 && !rows.isEmpty()) {
                    String finalCypher = batchCypher.toString();
                    if (log.isDebugEnabled()) {
                        log.debug("CREATE Cypher [{}] for parameters [{}]", (Object)finalCypher, params);
                    }
                    neo4jTransaction.run(finalCypher, params);
                }
            }
        }
    }

    private boolean isVetoedAfterPreOperations(PendingInsert entityInsert) {
        List preOperations = entityInsert.getPreOperations();
        for (PendingOperation preOperation : preOperations) {
            preOperation.run();
        }
        entityInsert.run();
        ((PendingOperationAdapter)entityInsert).setExecuted(true);
        return entityInsert.isVetoed();
    }

    private void buildAndExecuteCreateStatement(Collection<PendingInsert> entityInserts, GraphPersistentEntity graphEntity, List<PendingOperation<Object, Serializable>> cascadingOperations) {
        HashMap<String, Object> createParams = new HashMap<String, Object>(entityInserts.size());
        String finalCypher = this.buildCypherCreateStatement(entityInserts, graphEntity, cascadingOperations, createParams);
        if (graphEntity.hasDynamicAssociations()) {
            createParams.remove("org.grails.neo4j.DYNAMIC_ASSOCIATIONS");
        }
        if (finalCypher.length() > 0) {
            if (log.isDebugEnabled()) {
                log.debug("CREATE Cypher [{}] for parameters [{}]", (Object)finalCypher, createParams);
            }
            this.getTransaction().getNativeTransaction().run(finalCypher, createParams);
        }
    }

    private String buildCypherCreateStatement(Collection<PendingInsert> entityInserts, GraphPersistentEntity graphEntity, List<PendingOperation<Object, Serializable>> cascadingOperations, Map<String, Object> createParams) {
        StringBuilder createCypher = new StringBuilder();
        int i = 0;
        boolean first = true;
        for (PendingInsert entityInsert : entityInserts) {
            if (entityInsert.wasExecuted() || graphEntity.isRelationshipEntity()) {
                this.processPendingRelationshipUpdates(graphEntity, entityInsert.getEntityAccess(), (Serializable)entityInsert.getNativeKey(), cascadingOperations, false);
                cascadingOperations.addAll(entityInsert.getCascadeOperations());
                continue;
            }
            List preOperations = entityInsert.getPreOperations();
            for (PendingOperation preOperation : preOperations) {
                preOperation.run();
            }
            entityInsert.run();
            ((PendingOperationAdapter)entityInsert).setExecuted(true);
            if (entityInsert.isVetoed()) continue;
            cascadingOperations.addAll(entityInsert.getCascadeOperations());
            ++i;
            if (!first) {
                createCypher.append(',');
                createCypher.append('\n');
            } else {
                createCypher.append("CREATE ");
                first = false;
            }
            this.buildEntityCreateOperation(createCypher, String.valueOf(i), (PersistentEntity)graphEntity, entityInsert, createParams, cascadingOperations);
        }
        return createCypher.toString();
    }

    public String buildEntityCreateOperation(PersistentEntity entity, PendingInsert entityInsert, Map<String, Object> params, List<PendingOperation<Object, Serializable>> cascadingOperations) {
        StringBuilder createCypher = new StringBuilder("CREATE ");
        this.buildEntityCreateOperation(createCypher, "", entity, entityInsert, params, cascadingOperations);
        return createCypher.toString();
    }

    public void buildEntityCreateOperation(StringBuilder createCypher, String index, PersistentEntity entity, PendingInsert entityInsert, Map<String, Object> params, List<PendingOperation<Object, Serializable>> cascadingOperations) {
        GraphPersistentEntity graphEntity = (GraphPersistentEntity)entity;
        List persistentProperties = entity.getPersistentProperties();
        Object obj = entityInsert.getObject();
        EntityAccess access = entityInsert.getEntityAccess();
        Map<String, Object> simpleProps = this.readNodePropertiesForInsert(entityInsert, graphEntity, persistentProperties, access);
        Map<String, List<Object>> dynamicRelProps = this.amendMapWithUndeclaredProperties(graphEntity, simpleProps, obj, (MappingContext)this.getMappingContext());
        String labels = graphEntity.getLabelsWithInheritance(obj);
        String cypher = String.format("(n" + index + "%s {props" + index + "})", labels);
        createCypher.append(cypher);
        params.put("props" + index, simpleProps);
        this.processDynamicAssociationsIfNecessary(graphEntity, access, obj, entityInsert, cascadingOperations, params, dynamicRelProps);
    }

    private void processDynamicAssociationsIfNecessary(GraphPersistentEntity graphEntity, EntityAccess access, Object obj, PendingInsert entityInsert, List<PendingOperation<Object, Serializable>> cascadingOperations, Map<String, Object> params, Map<String, List<Object>> dynamicRelProps) {
        boolean hasDynamicAssociations = graphEntity.hasDynamicAssociations();
        Serializable parentId = (Serializable)entityInsert.getNativeKey();
        if (parentId != null) {
            this.processPendingRelationshipUpdates(graphEntity, access, parentId, cascadingOperations, false);
        }
        if (hasDynamicAssociations) {
            this.getEntityPersister(obj).processDynamicAssociations(graphEntity, access, this.getMappingContext(), dynamicRelProps, cascadingOperations, false);
            params.put("org.grails.neo4j.DYNAMIC_ASSOCIATIONS", dynamicRelProps);
        }
    }

    private Map<String, Object> readNodePropertiesForInsert(PendingInsert entityInsert, GraphPersistentEntity graphEntity, List<PersistentProperty> persistentProperties, EntityAccess access) {
        HashMap<String, Object> simpleProps = new HashMap<String, Object>(persistentProperties.size());
        Serializable id = (Serializable)entityInsert.getNativeKey();
        if (!graphEntity.isNativeId()) {
            if (graphEntity.getIdGeneratorType().equals((Object)IdGenerator.Type.SNOWFLAKE)) {
                simpleProps.put("__id__", id);
            } else {
                simpleProps.put(graphEntity.getIdentity().getName(), id);
            }
        }
        for (PersistentProperty pp : persistentProperties) {
            if (pp instanceof Simple || pp instanceof TenantId || pp instanceof Basic) {
                String name = pp.getName();
                Object value = access.getProperty(name);
                if (value == null) continue;
                simpleProps.put(name, this.getMappingContext().convertToNative(value));
                continue;
            }
            if (!(pp instanceof Custom)) continue;
            this.applyCustomType(access, pp, simpleProps);
        }
        return simpleProps;
    }

    private void applyCustomType(EntityAccess access, PersistentProperty property, Map<String, Object> simpleProps) {
        Custom custom = (Custom)property;
        CustomTypeMarshaller customTypeMarshaller = custom.getCustomTypeMarshaller();
        Object value = access.getProperty(property.getName());
        customTypeMarshaller.write((PersistentProperty)custom, value, simpleProps);
    }

    public Neo4jMappingContext getMappingContext() {
        return (Neo4jMappingContext)super.getMappingContext();
    }

    protected void flushPendingDeletes(Map<PersistentEntity, Collection<PendingDelete>> pendingDeletes) {
        Set<PersistentEntity> persistentEntities = pendingDeletes.keySet();
        for (PersistentEntity entity : persistentEntities) {
            Collection<PendingDelete> deletes = pendingDeletes.get(entity);
            ArrayList<Object> ids = new ArrayList<Object>();
            ArrayList cascadingOperations = new ArrayList();
            for (PendingDelete delete : deletes) {
                List preOperations = delete.getPreOperations();
                for (PendingOperation preOperation : preOperations) {
                    preOperation.run();
                }
                delete.run();
                if (delete.isVetoed()) continue;
                Object id = delete.getNativeKey();
                ids.add(id);
                cascadingOperations.addAll(delete.getCascadeOperations());
            }
            Neo4jQuery deleteQuery = new Neo4jQuery(this, entity, this.getEntityPersister(entity.getJavaClass()));
            deleteQuery.add((Query.Criterion)Restrictions.in((String)"id", ids));
            CypherBuilder cypherBuilder = deleteQuery.getBaseQuery();
            this.buildCascadingDeletes(entity, cypherBuilder);
            String cypher = cypherBuilder.build();
            Map<String, Object> idMap = cypherBuilder.getParams();
            if (log.isDebugEnabled()) {
                log.debug("DELETE Cypher [{}] for parameters {}", (Object)cypher, idMap);
            }
            this.getTransaction().getNativeTransaction().run(cypher, idMap);
            this.executePendings(cascadingOperations);
        }
    }

    protected Map<String, List<Object>> amendMapWithUndeclaredProperties(GraphPersistentEntity graphEntity, Map<String, Object> simpleProps, Object pojo, MappingContext mappingContext) {
        Map map;
        LinkedHashMap<String, List<Object>> dynRelProps;
        boolean hasDynamicAssociations = graphEntity.hasDynamicAssociations();
        LinkedHashMap<String, List<Object>> linkedHashMap = dynRelProps = hasDynamicAssociations ? new LinkedHashMap<String, List<Object>>() : Collections.emptyMap();
        if (pojo instanceof DynamicAttributes && (map = ((DynamicAttributes)pojo).attributes()) != null) {
            for (Map.Entry entry : map.entrySet()) {
                Object value = entry.getValue();
                String key = (String)entry.getKey();
                if (value == null) {
                    simpleProps.put(key, value);
                    continue;
                }
                if (hasDynamicAssociations) {
                    List<Object> objects;
                    if (mappingContext.isPersistentEntity(value)) {
                        objects = this.getOrInit(dynRelProps, key);
                        objects.add(value);
                        continue;
                    }
                    if (Neo4jSession.isCollectionWithPersistentEntities(value, mappingContext)) {
                        objects = this.getOrInit(dynRelProps, key);
                        objects.addAll((Collection)value);
                        continue;
                    }
                    if (!((DirtyCheckable)pojo).hasChanged(key)) continue;
                    simpleProps.put(key, ((Neo4jMappingContext)mappingContext).convertToNative(value));
                    continue;
                }
                if (!((DirtyCheckable)pojo).hasChanged(key)) continue;
                simpleProps.put(key, ((Neo4jMappingContext)mappingContext).convertToNative(value));
            }
        }
        return dynRelProps;
    }

    private List<Object> getOrInit(Map<String, List<Object>> dynRelProps, String key) {
        List<Object> objects = dynRelProps.get(key);
        if (objects == null) {
            objects = new ArrayList<Object>();
            dynRelProps.put(key, objects);
        }
        return objects;
    }

    public static boolean isCollectionWithPersistentEntities(Object o, MappingContext mappingContext) {
        if (!(o instanceof Collection)) {
            return false;
        }
        Collection c = (Collection)o;
        for (Object obj : c) {
            if (!mappingContext.isPersistentEntity(obj)) continue;
            return true;
        }
        return false;
    }

    public void flush() {
        if (this.wasTransactionTerminated()) {
            return;
        }
        Neo4jTransaction transaction = (Neo4jTransaction)this.transaction;
        if (transaction != null) {
            if (transaction.getTransactionDefinition().isReadOnly()) {
                return;
            }
        } else {
            throw new NoTransactionException("Cannot flush write operations without an active transaction!");
        }
        this.persistDirtyButUnsavedInstances();
        super.flush();
    }

    public Neo4jTransaction getTransaction() {
        return (Neo4jTransaction)super.getTransaction();
    }

    protected boolean wasTransactionTerminated() {
        return this.transaction != null && !this.transaction.isActive();
    }

    protected void postFlush(boolean hasUpdates) {
        super.postFlush(hasUpdates);
        if (this.publisher != null) {
            this.publisher.publishEvent((ApplicationEvent)new SessionFlushedEvent((Session)this));
        }
    }

    public Neo4jTransaction assertTransaction() {
        if (this.transaction == null || this.wasTransactionTerminated() && !TransactionSynchronizationManager.isSynchronizationActive()) {
            SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.getDatastore());
            if (sessionHolder != null && sessionHolder.getSession().equals((Object)this)) {
                Transaction transaction = sessionHolder.getTransaction();
                if (transaction instanceof Neo4jTransaction) {
                    this.transaction = transaction;
                    return (Neo4jTransaction)transaction;
                }
                this.startDefaultTransaction();
            } else {
                this.startDefaultTransaction();
            }
        }
        return (Neo4jTransaction)this.transaction;
    }

    public boolean hasTransaction() {
        return super.hasTransaction() && this.transaction.isActive();
    }

    private void startDefaultTransaction() {
        DefaultTransactionDefinition transactionDefinition = this.createDefaultTransactionDefinition(null);
        this.transaction = new Neo4jTransaction(this.boltDriver, (TransactionDefinition)transactionDefinition, true);
    }

    protected DefaultTransactionDefinition createDefaultTransactionDefinition(TransactionDefinition other) {
        DefaultTransactionDefinition transactionDefinition = other != null ? new DefaultTransactionDefinition(other) : new DefaultTransactionDefinition();
        transactionDefinition.setName("Neo4j Transaction");
        return transactionDefinition;
    }

    private void persistDirtyButUnsavedInstances() {
        for (Map cache : this.firstLevelCache.values()) {
            for (Object obj : cache.values()) {
                boolean isDirty;
                if (!(obj instanceof DirtyCheckable) || !(isDirty = ((DirtyCheckable)obj).hasChanged()) || this.isPendingAlready(obj)) continue;
                this.persist(obj);
            }
        }
    }

    public long deleteAll(QueryableCriteria criteria) {
        PersistentEntity entity = criteria.getPersistentEntity();
        List criteriaList = criteria.getCriteria();
        Neo4jQuery query = new Neo4jQuery(this, entity, this.getEntityPersister(entity.getJavaClass()));
        for (Query.Criterion criterion : criteriaList) {
            query.add(criterion);
        }
        query.projections().count();
        CypherBuilder baseQuery = query.getBaseQuery();
        this.buildCascadingDeletes(entity, baseQuery);
        String cypher = baseQuery.build();
        Map<String, Object> params = baseQuery.getParams();
        if (log.isDebugEnabled()) {
            log.debug("DELETE Cypher [{}] for parameters [{}]", (Object)cypher, params);
        }
        Number count = (Number)query.singleResult();
        this.getTransaction().getNativeTransaction().run(cypher, params);
        return count.longValue();
    }

    protected void buildCascadingDeletes(PersistentEntity entity, CypherBuilder baseQuery) {
        if (entity instanceof RelationshipPersistentEntity) {
            baseQuery.addDeleteColumn("r");
        } else {
            int i = 1;
            for (Association association : entity.getAssociations()) {
                if (association instanceof Basic || !association.doesCascade(CascadeType.REMOVE)) continue;
                String a = "a" + i++;
                baseQuery.addOptionalMatch("(n)" + RelationshipUtils.matchForAssociation(association) + "(" + a + ")");
                baseQuery.addDeleteColumn(a);
            }
            baseQuery.addDeleteColumn("n");
        }
    }

    public long updateAll(QueryableCriteria criteria, Map<String, Object> properties) {
        PersistentEntity entity = criteria.getPersistentEntity();
        List criteriaList = criteria.getCriteria();
        Neo4jQuery query = new Neo4jQuery(this, entity, this.getEntityPersister(entity.getJavaClass()));
        for (Query.Criterion criterion : criteriaList) {
            query.add(criterion);
        }
        query.projections().count();
        CypherBuilder baseQuery = query.getBaseQuery();
        baseQuery.addPropertySet(properties);
        String cypher = baseQuery.build();
        Map<String, Object> params = baseQuery.getParams();
        if (log.isDebugEnabled()) {
            log.debug("UPDATE Cypher [{}] for parameters [{}]", (Object)cypher, params);
        }
        StatementResult execute = this.getTransaction().getNativeTransaction().run(cypher, params);
        return Neo4jEntityPersister.countUpdates(execute);
    }

    private static class RelationshipUpdateKey {
        private final Serializable id;
        private final Association association;

        public RelationshipUpdateKey(Serializable id, Association association) {
            this.id = id;
            this.association = association;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RelationshipUpdateKey that = (RelationshipUpdateKey)o;
            if (this.association != null ? !this.association.equals(that.association) : that.association != null) {
                return false;
            }
            return !(this.id == null ? that.id != null : !this.id.equals(that.id));
        }

        public int hashCode() {
            int result = this.association != null ? this.association.hashCode() : 0;
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            return result;
        }
    }
}

