/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j.engine;

import grails.neo4j.Relationship;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.grails.datastore.gorm.neo4j.CypherBuilder;
import org.grails.datastore.gorm.neo4j.GraphPersistentEntity;
import org.grails.datastore.gorm.neo4j.Neo4jMappingContext;
import org.grails.datastore.gorm.neo4j.Neo4jSession;
import org.grails.datastore.gorm.neo4j.RelationshipUtils;
import org.grails.datastore.gorm.neo4j.engine.Neo4jEntityPersister;
import org.grails.datastore.gorm.neo4j.mapping.config.DynamicAssociation;
import org.grails.datastore.gorm.neo4j.mapping.config.DynamicToOneAssociation;
import org.grails.datastore.mapping.core.impl.PendingInsertAdapter;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.Basic;
import org.grails.datastore.mapping.model.types.OneToMany;
import org.grails.datastore.mapping.model.types.OneToOne;
import org.grails.datastore.mapping.model.types.Simple;
import org.grails.datastore.mapping.model.types.TenantId;
import org.grails.datastore.mapping.reflect.EntityReflector;
import org.neo4j.driver.v1.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipPendingInsert
extends PendingInsertAdapter<Object, Serializable> {
    public static final String FROM = "from";
    public static final String TO = "to";
    public static final String SOURCE_TYPE = "sourceType";
    public static final String TARGET_TYPE = "targetType";
    private static Logger log = LoggerFactory.getLogger(RelationshipPendingInsert.class);
    private final Transaction boltTransaction;
    private final Association association;
    private final Collection<Serializable> targetIdentifiers;
    private final boolean isUpdate;
    private final Neo4jSession session;

    public RelationshipPendingInsert(EntityAccess parent, Association association, Collection<Serializable> pendingInserts, Neo4jSession session, boolean isUpdate) {
        super(parent.getPersistentEntity(), (Object)-1L, parent.getEntity(), parent);
        this.boltTransaction = session.getTransaction().getTransaction();
        this.session = session;
        this.targetIdentifiers = pendingInserts;
        this.association = association;
        this.isUpdate = isUpdate;
    }

    public void run() {
        String relMatch;
        LinkedHashMap<String, String> attrs;
        GraphPersistentEntity graphParent = (GraphPersistentEntity)this.getEntity();
        GraphPersistentEntity graphChild = (GraphPersistentEntity)this.association.getAssociatedEntity();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(2);
        EntityAccess entityAccess = this.getEntityAccess();
        Object parentId = entityAccess.getIdentifier();
        boolean isRelationshipAssociation = Relationship.class.isAssignableFrom(graphParent.getJavaClass());
        if (isRelationshipAssociation) {
            if (this.association.getName().equals(FROM)) {
                Association endProperty = (Association)graphParent.getPropertyByName(TO);
                Association startProperty = (Association)graphParent.getPropertyByName(FROM);
                graphChild = (GraphPersistentEntity)endProperty.getAssociatedEntity();
                graphParent = (GraphPersistentEntity)startProperty.getAssociatedEntity();
                Object endEntity = entityAccess.getProperty(TO);
                Object startEntity = entityAccess.getProperty(FROM);
                parentId = graphParent.getReflector().getIdentifier(startEntity);
                this.targetIdentifiers.clear();
                this.targetIdentifiers.add(graphChild.getReflector().getIdentifier(endEntity));
            } else {
                return;
            }
        }
        params.put("start", parentId);
        params.put("end", this.targetIdentifiers);
        String labelsFrom = graphParent.getLabelsAsString();
        String labelsTo = graphChild.getLabelsAsString();
        if (this.association instanceof DynamicToOneAssociation) {
            attrs = new LinkedHashMap<String, String>();
            attrs.put(SOURCE_TYPE, graphParent.getJavaClass().getSimpleName());
            attrs.put(TARGET_TYPE, graphChild.getJavaClass().getSimpleName());
            relMatch = RelationshipUtils.matchForAssociation(this.association, "r", attrs);
        } else if (isRelationshipAssociation) {
            attrs = new LinkedHashMap();
            GraphPersistentEntity relEntity = (GraphPersistentEntity)this.getEntity();
            EntityReflector reflector = relEntity.getReflector();
            Neo4jMappingContext mappingContext = (Neo4jMappingContext)relEntity.getMappingContext();
            Neo4jEntityPersister entityPersister = this.session.getEntityPersister(this.getEntityAccess().getEntity());
            if (entityPersister.cancelInsert(this.entity, this.getEntityAccess())) {
                return;
            }
            for (PersistentProperty pp : relEntity.getPersistentProperties()) {
                Object v;
                String propertyName;
                if (!(pp instanceof Simple) && !(pp instanceof Basic) && !(pp instanceof TenantId) || "type".equals(propertyName = pp.getName()) || (v = reflector.getProperty(this.getNativeEntry(), propertyName)) == null) continue;
                attrs.put(propertyName, (String)mappingContext.convertToNative(v));
            }
            Relationship relationship = (Relationship)this.getEntityAccess().getEntity();
            attrs.putAll(relationship.attributes());
            params.put("rProps", attrs);
            relMatch = RelationshipUtils.toMatch(this.association, relationship);
        } else {
            relMatch = RelationshipUtils.matchForAssociation(this.association, "r");
        }
        if (this.isUpdate && (this.association instanceof DynamicAssociation || (this.association.isBidirectional() && this.association instanceof OneToMany || this.association instanceof OneToOne) && !RelationshipUtils.useReversedMappingFor(this.association))) {
            Map<String, Collection<Object>> deleteParams;
            StringBuilder cypher = new StringBuilder(CypherBuilder.buildRelationshipMatch(labelsFrom, relMatch, labelsTo));
            if (this.association instanceof DynamicToOneAssociation || this.association instanceof OneToOne) {
                cypher.append(graphChild.formatId(FROM));
                deleteParams = Collections.singletonMap("start", Collections.singletonList(parentId));
            } else {
                cypher.append(graphChild.formatId(TO));
                deleteParams = Collections.singletonMap("start", this.targetIdentifiers);
            }
            cypher.append(" IN {start} DELETE r");
            if (log.isDebugEnabled()) {
                log.debug("DELETE Cypher [{}] for parameters [{}]", (Object)cypher, deleteParams);
            }
            this.boltTransaction.run(cypher.toString(), deleteParams);
        }
        StringBuilder cypherQuery = new StringBuilder(String.format("MATCH (from%s),(to%s) WHERE ", labelsFrom, labelsTo));
        cypherQuery.append(graphParent.formatId(FROM)).append(" = {start} AND ").append(graphChild.formatId(TO)).append(" IN {end} MERGE (from)").append(relMatch).append("(to)");
        if (isRelationshipAssociation) {
            cypherQuery.append(" ON CREATE SET r={rProps}");
        }
        String cypher = cypherQuery.toString();
        if (log.isDebugEnabled()) {
            log.debug("MERGE Cypher [{}] for parameters [{}]", (Object)cypher, params);
        }
        this.boltTransaction.run(cypher, params);
    }
}

