/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.grails.datastore.gorm.neo4j.GraphPersistentEntity;
import org.grails.datastore.gorm.neo4j.Neo4jMappingContext;
import org.grails.datastore.gorm.neo4j.Neo4jSession;
import org.grails.datastore.gorm.neo4j.TypeDirectionPair;
import org.grails.datastore.gorm.neo4j.collection.Neo4jList;
import org.grails.datastore.gorm.neo4j.mapping.config.DynamicToManyAssociation;
import org.grails.datastore.gorm.neo4j.mapping.reflect.Neo4jNameUtils;
import org.grails.datastore.gorm.neo4j.util.IteratorUtil;
import org.grails.datastore.gorm.schemaless.DynamicAttributes;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.types.Association;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.StatementRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicAssociationSupport {
    private static final Logger log = LoggerFactory.getLogger(DynamicAssociationSupport.class);

    public static Map<TypeDirectionPair, Map<String, Object>> loadDynamicAssociations(Neo4jSession session, GraphPersistentEntity graphPersistentEntity, DynamicAttributes object, Serializable id) {
        HashMap<TypeDirectionPair, Map<String, Object>> relationshipsMap = new HashMap<TypeDirectionPair, Map<String, Object>>();
        boolean hasDynamicAssociations = graphPersistentEntity.hasDynamicAssociations();
        Object alreadyLoaded = session.getAttribute(object, "org.grails.neo4j.DYNAMIC_ASSOCIATIONS");
        if (alreadyLoaded == null && hasDynamicAssociations) {
            TypeDirectionPair key;
            session.setAttribute(object, "org.grails.neo4j.DYNAMIC_ASSOCIATIONS", Boolean.TRUE);
            String cypher = graphPersistentEntity.formatDynamicAssociationQuery();
            Map<String, Serializable> isMap = Collections.singletonMap("id", id);
            StatementRunner boltSession = (StatementRunner)(session.hasTransaction() ? session.getTransaction().getNativeTransaction() : session.getNativeInterface());
            if (log.isDebugEnabled()) {
                log.debug("QUERY Cypher [{}] for parameters [{}]", (Object)cypher, isMap);
            }
            StatementResult relationships = boltSession.run(cypher, isMap);
            while (relationships.hasNext()) {
                Record row = relationships.next();
                String relType = row.get("relType").asString();
                Boolean outGoing = row.get("out").asBoolean();
                Map values = row.get("values").asMap();
                key = new TypeDirectionPair(relType, outGoing);
                if (!row.containsKey("targetType") || row.get("targetType").isNull()) continue;
                key.setTargetType(row.get("targetType").asString());
                relationshipsMap.put(key, values);
            }
            if (!relationshipsMap.isEmpty()) {
                Neo4jMappingContext mappingContext = session.getMappingContext();
                for (Map.Entry entry : relationshipsMap.entrySet()) {
                    Object value;
                    EntityAccess entityAccess = session.createEntityAccess((PersistentEntity)graphPersistentEntity, object);
                    key = (TypeDirectionPair)entry.getKey();
                    if (!key.isOutgoing()) continue;
                    Map relationshipData = (Map)entry.getValue();
                    Object idsObject = relationshipData.get("ids");
                    Object labelsObject = relationshipData.get("labels");
                    if (!(idsObject instanceof Iterable) || !(labelsObject instanceof Iterable)) continue;
                    Iterator idIter = ((Iterable)idsObject).iterator();
                    String targetType = key.getTargetType();
                    Iterator labelIter = ((Iterable)labelsObject).iterator();
                    ArrayList<Object> values = new ArrayList<Object>();
                    GraphPersistentEntity associatedEntity = null;
                    while (idIter.hasNext() && labelIter.hasNext()) {
                        Serializable targetId = (Serializable)idIter.next();
                        List<String> nextLabels = (List<String>)labelIter.next();
                        List<String> labels = nextLabels.isEmpty() ? Collections.singletonList(targetType) : nextLabels;
                        associatedEntity = mappingContext.findPersistentEntityForLabels(labels);
                        if (associatedEntity == null) {
                            associatedEntity = mappingContext.findPersistentEntityForLabels(Collections.singletonList(targetType));
                        }
                        if (associatedEntity == null) continue;
                        Object proxy = mappingContext.getProxyFactory().createProxy((Session)session, associatedEntity.getJavaClass(), targetId);
                        values.add(proxy);
                    }
                    if (values.size() == 1 && DynamicAssociationSupport.isSingular(key.getType())) {
                        value = IteratorUtil.singleOrNull(values);
                    } else {
                        DynamicToManyAssociation dynamicAssociation = new DynamicToManyAssociation((PersistentEntity)graphPersistentEntity, graphPersistentEntity.getMappingContext(), key.getType(), (PersistentEntity)associatedEntity);
                        value = new Neo4jList(entityAccess, (Association)dynamicAssociation, values, session);
                    }
                    object.attributes().put(key.getType(), value);
                }
            }
        }
        return relationshipsMap;
    }

    private static boolean isSingular(String key) {
        return Neo4jNameUtils.isSingular(key);
    }
}

