/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j.connections;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import org.grails.datastore.gorm.neo4j.connections.Neo4jConnectionSourceSettings;
import org.grails.datastore.gorm.neo4j.connections.Neo4jConnectionSourceSettingsBuilder;
import org.grails.datastore.gorm.neo4j.connections.Neo4jEmbeddedConnectionSource;
import org.grails.datastore.gorm.neo4j.util.EmbeddedNeo4jServer;
import org.grails.datastore.mapping.core.connections.AbstractConnectionSourceFactory;
import org.grails.datastore.mapping.core.connections.ConnectionSource;
import org.grails.datastore.mapping.core.connections.ConnectionSourceSettings;
import org.grails.datastore.mapping.core.connections.DefaultConnectionSource;
import org.grails.datastore.mapping.model.DatastoreConfigurationException;
import org.grails.datastore.mapping.reflect.ClassUtils;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.harness.ServerControls;
import org.springframework.core.env.PropertyResolver;

public class Neo4jConnectionSourceFactory
extends AbstractConnectionSourceFactory<Driver, Neo4jConnectionSourceSettings> {
    protected <F extends ConnectionSourceSettings> Neo4jConnectionSourceSettings buildSettings(String name, PropertyResolver configuration, F fallbackSettings, boolean isDefaultDataSource) {
        String prefix = isDefaultDataSource ? "grails.neo4j" : "grails.neo4j.connections." + name;
        Neo4jConnectionSourceSettingsBuilder settingsBuilder = new Neo4jConnectionSourceSettingsBuilder(configuration, prefix, fallbackSettings);
        Neo4jConnectionSourceSettings settings = (Neo4jConnectionSourceSettings)settingsBuilder.build();
        return settings;
    }

    public ConnectionSource<Driver, Neo4jConnectionSourceSettings> create(String name, Neo4jConnectionSourceSettings settings) {
        String url = settings.getUrl();
        String username = settings.getUsername();
        String password = settings.getPassword();
        Neo4jConnectionSourceSettings.ConnectionType type = settings.getType();
        if (type == Neo4jConnectionSourceSettings.ConnectionType.embedded && "DEFAULT".equals(name)) {
            if (Neo4jConnectionSourceFactory.isEmbeddedAvailable()) {
                File dataDir;
                Neo4jConnectionSourceSettings.EmbeddedSettings embeddedSettings = settings.getEmbedded();
                String location = settings.getLocation() != null ? settings.getLocation() : embeddedSettings.getDirectory();
                Map options = embeddedSettings.getOptions();
                try {
                    dataDir = location != null ? new File(location) : (embeddedSettings.isEphemeral() ? File.createTempFile("neo4j-temporary-data", "-tempdir") : new File("data/neo4j"));
                }
                catch (IOException e) {
                    throw new DatastoreConfigurationException("Unable to create temporary data directory: " + e.getMessage(), (Throwable)e);
                }
                if (embeddedSettings.isDropData() || embeddedSettings.isEphemeral()) {
                    dataDir.delete();
                }
                if (embeddedSettings.isEphemeral()) {
                    dataDir.deleteOnExit();
                }
                try {
                    ServerControls serverControls = url != null ? EmbeddedNeo4jServer.start(url, dataDir, (Map<String, Object>)options) : EmbeddedNeo4jServer.start(dataDir, options);
                    Config config = Config.build().withEncryptionLevel(Config.EncryptionLevel.NONE).toConfig();
                    URI boltURI = serverControls.boltURI();
                    Driver driver = GraphDatabase.driver((URI)boltURI, (Config)config);
                    return new Neo4jEmbeddedConnectionSource(name, driver, settings, serverControls);
                }
                catch (Throwable e) {
                    throw new DatastoreConfigurationException("Unable to start embedded Neo4j server: " + e.getMessage(), e);
                }
            }
            throw new DatastoreConfigurationException("Embedded Neo4j server was configured but 'neo4j-harness' classes not found on classpath.");
        }
        AuthToken authToken = null;
        if (username != null && password != null) {
            authToken = AuthTokens.basic((String)username, (String)password);
        }
        Config driverConfig = (Config)settings.getOptions().build();
        Driver driver = GraphDatabase.driver((String)(url != null ? url : "bolt://localhost:7687"), (AuthToken)authToken, (Config)driverConfig);
        return new DefaultConnectionSource(name, (Object)driver, (ConnectionSourceSettings)settings);
    }

    public Serializable getConnectionSourcesConfigurationKey() {
        return "grails.neo4j.connections";
    }

    public static boolean isEmbeddedAvailable() {
        return ClassUtils.isPresent((String)"org.neo4j.harness.ServerControls", (ClassLoader)Neo4jConnectionSourceFactory.class.getClassLoader());
    }
}

