/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j;

import grails.neo4j.Relationship;
import groovy.lang.Closure;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.persistence.FlushModeType;
import org.grails.datastore.gorm.GormEnhancer;
import org.grails.datastore.gorm.GormInstanceApi;
import org.grails.datastore.gorm.GormStaticApi;
import org.grails.datastore.gorm.GormValidationApi;
import org.grails.datastore.gorm.events.AutoTimestampEventListener;
import org.grails.datastore.gorm.events.ConfigurableApplicationEventPublisher;
import org.grails.datastore.gorm.events.DefaultApplicationEventPublisher;
import org.grails.datastore.gorm.events.DomainEventListener;
import org.grails.datastore.gorm.multitenancy.MultiTenantEventListener;
import org.grails.datastore.gorm.neo4j.GraphPersistentEntity;
import org.grails.datastore.gorm.neo4j.IdGenerator;
import org.grails.datastore.gorm.neo4j.Neo4jDatastoreTransactionManager;
import org.grails.datastore.gorm.neo4j.Neo4jMappingContext;
import org.grails.datastore.gorm.neo4j.Neo4jSession;
import org.grails.datastore.gorm.neo4j.api.Neo4jGormStaticApi;
import org.grails.datastore.gorm.neo4j.connections.Neo4jConnectionSourceFactory;
import org.grails.datastore.gorm.neo4j.connections.Neo4jConnectionSourceSettings;
import org.grails.datastore.gorm.neo4j.connections.Neo4jConnectionSourceSettingsBuilder;
import org.grails.datastore.gorm.utils.ClasspathEntityScanner;
import org.grails.datastore.gorm.validation.constraints.MappingContextAwareConstraintFactory;
import org.grails.datastore.gorm.validation.constraints.builtin.UniqueConstraint;
import org.grails.datastore.gorm.validation.constraints.factory.ConstraintFactory;
import org.grails.datastore.gorm.validation.constraints.registry.ConstraintRegistry;
import org.grails.datastore.gorm.validation.registry.support.ValidatorRegistries;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.config.Settings;
import org.grails.datastore.mapping.core.AbstractDatastore;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.DatastoreUtils;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.StatelessDatastore;
import org.grails.datastore.mapping.core.connections.ConnectionSource;
import org.grails.datastore.mapping.core.connections.ConnectionSourceFactory;
import org.grails.datastore.mapping.core.connections.ConnectionSourceSettings;
import org.grails.datastore.mapping.core.connections.ConnectionSources;
import org.grails.datastore.mapping.core.connections.ConnectionSourcesInitializer;
import org.grails.datastore.mapping.core.connections.ConnectionSourcesSupport;
import org.grails.datastore.mapping.core.connections.DefaultConnectionSource;
import org.grails.datastore.mapping.core.connections.InMemoryConnectionSources;
import org.grails.datastore.mapping.core.connections.MultipleConnectionSourceCapableDatastore;
import org.grails.datastore.mapping.core.connections.SingletonConnectionSources;
import org.grails.datastore.mapping.core.exceptions.ConfigurationException;
import org.grails.datastore.mapping.graph.GraphDatastore;
import org.grails.datastore.mapping.model.DatastoreConfigurationException;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Simple;
import org.grails.datastore.mapping.multitenancy.MultiTenancySettings;
import org.grails.datastore.mapping.multitenancy.MultiTenantCapableDatastore;
import org.grails.datastore.mapping.multitenancy.TenantResolver;
import org.grails.datastore.mapping.transactions.TransactionCapableDatastore;
import org.grails.datastore.mapping.validation.ValidatorRegistry;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.exceptions.Neo4jException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.StaticMessageSource;
import org.springframework.core.env.PropertyResolver;
import org.springframework.transaction.PlatformTransactionManager;

public class Neo4jDatastore
extends AbstractDatastore
implements Closeable,
StatelessDatastore,
GraphDatastore,
Settings,
MultipleConnectionSourceCapableDatastore,
MultiTenantCapableDatastore<Driver, Neo4jConnectionSourceSettings>,
MessageSourceAware,
TransactionCapableDatastore {
    private static Logger log = LoggerFactory.getLogger(Neo4jDatastore.class);
    protected boolean skipIndexSetup = false;
    protected final Driver boltDriver;
    protected final FlushModeType defaultFlushMode;
    protected final ConfigurableApplicationEventPublisher eventPublisher;
    protected final Neo4jDatastoreTransactionManager transactionManager;
    protected final GormEnhancer gormEnhancer;
    protected final ConnectionSources<Driver, Neo4jConnectionSourceSettings> connectionSources;
    protected final Map<String, Neo4jDatastore> datastoresByConnectionSource = new LinkedHashMap<String, Neo4jDatastore>();
    protected final TenantResolver tenantResolver;
    protected final MultiTenancySettings.MultiTenancyMode multiTenancyMode;

    public Neo4jDatastore(ConnectionSources<Driver, Neo4jConnectionSourceSettings> connectionSources, Neo4jMappingContext mappingContext, ConfigurableApplicationEventPublisher eventPublisher) {
        super((MappingContext)mappingContext, connectionSources.getBaseConfiguration(), null);
        this.connectionSources = connectionSources;
        ConnectionSource defaultConnectionSource = connectionSources.getDefaultConnectionSource();
        Neo4jConnectionSourceSettings settings = (Neo4jConnectionSourceSettings)defaultConnectionSource.getSettings();
        MultiTenancySettings multiTenancySettings = settings.getMultiTenancy();
        this.boltDriver = (Driver)defaultConnectionSource.getSource();
        this.eventPublisher = eventPublisher;
        this.defaultFlushMode = settings.getFlushMode();
        this.skipIndexSetup = !settings.isBuildIndex();
        this.multiTenancyMode = multiTenancySettings.getMode();
        this.tenantResolver = multiTenancySettings.getTenantResolver();
        if (!this.skipIndexSetup) {
            this.setupIndexing();
        }
        this.transactionManager = new Neo4jDatastoreTransactionManager(this);
        if (!(connectionSources instanceof SingletonConnectionSources)) {
            Iterable allConnectionSources = connectionSources.getAllConnectionSources();
            for (ConnectionSource connectionSource : allConnectionSources) {
                SingletonConnectionSources singletonConnectionSources = new SingletonConnectionSources(connectionSource, connectionSources.getBaseConfiguration());
                Neo4jDatastore childDatastore = "DEFAULT".equals(connectionSource.getName()) ? this : new Neo4jDatastore((ConnectionSources)singletonConnectionSources, mappingContext, eventPublisher){

                    @Override
                    protected GormEnhancer initialize(Neo4jConnectionSourceSettings settings) {
                        return null;
                    }
                };
                this.datastoresByConnectionSource.put(connectionSource.getName(), childDatastore);
            }
        }
        this.gormEnhancer = this.initialize(settings);
    }

    public Neo4jDatastore(ConnectionSources<Driver, Neo4jConnectionSourceSettings> connectionSources, ConfigurableApplicationEventPublisher eventPublisher, Class ... classes) {
        this(connectionSources, Neo4jDatastore.createMappingContext(connectionSources, classes), eventPublisher);
    }

    public Neo4jDatastore(ConnectionSources<Driver, Neo4jConnectionSourceSettings> connectionSources, Class ... classes) {
        this(connectionSources, Neo4jDatastore.createMappingContext(connectionSources, classes), (ConfigurableApplicationEventPublisher)new DefaultApplicationEventPublisher());
    }

    public Neo4jDatastore(Driver boltDriver, PropertyResolver configuration, ConfigurableApplicationEventPublisher eventPublisher, Class ... classes) {
        this(Neo4jDatastore.createDefaultConnectionSources(boltDriver, configuration), eventPublisher, classes);
    }

    public Neo4jDatastore(Driver boltDriver, ConfigurableApplicationEventPublisher eventPublisher, Class ... classes) {
        this(Neo4jDatastore.createDefaultConnectionSources(boltDriver, DatastoreUtils.createPropertyResolver(null)), eventPublisher, classes);
    }

    public Neo4jDatastore(Driver boltDriver, PropertyResolver configuration, Class ... classes) {
        this(boltDriver, configuration, (ConfigurableApplicationEventPublisher)new DefaultApplicationEventPublisher(), classes);
    }

    public Neo4jDatastore(Driver boltDriver, Class ... classes) {
        this(boltDriver, DatastoreUtils.createPropertyResolver(null), (ConfigurableApplicationEventPublisher)new DefaultApplicationEventPublisher(), classes);
    }

    public Neo4jDatastore(PropertyResolver configuration, Neo4jConnectionSourceFactory connectionSourceFactory, ConfigurableApplicationEventPublisher eventPublisher, Class ... classes) {
        this((ConnectionSources<Driver, Neo4jConnectionSourceSettings>)ConnectionSourcesInitializer.create((ConnectionSourceFactory)connectionSourceFactory, (PropertyResolver)configuration), eventPublisher, classes);
    }

    public Neo4jDatastore(PropertyResolver configuration, Neo4jConnectionSourceFactory connectionSourceFactory, ConfigurableApplicationEventPublisher eventPublisher, Package ... packagesToScan) {
        this(configuration, connectionSourceFactory, eventPublisher, new ClasspathEntityScanner().scan(packagesToScan));
    }

    public Neo4jDatastore(PropertyResolver configuration, ConfigurableApplicationEventPublisher eventPublisher, Class ... classes) {
        this((ConnectionSources<Driver, Neo4jConnectionSourceSettings>)ConnectionSourcesInitializer.create((ConnectionSourceFactory)new Neo4jConnectionSourceFactory(), (PropertyResolver)configuration), eventPublisher, classes);
    }

    public Neo4jDatastore(PropertyResolver configuration, ConfigurableApplicationEventPublisher eventPublisher, Package ... packagesToScan) {
        this(configuration, eventPublisher, new ClasspathEntityScanner().scan(packagesToScan));
    }

    public Neo4jDatastore(PropertyResolver configuration, Class ... classes) {
        this(configuration, (ConfigurableApplicationEventPublisher)new DefaultApplicationEventPublisher(), classes);
    }

    public Neo4jDatastore(Class ... classes) {
        this(Neo4jDatastore.resolveEmbeddedConfiguration(), classes);
    }

    public Neo4jDatastore(Map<String, Object> configuration, ConfigurableApplicationEventPublisher eventPublisher, Class ... classes) {
        this(Neo4jDatastore.mapToPropertyResolver(configuration), eventPublisher, classes);
    }

    public Neo4jDatastore(Map<String, Object> configuration, Class ... classes) {
        this(configuration, (ConfigurableApplicationEventPublisher)new DefaultApplicationEventPublisher(), classes);
    }

    public Neo4jDatastore(Package ... packagesToScan) {
        this(new ClasspathEntityScanner().scan(packagesToScan));
    }

    public Neo4jDatastore(Package packageToScan) {
        this(new ClasspathEntityScanner().scan(new Package[]{packageToScan}));
    }

    public Neo4jDatastore(PropertyResolver configuration, Package ... packagesToScan) {
        this(configuration, new ClasspathEntityScanner().scan(packagesToScan));
    }

    public Neo4jDatastore(Map<String, Object> configuration, Package ... packagesToScan) {
        this(DatastoreUtils.createPropertyResolver(configuration), packagesToScan);
    }

    public Neo4jDatastoreTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public ConfigurableApplicationEventPublisher getApplicationEventPublisher() {
        return this.eventPublisher;
    }

    public Datastore getDatastoreForConnection(String connectionName) {
        return (Datastore)this.datastoresByConnectionSource.get(connectionName);
    }

    public Neo4jMappingContext getMappingContext() {
        return (Neo4jMappingContext)super.getMappingContext();
    }

    protected static ConnectionSources<Driver, Neo4jConnectionSourceSettings> createDefaultConnectionSources(Driver driver, PropertyResolver configuration) {
        Neo4jConnectionSourceSettingsBuilder builder = new Neo4jConnectionSourceSettingsBuilder(configuration);
        Neo4jConnectionSourceSettings settings = (Neo4jConnectionSourceSettings)builder.build();
        DefaultConnectionSource defaultConnectionSource = new DefaultConnectionSource("DEFAULT", (Object)driver, (ConnectionSourceSettings)settings);
        return new InMemoryConnectionSources((ConnectionSource)defaultConnectionSource, (ConnectionSourceFactory)new Neo4jConnectionSourceFactory(), configuration);
    }

    protected static Neo4jMappingContext createMappingContext(ConnectionSources<Driver, Neo4jConnectionSourceSettings> connectionSources, Class ... classes) {
        ConnectionSource defaultConnectionSource = connectionSources.getDefaultConnectionSource();
        Neo4jConnectionSourceSettings settings = (Neo4jConnectionSourceSettings)defaultConnectionSource.getSettings();
        Neo4jMappingContext neo4jMappingContext = new Neo4jMappingContext(settings, classes);
        StaticMessageSource messageSource = new StaticMessageSource();
        ValidatorRegistry defaultValidatorRegistry = Neo4jDatastore.createValidatorRegistry(settings, neo4jMappingContext, (MessageSource)messageSource);
        neo4jMappingContext.setValidatorRegistry(defaultValidatorRegistry);
        return neo4jMappingContext;
    }

    private static PropertyResolver resolveEmbeddedConfiguration() {
        if (Neo4jConnectionSourceFactory.isEmbeddedAvailable()) {
            LinkedHashMap<String, Object> config = new LinkedHashMap<String, Object>();
            config.put("grails.neo4j.type", "embedded");
            config.put("grails.neo4j.embedded.ephemeral", true);
            return Neo4jDatastore.mapToPropertyResolver(config);
        }
        return Neo4jDatastore.mapToPropertyResolver(null);
    }

    private static ValidatorRegistry createValidatorRegistry(Neo4jConnectionSourceSettings settings, Neo4jMappingContext neo4jMappingContext, MessageSource messageSource) {
        ValidatorRegistry defaultValidatorRegistry = ValidatorRegistries.createValidatorRegistry((MappingContext)neo4jMappingContext, (ConnectionSourceSettings)settings, (MessageSource)messageSource);
        Neo4jDatastore.configureValidatorRegistry(neo4jMappingContext, messageSource, defaultValidatorRegistry);
        return defaultValidatorRegistry;
    }

    private static void configureValidatorRegistry(Neo4jMappingContext neo4jMappingContext, MessageSource messageSource, ValidatorRegistry defaultValidatorRegistry) {
        if (defaultValidatorRegistry instanceof ConstraintRegistry) {
            ((ConstraintRegistry)defaultValidatorRegistry).addConstraintFactory((ConstraintFactory)new MappingContextAwareConstraintFactory(UniqueConstraint.class, messageSource, (MappingContext)neo4jMappingContext));
        }
    }

    protected void registerEventListeners(ConfigurableApplicationEventPublisher eventPublisher) {
        eventPublisher.addApplicationListener((ApplicationListener)new DomainEventListener((Datastore)this));
        eventPublisher.addApplicationListener((ApplicationListener)new AutoTimestampEventListener((Datastore)this));
        if (this.multiTenancyMode == MultiTenancySettings.MultiTenancyMode.DISCRIMINATOR) {
            eventPublisher.addApplicationListener((ApplicationListener)new MultiTenantEventListener((Datastore)this));
        }
    }

    protected GormEnhancer initialize(Neo4jConnectionSourceSettings settings) {
        this.registerEventListeners(this.eventPublisher);
        this.mappingContext.addMappingContextListener(new MappingContext.Listener(){

            public void persistentEntityAdded(PersistentEntity entity) {
                Neo4jDatastore.this.gormEnhancer.registerEntity(entity);
            }
        });
        return new GormEnhancer((Datastore)this, (PlatformTransactionManager)this.transactionManager, settings){

            protected <D> GormStaticApi<D> getStaticApi(Class<D> cls, String qualifier) {
                Neo4jDatastore neo4jDatastore = this.getDatastoreForQualifier(cls, qualifier);
                return new Neo4jGormStaticApi<D>(cls, (Datastore)neo4jDatastore, this.createDynamicFinders((Datastore)neo4jDatastore), (PlatformTransactionManager)neo4jDatastore.getTransactionManager());
            }

            protected <D> GormValidationApi<D> getValidationApi(Class<D> cls, String qualifier) {
                Neo4jDatastore neo4jDatastore = this.getDatastoreForQualifier(cls, qualifier);
                return new GormValidationApi(cls, (Datastore)neo4jDatastore);
            }

            protected <D> GormInstanceApi<D> getInstanceApi(Class<D> cls, String qualifier) {
                Neo4jDatastore neo4jDatastore = this.getDatastoreForQualifier(cls, qualifier);
                return new GormInstanceApi(cls, (Datastore)neo4jDatastore);
            }

            private <D> Neo4jDatastore getDatastoreForQualifier(Class<D> cls, String qualifier) {
                ConnectionSource connectionSource;
                String defaultConnectionSourceName = ConnectionSourcesSupport.getDefaultConnectionSourceName((PersistentEntity)Neo4jDatastore.this.getMappingContext().getPersistentEntity(cls.getName()));
                boolean isDefaultQualifier = qualifier.equals("DEFAULT");
                if (isDefaultQualifier && defaultConnectionSourceName.equals("DEFAULT")) {
                    return Neo4jDatastore.this;
                }
                if (isDefaultQualifier) {
                    qualifier = defaultConnectionSourceName;
                }
                if ((connectionSource = Neo4jDatastore.this.connectionSources.getConnectionSource(qualifier)) == null) {
                    throw new ConfigurationException("Invalid connection [" + defaultConnectionSourceName + "] configured for class [" + cls + "]");
                }
                return Neo4jDatastore.this.datastoresByConnectionSource.get(qualifier);
            }
        };
    }

    public void setSkipIndexSetup(boolean skipIndexSetup) {
        this.skipIndexSetup = skipIndexSetup;
    }

    protected Session createSession(PropertyResolver connectionDetails) {
        Neo4jSession neo4jSession = new Neo4jSession((Datastore)this, this.mappingContext, (ApplicationEventPublisher)this.eventPublisher, false, this.boltDriver);
        neo4jSession.setFlushMode(this.defaultFlushMode);
        return neo4jSession;
    }

    public void setupIndexing() {
        if (this.skipIndexSetup) {
            return;
        }
        ArrayList<String> schemaStrings = new ArrayList<String>();
        for (PersistentEntity persistentEntity : this.mappingContext.getPersistentEntities()) {
            if (persistentEntity.isExternal() || Relationship.class.isAssignableFrom(persistentEntity.getJavaClass())) continue;
            if (log.isDebugEnabled()) {
                log.debug("Setting up indexing for entity " + persistentEntity.getName());
            }
            GraphPersistentEntity graphPersistentEntity = (GraphPersistentEntity)persistentEntity;
            for (String label : graphPersistentEntity.getLabels()) {
                StringBuilder sb = new StringBuilder();
                IdGenerator.Type idGeneratorType = graphPersistentEntity.getIdGeneratorType();
                if (graphPersistentEntity.getIdGenerator() != null && idGeneratorType.equals((Object)IdGenerator.Type.SNOWFLAKE)) {
                    sb.append("CREATE CONSTRAINT ON (n:").append(label).append(") ASSERT n.").append("__id__").append(" IS UNIQUE");
                    schemaStrings.add(sb.toString());
                } else if (!graphPersistentEntity.isNativeId()) {
                    this.createUniqueConstraintOnProperty(label, graphPersistentEntity.getIdentity(), schemaStrings);
                }
                for (PersistentProperty persistentProperty : persistentEntity.getPersistentProperties()) {
                    Property mappedForm = persistentProperty.getMapping().getMappedForm();
                    if (!(persistentProperty instanceof Simple) || mappedForm == null) continue;
                    if (mappedForm.isUnique()) {
                        this.createUniqueConstraintOnProperty(label, persistentProperty, schemaStrings);
                        continue;
                    }
                    if (!mappedForm.isIndex()) continue;
                    sb = new StringBuilder();
                    sb.append("CREATE INDEX ON :").append(label).append("(").append(persistentProperty.getName()).append(")");
                    schemaStrings.add(sb.toString());
                    if (!log.isDebugEnabled()) continue;
                    log.debug("setting up indexing for " + label + " property " + persistentProperty.getName());
                }
            }
        }
        org.neo4j.driver.v1.Session boltSession = this.boltDriver.session();
        Transaction transaction = boltSession.beginTransaction();
        try {
            for (String cypher : schemaStrings) {
                if (log.isDebugEnabled()) {
                    log.debug("CREATE INDEX Cypher [{}]", (Object)cypher);
                }
                transaction.run(cypher);
                transaction.success();
            }
        }
        catch (Throwable e) {
            log.error("Error creating Neo4j index: " + e.getMessage(), e);
            transaction.failure();
            throw new DatastoreConfigurationException("Error creating Neo4j index: " + e.getMessage(), e);
        }
        finally {
            boltSession.close();
        }
        if (log.isDebugEnabled()) {
            log.debug("done setting up indexes");
        }
    }

    private void createUniqueConstraintOnProperty(String label, PersistentProperty persistentProperty, List<String> schemaStrings) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE CONSTRAINT ON (n:").append(label).append(") ASSERT n.").append(persistentProperty.getName()).append(" IS UNIQUE");
        schemaStrings.add(sb.toString());
    }

    public Driver getBoltDriver() {
        return this.boltDriver;
    }

    @Override
    @PreDestroy
    public void close() throws IOException {
        try {
            try {
                this.gormEnhancer.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                this.connectionSources.close();
            }
            catch (Neo4jException e) {
                log.error("Error shutting down Bolt driver: " + e.getMessage(), (Throwable)e);
            }
            super.destroy();
        }
        catch (Exception e) {
            throw new IOException("Error shutting down Neo4j datastore", e);
        }
    }

    public ConnectionSources<Driver, Neo4jConnectionSourceSettings> getConnectionSources() {
        return this.connectionSources;
    }

    public MultiTenancySettings.MultiTenancyMode getMultiTenancyMode() {
        return this.multiTenancyMode;
    }

    public TenantResolver getTenantResolver() {
        return this.tenantResolver;
    }

    public Neo4jDatastore getDatastoreForTenantId(Serializable tenantId) {
        if (this.getMultiTenancyMode() == MultiTenancySettings.MultiTenancyMode.DATABASE) {
            return this.datastoresByConnectionSource.get(tenantId.toString());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T1> T1 withNewSession(Serializable tenantId, Closure<T1> callable) {
        Neo4jDatastore neo4jDatastore = this.getDatastoreForTenantId(tenantId);
        Session session = neo4jDatastore.connect();
        try {
            DatastoreUtils.bindNewSession((Session)session);
            Object object = callable.call((Object)session);
            return (T1)object;
        }
        finally {
            DatastoreUtils.unbindSession((Session)session);
        }
    }

    public void setMessageSource(MessageSource messageSource) {
        if (messageSource != null) {
            Neo4jMappingContext mappingContext = this.getMappingContext();
            ValidatorRegistry validatorRegistry = Neo4jDatastore.createValidatorRegistry((Neo4jConnectionSourceSettings)this.connectionSources.getDefaultConnectionSource().getSettings(), mappingContext, messageSource);
            Neo4jDatastore.configureValidatorRegistry(mappingContext, messageSource, validatorRegistry);
            mappingContext.setValidatorRegistry(validatorRegistry);
        }
    }
}

