/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j.engine;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.gorm.neo4j.CypherBuilder;
import org.grails.datastore.gorm.neo4j.GraphPersistentEntity;
import org.grails.datastore.gorm.neo4j.Neo4jSession;
import org.grails.datastore.gorm.neo4j.RelationshipPersistentEntity;
import org.grails.datastore.gorm.neo4j.RelationshipUtils;
import org.grails.datastore.gorm.neo4j.collection.Neo4jResultList;
import org.grails.datastore.mapping.engine.AssociationQueryExecutor;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.config.GormProperties;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.Basic;
import org.grails.datastore.mapping.model.types.ToMany;
import org.grails.datastore.mapping.model.types.ToOne;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Neo4jAssociationQueryExecutor
implements AssociationQueryExecutor<Serializable, Object>,
GroovyObject {
    private final Neo4jSession session;
    private final PersistentEntity indexedEntity;
    private final Association association;
    private final boolean lazy;
    private final boolean singleResult;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    /*
     * WARNING - void declaration
     */
    public Neo4jAssociationQueryExecutor(Neo4jSession neo4jSession, Association association, boolean bl, boolean bl2) {
        void singleResult;
        void lazy;
        void association2;
        void session;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var6_6 = session;
        this.session = var6_6;
        PersistentEntity associatedEntity = association2.getAssociatedEntity();
        if (associatedEntity != null) {
            PersistentEntity persistentEntity;
            this.indexedEntity = persistentEntity = associatedEntity;
        } else if (association2 instanceof Basic) {
            PersistentEntity persistentEntity;
            this.indexedEntity = persistentEntity = session.getMappingContext().getPersistentEntity(((Basic)ScriptBytecodeAdapter.castToType((Object)association2, Basic.class)).getComponentType().getName());
        }
        if (this.indexedEntity == null) {
            throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{association2}, new String[]{"Cannot create association query loader for ", ". No mapped associated entity could be located."})));
        }
        void var10_10 = association2;
        this.association = var10_10;
        void var11_11 = lazy;
        this.lazy = var11_11;
        void var12_12 = singleResult;
        this.singleResult = var12_12;
    }

    public Neo4jAssociationQueryExecutor(Neo4jSession session, Association association, boolean lazy) {
        this(session, association, lazy, false);
    }

    public Neo4jAssociationQueryExecutor(Neo4jSession session, Association association) {
        this(session, association, DefaultTypeTransformation.booleanUnbox((Object)association.getMapping().getMappedForm().isLazy()), false);
    }

    public boolean doesReturnKeys() {
        return false;
    }

    public List<Object> query(Serializable primaryKey) {
        Object v1;
        Object v0;
        Transaction statementRunner = this.session.hasTransaction() ? this.session.getTransaction().getNativeTransaction() : this.session.getNativeInterface();
        String relType = null;
        GraphPersistentEntity parent = (GraphPersistentEntity)((Object)ScriptBytecodeAdapter.castToType((Object)this.association.getOwner(), GraphPersistentEntity.class));
        GraphPersistentEntity related = (GraphPersistentEntity)((Object)ScriptBytecodeAdapter.castToType((Object)this.indexedEntity, GraphPersistentEntity.class));
        boolean isRelationship = related.isRelationshipEntity();
        if (isRelationship) {
            RelationshipPersistentEntity relEntity = (RelationshipPersistentEntity)((Object)ScriptBytecodeAdapter.castToType((Object)((Object)related), RelationshipPersistentEntity.class));
            GraphPersistentEntity fromEntity = (GraphPersistentEntity)((Object)ScriptBytecodeAdapter.castToType((Object)relEntity.getFrom().getAssociatedEntity(), GraphPersistentEntity.class));
            GraphPersistentEntity toEntity = (GraphPersistentEntity)((Object)ScriptBytecodeAdapter.castToType((Object)relEntity.getTo().getAssociatedEntity(), GraphPersistentEntity.class));
            if (ScriptBytecodeAdapter.compareEqual((Object)((Object)parent), (Object)((Object)fromEntity))) {
                GraphPersistentEntity graphPersistentEntity;
                String string;
                relType = string = "-[rel]->";
                related = graphPersistentEntity = toEntity;
            } else {
                GraphPersistentEntity graphPersistentEntity;
                GraphPersistentEntity graphPersistentEntity2;
                String string;
                relType = string = "<-[rel]-";
                parent = graphPersistentEntity2 = toEntity;
                related = graphPersistentEntity = fromEntity;
            }
        } else {
            String string;
            relType = string = RelationshipUtils.matchForAssociation(this.association);
        }
        String relationship = CypherBuilder.buildRelationship(parent.getLabelsAsString(), relType, related.getLabelsAsString());
        StringBuilder cypher = new StringBuilder(CypherBuilder.buildRelationshipMatch(parent.getLabelsAsString(), relType, related.getLabelsAsString()));
        cypher.append(parent.formatId(RelationshipPersistentEntity.FROM)).append(" = {id} RETURN ");
        boolean isLazyToMany = this.lazy && !isRelationship && this.association instanceof ToMany;
        if (isLazyToMany) {
            cypher.append(related.formatId(RelationshipPersistentEntity.TO)).append(" as id");
        } else if (!isRelationship) {
            cypher.append("to as data");
        } else {
            cypher.append("rel as rel");
        }
        cypher.append(this.singleResult ? "LIMIT 1" : "");
        Map<String, Serializable> params = Collections.singletonMap(GormProperties.IDENTITY, primaryKey);
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.association, relationship}, new String[]{"Lazy loading association [", "] using relationship ", ""})));
            v0 = null;
        } else {
            v0 = null;
        }
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{cypher, params}, new String[]{"QUERY Cypher [", "] for params [", "]"})));
            v1 = null;
        } else {
            v1 = null;
        }
        StatementResult result = statementRunner.run(cypher.toString(), params);
        if (isLazyToMany) {
            List results = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            while (result.hasNext()) {
                Object id = result.next().get(GormProperties.IDENTITY).asObject();
                results.add(this.session.proxy(related.getJavaClass(), (Serializable)ScriptBytecodeAdapter.asType((Object)id, Serializable.class)));
            }
            return results;
        }
        Neo4jResultList resultList = new Neo4jResultList(0, result, isRelationship ? this.session.getEntityPersister(this.indexedEntity) : this.session.getEntityPersister((Object)related));
        if (this.association.isBidirectional()) {
            Association inverseSide = this.association.getInverseSide();
            if (inverseSide instanceof ToOne) {
                Object parentObject = this.session.getCachedInstance(this.association.getOwner().getJavaClass(), primaryKey);
                if (parentObject != null) {
                    resultList.setInitializedAssociations(Collections.singletonMap(inverseSide, parentObject));
                }
            }
        }
        return resultList;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Neo4jAssociationQueryExecutor.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"org.grails.datastore.gorm.neo4j.engine.Neo4jAssociationQueryExecutor");
    }

    public final Neo4jSession getSession() {
        return this.session;
    }

    public final PersistentEntity getIndexedEntity() {
        return this.indexedEntity;
    }

    public final Association getAssociation() {
        return this.association;
    }

    public final boolean getLazy() {
        return this.lazy;
    }

    public final boolean isLazy() {
        return this.lazy;
    }

    public final boolean getSingleResult() {
        return this.singleResult;
    }

    public final boolean isSingleResult() {
        return this.singleResult;
    }
}

