/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j;

import grails.neo4j.Relationship;
import groovy.lang.Closure;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.grails.datastore.gorm.neo4j.GraphGormMappingFactory;
import org.grails.datastore.gorm.neo4j.GraphPersistentEntity;
import org.grails.datastore.gorm.neo4j.IdGenerator;
import org.grails.datastore.gorm.neo4j.RelationshipPersistentEntity;
import org.grails.datastore.gorm.neo4j.connections.Neo4jConnectionSourceSettings;
import org.grails.datastore.gorm.neo4j.proxy.HashcodeEqualsAwareProxyFactory;
import org.grails.datastore.mapping.model.AbstractMappingContext;
import org.grails.datastore.mapping.model.MappingConfigurationStrategy;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.MappingFactory;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.config.GormMappingConfigurationStrategy;
import org.grails.datastore.mapping.proxy.ProxyFactory;
import org.springframework.core.convert.ConversionService;

public class Neo4jMappingContext
extends AbstractMappingContext {
    private static final Class<Long> LONG_TYPE = Long.TYPE;
    private static final Class<Double> DOUBLE_TYPE = Double.TYPE;
    private static final Class<String> STRING_TYPE = String.class;
    public static final Set<Class> BASIC_TYPES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(STRING_TYPE, Long.class, Float.class, Integer.class, Double.class, Short.class, Boolean.class, Byte.class, Byte.TYPE, Integer.TYPE, LONG_TYPE, Float.TYPE, DOUBLE_TYPE, Short.TYPE, Boolean.TYPE, byte[].class, int[].class, long[].class, float[].class, double[].class, short[].class, boolean[].class, String[].class)));
    GraphGormMappingFactory mappingFactory = new GraphGormMappingFactory();
    MappingConfigurationStrategy mappingSyntaxStrategy = new GormMappingConfigurationStrategy((MappingFactory)this.mappingFactory);
    protected Map<Iterable<String>, GraphPersistentEntity> entitiesByLabel = new LinkedHashMap<Iterable<String>, GraphPersistentEntity>();
    protected IdGenerator idGenerator = null;

    public Neo4jMappingContext() {
    }

    public Neo4jMappingContext(Closure defaultMapping) {
        this.setProxyFactory((ProxyFactory)new HashcodeEqualsAwareProxyFactory());
        this.mappingFactory.setDefaultMapping(defaultMapping);
    }

    public Neo4jMappingContext(Closure defaultMapping, Class ... classes) {
        this.mappingFactory.setDefaultMapping(defaultMapping);
        this.addPersistentEntities(classes);
    }

    public Neo4jMappingContext(Neo4jConnectionSourceSettings settings, Class ... classes) {
        this.mappingFactory.setDefaultMapping(settings.getDefault().getMapping());
        this.mappingFactory.setDefaultConstraints(settings.getDefault().getConstraints());
        this.initialize(settings);
        this.addPersistentEntities(classes);
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public MappingConfigurationStrategy getMappingSyntaxStrategy() {
        return this.mappingSyntaxStrategy;
    }

    public MappingFactory getMappingFactory() {
        return this.mappingFactory;
    }

    protected PersistentEntity createPersistentEntity(Class javaClass) {
        return this.createPersistentEntity(javaClass, false);
    }

    protected PersistentEntity createPersistentEntity(Class javaClass, boolean external) {
        GraphPersistentEntity entity = Relationship.class.isAssignableFrom(javaClass) ? new RelationshipPersistentEntity(javaClass, (MappingContext)this, external) : new GraphPersistentEntity(javaClass, (MappingContext)this, external);
        Collection<String> labels = entity.getLabels();
        this.entitiesByLabel.put(labels, entity);
        return entity;
    }

    public GraphPersistentEntity findPersistentEntityForLabels(Iterable<String> labels) {
        GraphPersistentEntity entity = this.entitiesByLabel.get(labels);
        if (entity != null) {
            return entity;
        }
        return null;
    }

    public Object convertToNative(Object value) {
        if (value != null) {
            Class<?> type = value.getClass();
            if (type.equals(byte[].class)) {
                byte[] bytes = (byte[])value;
                int[] intArray = new int[bytes.length];
                for (int i = 0; i < bytes.length; ++i) {
                    int b;
                    intArray[i] = b = bytes[i];
                }
                return intArray;
            }
            if (BASIC_TYPES.contains(type)) {
                return value;
            }
            if (value instanceof CharSequence) {
                return value.toString();
            }
            if (value instanceof Collection) {
                return value;
            }
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).doubleValue();
            }
            ConversionService conversionService = this.getConversionService();
            if (byte[].class.isInstance(value)) {
                return conversionService.convert(value, String.class);
            }
            if (conversionService.canConvert(type, LONG_TYPE)) {
                return conversionService.convert(value, LONG_TYPE);
            }
            if (conversionService.canConvert(type, DOUBLE_TYPE)) {
                return conversionService.convert(value, DOUBLE_TYPE);
            }
            if (conversionService.canConvert(type, STRING_TYPE)) {
                return conversionService.convert(value, STRING_TYPE);
            }
            return value.toString();
        }
        return value;
    }
}

