/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j.engine;

import grails.neo4j.Relationship;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.grails.datastore.gorm.neo4j.GraphPersistentEntity;
import org.grails.datastore.gorm.neo4j.RelationshipUtils;
import org.grails.datastore.gorm.neo4j.mapping.config.DynamicToOneAssociation;
import org.grails.datastore.mapping.core.impl.PendingInsertAdapter;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.Basic;
import org.grails.datastore.mapping.model.types.Simple;
import org.grails.datastore.mapping.model.types.ToOne;
import org.grails.datastore.mapping.reflect.EntityReflector;
import org.neo4j.driver.v1.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipPendingInsert
extends PendingInsertAdapter<Object, Serializable> {
    public static final String FROM = "from";
    public static final String TO = "to";
    public static final String CYPHER_DELETE_RELATIONSHIP = "MATCH (from%s {__id__: {start}})%s() DELETE r";
    public static final String CYPHER_DELETE_NATIVE_RELATIONSHIP = "MATCH (from%s)%s() WHERE ID(from) = {start} DELETE r";
    public static final String SOURCE_TYPE = "sourceType";
    public static final String TARGET_TYPE = "targetType";
    private static Logger log = LoggerFactory.getLogger(RelationshipPendingInsert.class);
    private final Transaction boltTransaction;
    private final Association association;
    private final Collection<Serializable> targetIdentifiers;
    private final boolean isUpdate;

    public RelationshipPendingInsert(EntityAccess parent, Association association, Collection<Serializable> pendingInserts, Transaction boltTransaction, boolean isUpdate) {
        super(parent.getPersistentEntity(), (Object)-1L, parent.getEntity(), parent);
        this.boltTransaction = boltTransaction;
        this.targetIdentifiers = pendingInserts;
        this.association = association;
        this.isUpdate = isUpdate;
    }

    public RelationshipPendingInsert(EntityAccess parent, Association association, Collection<Serializable> pendingInserts, Transaction boltTransaction) {
        this(parent, association, pendingInserts, boltTransaction, false);
    }

    public void run() {
        String relMatch;
        LinkedHashMap<String, String> attrs;
        GraphPersistentEntity graphParent = (GraphPersistentEntity)this.getEntity();
        GraphPersistentEntity graphChild = (GraphPersistentEntity)this.association.getAssociatedEntity();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(2);
        EntityAccess entityAccess = this.getEntityAccess();
        Object parentId = entityAccess.getIdentifier();
        boolean isRelationshipAssociation = Relationship.class.isAssignableFrom(graphParent.getJavaClass());
        if (isRelationshipAssociation) {
            if (this.association.getName().equals(FROM)) {
                Association endProperty = (Association)graphParent.getPropertyByName(TO);
                Association startProperty = (Association)graphParent.getPropertyByName(FROM);
                graphChild = (GraphPersistentEntity)endProperty.getAssociatedEntity();
                graphParent = (GraphPersistentEntity)startProperty.getAssociatedEntity();
                Object endEntity = entityAccess.getProperty(TO);
                Object startEntity = entityAccess.getProperty(FROM);
                parentId = graphParent.getReflector().getIdentifier(startEntity);
                this.targetIdentifiers.clear();
                this.targetIdentifiers.add(graphChild.getReflector().getIdentifier(endEntity));
            } else {
                return;
            }
        }
        params.put("start", parentId);
        params.put("end", this.targetIdentifiers);
        boolean nativeParent = graphParent.getIdGenerator() == null;
        String labelsFrom = graphParent.getLabelsAsString();
        String labelsTo = graphChild.getLabelsAsString();
        if (this.association instanceof DynamicToOneAssociation) {
            attrs = new LinkedHashMap<String, String>();
            attrs.put(SOURCE_TYPE, graphParent.getJavaClass().getSimpleName());
            attrs.put(TARGET_TYPE, graphChild.getJavaClass().getSimpleName());
            relMatch = RelationshipUtils.matchForAssociation(this.association, "r", attrs);
        } else if (isRelationshipAssociation) {
            attrs = new LinkedHashMap();
            GraphPersistentEntity relEntity = (GraphPersistentEntity)this.getEntity();
            EntityReflector reflector = relEntity.getReflector();
            for (PersistentProperty pp : relEntity.getPersistentProperties()) {
                Object v;
                String propertyName;
                if (!(pp instanceof Simple) && !(pp instanceof Basic) || "type".equals(propertyName = pp.getName()) || (v = reflector.getProperty(this.getNativeEntry(), propertyName)) == null) continue;
                attrs.put(propertyName, (String)v);
            }
            Relationship relationship = (Relationship)this.getEntityAccess().getEntity();
            attrs.putAll(relationship.attributes());
            params.put("rProps", attrs);
            relMatch = RelationshipUtils.toMatch(this.association, relationship);
        } else {
            relMatch = RelationshipUtils.matchForAssociation(this.association, "r");
        }
        boolean reversed = RelationshipUtils.useReversedMappingFor(this.association);
        if (!reversed && this.association instanceof ToOne && this.isUpdate) {
            String cypher = nativeParent ? String.format(CYPHER_DELETE_NATIVE_RELATIONSHIP, labelsFrom, relMatch) : String.format(CYPHER_DELETE_RELATIONSHIP, labelsFrom, relMatch);
            Map<String, Object> deleteParams = Collections.singletonMap("start", parentId);
            if (log.isDebugEnabled()) {
                log.debug("DELETE Cypher [{}] for parameters [{}]", (Object)cypher, deleteParams);
            }
            this.boltTransaction.run(cypher, deleteParams);
        }
        StringBuilder cypherQuery = new StringBuilder("MATCH (from").append(labelsFrom).append("), (to").append(labelsTo).append(") WHERE ");
        if (nativeParent) {
            cypherQuery.append("ID(from) = {start}");
        } else {
            cypherQuery.append("from.").append("__id__").append(" = {start}");
        }
        cypherQuery.append(" AND ");
        if (graphChild.getIdGenerator() == null) {
            cypherQuery.append(" ID(to) IN {end} ");
        } else {
            cypherQuery.append("to.").append("__id__").append(" IN {end}");
        }
        cypherQuery.append(" MERGE (from)").append(relMatch).append("(to)");
        if (isRelationshipAssociation) {
            cypherQuery.append(" ON CREATE SET r={rProps}");
        }
        String cypher = cypherQuery.toString();
        if (log.isDebugEnabled()) {
            log.debug("MERGE Cypher [{}] for parameters [{}]", (Object)cypher, params);
        }
        this.boltTransaction.run(cypher, params);
    }
}

