/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j.engine;

import grails.neo4j.Relationship;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.grails.datastore.gorm.neo4j.GraphPersistentEntity;
import org.grails.datastore.gorm.neo4j.RelationshipUtils;
import org.grails.datastore.mapping.core.impl.PendingOperationAdapter;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.model.types.Association;
import org.neo4j.driver.v1.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipPendingDelete
extends PendingOperationAdapter<Object, Serializable> {
    private static Logger log = LoggerFactory.getLogger(RelationshipPendingDelete.class);
    private final Transaction boltTransaction;
    private final Association association;
    private final Collection<Serializable> targetIdentifiers;
    private final EntityAccess entityAccess;

    public RelationshipPendingDelete(EntityAccess parent, Association association, Collection<Serializable> pendingInserts, Transaction boltTransaction) {
        super(parent.getPersistentEntity(), (Object)((Serializable)parent.getIdentifier()), parent.getEntity());
        this.targetIdentifiers = pendingInserts;
        this.boltTransaction = boltTransaction;
        this.association = association;
        this.entityAccess = parent;
    }

    public void run() {
        boolean nativeParent;
        GraphPersistentEntity graphParent = (GraphPersistentEntity)this.getEntity();
        GraphPersistentEntity graphChild = (GraphPersistentEntity)this.association.getAssociatedEntity();
        String labelsFrom = graphParent.getLabelsAsString();
        String labelsTo = graphChild.getLabelsAsString();
        Serializable parentId = (Serializable)this.getNativeKey();
        boolean isRelationshipAssociation = Relationship.class.isAssignableFrom(graphParent.getJavaClass());
        if (isRelationshipAssociation) {
            if (this.association.getName().equals("from")) {
                Association endProperty = (Association)graphParent.getPropertyByName("to");
                Association startProperty = (Association)graphParent.getPropertyByName("from");
                graphChild = (GraphPersistentEntity)endProperty.getAssociatedEntity();
                graphParent = (GraphPersistentEntity)startProperty.getAssociatedEntity();
                Object endEntity = this.entityAccess.getProperty("to");
                Object startEntity = this.entityAccess.getProperty("from");
                parentId = graphParent.getReflector().getIdentifier(startEntity);
                this.targetIdentifiers.clear();
                this.targetIdentifiers.add(graphChild.getReflector().getIdentifier(endEntity));
            } else {
                return;
            }
        }
        String relMatch = isRelationshipAssociation ? RelationshipUtils.toMatch(this.association, (Relationship)this.entityAccess.getEntity()) : RelationshipUtils.matchForAssociation(this.association, "r");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(2);
        params.put("start", parentId);
        params.put("end", this.targetIdentifiers);
        StringBuilder cypherQuery = new StringBuilder("MATCH (from").append(labelsFrom).append(")").append(relMatch).append("(to").append(labelsTo).append(") WHERE ");
        boolean bl = nativeParent = graphParent.getIdGenerator() == null;
        if (nativeParent) {
            cypherQuery.append("ID(from) = {start}");
        } else {
            cypherQuery.append("from.").append("__id__").append(" = {start}");
        }
        cypherQuery.append(" AND ");
        if (graphChild.getIdGenerator() == null) {
            cypherQuery.append(" ID(to) IN {end} ");
        } else {
            cypherQuery.append("to.").append("__id__").append(" IN {end}");
        }
        cypherQuery.append(" DELETE r");
        String cypher = cypherQuery.toString();
        if (log.isDebugEnabled()) {
            log.debug("DELETE Cypher [{}] for parameters [{}]", (Object)cypher, params);
        }
        this.boltTransaction.run(cypher, params);
    }
}

