/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j;

import grails.neo4j.Direction;
import grails.neo4j.Relationship;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.gorm.neo4j.RelationshipPersistentEntity;
import org.grails.datastore.gorm.neo4j.mapping.config.Attribute;
import org.grails.datastore.gorm.neo4j.mapping.config.DynamicAssociation;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PropertyMapping;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.ManyToMany;
import org.grails.datastore.mapping.model.types.OneToMany;

public class RelationshipUtils
implements GroovyObject {
    private static final char INCOMING_CHAR = '<';
    private static final char OUTGOING_CHAR = '>';
    private static final char OPEN_BRACE = '{';
    private static final char CLOSE_BRACE = '}';
    private static final char COMMA = ',';
    private static final char COLON = ':';
    private static final String SINGLE_QUOTE;
    private static final String START_RELATIONSHIP = "-[";
    private static final String END_RELATIONSHIP = "]-";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public RelationshipUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static boolean useReversedMappingFor(Association association) {
        PropertyMapping propertyMapping = association.getMapping();
        Attribute attr = (Attribute)((Object)ScriptBytecodeAdapter.castToType((Object)(propertyMapping != null ? propertyMapping.getMappedForm() : null), Attribute.class));
        return RelationshipUtils.isIncomingRelationship(association, attr);
    }

    public static String relationshipTypeUsedFor(Association association) {
        PropertyMapping propertyMapping = association.getMapping();
        Attribute mappedForm = (Attribute)((Object)ScriptBytecodeAdapter.castToType((Object)(propertyMapping != null ? propertyMapping.getMappedForm() : null), Attribute.class));
        return RelationshipUtils.getRelationshipType(association, mappedForm);
    }

    public static String matchForAssociation(Association association, String var, Map<String, String> attributes) {
        PropertyMapping propertyMapping = association.getMapping();
        Attribute mappedForm = (Attribute)((Object)ScriptBytecodeAdapter.castToType((Object)(propertyMapping != null ? propertyMapping.getMappedForm() : null), Attribute.class));
        String relationshipType = RelationshipUtils.getRelationshipType(association, mappedForm);
        boolean reversed = RelationshipUtils.isIncomingRelationship(association, mappedForm);
        StringBuilder sb = new StringBuilder();
        if (reversed) {
            sb.append(INCOMING_CHAR);
        }
        sb.append(START_RELATIONSHIP).append(var).append(COLON).append(relationshipType);
        if (!attributes.isEmpty()) {
            sb.append(OPEN_BRACE);
            Iterator<Map.Entry<String, String>> i = attributes.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)ScriptBytecodeAdapter.castToType(i.next(), Map.Entry.class);
                sb.append(ShortTypeHandling.castToString(entry.getKey())).append(COLON).append(SINGLE_QUOTE).append(ShortTypeHandling.castToString(entry.getValue())).append(SINGLE_QUOTE);
                if (!i.hasNext()) continue;
                sb.append(COMMA);
            }
            sb.append(CLOSE_BRACE);
        }
        sb.append(END_RELATIONSHIP);
        Attribute attribute = mappedForm;
        Direction direction = attribute != null ? attribute.getDirection() : null;
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)direction), (Object)((Object)Direction.OUTGOING)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)direction), (Object)((Object)Direction.BOTH)) || !reversed) {
            sb.append(OUTGOING_CHAR);
        }
        return sb.toString();
    }

    public static String toMatch(Association association, Relationship relationship, String var) {
        PropertyMapping propertyMapping = association.getMapping();
        Attribute mappedForm = (Attribute)((Object)ScriptBytecodeAdapter.castToType((Object)(propertyMapping != null ? propertyMapping.getMappedForm() : null), Attribute.class));
        String relationshipType = relationship.type();
        Direction direction = mappedForm.getDirection();
        Direction direction2 = DefaultTypeTransformation.booleanUnbox((Object)((Object)direction)) ? direction : Direction.OUTGOING;
        boolean reversed = ScriptBytecodeAdapter.compareEqual((Object)((Object)direction2), (Object)((Object)Direction.INCOMING)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)direction2), (Object)((Object)Direction.BOTH));
        StringBuilder sb = new StringBuilder();
        if (reversed) {
            sb.append(INCOMING_CHAR);
        }
        sb.append(START_RELATIONSHIP).append(var).append(COLON).append(relationshipType);
        sb.append(END_RELATIONSHIP);
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)direction2), (Object)((Object)Direction.OUTGOING)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)direction2), (Object)((Object)Direction.BOTH))) {
            sb.append(OUTGOING_CHAR);
        }
        return sb.toString();
    }

    public static String matchForRelationshipEntity(Association association, RelationshipPersistentEntity entity, String var) {
        PropertyMapping propertyMapping = association.getMapping();
        Attribute mappedForm = (Attribute)((Object)ScriptBytecodeAdapter.castToType((Object)(propertyMapping != null ? propertyMapping.getMappedForm() : null), Attribute.class));
        PersistentEntity owningEntity = association.getOwner();
        Direction direction = mappedForm.getDirection();
        Direction direction2 = DefaultTypeTransformation.booleanUnbox((Object)((Object)direction)) ? direction : (ScriptBytecodeAdapter.compareEqual((Object)owningEntity, (Object)entity.getTo().getAssociatedEntity()) ? Direction.INCOMING : Direction.OUTGOING);
        boolean reversed = ScriptBytecodeAdapter.compareEqual((Object)((Object)direction2), (Object)((Object)Direction.INCOMING)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)direction2), (Object)((Object)Direction.BOTH));
        StringBuilder sb = new StringBuilder();
        if (reversed) {
            sb.append(INCOMING_CHAR);
        }
        sb.append(START_RELATIONSHIP).append(var).append(END_RELATIONSHIP);
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)direction2), (Object)((Object)Direction.OUTGOING)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)direction2), (Object)((Object)Direction.BOTH))) {
            sb.append(OUTGOING_CHAR);
        }
        return sb.toString();
    }

    protected static boolean isIncomingRelationship(Association association, Attribute mappedForm) {
        Attribute attribute = mappedForm;
        Direction direction = attribute != null ? attribute.getDirection() : null;
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)direction), (Object)((Object)Direction.INCOMING)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)direction), (Object)((Object)Direction.BOTH))) {
            return true;
        }
        return association.isBidirectional() && (association instanceof OneToMany || association instanceof ManyToMany && association.isOwningSide());
    }

    protected static String getRelationshipType(Association association, Attribute mappedForm) {
        Attribute attribute = mappedForm;
        String relationshipType = attribute != null ? attribute.getType() : null;
        if (relationshipType != null) {
            return relationshipType;
        }
        String name = RelationshipUtils.useReversedMappingFor(association) ? association.getReferencedPropertyName() : association.getName();
        if (name != null) {
            if (association instanceof DynamicAssociation) {
                return name;
            }
            return name.toUpperCase();
        }
        return association.getName();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RelationshipUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static String matchForAssociation(Association association, String var) {
        return RelationshipUtils.matchForAssociation(association, var, Collections.emptyMap());
    }

    public static String matchForAssociation(Association association) {
        return RelationshipUtils.matchForAssociation(association, "", Collections.emptyMap());
    }

    public static String toMatch(Association association, Relationship relationship) {
        return RelationshipUtils.toMatch(association, relationship, "r");
    }

    public static String matchForRelationshipEntity(Association association, RelationshipPersistentEntity entity) {
        return RelationshipUtils.matchForRelationshipEntity(association, entity, "r");
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        String string;
        SINGLE_QUOTE = string = "'";
    }
}

