/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CypherBuilder {
    public static final String TYPE = "type";
    public static final String END = "end";
    public static final String START = "start";
    public static final String IDENTIFIER = "__id__";
    public static final String PROPS = "props";
    public static final String RELATED = "related";
    public static final String WHERE = " WHERE ";
    public static final String RETURN = " RETURN ";
    public static final String COMMAND_SEPARATOR = ", ";
    public static final String DEFAULT_RETURN_TYPES = "n as data\n";
    public static final String DEFAULT_RETURN_STATEMENT = " RETURN n as data\n";
    public static final String NEW_LINE = " \n";
    public static final String START_MATCH = "MATCH (n";
    public static final String SPACE = " ";
    public static final String OPTIONAL_MATCH = "OPTIONAL MATCH";
    public static final String CYPHER_CREATE = "CREATE ";
    public static final String CYPHER_MATCH_ID = "MATCH (n%s) WHERE n.__id__={id}";
    public static final String CYPHER_MATCH_NATIVE_ID = "MATCH (n%s) WHERE ID(n) = {id}";
    public static final String NODE_LABELS = "labels";
    public static final String NODE_DATA = "data";
    public static final String NODE_VAR = "n";
    public static final String DELETE = "\n DETACH DELETE ";
    private String forLabels;
    private Set<String> matches = new HashSet<String>();
    private List<String> optionalMatches = new ArrayList<String>();
    private String conditions;
    private String orderAndLimits;
    private List<String> returnColumns = new ArrayList<String>();
    private List<String> deleteColumns = new ArrayList<String>();
    private Map<String, Object> sets = null;
    private Map<String, Object> params = new LinkedHashMap<String, Object>();
    private int setIndex;

    public CypherBuilder(String forLabels) {
        this.forLabels = forLabels;
    }

    public void addMatch(String match) {
        this.matches.add(match);
    }

    public void addOptionalMatch(String match) {
        this.optionalMatches.add(match);
    }

    public int getNextMatchNumber() {
        return this.matches.size();
    }

    public void setConditions(String conditions) {
        this.conditions = conditions;
    }

    public void setOrderAndLimits(String orderAndLimits) {
        this.orderAndLimits = orderAndLimits;
    }

    public int addParam(Object value) {
        this.params.put(String.valueOf(this.params.size() + 1), value);
        return this.params.size();
    }

    public void replaceParamAt(int position, Object value) {
        this.params.put(String.valueOf(position), value);
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void addReturnColumn(String returnColumn) {
        this.returnColumns.add(returnColumn);
    }

    public void addDeleteColumn(String deleteColumn) {
        this.deleteColumns.add(deleteColumn);
    }

    public void addPropertySet(Map<String, Object> sets) {
        if (sets != null) {
            int index;
            this.setIndex = index = this.addParam(sets);
            this.sets = sets;
        }
    }

    public String build() {
        Iterator<String> iter;
        StringBuilder cypher = new StringBuilder();
        cypher.append(START_MATCH).append(this.forLabels).append(")");
        for (String m : this.matches) {
            cypher.append(COMMAND_SEPARATOR).append(m);
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            cypher.append(WHERE).append(this.conditions);
        }
        if (!this.optionalMatches.isEmpty()) {
            for (String m : this.optionalMatches) {
                cypher.append(NEW_LINE).append(OPTIONAL_MATCH).append(m);
            }
        }
        if (!this.deleteColumns.isEmpty()) {
            cypher.append(DELETE);
            iter = this.deleteColumns.iterator();
            if (iter.hasNext()) {
                cypher.append(iter.next());
                while (iter.hasNext()) {
                    cypher.append(COMMAND_SEPARATOR).append(iter.next());
                }
            }
            return cypher.toString();
        }
        if (this.sets != null) {
            cypher.append("\nSET n += {").append(this.setIndex).append("}\n");
        }
        if (this.returnColumns.isEmpty()) {
            cypher.append(DEFAULT_RETURN_STATEMENT);
            if (this.orderAndLimits != null) {
                cypher.append(this.orderAndLimits).append(NEW_LINE);
            }
        } else {
            cypher.append(RETURN);
            iter = this.returnColumns.iterator();
            if (iter.hasNext()) {
                cypher.append(iter.next());
                while (iter.hasNext()) {
                    cypher.append(COMMAND_SEPARATOR).append(iter.next());
                }
            }
            if (this.orderAndLimits != null) {
                cypher.append(SPACE);
                cypher.append(this.orderAndLimits);
            }
        }
        return cypher.toString();
    }
}

