/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.EvictionListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.persistence.CascadeType;
import org.grails.datastore.gorm.neo4j.CypherBuilder;
import org.grails.datastore.gorm.neo4j.GraphPersistentEntity;
import org.grails.datastore.gorm.neo4j.Neo4jDatastore;
import org.grails.datastore.gorm.neo4j.Neo4jMappingContext;
import org.grails.datastore.gorm.neo4j.Neo4jTransaction;
import org.grails.datastore.gorm.neo4j.SessionFlushedEvent;
import org.grails.datastore.gorm.neo4j.engine.Neo4jEntityPersister;
import org.grails.datastore.gorm.neo4j.engine.Neo4jQuery;
import org.grails.datastore.gorm.neo4j.engine.RelationshipPendingDelete;
import org.grails.datastore.gorm.neo4j.engine.RelationshipPendingInsert;
import org.grails.datastore.gorm.neo4j.mapping.config.DynamicAssociation;
import org.grails.datastore.gorm.neo4j.mapping.config.DynamicToOneAssociation;
import org.grails.datastore.gorm.schemaless.DynamicAttributes;
import org.grails.datastore.mapping.core.AbstractSession;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.OptimisticLockingException;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.impl.PendingDelete;
import org.grails.datastore.mapping.core.impl.PendingInsert;
import org.grails.datastore.mapping.core.impl.PendingOperation;
import org.grails.datastore.mapping.core.impl.PendingUpdate;
import org.grails.datastore.mapping.dirty.checking.DirtyCheckable;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.Persister;
import org.grails.datastore.mapping.engine.types.CustomTypeMarshaller;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.Custom;
import org.grails.datastore.mapping.model.types.Simple;
import org.grails.datastore.mapping.model.types.TenantId;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.Restrictions;
import org.grails.datastore.mapping.query.api.QueryableCriteria;
import org.grails.datastore.mapping.transactions.SessionHolder;
import org.grails.datastore.mapping.transactions.Transaction;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.StatementResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class Neo4jSession
extends AbstractSession<org.neo4j.driver.v1.Session> {
    private static final String COUNT_RETURN = "count(n) as total";
    private static final String TOTAL_COUNT = "total";
    private static Logger log = LoggerFactory.getLogger(Neo4jSession.class);
    private static final EvictionListener<RelationshipUpdateKey, Collection<Serializable>> EXCEPTION_THROWING_INSERT_LISTENER = new EvictionListener<RelationshipUpdateKey, Collection<Serializable>>(){

        public void onEviction(RelationshipUpdateKey association, Collection<Serializable> value) {
            throw new DataAccessResourceFailureException("Maximum number (5000) of relationship update operations to flush() exceeded. Flush the session periodically to avoid this error for batch operations.");
        }
    };
    protected Map<RelationshipUpdateKey, Collection<Serializable>> pendingRelationshipInserts = new ConcurrentLinkedHashMap.Builder().listener(EXCEPTION_THROWING_INSERT_LISTENER).maximumWeightedCapacity(5000L).build();
    protected Map<RelationshipUpdateKey, Collection<Serializable>> pendingRelationshipDeletes = new ConcurrentLinkedHashMap.Builder().listener(EXCEPTION_THROWING_INSERT_LISTENER).maximumWeightedCapacity(5000L).build();
    protected final org.neo4j.driver.v1.Session boltSession;

    public Neo4jSession(Datastore datastore, MappingContext mappingContext, ApplicationEventPublisher publisher, boolean stateless, Driver boltDriver) {
        super(datastore, mappingContext, publisher, stateless);
        if (log.isDebugEnabled()) {
            log.debug("Session created");
        }
        this.boltSession = boltDriver.session();
    }

    public void addPendingRelationshipInsert(Serializable parentId, Association association, Serializable id) {
        this.addRelationshipUpdate(parentId, association, id, this.pendingRelationshipInserts);
    }

    public void addPendingRelationshipDelete(Serializable parentId, Association association, Serializable id) {
        this.addRelationshipUpdate(parentId, association, id, this.pendingRelationshipDeletes);
    }

    protected void addRelationshipUpdate(Serializable parentId, Association association, Serializable id, Map<RelationshipUpdateKey, Collection<Serializable>> targetMap) {
        RelationshipUpdateKey key = new RelationshipUpdateKey(parentId, association);
        Collection<Serializable> inserts = targetMap.get(key);
        if (inserts == null) {
            inserts = new ConcurrentLinkedQueue<Serializable>();
            targetMap.put(key, inserts);
        }
        inserts.add(id);
    }

    protected void clearPendingOperations() {
        try {
            super.clearPendingOperations();
        }
        finally {
            this.pendingRelationshipInserts.clear();
        }
    }

    public Neo4jEntityPersister getEntityPersister(Object o) {
        return (Neo4jEntityPersister)this.getPersister(o);
    }

    protected Persister createPersister(Class cls, MappingContext mappingContext) {
        PersistentEntity entity = mappingContext.getPersistentEntity(cls.getName());
        return entity != null ? new Neo4jEntityPersister(mappingContext, entity, (Session)this, this.publisher) : null;
    }

    protected Transaction beginTransactionInternal() {
        throw new IllegalStateException("Use beingTransaction(TransactionDefinition) instead");
    }

    public Transaction beginTransaction(TransactionDefinition transactionDefinition) {
        return this.beginTransactionInternal(transactionDefinition, false);
    }

    protected Transaction beginTransactionInternal(TransactionDefinition transactionDefinition, boolean sessionCreated) {
        if (this.transaction != null && this.transaction.isActive()) {
            return this.transaction;
        }
        Transaction tx = null;
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.getDatastore());
            tx = sessionHolder.getTransaction();
        }
        if (tx == null || !tx.isActive()) {
            if (transactionDefinition.getName() == null) {
                transactionDefinition = this.createDefaultTransactionDefinition(transactionDefinition);
            }
            tx = new Neo4jTransaction(this.boltSession, transactionDefinition, sessionCreated);
        }
        this.transaction = tx;
        return this.transaction;
    }

    public void disconnect() {
        if (this.isConnected()) {
            super.disconnect();
            try {
                if (this.transaction != null && !this.isSynchronizedWithTransaction) {
                    Neo4jTransaction transaction = this.getTransaction();
                    transaction.close();
                }
                this.boltSession.close();
            }
            catch (IOException e) {
                log.error("Error closing transaction: " + e.getMessage(), (Throwable)e);
            }
            finally {
                if (log.isDebugEnabled()) {
                    log.debug("Session closed");
                }
                this.transaction = null;
            }
        }
    }

    public Neo4jDatastore getDatastore() {
        return (Neo4jDatastore)super.getDatastore();
    }

    public org.neo4j.driver.v1.Session getNativeInterface() {
        return this.boltSession;
    }

    protected void flushPendingUpdates(Map<PersistentEntity, Collection<PendingUpdate>> updates) {
        Set<PersistentEntity> entities = updates.keySet();
        Neo4jMappingContext mappingContext = (Neo4jMappingContext)this.getMappingContext();
        for (PersistentEntity entity : entities) {
            Collection<PendingUpdate> pendingUpdates = updates.get(entity);
            GraphPersistentEntity graphPersistentEntity = (GraphPersistentEntity)entity;
            boolean isNativeId = graphPersistentEntity.getIdGenerator() == null;
            boolean isVersioned = entity.hasProperty("version", Long.class) && entity.isVersioned();
            for (PendingUpdate pendingUpdate : pendingUpdates) {
                StatementResult executionResult;
                List preOperations = pendingUpdate.getPreOperations();
                this.executePendings(preOperations);
                pendingUpdate.run();
                if (pendingUpdate.isVetoed()) continue;
                EntityAccess access = pendingUpdate.getEntityAccess();
                ArrayList<PendingOperation<Object, Serializable>> cascadingOperations = new ArrayList<PendingOperation<Object, Serializable>>(pendingUpdate.getCascadeOperations());
                String labels = ((GraphPersistentEntity)entity).getLabelsWithInheritance(access.getEntity());
                StringBuilder cypherStringBuilder = new StringBuilder();
                LinkedHashMap<String, Serializable> params = new LinkedHashMap<String, Serializable>(2);
                Serializable id = (Serializable)pendingUpdate.getNativeKey();
                params.put("id", id);
                HashMap<String, Object> simpleProps = new HashMap<String, Object>();
                if (isNativeId) {
                    cypherStringBuilder.append("MATCH (n%s) WHERE ID(n) = {id}");
                } else {
                    cypherStringBuilder.append("MATCH (n%s) WHERE n.__id__={id}");
                }
                Object object = pendingUpdate.getObject();
                DirtyCheckable dirtyCheckable = (DirtyCheckable)object;
                List dirtyPropertyNames = dirtyCheckable.listDirtyPropertyNames();
                ArrayList<String> nulls = new ArrayList<String>();
                for (String dirtyPropertyName : dirtyPropertyNames) {
                    PersistentProperty property = entity.getPropertyByName(dirtyPropertyName);
                    if (property == null) continue;
                    if (property instanceof Simple) {
                        String name = property.getName();
                        Object value = access.getProperty(name);
                        if (value != null) {
                            simpleProps.put(name, mappingContext.convertToNative(value));
                            continue;
                        }
                        nulls.add(name);
                        continue;
                    }
                    if (!(property instanceof Custom)) continue;
                    Custom custom = (Custom)property;
                    CustomTypeMarshaller customTypeMarshaller = custom.getCustomTypeMarshaller();
                    Object value = access.getProperty(property.getName());
                    customTypeMarshaller.write((PersistentProperty)custom, value, simpleProps);
                }
                Map<String, List<Object>> dynamicAssociations = this.amendMapWithUndeclaredProperties(graphPersistentEntity, simpleProps, object, (MappingContext)mappingContext, nulls);
                this.processDynamicAssociations(graphPersistentEntity, access, mappingContext, dynamicAssociations, cascadingOperations, true);
                this.processPendingRelationshipUpdates(graphPersistentEntity, access, id, cascadingOperations, true);
                boolean hasNoUpdates = simpleProps.isEmpty();
                if (hasNoUpdates && nulls.isEmpty()) {
                    dirtyCheckable.trackChanges();
                    this.executePendings(cascadingOperations);
                    continue;
                }
                params.put("props", simpleProps);
                if (isVersioned) {
                    Object version = (Long)access.getProperty("version");
                    if (version == null) {
                        version = 0L;
                    }
                    params.put("version", (Serializable)version);
                    cypherStringBuilder.append(" AND n.version={version}");
                    long newVersion = (Long)version + 1L;
                    simpleProps.put("version", newVersion);
                    access.setProperty("version", (Object)newVersion);
                }
                cypherStringBuilder.append(" SET n+={props}");
                if (!nulls.isEmpty()) {
                    for (String aNull : nulls) {
                        cypherStringBuilder.append(",n.").append(aNull).append(" = NULL");
                    }
                }
                cypherStringBuilder.append(" RETURN ID(n) as id");
                String cypher = String.format(cypherStringBuilder.toString(), labels);
                if (log.isDebugEnabled()) {
                    log.debug("UPDATE Cypher [{}] for parameters [{}]", (Object)cypher, params);
                }
                if (!(executionResult = this.getTransaction().getNativeTransaction().run(cypher, params)).hasNext() && isVersioned) {
                    throw new OptimisticLockingException(entity, (Object)id);
                }
                dirtyCheckable.trackChanges();
                this.executePendings(cascadingOperations);
            }
        }
    }

    private void processPendingRelationshipUpdates(GraphPersistentEntity entity, EntityAccess access, Serializable id, List<PendingOperation<Object, Serializable>> cascadingOperations, boolean isUpdate) {
        for (Association association : entity.getAssociations()) {
            this.processPendingRelationshipUpdates(access, id, association, cascadingOperations, isUpdate);
        }
        if (entity.hasDynamicAssociations()) {
            if (!this.pendingRelationshipDeletes.isEmpty()) {
                for (RelationshipUpdateKey relationshipUpdateKey : this.pendingRelationshipDeletes.keySet()) {
                    Association association = relationshipUpdateKey.association;
                    if (!(association instanceof DynamicAssociation) || !association.getOwner().equals((Object)entity) || !relationshipUpdateKey.id.equals(id)) continue;
                    cascadingOperations.add((PendingOperation<Object, Serializable>)new RelationshipPendingDelete(access, association, this.pendingRelationshipDeletes.get(relationshipUpdateKey), this.getTransaction().getTransaction()));
                }
            }
            if (!this.pendingRelationshipInserts.isEmpty()) {
                ArrayList<RelationshipUpdateKey> relationshipUpdates = new ArrayList<RelationshipUpdateKey>(this.pendingRelationshipInserts.keySet());
                Collections.sort(relationshipUpdates, new Comparator<RelationshipUpdateKey>(){

                    @Override
                    public int compare(RelationshipUpdateKey o1, RelationshipUpdateKey o2) {
                        return o1.association.getName().compareTo(o2.association.getName());
                    }
                });
                for (RelationshipUpdateKey relationshipUpdate : relationshipUpdates) {
                    Association association = relationshipUpdate.association;
                    if (!(association instanceof DynamicToOneAssociation) || !association.getOwner().equals((Object)entity) || !relationshipUpdate.id.equals(id)) continue;
                    cascadingOperations.add((PendingOperation<Object, Serializable>)new RelationshipPendingInsert(access, association, this.pendingRelationshipInserts.get(relationshipUpdate), this.getTransaction().getTransaction(), isUpdate));
                }
            }
        }
    }

    private void processPendingRelationshipUpdates(EntityAccess parent, Serializable parentId, Association association, List<PendingOperation<Object, Serializable>> cascadingOperations, boolean isUpdate) {
        Collection<Serializable> pendingDeletes;
        RelationshipUpdateKey key = new RelationshipUpdateKey(parentId, association);
        Collection<Serializable> pendingInserts = this.pendingRelationshipInserts.get(key);
        if (pendingInserts != null) {
            cascadingOperations.add((PendingOperation<Object, Serializable>)new RelationshipPendingInsert(parent, association, pendingInserts, this.getTransaction().getTransaction(), isUpdate));
        }
        if ((pendingDeletes = this.pendingRelationshipDeletes.get(key)) != null) {
            cascadingOperations.add((PendingOperation<Object, Serializable>)new RelationshipPendingDelete(parent, association, pendingDeletes, this.getTransaction().getNativeTransaction()));
        }
    }

    protected void flushPendingInserts(Map<PersistentEntity, Collection<PendingInsert>> inserts) {
        Set<PersistentEntity> entities = inserts.keySet();
        Neo4jMappingContext mappingContext = (Neo4jMappingContext)this.getMappingContext();
        int i = 0;
        boolean first = true;
        boolean hasInserts = false;
        StringBuilder createCypher = new StringBuilder("CREATE ");
        HashMap<String, Object> params = new HashMap<String, Object>(inserts.size());
        ArrayList<PendingOperation<Object, Serializable>> cascadingOperations = new ArrayList<PendingOperation<Object, Serializable>>();
        for (PersistentEntity entity : entities) {
            Collection<PendingInsert> entityInserts = inserts.get(entity);
            for (PendingInsert entityInsert : entityInserts) {
                if (entityInsert.wasExecuted()) {
                    this.processPendingRelationshipUpdates((GraphPersistentEntity)entity, entityInsert.getEntityAccess(), (Serializable)entityInsert.getNativeKey(), cascadingOperations, false);
                    cascadingOperations.addAll(entityInsert.getCascadeOperations());
                    continue;
                }
                List preOperations = entityInsert.getPreOperations();
                for (PendingOperation preOperation : preOperations) {
                    preOperation.run();
                }
                entityInsert.run();
                if (entityInsert.isVetoed()) continue;
                cascadingOperations.addAll(entityInsert.getCascadeOperations());
                hasInserts = true;
                ++i;
                if (!first) {
                    createCypher.append(',');
                    createCypher.append('\n');
                } else {
                    first = false;
                }
                this.buildEntityCreateOperation(createCypher, String.valueOf(i), entity, entityInsert, params, cascadingOperations, mappingContext);
            }
        }
        if (hasInserts) {
            String finalCypher = createCypher.toString();
            if (log.isDebugEnabled()) {
                log.debug("CREATE Cypher [{}] for parameters [{}]", (Object)finalCypher, params);
            }
            this.getTransaction().getNativeTransaction().run(finalCypher, params);
        }
        this.executePendings(cascadingOperations);
    }

    public String buildEntityCreateOperation(PersistentEntity entity, PendingInsert entityInsert, Map<String, Object> params, List<PendingOperation<Object, Serializable>> cascadingOperations) {
        StringBuilder createCypher = new StringBuilder("CREATE ");
        this.buildEntityCreateOperation(createCypher, "", entity, entityInsert, params, cascadingOperations, (Neo4jMappingContext)this.getMappingContext());
        return createCypher.toString();
    }

    public void buildEntityCreateOperation(StringBuilder createCypher, String index, PersistentEntity entity, PendingInsert entityInsert, Map<String, Object> params, List<PendingOperation<Object, Serializable>> cascadingOperations, Neo4jMappingContext mappingContext) {
        GraphPersistentEntity graphPersistentEntity = (GraphPersistentEntity)entity;
        List persistentProperties = entity.getPersistentProperties();
        HashMap<String, Object> simpleProps = new HashMap<String, Object>(persistentProperties.size());
        Serializable id = (Serializable)entityInsert.getNativeKey();
        if (graphPersistentEntity.getIdGenerator() != null) {
            simpleProps.put("__id__", id);
        }
        Object obj = entityInsert.getObject();
        GraphPersistentEntity graphEntity = (GraphPersistentEntity)entity;
        String labels = graphEntity.getLabelsWithInheritance(obj);
        String cypher = String.format("(n" + index + "%s {props" + index + "})", labels);
        createCypher.append(cypher);
        params.put("props" + index, simpleProps);
        Map<String, List<Object>> dynamicRelProps = this.amendMapWithUndeclaredProperties(graphEntity, simpleProps, obj, (MappingContext)mappingContext);
        EntityAccess access = entityInsert.getEntityAccess();
        for (PersistentProperty pp : persistentProperties) {
            if (pp instanceof Simple || pp instanceof TenantId) {
                String name = pp.getName();
                Object value = access.getProperty(name);
                if (value == null) continue;
                simpleProps.put(name, mappingContext.convertToNative(value));
                continue;
            }
            if (!(pp instanceof Custom)) continue;
            Custom custom = (Custom)pp;
            CustomTypeMarshaller customTypeMarshaller = custom.getCustomTypeMarshaller();
            Object value = access.getProperty(pp.getName());
            customTypeMarshaller.write((PersistentProperty)custom, value, simpleProps);
        }
        this.processDynamicAssociations(graphEntity, access, mappingContext, dynamicRelProps, cascadingOperations, false);
        this.processPendingRelationshipUpdates((GraphPersistentEntity)entity, entityInsert.getEntityAccess(), (Serializable)entityInsert.getNativeKey(), cascadingOperations, false);
    }

    protected void processDynamicAssociations(GraphPersistentEntity graphEntity, EntityAccess access, Neo4jMappingContext mappingContext, Map<String, List<Object>> dynamicRelProps, List<PendingOperation<Object, Serializable>> cascadingOperations, boolean isUpdate) {
        if (graphEntity.hasDynamicAssociations()) {
            Serializable parentId = (Serializable)access.getIdentifier();
            for (Map.Entry<String, List<Object>> e : dynamicRelProps.entrySet()) {
                for (Object o : e.getValue()) {
                    GraphPersistentEntity associated;
                    if (!((DirtyCheckable)access.getEntity()).hasChanged(e.getKey()) || (associated = (GraphPersistentEntity)mappingContext.getPersistentEntity(o.getClass().getName())) == null) continue;
                    Serializable childId = this.getEntityPersister(o).getObjectIdentifier(o);
                    if (childId == null) {
                        childId = this.persist(o);
                    }
                    this.addPendingRelationshipInsert(parentId, (Association)new DynamicToOneAssociation((PersistentEntity)graphEntity, (MappingContext)mappingContext, e.getKey(), (PersistentEntity)associated), childId);
                }
            }
        }
    }

    protected void flushPendingDeletes(Map<PersistentEntity, Collection<PendingDelete>> pendingDeletes) {
        Set<PersistentEntity> persistentEntities = pendingDeletes.keySet();
        for (PersistentEntity entity : persistentEntities) {
            Collection<PendingDelete> deletes = pendingDeletes.get(entity);
            ArrayList<Object> ids = new ArrayList<Object>();
            ArrayList cascadingOperations = new ArrayList();
            for (PendingDelete delete : deletes) {
                List preOperations = delete.getPreOperations();
                for (PendingOperation preOperation : preOperations) {
                    preOperation.run();
                }
                delete.run();
                if (delete.isVetoed()) continue;
                Object id = delete.getNativeKey();
                ids.add(id);
                cascadingOperations.addAll(delete.getCascadeOperations());
            }
            Neo4jQuery deleteQuery = new Neo4jQuery(this, entity, this.getEntityPersister(entity.getJavaClass()));
            deleteQuery.add((Query.Criterion)Restrictions.in((String)"id", ids));
            CypherBuilder cypherBuilder = deleteQuery.getBaseQuery();
            this.buildCascadingDeletes(entity, cypherBuilder);
            String cypher = cypherBuilder.build();
            Map<String, Object> idMap = cypherBuilder.getParams();
            if (log.isDebugEnabled()) {
                log.debug("DELETE Cypher [{}] for parameters {}", (Object)cypher, idMap);
            }
            this.getTransaction().getNativeTransaction().run(cypher, idMap);
            this.executePendings(cascadingOperations);
        }
    }

    protected Map<String, List<Object>> amendMapWithUndeclaredProperties(GraphPersistentEntity graphEntity, Map<String, Object> simpleProps, Object pojo, MappingContext mappingContext) {
        return this.amendMapWithUndeclaredProperties(graphEntity, simpleProps, pojo, mappingContext, new ArrayList<String>());
    }

    protected Map<String, List<Object>> amendMapWithUndeclaredProperties(GraphPersistentEntity graphEntity, Map<String, Object> simpleProps, Object pojo, MappingContext mappingContext, List<String> nulls) {
        Map map;
        LinkedHashMap<String, List<Object>> dynRelProps;
        boolean hasDynamicAssociations = graphEntity.hasDynamicAssociations();
        LinkedHashMap<String, List<Object>> linkedHashMap = dynRelProps = hasDynamicAssociations ? new LinkedHashMap<String, List<Object>>() : Collections.emptyMap();
        if (pojo instanceof DynamicAttributes && (map = ((DynamicAttributes)pojo).attributes()) != null) {
            for (Map.Entry entry : map.entrySet()) {
                Object value = entry.getValue();
                String key = (String)entry.getKey();
                if (value == null) {
                    nulls.add(key);
                    continue;
                }
                if (hasDynamicAssociations) {
                    List<Object> objects;
                    if (mappingContext.isPersistentEntity(value)) {
                        objects = this.getOrInit(dynRelProps, key);
                        objects.add(value);
                        continue;
                    }
                    if (Neo4jSession.isCollectionWithPersistentEntities(value, mappingContext)) {
                        objects = this.getOrInit(dynRelProps, key);
                        objects.addAll((Collection)value);
                        continue;
                    }
                    simpleProps.put(key, ((Neo4jMappingContext)mappingContext).convertToNative(value));
                    continue;
                }
                simpleProps.put(key, ((Neo4jMappingContext)mappingContext).convertToNative(value));
            }
        }
        return dynRelProps;
    }

    private List<Object> getOrInit(Map<String, List<Object>> dynRelProps, String key) {
        List<Object> objects = dynRelProps.get(key);
        if (objects == null) {
            objects = new ArrayList<Object>();
            dynRelProps.put(key, objects);
        }
        return objects;
    }

    public static boolean isCollectionWithPersistentEntities(Object o, MappingContext mappingContext) {
        if (!(o instanceof Collection)) {
            return false;
        }
        Collection c = (Collection)o;
        for (Object obj : c) {
            if (!mappingContext.isPersistentEntity(obj)) continue;
            return true;
        }
        return false;
    }

    public void flush() {
        if (this.wasTransactionTerminated()) {
            return;
        }
        Neo4jTransaction transaction = (Neo4jTransaction)this.transaction;
        if (transaction != null) {
            if (transaction.getTransactionDefinition().isReadOnly()) {
                return;
            }
        } else {
            throw new NoTransactionException("Cannot flush write operations without an active transaction!");
        }
        this.persistDirtyButUnsavedInstances();
        super.flush();
    }

    public Neo4jTransaction getTransaction() {
        return (Neo4jTransaction)super.getTransaction();
    }

    protected boolean wasTransactionTerminated() {
        return this.transaction != null && !this.transaction.isActive();
    }

    protected void postFlush(boolean hasUpdates) {
        super.postFlush(hasUpdates);
        if (this.publisher != null) {
            this.publisher.publishEvent((ApplicationEvent)new SessionFlushedEvent((Session)this));
        }
    }

    public Neo4jTransaction assertTransaction() {
        if (this.transaction == null || this.wasTransactionTerminated() && !TransactionSynchronizationManager.isSynchronizationActive()) {
            SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.getDatastore());
            if (sessionHolder != null && sessionHolder.getSession().equals((Object)this)) {
                Transaction transaction = sessionHolder.getTransaction();
                if (transaction instanceof Neo4jTransaction) {
                    this.transaction = transaction;
                    return (Neo4jTransaction)transaction;
                }
                this.startDefaultTransaction();
            } else {
                this.startDefaultTransaction();
            }
        }
        return (Neo4jTransaction)this.transaction;
    }

    public boolean hasTransaction() {
        return super.hasTransaction() && this.transaction.isActive();
    }

    private void startDefaultTransaction() {
        DefaultTransactionDefinition transactionDefinition = this.createDefaultTransactionDefinition(null);
        this.transaction = new Neo4jTransaction(this.boltSession, (TransactionDefinition)transactionDefinition, true);
    }

    protected DefaultTransactionDefinition createDefaultTransactionDefinition(TransactionDefinition other) {
        DefaultTransactionDefinition transactionDefinition = other != null ? new DefaultTransactionDefinition(other) : new DefaultTransactionDefinition();
        transactionDefinition.setName("Neo4j Transaction");
        return transactionDefinition;
    }

    private void persistDirtyButUnsavedInstances() {
        for (Map cache : this.firstLevelCache.values()) {
            for (Object obj : cache.values()) {
                boolean isDirty;
                if (!(obj instanceof DirtyCheckable) || !(isDirty = ((DirtyCheckable)obj).hasChanged())) continue;
                this.persist(obj);
            }
        }
    }

    public long deleteAll(QueryableCriteria criteria) {
        PersistentEntity entity = criteria.getPersistentEntity();
        List criteriaList = criteria.getCriteria();
        Neo4jQuery query = new Neo4jQuery(this, entity, this.getEntityPersister(entity.getJavaClass()));
        for (Query.Criterion criterion : criteriaList) {
            query.add(criterion);
        }
        query.projections().count();
        CypherBuilder baseQuery = query.getBaseQuery();
        this.buildCascadingDeletes(entity, baseQuery);
        String cypher = baseQuery.build();
        Map<String, Object> params = baseQuery.getParams();
        if (log.isDebugEnabled()) {
            log.debug("DELETE Cypher [{}] for parameters [{}]", (Object)cypher, params);
        }
        Number count = (Number)query.singleResult();
        this.getTransaction().getNativeTransaction().run(cypher, params);
        return count.longValue();
    }

    protected void buildCascadingDeletes(PersistentEntity entity, CypherBuilder baseQuery) {
        int i = 1;
        for (Association association : entity.getAssociations()) {
            if (!association.doesCascade(CascadeType.REMOVE)) continue;
            String a = "a" + i++;
            baseQuery.addOptionalMatch("(n)" + Neo4jQuery.matchForAssociation(association) + "(" + a + ")");
            baseQuery.addDeleteColumn(a);
        }
        baseQuery.addDeleteColumn("n");
    }

    public long updateAll(QueryableCriteria criteria, Map<String, Object> properties) {
        StatementResult execute;
        PersistentEntity entity = criteria.getPersistentEntity();
        List criteriaList = criteria.getCriteria();
        Neo4jQuery query = new Neo4jQuery(this, entity, this.getEntityPersister(entity.getJavaClass()));
        for (Query.Criterion criterion : criteriaList) {
            query.add(criterion);
        }
        query.projections().count();
        CypherBuilder baseQuery = query.getBaseQuery();
        baseQuery.addPropertySet(properties);
        baseQuery.addReturnColumn(COUNT_RETURN);
        String cypher = baseQuery.build();
        Map<String, Object> params = baseQuery.getParams();
        if (log.isDebugEnabled()) {
            log.debug("UPDATE Cypher [{}] for parameters [{}]", (Object)cypher, params);
        }
        if ((execute = this.getTransaction().getNativeTransaction().run(cypher, params)).hasNext()) {
            Record currentRecord = execute.next();
            Map result = currentRecord.asMap();
            return ((Number)result.get(TOTAL_COUNT)).longValue();
        }
        return 0L;
    }

    private static class RelationshipUpdateKey {
        private final Serializable id;
        private final Association association;

        public RelationshipUpdateKey(Serializable id, Association association) {
            this.id = id;
            this.association = association;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RelationshipUpdateKey that = (RelationshipUpdateKey)o;
            if (this.association != null ? !this.association.equals(that.association) : that.association != null) {
                return false;
            }
            return !(this.id == null ? that.id != null : !this.id.equals(that.id));
        }

        public int hashCode() {
            int result = this.association != null ? this.association.hashCode() : 0;
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            return result;
        }
    }
}

