/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j.engine;

import groovy.lang.GroovyObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.persistence.LockModeType;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.grails.datastore.gorm.GormEntity;
import org.grails.datastore.gorm.neo4j.GraphPersistentEntity;
import org.grails.datastore.gorm.neo4j.IdGenerator;
import org.grails.datastore.gorm.neo4j.Neo4jMappingContext;
import org.grails.datastore.gorm.neo4j.Neo4jSession;
import org.grails.datastore.gorm.neo4j.Neo4jTransaction;
import org.grails.datastore.gorm.neo4j.RelationshipUtils;
import org.grails.datastore.gorm.neo4j.TypeDirectionPair;
import org.grails.datastore.gorm.neo4j.collection.Neo4jList;
import org.grails.datastore.gorm.neo4j.collection.Neo4jPersistentList;
import org.grails.datastore.gorm.neo4j.collection.Neo4jPersistentSet;
import org.grails.datastore.gorm.neo4j.collection.Neo4jPersistentSortedSet;
import org.grails.datastore.gorm.neo4j.collection.Neo4jResultList;
import org.grails.datastore.gorm.neo4j.collection.Neo4jSet;
import org.grails.datastore.gorm.neo4j.collection.Neo4jSortedSet;
import org.grails.datastore.gorm.neo4j.engine.Neo4jAssociationQueryExecutor;
import org.grails.datastore.gorm.neo4j.engine.Neo4jQuery;
import org.grails.datastore.gorm.neo4j.mapping.reflect.Neo4jNameUtils;
import org.grails.datastore.mapping.collection.PersistentCollection;
import org.grails.datastore.mapping.core.IdentityGenerationException;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.impl.PendingDelete;
import org.grails.datastore.mapping.core.impl.PendingDeleteAdapter;
import org.grails.datastore.mapping.core.impl.PendingInsert;
import org.grails.datastore.mapping.core.impl.PendingInsertAdapter;
import org.grails.datastore.mapping.core.impl.PendingOperation;
import org.grails.datastore.mapping.core.impl.PendingOperationAdapter;
import org.grails.datastore.mapping.core.impl.PendingUpdate;
import org.grails.datastore.mapping.core.impl.PendingUpdateAdapter;
import org.grails.datastore.mapping.dirty.checking.DirtyCheckable;
import org.grails.datastore.mapping.dirty.checking.DirtyCheckableCollection;
import org.grails.datastore.mapping.engine.AssociationQueryExecutor;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.EntityPersister;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.ManyToMany;
import org.grails.datastore.mapping.model.types.OneToMany;
import org.grails.datastore.mapping.model.types.OneToOne;
import org.grails.datastore.mapping.model.types.Simple;
import org.grails.datastore.mapping.model.types.ToMany;
import org.grails.datastore.mapping.model.types.ToOne;
import org.grails.datastore.mapping.proxy.EntityProxy;
import org.grails.datastore.mapping.query.Query;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Result;
import org.neo4j.helpers.collection.IteratorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.convert.ConversionService;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.util.Assert;

public class Neo4jEntityPersister
extends EntityPersister {
    public static final String DYNAMIC_ASSOCIATIONS_QUERY = "MATCH (m%s {__id__:{id}})-[r]-(o) RETURN type(r) as relType, startNode(r)=m as out, r.sourceType as sourceType, r.targetType as targetType, {ids: collect(o.__id__), labels: collect(labels(o))} as values";
    public static final String RETURN_NODE_ID = " RETURN ID(n) as id";
    private static Logger log = LoggerFactory.getLogger(Neo4jEntityPersister.class);

    public Neo4jEntityPersister(MappingContext mappingContext, PersistentEntity entity, Session session, ApplicationEventPublisher publisher) {
        super(mappingContext, entity, session, publisher);
    }

    public Neo4jSession getSession() {
        return (Neo4jSession)this.session;
    }

    protected List<Object> retrieveAllEntities(PersistentEntity pe, Serializable[] keys) {
        return this.retrieveAllEntities(pe, Arrays.asList(keys));
    }

    protected List<Object> retrieveAllEntities(PersistentEntity pe, Iterable<Serializable> keys) {
        ArrayList<Query.In> criterions = new ArrayList<Query.In>(1);
        criterions.add(new Query.In("id", IteratorUtil.asCollection(keys)));
        Query.Conjunction junction = new Query.Conjunction(criterions);
        return new Neo4jQuery(this.getSession(), pe, this).executeQuery(pe, (Query.Junction)junction);
    }

    protected List<Serializable> persistEntities(final PersistentEntity pe, Iterable objs) {
        ArrayList<Serializable> idList;
        block11: {
            block10: {
                String finalCypher;
                Result result;
                GraphPersistentEntity graphPersistentEntity = (GraphPersistentEntity)pe;
                idList = new ArrayList<Serializable>();
                if (graphPersistentEntity.getIdGenerator() != null) break block10;
                ArrayList<EntityAccess> entityAccesses = new ArrayList<EntityAccess>();
                Neo4jSession session = this.getSession();
                StringBuilder createCypher = new StringBuilder("CREATE ");
                int listIndex = 0;
                ArrayList<PendingOperation<Object, Serializable>> cascadingOperations = new ArrayList<PendingOperation<Object, Serializable>>();
                HashMap<String, Object> params = new HashMap<String, Object>(1);
                HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
                int insertIndex = 0;
                Iterator iterator = objs.iterator();
                while (iterator.hasNext()) {
                    boolean isUpdate;
                    EntityAccess entityAccess;
                    Object obj = iterator.next();
                    ++listIndex;
                    if (this.shouldIgnore(session, obj)) {
                        entityAccess = this.createEntityAccess(pe, obj);
                        idList.add((Serializable)entityAccess.getIdentifier());
                        continue;
                    }
                    entityAccess = this.createEntityAccess(pe, obj);
                    if (this.getMappingContext().getProxyFactory().isProxy(obj)) {
                        idList.add(((EntityProxy)obj).getProxyKey());
                        continue;
                    }
                    session.registerPending(obj);
                    Serializable identifier = (Serializable)entityAccess.getIdentifier();
                    boolean bl = isUpdate = identifier != null;
                    if (isUpdate) {
                        this.registerPendingUpdate(session, pe, entityAccess, obj, identifier);
                        idList.add(identifier);
                        continue;
                    }
                    PendingInsertAdapter<Object, Serializable> pendingInsert = new PendingInsertAdapter<Object, Serializable>(pe, identifier, obj, entityAccess){

                        public void run() {
                            if (Neo4jEntityPersister.this.cancelInsert(pe, entityAccess)) {
                                this.setVetoed(true);
                            }
                        }
                    };
                    pendingInsert.addCascadeOperation((PendingOperation)new PendingOperationAdapter<Object, Serializable>(pe, identifier, obj){

                        public void run() {
                            Neo4jEntityPersister.this.firePostInsertEvent(pe, entityAccess);
                        }
                    });
                    cascadingOperations.addAll(pendingInsert.getCascadeOperations());
                    List preOperations = pendingInsert.getPreOperations();
                    for (PendingOperation preOperation : preOperations) {
                        preOperation.run();
                    }
                    pendingInsert.run();
                    pendingInsert.setExecuted(true);
                    idList.add(null);
                    if (pendingInsert.isVetoed()) continue;
                    session.addPendingInsert((PendingInsert)pendingInsert);
                    indexMap.put(insertIndex++, listIndex - 1);
                    entityAccesses.add(entityAccess);
                    session.buildEntityCreateOperation(createCypher, String.valueOf(insertIndex), pe, (PendingInsert)pendingInsert, params, cascadingOperations, (Neo4jMappingContext)this.getMappingContext());
                    if (!iterator.hasNext()) continue;
                    createCypher.append(", ");
                }
                if (insertIndex <= 0) break block11;
                GraphDatabaseService graphDatabaseService = session.getNativeInterface();
                if (log.isDebugEnabled()) {
                    log.debug("CREATE Cypher [{}] for parameters [{}]", (Object)createCypher, params);
                }
                if (!(result = graphDatabaseService.execute(finalCypher = createCypher.toString() + " RETURN *", params)).hasNext()) {
                    throw new IdentityGenerationException("CREATE operation did not generate an identifier for entity " + pe.getJavaClass());
                }
                Map resultMap = (Map)IteratorUtil.singleOrNull((Iterator)result);
                for (int j = 0; j < insertIndex; ++j) {
                    Integer targetIndex = (Integer)indexMap.get(j);
                    Assert.notNull((Object)targetIndex, (String)"Should never be null. Please file an issue");
                    Node node = (Node)resultMap.get("n" + (j + 1));
                    if (node == null) {
                        throw new IdentityGenerationException("CREATE operation did not generate an identifier for entity " + pe.getJavaClass());
                    }
                    long identifier = node.getId();
                    EntityAccess entityAccess = (EntityAccess)entityAccesses.get(j);
                    entityAccess.setIdentifier((Object)identifier);
                    idList.set(targetIndex, Long.valueOf(identifier));
                    this.persistAssociationsOfEntity(pe, entityAccess, false);
                }
                break block11;
            }
            for (Object obj : objs) {
                idList.add(this.persistEntity(pe, obj));
            }
        }
        return idList;
    }

    protected Object retrieveEntity(PersistentEntity pe, Serializable key) {
        GraphPersistentEntity graphPersistentEntity = (GraphPersistentEntity)pe;
        if (graphPersistentEntity.getIdGenerator() == null) {
            this.getSession().assertTransaction();
            Neo4jSession session = this.getSession();
            ConversionService conversionService = this.getMappingContext().getConversionService();
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Retrieving entity [{}] by node id [{}]", (Object)pe.getJavaClass(), (Object)key);
                }
                Node node = session.getNativeInterface().getNodeById(((Long)conversionService.convert((Object)key, Long.class)).longValue());
                return this.unmarshallOrFromCache(pe, node);
            }
            catch (NotFoundException e) {
                return null;
            }
        }
        Neo4jQuery query = new Neo4jQuery(this.getSession(), pe, this);
        query.idEq(key);
        return IteratorUtil.singleOrNull(query.max(1).list().iterator());
    }

    public Object unmarshallOrFromCache(PersistentEntity defaultPersistentEntity, Map<String, Object> resultData) {
        Node data = (Node)resultData.get("data");
        return this.unmarshallOrFromCache(defaultPersistentEntity, data, resultData);
    }

    public Object unmarshallOrFromCache(PersistentEntity defaultPersistentEntity, Node data) {
        return this.unmarshallOrFromCache(defaultPersistentEntity, data, Collections.emptyMap());
    }

    public Object unmarshallOrFromCache(PersistentEntity defaultPersistentEntity, Node data, Map<String, Object> resultData) {
        return this.unmarshallOrFromCache(defaultPersistentEntity, data, resultData, Collections.emptyMap());
    }

    public Object unmarshallOrFromCache(PersistentEntity defaultPersistentEntity, Node data, Map<String, Object> resultData, Map<Association, Object> initializedAssociations) {
        return this.unmarshallOrFromCache(defaultPersistentEntity, data, resultData, initializedAssociations, LockModeType.NONE);
    }

    public Object unmarshallOrFromCache(PersistentEntity defaultPersistentEntity, Node data, Map<String, Object> resultData, Map<Association, Object> initializedAssociations, LockModeType lockModeType) {
        Neo4jSession session = this.getSession();
        Neo4jTransaction neo4jTransaction = session.assertTransaction();
        if (LockModeType.PESSIMISTIC_WRITE.equals((Object)lockModeType)) {
            if (log.isDebugEnabled()) {
                log.debug("Locking entity [{}] node [{}] for pessimistic write", (Object)defaultPersistentEntity.getName(), (Object)data.getId());
            }
            neo4jTransaction.getTransaction().acquireWriteLock((PropertyContainer)data);
        }
        Iterable labels = data.getLabels();
        GraphPersistentEntity graphPersistentEntity = (GraphPersistentEntity)defaultPersistentEntity;
        PersistentEntity persistentEntity = this.mostSpecificPersistentEntity(defaultPersistentEntity, labels);
        Serializable id = graphPersistentEntity.getIdGenerator() == null ? Long.valueOf(data.getId()) : (Serializable)data.getProperty("__id__");
        Object instance = session.getCachedInstance(persistentEntity.getJavaClass(), id);
        if (instance == null) {
            instance = this.unmarshall(persistentEntity, id, data, resultData, initializedAssociations);
        }
        return instance;
    }

    private PersistentEntity mostSpecificPersistentEntity(PersistentEntity pe, Iterable<Label> labels) {
        PersistentEntity result = null;
        int longestInheritenceChain = -1;
        for (Label l : labels) {
            int inheritenceChain;
            PersistentEntity persistentEntity = this.findDerivedPersistentEntityWithLabel(pe, l.name());
            if (persistentEntity == null || (inheritenceChain = this.calcInheritenceChain(persistentEntity)) <= longestInheritenceChain) continue;
            longestInheritenceChain = inheritenceChain;
            result = persistentEntity;
        }
        if (result != null) {
            return result;
        }
        return pe;
    }

    private PersistentEntity findDerivedPersistentEntityWithLabel(PersistentEntity parent, String label) {
        for (PersistentEntity pe : this.getMappingContext().getPersistentEntities()) {
            if (!this.isInParentsChain(parent, pe) || !((GraphPersistentEntity)pe).getLabels().contains(label)) continue;
            return pe;
        }
        return null;
    }

    private boolean isInParentsChain(PersistentEntity parent, PersistentEntity it) {
        if (it == null) {
            return false;
        }
        if (it.equals(parent)) {
            return true;
        }
        return this.isInParentsChain(parent, it.getParentEntity());
    }

    private int calcInheritenceChain(PersistentEntity current) {
        if (current == null) {
            return 0;
        }
        return this.calcInheritenceChain(current.getParentEntity()) + 1;
    }

    protected Object unmarshall(PersistentEntity persistentEntity, Serializable id, Node node, Map<String, Object> resultData, Map<Association, Object> initializedAssociations) {
        if (log.isDebugEnabled()) {
            log.debug("unmarshalling entity [{}] with id [{}], props {}, {}", new Object[]{persistentEntity.getName(), id, node});
        }
        Neo4jSession session = this.getSession();
        GraphPersistentEntity graphPersistentEntity = (GraphPersistentEntity)persistentEntity;
        EntityAccess entityAccess = session.createEntityAccess(persistentEntity, persistentEntity.newInstance());
        entityAccess.setIdentifierNoConversion((Object)id);
        Object entity = entityAccess.getEntity();
        this.getSession().cacheInstance(persistentEntity.getJavaClass(), id, entity);
        HashMap<TypeDirectionPair, Map<String, Collection>> relationshipsMap = new HashMap<TypeDirectionPair, Map<String, Collection>>();
        boolean hasDynamicAssociations = graphPersistentEntity.hasDynamicAssociations();
        if (hasDynamicAssociations) {
            String cypher = String.format(DYNAMIC_ASSOCIATIONS_QUERY, ((GraphPersistentEntity)persistentEntity).getLabelsAsString());
            Map<String, Serializable> isMap = Collections.singletonMap("id", id);
            GraphDatabaseService graphDatabaseService = this.getSession().getNativeInterface();
            if (log.isDebugEnabled()) {
                log.debug("QUERY Cypher [{}] for parameters [{}]", (Object)cypher, (Object)isMap);
            }
            Result result = graphDatabaseService.execute(cypher, (Map)isMap);
            while (result.hasNext()) {
                Object targetType;
                Map row = result.next();
                String relType = (String)row.get("relType");
                Boolean outGoing = (Boolean)row.get("out");
                Map values = (Map)row.get("values");
                TypeDirectionPair key = new TypeDirectionPair(relType, outGoing);
                if (row.containsKey("targetType") && (targetType = row.get("targetType")) != null) {
                    key.setTargetType(targetType.toString());
                }
                relationshipsMap.put(key, values);
            }
        }
        List nodeProperties = DefaultGroovyMethods.toList((Iterable)node.getPropertyKeys());
        for (Object property : entityAccess.getPersistentEntity().getPersistentProperties()) {
            String string = property.getName();
            if (property instanceof Simple) {
                if (!node.hasProperty(string)) continue;
                entityAccess.setProperty(string, node.getProperty(string));
                nodeProperties.remove(string);
                continue;
            }
            if (property instanceof Association) {
                GroovyObject values;
                Class type;
                Association association = (Association)property;
                String associationName = association.getName();
                if (initializedAssociations.containsKey(association)) {
                    entityAccess.setPropertyNoConversion(associationName, initializedAssociations.get(association));
                    this.removeFromRelationshipMap(association, relationshipsMap);
                    continue;
                }
                if (hasDynamicAssociations) {
                    this.removeFromRelationshipMap(association, relationshipsMap);
                }
                String associationNodesKey = associationName + "Nodes";
                String associationIdsKey = associationName + "Ids";
                if (resultData.containsKey(associationNodesKey)) {
                    Association inverseSide;
                    Iterable associationNodes;
                    if (association instanceof ToOne) {
                        PersistentEntity associatedEntity = association.getAssociatedEntity();
                        Neo4jEntityPersister associationPersister = this.getSession().getEntityPersister(associatedEntity.getJavaClass());
                        associationNodes = (Iterable)resultData.get(associationNodesKey);
                        Node associationNode = (Node)IteratorUtil.singleOrNull((Iterable)associationNodes);
                        if (associationNode == null) continue;
                        entityAccess.setPropertyNoConversion(associationName, associationPersister.unmarshallOrFromCache(associatedEntity, associationNode));
                        continue;
                    }
                    if (!(association instanceof ToMany)) continue;
                    type = association.getType();
                    associationNodes = (Collection)resultData.get(associationNodesKey);
                    Neo4jResultList resultSet = new Neo4jResultList(0, associationNodes.size(), associationNodes.iterator(), session.getEntityPersister(association.getAssociatedEntity()));
                    if (association.isBidirectional() && (inverseSide = association.getInverseSide()) instanceof ToOne) {
                        resultSet.setInitializedAssociations(Collections.singletonMap(inverseSide, entity));
                    }
                    values = List.class.isAssignableFrom(type) ? new Neo4jList(entityAccess, association, (List)((Object)resultSet), session) : (SortedSet.class.isAssignableFrom(type) ? new Neo4jSortedSet(entityAccess, association, new TreeSet(resultSet), session) : new Neo4jSet(entityAccess, association, new HashSet(resultSet), session));
                    entityAccess.setPropertyNoConversion(string, (Object)values);
                    continue;
                }
                if (resultData.containsKey(associationIdsKey)) {
                    Object associationValues = resultData.get(associationIdsKey);
                    List targetIds = Collections.emptyList();
                    if (associationValues instanceof Collection) {
                        targetIds = (List)associationValues;
                    }
                    if (association instanceof ToOne) {
                        Serializable targetId;
                        ToOne toOne = (ToOne)association;
                        if (targetIds.isEmpty()) continue;
                        try {
                            targetId = (Serializable)IteratorUtil.single((Iterable)targetIds);
                        }
                        catch (NoSuchElementException e) {
                            throw new DataIntegrityViolationException("Single-ended association has more than one associated identifier: " + association);
                        }
                        entityAccess.setPropertyNoConversion(string, this.getMappingContext().getProxyFactory().createProxy(this.session, toOne.getAssociatedEntity().getJavaClass(), targetId));
                        continue;
                    }
                    if (association instanceof ToMany) {
                        GroovyObject values2;
                        Class type2 = association.getType();
                        if (List.class.isAssignableFrom(type2)) {
                            Neo4jPersistentList values22 = new Neo4jPersistentList(targetIds, session, entityAccess, (ToMany)association);
                        } else {
                            values2 = SortedSet.class.isAssignableFrom(type2) ? new Neo4jPersistentSortedSet(targetIds, session, entityAccess, (ToMany)association) : new Neo4jPersistentSet(targetIds, session, entityAccess, (ToMany)association);
                        }
                        entityAccess.setPropertyNoConversion(string, (Object)values2);
                        continue;
                    }
                    throw new IllegalArgumentException("association " + associationName + " is of type " + association.getClass().getSuperclass().getName());
                }
                if (association instanceof ToOne) {
                    Neo4jAssociationQueryExecutor associationQueryExecutor = new Neo4jAssociationQueryExecutor(session, association);
                    if (association.getMapping().getMappedForm().isLazy()) {
                        Object proxy = this.getMappingContext().getProxyFactory().createProxy(this.session, (AssociationQueryExecutor)associationQueryExecutor, id);
                        entityAccess.setPropertyNoConversion(string, proxy);
                        continue;
                    }
                    List<Object> results = associationQueryExecutor.query(id);
                    if (results.isEmpty()) continue;
                    entityAccess.setPropertyNoConversion(string, results.get(0));
                    continue;
                }
                if (!(association instanceof ToMany)) continue;
                type = association.getType();
                values = List.class.isAssignableFrom(type) ? new Neo4jPersistentList(id, session, entityAccess, (ToMany)association) : (SortedSet.class.isAssignableFrom(type) ? new Neo4jPersistentSortedSet(id, session, entityAccess, (ToMany)association) : new Neo4jPersistentSet(id, session, entityAccess, (ToMany)association));
                entityAccess.setPropertyNoConversion(string, (Object)values);
                continue;
            }
            throw new IllegalArgumentException("property " + property.getName() + " is of type " + property.getClass().getSuperclass().getName());
        }
        LinkedHashMap<String, Object> undeclared = new LinkedHashMap<String, Object>();
        if (!relationshipsMap.isEmpty()) {
            for (Map.Entry entry : relationshipsMap.entrySet()) {
                TypeDirectionPair key = (TypeDirectionPair)entry.getKey();
                if (!key.isOutgoing()) continue;
                Map relationshipData = (Map)entry.getValue();
                Iterator idIter = ((Collection)relationshipData.get("ids")).iterator();
                String targetType = key.getTargetType();
                Iterator labelIter = ((Collection)relationshipData.get("labels")).iterator();
                ArrayList<Object> values = new ArrayList<Object>();
                while (idIter.hasNext() && labelIter.hasNext()) {
                    Serializable targetId = (Serializable)idIter.next();
                    List<String> nextLabels = (List<String>)labelIter.next();
                    List<String> labels = targetType != null ? Collections.singletonList(targetType) : nextLabels;
                    Object proxy = this.getMappingContext().getProxyFactory().createProxy(this.session, ((Neo4jMappingContext)this.getMappingContext()).findPersistentEntityForLabels(labels).getJavaClass(), targetId);
                    values.add(proxy);
                }
                ArrayList<Object> value = values.size() == 1 && this.isSingular(key.getType()) ? IteratorUtil.single(values) : values;
                undeclared.put(key.getType(), value);
            }
        }
        if (!nodeProperties.isEmpty()) {
            for (String string : nodeProperties) {
                if (string.equals("__id__")) continue;
                undeclared.put(string, node.getProperty(string));
            }
        }
        Object obj = entity;
        if (!undeclared.isEmpty()) {
            this.getSession().setAttribute(obj, "_neo4j_gorm_undecl_", undeclared);
        }
        this.firePostLoadEvent(entityAccess.getPersistentEntity(), entityAccess);
        return obj;
    }

    private void removeFromRelationshipMap(Association association, Map<TypeDirectionPair, Map<String, Collection>> relationshipsMap) {
        TypeDirectionPair typeDirectionPair = new TypeDirectionPair(RelationshipUtils.relationshipTypeUsedFor(association), !RelationshipUtils.useReversedMappingFor(association));
        relationshipsMap.remove(typeDirectionPair);
    }

    private Collection createCollection(Association association) {
        return association.isList() ? new ArrayList() : new HashSet();
    }

    private Collection createDirtyCheckableAwareCollection(EntityAccess entityAccess, Association association, Collection delegate) {
        if (delegate == null) {
            delegate = this.createCollection(association);
        }
        if (!(delegate instanceof DirtyCheckableCollection)) {
            Object entity = entityAccess.getEntity();
            if (entity instanceof DirtyCheckable) {
                Neo4jSession session = this.getSession();
                for (Object o : delegate) {
                    EntityAccess associationAccess = this.getSession().createEntityAccess(association.getAssociatedEntity(), o);
                    session.addPendingRelationshipInsert((Serializable)entityAccess.getIdentifier(), association, (Serializable)associationAccess.getIdentifier());
                }
                delegate = association.isList() ? new Neo4jList(entityAccess, association, (List)delegate, session) : new Neo4jSet(entityAccess, association, (Set)delegate, session);
            }
        } else {
            DirtyCheckableCollection dirtyCheckableCollection = (DirtyCheckableCollection)delegate;
            Neo4jSession session = this.getSession();
            if (dirtyCheckableCollection.hasChanged()) {
                for (Object o : (Iterable)dirtyCheckableCollection) {
                    EntityAccess associationAccess = this.getSession().createEntityAccess(association.getAssociatedEntity(), o);
                    session.addPendingRelationshipInsert((Serializable)entityAccess.getIdentifier(), association, (Serializable)associationAccess.getIdentifier());
                }
            }
        }
        return delegate;
    }

    private boolean isSingular(String key) {
        return Neo4jNameUtils.isSingular(key);
    }

    protected Serializable persistEntity(final PersistentEntity pe, Object obj) {
        boolean isUpdate;
        if (obj == null) {
            throw new IllegalStateException("obj is null");
        }
        Neo4jSession session = this.getSession();
        if (this.shouldIgnore(session, obj)) {
            EntityAccess entityAccess = this.createEntityAccess(pe, obj);
            return (Serializable)entityAccess.getIdentifier();
        }
        if (this.getMappingContext().getProxyFactory().isProxy(obj)) {
            return ((EntityProxy)obj).getProxyKey();
        }
        final EntityAccess entityAccess = this.createEntityAccess(pe, obj);
        Object identifier = entityAccess.getIdentifier();
        session.registerPending(obj);
        boolean bl = isUpdate = identifier != null;
        if (isUpdate) {
            this.registerPendingUpdate(session, pe, entityAccess, obj, (Serializable)identifier);
        } else {
            boolean isNativeId;
            GraphPersistentEntity graphPersistentEntity = (GraphPersistentEntity)pe;
            IdGenerator idGenerator = graphPersistentEntity.getIdGenerator();
            boolean bl2 = isNativeId = idGenerator == null;
            if (!isNativeId) {
                identifier = idGenerator.nextId();
                entityAccess.setIdentifier(identifier);
            }
            PendingInsertAdapter<Object, Serializable> pendingInsert = new PendingInsertAdapter<Object, Serializable>(pe, (Serializable)identifier, obj, entityAccess){

                public void run() {
                    if (Neo4jEntityPersister.this.cancelInsert(pe, entityAccess)) {
                        this.setVetoed(true);
                    }
                }
            };
            pendingInsert.addCascadeOperation((PendingOperation)new PendingOperationAdapter<Object, Serializable>(pe, (Serializable)identifier, obj){

                public void run() {
                    Neo4jEntityPersister.this.firePostInsertEvent(pe, entityAccess);
                }
            });
            if (isNativeId) {
                Result result;
                List preOperations = pendingInsert.getPreOperations();
                for (PendingOperation preOperation : preOperations) {
                    preOperation.run();
                }
                pendingInsert.run();
                pendingInsert.setExecuted(true);
                if (pendingInsert.isVetoed()) {
                    return null;
                }
                HashMap<String, Object> params = new HashMap<String, Object>(1);
                String cypher = session.buildEntityCreateOperation(pe, (PendingInsert)pendingInsert, params, pendingInsert.getCascadeOperations());
                GraphDatabaseService graphDatabaseService = session.getNativeInterface();
                String finalCypher = cypher + RETURN_NODE_ID;
                if (log.isDebugEnabled()) {
                    log.debug("CREATE Cypher [{}] for parameters [{}]", (Object)finalCypher, params);
                }
                if (!(result = graphDatabaseService.execute(finalCypher, params)).hasNext()) {
                    throw new IdentityGenerationException("CREATE operation did not generate an identifier for entity " + entityAccess.getEntity());
                }
                Map idMap = (Map)IteratorUtil.singleOrNull((Iterator)result);
                if (idMap != null) {
                    identifier = idMap.get("id");
                    if (identifier == null) {
                        throw new IdentityGenerationException("CREATE operation did not generate an identifier for entity " + entityAccess.getEntity());
                    }
                } else {
                    throw new IdentityGenerationException("CREATE operation did not generate an identifier for entity " + entityAccess.getEntity());
                }
                entityAccess.setIdentifier(identifier);
                this.persistAssociationsOfEntity(pe, entityAccess, false);
                session.addPendingInsert((PendingInsert)pendingInsert);
            } else {
                session.addPendingInsert((PendingInsert)pendingInsert);
                this.persistAssociationsOfEntity(pe, entityAccess, false);
            }
        }
        return (Serializable)identifier;
    }

    private void registerPendingUpdate(Neo4jSession session, final PersistentEntity pe, final EntityAccess entityAccess, Object obj, Serializable identifier) {
        PendingUpdateAdapter<Object, Serializable> pendingUpdate = new PendingUpdateAdapter<Object, Serializable>(pe, identifier, obj, entityAccess){

            public void run() {
                if (Neo4jEntityPersister.this.cancelUpdate(pe, entityAccess)) {
                    this.setVetoed(true);
                }
            }
        };
        pendingUpdate.addCascadeOperation((PendingOperation)new PendingOperationAdapter<Object, Serializable>(pe, identifier, obj){

            public void run() {
                Neo4jEntityPersister.this.firePostUpdateEvent(pe, entityAccess);
            }
        });
        session.addPendingUpdate((PendingUpdate)pendingUpdate);
        this.persistAssociationsOfEntity(pe, entityAccess, true);
    }

    private boolean shouldIgnore(Neo4jSession session, Object obj) {
        boolean isDirty = obj instanceof DirtyCheckable ? ((DirtyCheckable)obj).hasChanged() : true;
        return session.isPendingAlready(obj) || !isDirty;
    }

    private void persistAssociationsOfEntity(PersistentEntity pe, EntityAccess entityAccess, boolean isUpdate) {
        Object obj = entityAccess.getEntity();
        DirtyCheckable dirtyCheckable = null;
        if (obj instanceof DirtyCheckable) {
            dirtyCheckable = (DirtyCheckable)obj;
        }
        for (PersistentProperty pp : pe.getAssociations()) {
            if (isUpdate && (dirtyCheckable == null || !dirtyCheckable.hasChanged(pp.getName()))) continue;
            Object propertyValue = entityAccess.getProperty(pp.getName());
            if (pp instanceof OneToMany || pp instanceof ManyToMany) {
                Object pc;
                Association association = (Association)pp;
                if (propertyValue == null || propertyValue instanceof PersistentCollection && !(pc = (PersistentCollection)propertyValue).isInitialized()) continue;
                if (association.isBidirectional()) {
                    pc = ((Iterable)propertyValue).iterator();
                    while (pc.hasNext()) {
                        Object associatedObject = pc.next();
                        EntityAccess assocEntityAccess = this.createEntityAccess(association.getAssociatedEntity(), associatedObject);
                        String referencedPropertyName = association.getReferencedPropertyName();
                        if (association instanceof ManyToMany) {
                            ((GormEntity)associatedObject).addTo(referencedPropertyName, obj);
                            continue;
                        }
                        assocEntityAccess.setPropertyNoConversion(referencedPropertyName, obj);
                        ((DirtyCheckable)associatedObject).markDirty(referencedPropertyName);
                    }
                }
                Collection targets = (Collection)propertyValue;
                this.persistEntities(association.getAssociatedEntity(), targets);
                boolean reversed = RelationshipUtils.useReversedMappingFor(association);
                if (reversed) continue;
                Collection dcc = this.createDirtyCheckableAwareCollection(entityAccess, association, targets);
                entityAccess.setProperty(association.getName(), (Object)dcc);
                continue;
            }
            if (pp instanceof ToOne) {
                if (propertyValue == null) continue;
                ToOne to = (ToOne)pp;
                if (to.isBidirectional()) {
                    EntityAccess assocEntityAccess = this.createEntityAccess(to.getAssociatedEntity(), propertyValue);
                    if (to instanceof OneToOne) {
                        assocEntityAccess.setProperty(to.getReferencedPropertyName(), obj);
                    } else {
                        ArrayList<Object> collection = (ArrayList<Object>)assocEntityAccess.getProperty(to.getReferencedPropertyName());
                        if (collection == null) {
                            collection = new ArrayList<Object>();
                            assocEntityAccess.setProperty(to.getReferencedPropertyName(), collection);
                        }
                        if (!collection.contains(obj)) {
                            collection.add(obj);
                        }
                    }
                }
                this.persistEntity(to.getAssociatedEntity(), propertyValue);
                boolean reversed = RelationshipUtils.useReversedMappingFor((Association)to);
                if (reversed) continue;
                EntityAccess assocationAccess = this.getSession().createEntityAccess(to.getAssociatedEntity(), propertyValue);
                this.getSession().addPendingRelationshipInsert((Serializable)entityAccess.getIdentifier(), (Association)to, (Serializable)assocationAccess.getIdentifier());
                continue;
            }
            throw new IllegalArgumentException("wtf don't know how to handle " + pp + "(" + pp.getClass() + ")");
        }
    }

    protected void deleteEntity(final PersistentEntity pe, Object obj) {
        final EntityAccess entityAccess = this.createEntityAccess(pe, obj);
        Neo4jSession session = this.getSession();
        session.clear(obj);
        PendingDeleteAdapter pendingDelete = this.createPendingDeleteOne(session, pe, entityAccess, obj);
        pendingDelete.addCascadeOperation((PendingOperation)new PendingOperationAdapter<Object, Serializable>(pe, (Serializable)entityAccess.getIdentifier(), obj){

            public void run() {
                Neo4jEntityPersister.this.firePostDeleteEvent(pe, entityAccess);
            }
        });
        session.addPendingDelete((PendingDelete)pendingDelete);
    }

    private PendingDeleteAdapter createPendingDeleteOne(Neo4jSession session, final PersistentEntity pe, final EntityAccess entityAccess, Object obj) {
        return new PendingDeleteAdapter(pe, entityAccess.getIdentifier(), obj){

            public void run() {
                if (Neo4jEntityPersister.this.cancelDelete(pe, entityAccess)) {
                    this.setVetoed(true);
                }
            }
        };
    }

    protected void deleteEntities(PersistentEntity pe, Iterable objects) {
        for (Object object : objects) {
            this.deleteEntity(pe, object);
        }
    }

    public Query createQuery() {
        return new Neo4jQuery(this.getSession(), this.getPersistentEntity(), this);
    }

    public Serializable refresh(Object o) {
        throw new UnsupportedOperationException();
    }
}

