/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j;

import java.io.IOException;
import javax.persistence.FlushModeType;
import org.grails.datastore.gorm.neo4j.Neo4jSession;
import org.grails.datastore.gorm.neo4j.Neo4jTransaction;
import org.grails.datastore.mapping.core.DatastoreUtils;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.transactions.DatastoreTransactionManager;
import org.grails.datastore.mapping.transactions.Transaction;
import org.grails.datastore.mapping.transactions.TransactionObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class Neo4jDatastoreTransactionManager
extends DatastoreTransactionManager {
    private static final Logger log = LoggerFactory.getLogger(Neo4jDatastoreTransactionManager.class);

    protected void doSetRollbackOnly(DefaultTransactionStatus status) throws TransactionException {
        super.doSetRollbackOnly(status);
        TransactionObject txObject = (TransactionObject)status.getTransaction();
        Neo4jTransaction neo4jTransaction = (Neo4jTransaction)txObject.getTransaction();
        neo4jTransaction.rollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        super.doCleanupAfterCompletion(transaction);
        TransactionObject txObject = (TransactionObject)transaction;
        Neo4jTransaction neo4jTransaction = (Neo4jTransaction)txObject.getTransaction();
        if (!neo4jTransaction.isSessionCreated()) {
            try {
                neo4jTransaction.close();
            }
            catch (IOException e) {
                log.warn("Error closing transaction: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doBegin(Object o, TransactionDefinition definition) throws TransactionException {
        TransactionObject txObject = (TransactionObject)o;
        Neo4jSession session = null;
        try {
            session = (Neo4jSession)txObject.getSessionHolder().getSession();
            if (definition.isReadOnly()) {
                session.setFlushMode(FlushModeType.COMMIT);
            }
            Transaction tx = session.beginTransaction(definition);
            int timeout = this.determineTimeout(definition);
            if (timeout != -1) {
                tx.setTimeout(timeout);
            }
            txObject.setTransaction(tx);
            if (txObject.isNewSessionHolder()) {
                TransactionSynchronizationManager.bindResource((Object)this.getDatastore(), (Object)txObject.getSessionHolder());
            }
            txObject.getSessionHolder().setSynchronizedWithTransaction(true);
            session.setSynchronizedWithTransaction(true);
        }
        catch (Exception ex) {
            if (txObject.isNewSession()) {
                try {
                    if (session != null && session.getTransaction().isActive()) {
                        session.getTransaction().rollback();
                    }
                }
                catch (Throwable ex2) {
                    this.logger.debug((Object)"Could not rollback Session after failed transaction begin", (Throwable)ex);
                }
                finally {
                    DatastoreUtils.closeSession((Session)session);
                }
            }
            throw new CannotCreateTransactionException("Could not open Datastore Session for transaction", (Throwable)ex);
        }
    }

    protected boolean isExistingTransaction(Object transaction) throws TransactionException {
        TransactionObject txObject = (TransactionObject)transaction;
        Neo4jTransaction tx = txObject == null ? null : (Neo4jTransaction)txObject.getTransaction();
        return tx != null && tx.isActive() && !tx.isSessionCreated();
    }
}

