/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j.engine;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.gorm.neo4j.CypherBuilder;
import org.grails.datastore.gorm.neo4j.GraphPersistentEntity;
import org.grails.datastore.gorm.neo4j.Neo4jSession;
import org.grails.datastore.gorm.neo4j.collection.Neo4jResultList;
import org.grails.datastore.gorm.neo4j.engine.Neo4jQuery;
import org.grails.datastore.mapping.engine.AssociationQueryExecutor;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.config.GormProperties;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.ToOne;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Neo4jAssociationQueryExecutor
implements AssociationQueryExecutor<Serializable, Object>,
GroovyObject {
    private final Neo4jSession session;
    private final PersistentEntity indexedEntity;
    private final Association association;
    private final boolean lazy;
    private final boolean singleResult;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    /*
     * WARNING - void declaration
     */
    public Neo4jAssociationQueryExecutor(Neo4jSession neo4jSession, Association association, boolean bl, boolean bl2) {
        void singleResult;
        void lazy;
        void association2;
        PersistentEntity persistentEntity;
        void session;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var6_6 = session;
        this.session = var6_6;
        this.indexedEntity = persistentEntity = association2.getAssociatedEntity();
        void var8_8 = association2;
        this.association = var8_8;
        void var9_9 = lazy;
        this.lazy = var9_9;
        void var10_10 = singleResult;
        this.singleResult = var10_10;
    }

    public Neo4jAssociationQueryExecutor(Neo4jSession session, Association association, boolean lazy) {
        this(session, association, lazy, false);
    }

    public Neo4jAssociationQueryExecutor(Neo4jSession session, Association association) {
        this(session, association, false, false);
    }

    public boolean doesReturnKeys() {
        return false;
    }

    public List<Object> query(Serializable primaryKey) {
        Object v1;
        Object v0;
        GraphDatabaseService graphDatabaseService = this.session.getNativeInterface();
        String relType = Neo4jQuery.matchForAssociation(this.association);
        GraphPersistentEntity parent = (GraphPersistentEntity)((Object)ScriptBytecodeAdapter.castToType((Object)this.association.getOwner(), GraphPersistentEntity.class));
        GraphPersistentEntity related = (GraphPersistentEntity)((Object)ScriptBytecodeAdapter.castToType((Object)this.indexedEntity, GraphPersistentEntity.class));
        String relationship = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{parent.getLabelsAsString(), relType, related.getLabelsAsString()}, new String[]{"(from", ")", "(to", ")"}));
        StringBuilder cypher = new StringBuilder((CharSequence)new GStringImpl(new Object[]{relationship}, new String[]{"MATCH ", " WHERE "}));
        if (parent.getIdGenerator() == null) {
            cypher.append("ID(from) = {id} RETURN ");
        } else {
            cypher.append((CharSequence)new GStringImpl(new Object[]{CypherBuilder.IDENTIFIER}, new String[]{"from.", " = {id}  RETURN "}));
        }
        if (this.lazy) {
            if (related.getIdGenerator() == null) {
                cypher.append("ID(to) as id");
            } else {
                cypher.append((CharSequence)new GStringImpl(new Object[]{CypherBuilder.IDENTIFIER}, new String[]{"to.", " as id"}));
            }
        } else {
            cypher.append("to as data");
        }
        cypher.append(this.singleResult ? "LIMIT 1" : "");
        Map<String, Serializable> params = Collections.singletonMap(GormProperties.IDENTITY, primaryKey);
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.association, relationship}, new String[]{"Lazy loading association [", "] using relationship ", ""})));
            v0 = null;
        } else {
            v0 = null;
        }
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{cypher, params}, new String[]{"QUERY Cypher [", "] for params [", "]"})));
            v1 = null;
        } else {
            v1 = null;
        }
        Result result = graphDatabaseService.execute(cypher.toString(), params);
        if (this.isLazy()) {
            List results = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            while (result.hasNext()) {
                Object id = result.next().get(GormProperties.IDENTITY);
                if (!(id instanceof Long)) continue;
                results.add(this.session.proxy(related.getJavaClass(), (Serializable)ScriptBytecodeAdapter.castToType(id, Serializable.class)));
            }
            return results;
        }
        Neo4jResultList resultList = new Neo4jResultList(0, result, this.session.getEntityPersister((Object)related));
        if (this.association.isBidirectional()) {
            Association inverseSide = this.association.getInverseSide();
            if (inverseSide instanceof ToOne) {
                Object parentObject = this.session.getCachedInstance(this.association.getOwner().getJavaClass(), primaryKey);
                if (parentObject != null) {
                    resultList.setInitializedAssociations(Collections.singletonMap(inverseSide, parentObject));
                }
            }
        }
        return resultList;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Neo4jAssociationQueryExecutor.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"org.grails.datastore.gorm.neo4j.engine.Neo4jAssociationQueryExecutor");
    }

    public final Neo4jSession getSession() {
        return this.session;
    }

    public final PersistentEntity getIndexedEntity() {
        return this.indexedEntity;
    }

    public final Association getAssociation() {
        return this.association;
    }

    public final boolean getLazy() {
        return this.lazy;
    }

    public final boolean isLazy() {
        return this.lazy;
    }

    public final boolean getSingleResult() {
        return this.singleResult;
    }

    public final boolean isSingleResult() {
        return this.singleResult;
    }
}

