/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j.identity;

import java.io.Serializable;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Random;
import org.grails.datastore.gorm.neo4j.IdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowflakeIdGenerator
implements IdGenerator {
    private static Logger log = LoggerFactory.getLogger(SnowflakeIdGenerator.class);
    private final long datacenterIdBits = 10L;
    private final long maxDatacenterId = 1023L;
    private final long timestampBits = 41L;
    private final long datacenterIdShift = 54L;
    private final long timestampLeftShift = 13L;
    private final long sequenceMax = 4096L;
    private final long twepoch = 1288834974657L;
    private final long datacenterId = this.getDatacenterId();
    private volatile long lastTimestamp = -1L;
    private volatile long sequence = 0L;

    public SnowflakeIdGenerator() {
        if (this.datacenterId > 1023L || this.datacenterId < 0L) {
            throw new IllegalStateException("datacenterId > maxDatacenterId");
        }
    }

    @Override
    public synchronized Serializable nextId() {
        long timestamp = System.currentTimeMillis();
        if (timestamp < this.lastTimestamp) {
            throw new IllegalArgumentException("Clock moved backwards.  Refusing to generate id for " + (this.lastTimestamp - timestamp) + " milliseconds.");
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = (this.sequence + 1L) % 4096L;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return Long.valueOf(timestamp - 1288834974657L << 13 | this.datacenterId << 54 | this.sequence);
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = System.currentTimeMillis();
        }
        return timestamp;
    }

    protected long getDatacenterId() {
        byte[] hardwareAddress = null;
        try {
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (this.isInvalidHardwareAddress(hardwareAddress) && nics.hasMoreElements()) {
                NetworkInterface nic = nics.nextElement();
                hardwareAddress = nic.getHardwareAddress();
            }
        }
        catch (SocketException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (this.isInvalidHardwareAddress(hardwareAddress)) {
            hardwareAddress = new byte[6];
            new Random().nextBytes(hardwareAddress);
        }
        long id = (0xFFL & (long)hardwareAddress[hardwareAddress.length - 1] | 0xFF00L & (long)hardwareAddress[hardwareAddress.length - 2] << 8) >> 6;
        return id;
    }

    private boolean isInvalidHardwareAddress(byte[] hardwareAddress) {
        return hardwareAddress == null || hardwareAddress.length < 6;
    }
}

