/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.persistence.FlushModeType;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.grails.datastore.gorm.neo4j.GraphPersistentEntity;
import org.grails.datastore.gorm.neo4j.Neo4jSession;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.core.AbstractDatastore;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.StatelessDatastore;
import org.grails.datastore.mapping.graph.GraphDatastore;
import org.grails.datastore.mapping.model.DatastoreConfigurationException;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Simple;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.PropertyResolver;

public class Neo4jDatastore
extends AbstractDatastore
implements InitializingBean,
DisposableBean,
StatelessDatastore,
GraphDatastore {
    public static final String DEFAULT_LOCATION = "data/neo4j";
    public static final String SETTING_NEO4J_LOCATION = "grails.neo4j.location";
    public static final String SETTING_NEO4J_TYPE = "grails.neo4j.type";
    public static final String SETTING_NEO4J_FLUSH_MODE = "grails.neo4j.flush.mode";
    public static final String SETTING_NEO4J_USERNAME = "grails.neo4j.username";
    public static final String SETTING_NEO4J_PASSWORD = "grails.neo4j.password";
    public static final String SETTING_DEFAULT_MAPPING = "grails.neo4j.default.mapping";
    public static final String SETTING_NEO4J_DB_PROPERTIES = "grails.neo4j.options";
    public static final String DEFAULT_DATABASE_TYPE = "embedded";
    public static final String DATABASE_TYPE_HA = "ha";
    public static final String DATABASE_TYPE_REST = "rest";
    public static final String DATABASE_TYPE_IMPERMANENT = "impermanent";
    public static final String DATABASE_TYPE_EMBEDDED = "embedded";
    private static Logger log = LoggerFactory.getLogger(Neo4jDatastore.class);
    protected GraphDatabaseService graphDatabaseService;
    protected boolean skipIndexSetup = false;
    protected FlushModeType defaultFlushMode = FlushModeType.AUTO;

    public Neo4jDatastore(MappingContext mappingContext, PropertyResolver configuration, ConfigurableApplicationContext applicationContext) {
        super(mappingContext, configuration, applicationContext);
        this.graphDatabaseService = this.createGraphDatabaseService(configuration);
    }

    public Neo4jDatastore(MappingContext mappingContext, PropertyResolver configuration, ConfigurableApplicationContext applicationContext, GraphDatabaseService graphDatabaseService) {
        super(mappingContext, configuration, applicationContext);
        this.graphDatabaseService = graphDatabaseService;
    }

    public Neo4jDatastore(MappingContext mappingContext, ConfigurableApplicationContext applicationContext) {
        this(mappingContext, (PropertyResolver)applicationContext.getEnvironment(), applicationContext);
    }

    public Neo4jDatastore(MappingContext mappingContext, ConfigurableApplicationContext applicationContext, GraphDatabaseService graphDatabaseService) {
        this(mappingContext, (PropertyResolver)applicationContext.getEnvironment(), applicationContext, graphDatabaseService);
    }

    protected GraphDatabaseService createGraphDatabaseService(PropertyResolver configuration) {
        GraphDatabaseFactory graphDatabaseFactory;
        this.defaultFlushMode = (FlushModeType)configuration.getProperty(SETTING_NEO4J_FLUSH_MODE, FlushModeType.class, (Object)FlushModeType.AUTO);
        String type = configuration.getProperty(SETTING_NEO4J_TYPE, "embedded");
        String location = configuration.getProperty(SETTING_NEO4J_LOCATION, DEFAULT_LOCATION);
        Map dbProperties = (Map)configuration.getProperty(SETTING_NEO4J_DB_PROPERTIES, Map.class, new LinkedHashMap());
        if (DATABASE_TYPE_HA.equalsIgnoreCase(type)) {
            try {
                graphDatabaseFactory = (GraphDatabaseFactory)Class.forName("org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory", true, Thread.currentThread().getContextClassLoader()).newInstance();
            }
            catch (Throwable e) {
                throw new DatastoreConfigurationException("Cannot load class [org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory] for HA mode. Check 'neo4j-ha' dependency is on your classpath", e);
            }
        } else {
            if (DATABASE_TYPE_REST.equalsIgnoreCase(type)) {
                if (!location.startsWith("http")) {
                    throw new DatastoreConfigurationException("The [grails.neo4j.location] setting must be an HTTP or HTTPS URL");
                }
                String username = configuration.getProperty(SETTING_NEO4J_USERNAME);
                String password = configuration.getProperty(SETTING_NEO4J_PASSWORD);
                try {
                    Class<?> restFactory = Class.forName("org.grails.datastore.gorm.neo4j.rest.GrailsCypherRestGraphDatabase", true, Thread.currentThread().getContextClassLoader());
                    boolean hasCredentials = username != null && password != null;
                    for (Object option : dbProperties.keySet()) {
                        Object value = dbProperties.get(option);
                        if (value == null) continue;
                        System.setProperty("org.neo4j.rest." + option, value.toString());
                    }
                    if (hasCredentials) {
                        return (GraphDatabaseService)DefaultGroovyMethods.newInstance(restFactory, (Object[])new String[]{location, username, password});
                    }
                    return (GraphDatabaseService)DefaultGroovyMethods.newInstance(restFactory, (Object[])new String[]{location});
                }
                catch (Throwable e) {
                    throw new DatastoreConfigurationException("Cannot load class [org.neo4j.rest.graphdb.GraphDatabaseFactory] for REST mode. Check 'neo4j-rest-graphdb' dependency is on your classpath", e);
                }
            }
            if (DATABASE_TYPE_IMPERMANENT.equalsIgnoreCase(type)) {
                try {
                    graphDatabaseFactory = (GraphDatabaseFactory)Class.forName("org.neo4j.test.TestGraphDatabaseFactory", true, Thread.currentThread().getContextClassLoader()).newInstance();
                }
                catch (Throwable e) {
                    throw new DatastoreConfigurationException("Cannot load class [org.neo4j.test.TestGraphDatabaseFactory] for impermanent mode. Check 'neo4j-kernel' (classifier: 'tests') dependency is on your classpath", e);
                }
            } else if ("embedded".equalsIgnoreCase(type)) {
                graphDatabaseFactory = new GraphDatabaseFactory();
            } else {
                try {
                    return (GraphDatabaseService)Class.forName(type, true, Thread.currentThread().getContextClassLoader()).newInstance();
                }
                catch (Throwable e) {
                    throw new DatastoreConfigurationException("Cannot load class GraphDatabaseService for type [" + type + "]: " + e.getMessage(), e);
                }
            }
        }
        GraphDatabaseBuilder graphDatabaseBuilder = graphDatabaseFactory.newEmbeddedDatabaseBuilder(location);
        if (!dbProperties.containsKey(GraphDatabaseSettings.cache_type.name())) {
            graphDatabaseBuilder.setConfig(GraphDatabaseSettings.cache_type, "soft");
        }
        graphDatabaseBuilder.setConfig(dbProperties);
        return graphDatabaseBuilder.newGraphDatabase();
    }

    public void setSkipIndexSetup(boolean skipIndexSetup) {
        this.skipIndexSetup = skipIndexSetup;
    }

    protected Session createSession(PropertyResolver connectionDetails) {
        Neo4jSession neo4jSession = new Neo4jSession((Datastore)this, this.mappingContext, (ApplicationEventPublisher)this.getApplicationContext(), false, this.graphDatabaseService);
        neo4jSession.setFlushMode(this.defaultFlushMode);
        return neo4jSession;
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.skipIndexSetup) {
            this.setupIndexing();
        }
    }

    public void setupIndexing() {
        ArrayList<String> schemaStrings = new ArrayList<String>();
        for (PersistentEntity persistentEntity : this.mappingContext.getPersistentEntities()) {
            if (persistentEntity.isExternal()) continue;
            if (log.isDebugEnabled()) {
                log.debug("Setting up indexing for entity " + persistentEntity.getName());
            }
            GraphPersistentEntity graphPersistentEntity = (GraphPersistentEntity)persistentEntity;
            for (String label : graphPersistentEntity.getLabels()) {
                StringBuilder sb = new StringBuilder();
                if (graphPersistentEntity.getIdGenerator() != null) {
                    sb.append("CREATE CONSTRAINT ON (n:").append(label).append(") ASSERT n.").append("__id__").append(" IS UNIQUE");
                    schemaStrings.add(sb.toString());
                }
                for (PersistentProperty persistentProperty : persistentEntity.getPersistentProperties()) {
                    Property mappedForm = persistentProperty.getMapping().getMappedForm();
                    if (!(persistentProperty instanceof Simple) || mappedForm == null) continue;
                    if (mappedForm.isUnique()) {
                        sb = new StringBuilder();
                        sb.append("CREATE CONSTRAINT ON (n:").append(label).append(") ASSERT n.").append(persistentProperty.getName()).append(" IS UNIQUE");
                        schemaStrings.add(sb.toString());
                        continue;
                    }
                    if (!mappedForm.isIndex()) continue;
                    sb = new StringBuilder();
                    sb.append("CREATE INDEX ON :").append(label).append("(").append(persistentProperty.getName()).append(")");
                    schemaStrings.add(sb.toString());
                    if (!log.isDebugEnabled()) continue;
                    log.debug("setting up indexing for " + label + " property " + persistentProperty.getName());
                }
            }
        }
        try (Transaction transaction = this.graphDatabaseService.beginTx();){
            for (String cypher : schemaStrings) {
                if (log.isDebugEnabled()) {
                    log.debug("CREATE INDEX Cypher [{}]", (Object)cypher);
                }
                this.graphDatabaseService.execute(cypher);
                transaction.success();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("done setting up indexes");
        }
    }

    public GraphDatabaseService getGraphDatabaseService() {
        return this.graphDatabaseService;
    }

    public void destroy() throws Exception {
        super.destroy();
        if (this.graphDatabaseService != null) {
            this.graphDatabaseService.shutdown();
        }
    }
}

