/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j.engine;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.grails.datastore.gorm.neo4j.GraphPersistentEntity;
import org.grails.datastore.gorm.neo4j.engine.Neo4jQuery;
import org.grails.datastore.mapping.core.impl.PendingOperationAdapter;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.model.types.Association;
import org.neo4j.graphdb.GraphDatabaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipPendingDelete
extends PendingOperationAdapter<Object, Serializable> {
    private static Logger log = LoggerFactory.getLogger(RelationshipPendingDelete.class);
    private final GraphDatabaseService graphDatabaseService;
    private final Association association;
    private final Collection<Serializable> targetIdentifiers;

    public RelationshipPendingDelete(EntityAccess parent, Association association, Collection<Serializable> pendingInserts, GraphDatabaseService graphDatabaseService) {
        super(parent.getPersistentEntity(), (Object)((Serializable)parent.getIdentifier()), parent.getEntity());
        this.targetIdentifiers = pendingInserts;
        this.graphDatabaseService = graphDatabaseService;
        this.association = association;
    }

    public void run() {
        boolean nativeParent;
        GraphPersistentEntity graphParent = (GraphPersistentEntity)this.getEntity();
        GraphPersistentEntity graphChild = (GraphPersistentEntity)this.association.getAssociatedEntity();
        String labelsFrom = graphParent.getLabelsAsString();
        String labelsTo = graphChild.getLabelsAsString();
        String relMatch = Neo4jQuery.matchForAssociation(this.association, "r");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(2);
        params.put("start", this.getNativeKey());
        params.put("end", this.targetIdentifiers);
        StringBuilder cypherQuery = new StringBuilder("MATCH (from").append(labelsFrom).append(")").append(relMatch).append("(to").append(labelsTo).append(") WHERE ");
        boolean bl = nativeParent = graphParent.getIdGenerator() == null;
        if (nativeParent) {
            cypherQuery.append("ID(from) = {start}");
        } else {
            cypherQuery.append("from.").append("__id__").append(" = {start}");
        }
        cypherQuery.append(" AND ");
        if (graphChild.getIdGenerator() == null) {
            cypherQuery.append(" ID(to) IN {end} ");
        } else {
            cypherQuery.append("to.").append("__id__").append(" IN {end}");
        }
        cypherQuery.append(" DELETE r");
        String cypher = cypherQuery.toString();
        if (log.isDebugEnabled()) {
            log.debug("DELETE Cypher [{}] for parameters [{}]", (Object)cypher, params);
        }
        this.graphDatabaseService.execute(cypher, params);
    }
}

