/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j.internal.tools;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.grails.datastore.gorm.neo4j.Neo4jUtils;
import org.grails.datastore.gorm.neo4j.SessionFlushedEvent;
import org.neo4j.cypher.export.DatabaseSubGraph;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.cypher.export.SubGraphExporter;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;

public class DumpGraphOnSessionFlushListener
implements ApplicationListener<SessionFlushedEvent> {
    private static Logger log = LoggerFactory.getLogger(DumpGraphOnSessionFlushListener.class);
    private final GraphDatabaseService graphDatabaseService;

    public DumpGraphOnSessionFlushListener(GraphDatabaseService graphDatabaseService) {
        this.graphDatabaseService = graphDatabaseService;
    }

    public void onApplicationEvent(SessionFlushedEvent event) {
        this.dump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        try (Transaction tx = this.graphDatabaseService.beginTx();){
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            new SubGraphExporter((SubGraph)new DatabaseSubGraph(this.graphDatabaseService)).export(printWriter);
            log.trace(writer.toString());
            log.trace("svg: " + Neo4jUtils.dumpGraphToSvg(this.graphDatabaseService));
            tx.success();
        }
        catch (Throwable e) {
            log.trace("Failed to dump graph:" + e.getMessage(), e);
        }
    }
}

