/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j.engine;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.grails.datastore.gorm.neo4j.engine.CypherResult;
import org.grails.datastore.gorm.neo4j.engine.ResultSetIterator;
import org.neo4j.graphdb.ResourceIterator;

public class JdbcCypherResult
implements CypherResult {
    private final ResultSet resultSet;

    public JdbcCypherResult(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    @Override
    public List<String> getColumns() {
        try {
            ResultSetMetaData metaData = this.resultSet.getMetaData();
            int count = metaData.getColumnCount();
            ArrayList<String> result = new ArrayList<String>(count);
            for (int i = 1; i <= count; ++i) {
                result.add(metaData.getColumnName(i));
            }
            return result;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public ResourceIterator<Map<String, Object>> iterator() {
        return new ResultSetIterator(this.resultSet);
    }
}

