/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.grails.datastore.gorm.neo4j.GraphPersistentEntity;
import org.grails.datastore.gorm.neo4j.Neo4jGormEnhancer;
import org.grails.datastore.gorm.neo4j.Neo4jUtils;
import org.grails.datastore.gorm.neo4j.engine.CypherEngine;
import org.grails.datastore.mapping.core.impl.PendingInsertAdapter;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Simple;

class NodePendingInsert
extends PendingInsertAdapter<Object, Long> {
    private CypherEngine cypherEngine;
    private MappingContext mappingContext;

    public NodePendingInsert(Long nativeKey, EntityAccess ea, CypherEngine cypherEngine, MappingContext mappingContext) {
        super(ea.getPersistentEntity(), (Object)nativeKey, ea.getEntity(), ea);
        this.cypherEngine = cypherEngine;
        this.mappingContext = mappingContext;
        ea.setIdentifier((Object)nativeKey);
    }

    public void run() {
        HashMap<String, Object> simpleProps = new HashMap<String, Object>();
        simpleProps.put("__id__", this.nativeKey);
        for (PersistentProperty pp : this.getEntityAccess().getPersistentEntity().getPersistentProperties()) {
            if (!(pp instanceof Simple)) continue;
            String name = pp.getName();
            Object value = this.getEntityAccess().getProperty(name);
            if (value == null) continue;
            simpleProps.put(name, Neo4jUtils.mapToAllowedNeo4jType(value, this.mappingContext));
        }
        Map<String, List<Object>> dynamicRelProps = Neo4jGormEnhancer.amendMapWithUndeclaredProperties(simpleProps, this.getNativeEntry(), this.mappingContext);
        String labels = ((GraphPersistentEntity)this.entity).getLabelsWithInheritance(this.getEntityAccess().getEntity());
        String cypher = String.format("CREATE (n%s {1})", labels);
        this.cypherEngine.execute(cypher, Collections.singletonList(simpleProps));
        for (Map.Entry<String, List<Object>> e : dynamicRelProps.entrySet()) {
            for (Object o : e.getValue()) {
                GraphPersistentEntity gpe = (GraphPersistentEntity)this.mappingContext.getPersistentEntity(o.getClass().getName());
                cypher = String.format("MATCH (a%s {__id__:{1}}), (b%s {__id__:{2}}) MERGE (a)-[:%s]->(b)", labels, gpe.getLabelsWithInheritance(o), e.getKey());
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(this.nativeKey);
                params.add(new EntityAccess((PersistentEntity)gpe, o).getIdentifier());
                this.cypherEngine.execute(cypher, params);
            }
        }
    }
}

