/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j;

import groovy.lang.GroovyObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import org.grails.datastore.gorm.neo4j.DirtyCheckableAwareCollection;
import org.grails.datastore.gorm.neo4j.DirtyCheckableAwareList;
import org.grails.datastore.gorm.neo4j.DirtyCheckableAwareSet;
import org.grails.datastore.gorm.neo4j.GraphPersistentEntity;
import org.grails.datastore.gorm.neo4j.Neo4jMappingContext;
import org.grails.datastore.gorm.neo4j.Neo4jQuery;
import org.grails.datastore.gorm.neo4j.Neo4jSession;
import org.grails.datastore.gorm.neo4j.NodePendingInsert;
import org.grails.datastore.gorm.neo4j.NodePendingUpdate;
import org.grails.datastore.gorm.neo4j.RelationshipPendingDelete;
import org.grails.datastore.gorm.neo4j.RelationshipPendingInsert;
import org.grails.datastore.gorm.neo4j.RelationshipUtils;
import org.grails.datastore.gorm.neo4j.TypeDirectionPair;
import org.grails.datastore.gorm.neo4j.engine.CypherEngine;
import org.grails.datastore.gorm.neo4j.engine.CypherResult;
import org.grails.datastore.gorm.neo4j.parsers.PlingStemmer;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.impl.PendingInsert;
import org.grails.datastore.mapping.core.impl.PendingUpdate;
import org.grails.datastore.mapping.dirty.checking.DirtyCheckable;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.EntityPersister;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.ManyToMany;
import org.grails.datastore.mapping.model.types.OneToMany;
import org.grails.datastore.mapping.model.types.OneToOne;
import org.grails.datastore.mapping.model.types.Simple;
import org.grails.datastore.mapping.model.types.ToOne;
import org.grails.datastore.mapping.query.Query;
import org.neo4j.helpers.collection.IteratorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class Neo4jEntityPersister
extends EntityPersister {
    private static Logger log = LoggerFactory.getLogger(Neo4jEntityPersister.class);

    public Neo4jEntityPersister(MappingContext mappingContext, PersistentEntity entity, Session session, ApplicationEventPublisher publisher) {
        super(mappingContext, entity, session, publisher);
    }

    public Neo4jSession getSession() {
        return (Neo4jSession)this.session;
    }

    protected List<Object> retrieveAllEntities(PersistentEntity pe, Serializable[] keys) {
        throw new UnsupportedOperationException();
    }

    protected List<Object> retrieveAllEntities(PersistentEntity pe, Iterable<Serializable> keys) {
        ArrayList<Query.In> criterions = new ArrayList<Query.In>(1);
        criterions.add(new Query.In("id", IteratorUtil.asCollection(keys)));
        Query.Conjunction junction = new Query.Conjunction(criterions);
        return new Neo4jQuery(this.session, pe, this).executeQuery(pe, (Query.Junction)junction);
    }

    protected List<Serializable> persistEntities(PersistentEntity pe, Iterable objs) {
        return this.persistEntities(pe, objs, new HashSet());
    }

    protected List<Serializable> persistEntities(PersistentEntity pe, Iterable objs, Collection persistingColl) {
        ArrayList<Serializable> result = new ArrayList<Serializable>();
        for (Object obj : objs) {
            result.add(this.persistEntity(pe, obj, persistingColl));
        }
        return result;
    }

    protected Object retrieveEntity(PersistentEntity pe, Serializable key) {
        ArrayList<Query.IdEquals> criteria = new ArrayList<Query.IdEquals>(1);
        criteria.add(new Query.IdEquals((Object)key));
        return IteratorUtil.singleOrNull(new Neo4jQuery(this.session, pe, this).executeQuery(pe, (Query.Junction)new Query.Conjunction(criteria)).iterator());
    }

    public Object unmarshallOrFromCache(PersistentEntity defaultPersistentEntity, Long id, Collection<String> labels, Map<String, Object> data) {
        PersistentEntity persistentEntity = this.mostSpecificPersistentEntity(defaultPersistentEntity, labels);
        Object instance = this.getSession().getCachedInstance(persistentEntity.getJavaClass(), id);
        if (instance == null) {
            instance = this.unmarshall(persistentEntity, id, data);
            this.getSession().cacheInstance(persistentEntity.getJavaClass(), id, instance);
        }
        return instance;
    }

    private PersistentEntity mostSpecificPersistentEntity(PersistentEntity pe, Collection<String> labels) {
        if (labels.size() == 1) {
            return pe;
        }
        PersistentEntity result = null;
        int longestInheritenceChain = -1;
        for (String l : labels) {
            int inheritenceChain;
            PersistentEntity persistentEntity = this.findDerivedPersistentEntityWithLabel(pe, l);
            if (persistentEntity == null || (inheritenceChain = this.calcInheritenceChain(persistentEntity)) <= longestInheritenceChain) continue;
            longestInheritenceChain = inheritenceChain;
            result = persistentEntity;
        }
        return result;
    }

    private PersistentEntity findDerivedPersistentEntityWithLabel(PersistentEntity parent, String label) {
        for (PersistentEntity pe : this.getMappingContext().getPersistentEntities()) {
            if (!this.isInParentsChain(parent, pe) || !((GraphPersistentEntity)pe).getLabels().contains(label)) continue;
            return pe;
        }
        return null;
    }

    private boolean isInParentsChain(PersistentEntity parent, PersistentEntity it) {
        if (it == null) {
            return false;
        }
        if (it.equals(parent)) {
            return true;
        }
        return this.isInParentsChain(parent, it.getParentEntity());
    }

    private int calcInheritenceChain(PersistentEntity current) {
        if (current == null) {
            return 0;
        }
        return this.calcInheritenceChain(current.getParentEntity()) + 1;
    }

    private Object unmarshall(PersistentEntity persistentEntity, Long id, Map<String, Object> data) {
        Object values;
        log.debug("unmarshalling entity {}, props {}, {}", (Object)id, data);
        EntityAccess entityAccess = new EntityAccess(persistentEntity, persistentEntity.newInstance());
        entityAccess.setConversionService(persistentEntity.getMappingContext().getConversionService());
        entityAccess.setIdentifier((Object)id);
        data.remove("__id__");
        HashMap<TypeDirectionPair, Map> relationshipsMap = new HashMap<TypeDirectionPair, Map>();
        CypherResult relationships = this.getSession().getNativeInterface().execute(String.format("MATCH (m%s {__id__:{1}})-[r]-(o) RETURN type(r) as relType, startNode(r)=m as out, {ids: collect(o.__id__), labels: collect(labels(o))} as values", ((GraphPersistentEntity)persistentEntity).getLabelsAsString()), Collections.singletonList(id));
        Iterator<Object> i$ = relationships.iterator();
        while (i$.hasNext()) {
            Map map = (Map)i$.next();
            String relType = (String)map.get("relType");
            Boolean outGoing = (Boolean)map.get("out");
            values = (Map)map.get("values");
            TypeDirectionPair key = new TypeDirectionPair(relType, outGoing);
            relationshipsMap.put(key, (Map)values);
        }
        for (PersistentProperty persistentProperty : entityAccess.getPersistentEntity().getPersistentProperties()) {
            String propertyName = persistentProperty.getName();
            if (persistentProperty instanceof Simple) {
                entityAccess.setProperty(propertyName, data.remove(propertyName));
                continue;
            }
            if (persistentProperty instanceof Association) {
                Collection targetIds;
                Association association = (Association)persistentProperty;
                TypeDirectionPair typeDirectionPair = new TypeDirectionPair(RelationshipUtils.relationshipTypeUsedFor(association), !RelationshipUtils.useReversedMappingFor(association));
                Map idsAndLabels = (Map)relationshipsMap.remove(typeDirectionPair);
                Collection collection = targetIds = idsAndLabels == null ? null : (Collection)idsAndLabels.get("ids");
                if (association instanceof ToOne) {
                    ToOne toOne = (ToOne)association;
                    if (targetIds == null) continue;
                    Long targetId = (Long)IteratorUtil.single((Iterable)targetIds);
                    entityAccess.setProperty(propertyName, this.getMappingContext().getProxyFactory().createProxy(this.session, toOne.getAssociatedEntity().getJavaClass(), (Serializable)targetId));
                    continue;
                }
                if (association instanceof OneToMany || association instanceof ManyToMany) {
                    Collection values2 = (Collection)entityAccess.getProperty(propertyName);
                    values2 = this.createDirtyCheckableAwareCollection(entityAccess, association, values2);
                    entityAccess.setProperty(propertyName, (Object)values2);
                    if (targetIds == null) continue;
                    for (Long targetId : targetIds) {
                        values2.add(this.getMappingContext().getProxyFactory().createProxy(this.session, association.getAssociatedEntity().getJavaClass(), (Serializable)targetId));
                    }
                    continue;
                }
                throw new IllegalArgumentException("association " + association.getName() + " is of type " + association.getClass().getSuperclass().getName());
            }
            throw new IllegalArgumentException("property " + persistentProperty.getName() + " is of type " + persistentProperty.getClass().getSuperclass().getName());
        }
        if (!relationshipsMap.isEmpty()) {
            for (Map.Entry entry : relationshipsMap.entrySet()) {
                if (!((TypeDirectionPair)entry.getKey()).isOutgoing()) continue;
                Iterator idIter = ((Collection)((Map)entry.getValue()).get("ids")).iterator();
                Iterator labelIter = ((Collection)((Map)entry.getValue()).get("labels")).iterator();
                values = new ArrayList();
                while (idIter.hasNext() && labelIter.hasNext()) {
                    Long targetId = (Long)idIter.next();
                    Collection labels = (Collection)labelIter.next();
                    Object proxy = this.getMappingContext().getProxyFactory().createProxy(this.session, ((Neo4jMappingContext)this.getMappingContext()).findPersistentEntityForLabels(labels).getJavaClass(), (Serializable)targetId);
                    values.add(proxy);
                }
                Object value = values.size() == 1 && this.isSingular(((TypeDirectionPair)entry.getKey()).getType()) ? IteratorUtil.single((Iterable)values) : values;
                data.put(((TypeDirectionPair)entry.getKey()).getType(), value);
            }
        }
        if (!data.isEmpty()) {
            GroovyObject go = (GroovyObject)entityAccess.getEntity();
            go.setProperty("_neo4j_gorm_undecl_", data);
        }
        this.firePostLoadEvent(entityAccess.getPersistentEntity(), entityAccess);
        return entityAccess.getEntity();
    }

    private Collection createCollection(Association association) {
        return association.isList() ? new ArrayList() : new HashSet();
    }

    private Collection createDirtyCheckableAwareCollection(EntityAccess entityAccess, Association association, Collection delegate) {
        if (delegate == null) {
            delegate = this.createCollection(association);
        }
        if (!(delegate instanceof DirtyCheckableAwareCollection)) {
            delegate = association.isList() ? new DirtyCheckableAwareList(entityAccess, association, delegate, this.getSession()) : new DirtyCheckableAwareSet(entityAccess, association, (Set)((Object)delegate), this.getSession());
        }
        return delegate;
    }

    private boolean isSingular(String key) {
        return PlingStemmer.isSingular(key);
    }

    protected Serializable persistEntity(PersistentEntity pe, Object obj) {
        if (obj == null) {
            log.error("obj is null");
            throw new IllegalStateException("obj is null");
        }
        return this.persistEntity(pe, obj, new HashSet());
    }

    protected Serializable persistEntity(PersistentEntity pe, Object obj, Collection persistingColl) {
        boolean isUpdate;
        boolean isDirty;
        if (persistingColl.contains(obj)) {
            return null;
        }
        persistingColl.add(obj);
        boolean bl = isDirty = obj instanceof DirtyCheckable ? ((DirtyCheckable)obj).hasChanged() : true;
        if (this.getSession().containsPersistingInstance(obj) && !isDirty) {
            return null;
        }
        EntityAccess entityAccess = this.createEntityAccess(pe, obj);
        if (this.getMappingContext().getProxyFactory().isProxy(obj)) {
            return (Serializable)entityAccess.getIdentifier();
        }
        this.getSession().addPersistingInstance(obj);
        boolean bl2 = isUpdate = entityAccess.getIdentifier() != null;
        if (isUpdate) {
            if (this.cancelUpdate(pe, entityAccess)) {
                return null;
            }
            this.getSession().addPendingUpdate((PendingUpdate)new NodePendingUpdate(entityAccess, this.getCypherEngine(), this.getMappingContext()));
            this.persistAssociationsOfEntity(pe, entityAccess, true, persistingColl);
            this.firePostUpdateEvent(pe, entityAccess);
        } else {
            if (this.cancelInsert(pe, entityAccess)) {
                return null;
            }
            this.getSession().addPendingInsert((PendingInsert)new NodePendingInsert(this.getSession().getDatastore().nextIdForType(pe), entityAccess, this.getCypherEngine(), this.getMappingContext()));
            this.persistAssociationsOfEntity(pe, entityAccess, false, persistingColl);
            this.firePostInsertEvent(pe, entityAccess);
        }
        return (Serializable)entityAccess.getIdentifier();
    }

    private void persistAssociationsOfEntity(PersistentEntity pe, EntityAccess entityAccess, boolean isUpdate, Collection persistingColl) {
        Object obj = entityAccess.getEntity();
        DirtyCheckable dirtyCheckable = null;
        if (obj instanceof DirtyCheckable) {
            dirtyCheckable = (DirtyCheckable)obj;
        }
        for (PersistentProperty pp : pe.getAssociations()) {
            if (isUpdate && (dirtyCheckable == null || !dirtyCheckable.hasChanged(pp.getName()))) continue;
            Object propertyValue = entityAccess.getProperty(pp.getName());
            if (pp instanceof OneToMany || pp instanceof ManyToMany) {
                Association association = (Association)pp;
                if (propertyValue == null) continue;
                if (association.isBidirectional()) {
                    for (Object associatedObject : (Iterable)propertyValue) {
                        EntityAccess assocEntityAccess = this.createEntityAccess(association.getAssociatedEntity(), associatedObject);
                        assocEntityAccess.setProperty(association.getReferencedPropertyName(), obj);
                    }
                }
                Collection targets = (Collection)propertyValue;
                this.persistEntities(association.getAssociatedEntity(), targets, persistingColl);
                boolean reversed = RelationshipUtils.useReversedMappingFor(association);
                if (reversed) continue;
                Collection dcc = this.createDirtyCheckableAwareCollection(entityAccess, association, targets);
                entityAccess.setProperty(association.getName(), (Object)dcc);
                continue;
            }
            if (pp instanceof ToOne) {
                if (propertyValue == null) continue;
                ToOne to = (ToOne)pp;
                if (to.isBidirectional()) {
                    EntityAccess assocEntityAccess = this.createEntityAccess(to.getAssociatedEntity(), propertyValue);
                    if (to instanceof OneToOne) {
                        assocEntityAccess.setProperty(to.getReferencedPropertyName(), obj);
                    } else {
                        ArrayList<Object> collection = (ArrayList<Object>)assocEntityAccess.getProperty(to.getReferencedPropertyName());
                        if (collection == null) {
                            collection = new ArrayList<Object>();
                            assocEntityAccess.setProperty(to.getReferencedPropertyName(), collection);
                        }
                        if (!collection.contains(obj)) {
                            collection.add(obj);
                        }
                    }
                }
                this.persistEntity(to.getAssociatedEntity(), propertyValue, persistingColl);
                boolean reversed = RelationshipUtils.useReversedMappingFor((Association)to);
                String relType = RelationshipUtils.relationshipTypeUsedFor((Association)to);
                if (reversed) continue;
                if (isUpdate) {
                    this.getSession().addPendingInsert((PendingInsert)new RelationshipPendingDelete(entityAccess, relType, null, this.getCypherEngine()));
                }
                this.getSession().addPendingInsert((PendingInsert)new RelationshipPendingInsert(entityAccess, relType, new EntityAccess(to.getAssociatedEntity(), propertyValue), this.getCypherEngine()));
                continue;
            }
            throw new IllegalArgumentException("wtf don't know how to handle " + pp + "(" + pp.getClass() + ")");
        }
    }

    protected void deleteEntity(PersistentEntity pe, Object obj) {
        EntityAccess entityAccess = this.createEntityAccess(pe, obj);
        if (this.cancelDelete(pe, entityAccess)) {
            return;
        }
        for (Association association : pe.getAssociations()) {
            if (!association.isOwningSide() || !association.doesCascade(CascadeType.REMOVE)) continue;
            log.debug("cascading delete for property " + association.getName());
            GraphPersistentEntity otherPersistentEntity = (GraphPersistentEntity)association.getAssociatedEntity();
            Object otherSideValue = entityAccess.getProperty(association.getName());
            if (association instanceof ToOne) {
                this.deleteEntity((PersistentEntity)otherPersistentEntity, otherSideValue);
                continue;
            }
            this.deleteEntities((PersistentEntity)otherPersistentEntity, (Iterable)otherSideValue);
        }
        this.getCypherEngine().execute(String.format("MATCH (n%s) WHERE n.__id__={1} OPTIONAL MATCH (n)-[r]-() DELETE r,n", ((GraphPersistentEntity)pe).getLabelsAsString()), Collections.singletonList(entityAccess.getIdentifier()));
        this.firePostDeleteEvent(pe, entityAccess);
    }

    protected void deleteEntities(PersistentEntity pe, Iterable objects) {
        ArrayList<EntityAccess> entityAccesses = new ArrayList<EntityAccess>();
        ArrayList<Object> ids = new ArrayList<Object>();
        HashMap cascades = new HashMap();
        for (Object t : objects) {
            EntityAccess entityAccess = this.createEntityAccess(pe, t);
            if (this.cancelDelete(pe, entityAccess)) {
                return;
            }
            entityAccesses.add(entityAccess);
            ids.add(entityAccess.getIdentifier());
            for (Association association : pe.getAssociations()) {
                Object property = entityAccess.getProperty(association.getName());
                if (!association.isOwningSide() || !association.doesCascade(CascadeType.REMOVE) || !this.propertyNotEmpty(property)) continue;
                PersistentEntity associatedEntity = association.getAssociatedEntity();
                ArrayList<Object> cascadesForPersistentEntity = (ArrayList<Object>)cascades.get(associatedEntity);
                if (cascadesForPersistentEntity == null) {
                    cascadesForPersistentEntity = new ArrayList<Object>();
                    cascades.put(associatedEntity, cascadesForPersistentEntity);
                }
                if (association instanceof ToOne) {
                    cascadesForPersistentEntity.add(property);
                    continue;
                }
                cascadesForPersistentEntity.addAll((Collection)property);
            }
        }
        for (Map.Entry entry : cascades.entrySet()) {
            if (((Collection)entry.getValue()).isEmpty()) continue;
            this.deleteEntities((PersistentEntity)entry.getKey(), (Iterable)entry.getValue());
        }
        this.getCypherEngine().execute(String.format("MATCH (n%s) WHERE n.__id__ in {1} OPTIONAL MATCH (n)-[r]-() DELETE r,n", ((GraphPersistentEntity)pe).getLabelsAsString()), Collections.singletonList(ids));
        for (EntityAccess entityAccess : entityAccesses) {
            this.firePostDeleteEvent(pe, entityAccess);
        }
    }

    private boolean propertyNotEmpty(Object property) {
        if (property == null) {
            return false;
        }
        return !(property instanceof Collection) || !((Collection)property).isEmpty();
    }

    public Query createQuery() {
        return new Neo4jQuery(this.session, this.getPersistentEntity(), this);
    }

    public Serializable refresh(Object o) {
        throw new UnsupportedOperationException();
    }

    protected EntityAccess createEntityAccess(PersistentEntity pe, Object obj) {
        return new EntityAccess(pe, obj);
    }

    public CypherEngine getCypherEngine() {
        return (CypherEngine)this.session.getNativeInterface();
    }
}

