/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j.parsers;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class PositionTracker {
    private SortedMap<Integer, Integer> positionMap = new TreeMap<Integer, Integer>();
    private SortedMap<Integer, Integer> positionChanges = new TreeMap<Integer, Integer>();
    private SortedMap<Integer, Integer> old2NewMap = new TreeMap<Integer, Integer>();
    private int accumulatedModifier = 0;

    public void addPositionChange(int pos, int modifier) {
        if (modifier != 0) {
            int oldModifier = 0;
            this.old2NewMap.put(pos, modifier);
            this.accumulatedModifier += modifier;
            if (this.positionChanges.containsKey(pos + this.accumulatedModifier)) {
                oldModifier = (Integer)this.positionChanges.get(pos + this.accumulatedModifier);
            }
            this.positionChanges.put(pos + this.accumulatedModifier, modifier * -1 + oldModifier);
        }
    }

    public void closeRun() {
        if (this.positionChanges.isEmpty()) {
            return;
        }
        SortedMap<Integer, Integer> temp = this.positionChanges;
        while (!this.positionMap.isEmpty()) {
            Integer key = this.positionMap.firstKey();
            Collection<Integer> modifiers = this.old2NewMap.headMap(key + 1).values();
            Integer newposition = key;
            Iterator<Integer> it = modifiers.iterator();
            while (it.hasNext()) {
                newposition = newposition + it.next();
            }
            Integer value = (Integer)this.positionMap.get(key);
            if (this.positionChanges.containsKey(newposition)) {
                value = value + (Integer)this.positionChanges.get(newposition);
            }
            this.positionChanges.put(newposition, value);
            this.positionMap.remove(key);
        }
        this.positionChanges = this.positionMap;
        this.positionMap = temp;
        this.old2NewMap.clear();
        this.accumulatedModifier = 0;
    }

    public Integer translatePosition(Integer pos) {
        SortedMap<Integer, Integer> headMap = this.positionMap.headMap(pos + 1);
        Integer modifier = 0;
        Iterator<Integer> it = headMap.values().iterator();
        while (it.hasNext()) {
            modifier = modifier + it.next();
        }
        return pos + modifier;
    }

    public static class ForwardPositionTracker {
        private SortedMap<Integer, Integer> positionMap = new TreeMap<Integer, Integer>();
        private SortedMap<Integer, Integer> positionChanges = new TreeMap<Integer, Integer>();
        private PositionTracker new2OldTracker = new PositionTracker();

        public void addPositionChange(int pos, int modifier) {
            if (modifier != 0) {
                this.positionChanges.put(pos, modifier);
                this.new2OldTracker.addPositionChange(pos, modifier);
            }
        }

        public void closeRun() {
            if (this.positionChanges.isEmpty()) {
                return;
            }
            for (Map.Entry<Integer, Integer> change : this.positionChanges.entrySet()) {
                Integer positionInOrigStream = this.new2OldTracker.translatePosition(change.getKey());
                if (this.positionMap.containsKey(positionInOrigStream)) {
                    this.positionMap.put(positionInOrigStream, change.getValue() + (Integer)this.positionMap.get(positionInOrigStream));
                    continue;
                }
                this.positionMap.put(positionInOrigStream, change.getValue());
            }
            this.positionChanges.clear();
            this.new2OldTracker.closeRun();
        }

        public boolean hasBeenCutAway(Integer pos) {
            SortedMap<Integer, Integer> tailMap = this.positionMap.tailMap(pos + 1);
            if (tailMap.isEmpty()) {
                return false;
            }
            Integer key = tailMap.firstKey();
            Integer modifier = (Integer)tailMap.get(key);
            return modifier < 0 && key + modifier <= pos;
        }

        public Integer translatePosition(Integer pos) {
            SortedMap<Integer, Integer> headMap = this.positionMap.headMap(pos + 1);
            Integer modifier = 0;
            Iterator<Integer> it = headMap.values().iterator();
            while (it.hasNext()) {
                modifier = modifier + it.next();
            }
            return pos + modifier;
        }

        public Integer translatePositionExactly(Integer pos) {
            SortedMap<Integer, Integer> tailMap = this.positionMap.tailMap(pos + 1);
            if (tailMap.isEmpty()) {
                return this.translatePosition(pos);
            }
            Integer key = tailMap.firstKey();
            Integer modifier = (Integer)tailMap.get(key);
            return this.translatePosition(Math.min(pos, key + modifier));
        }
    }
}

