/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j.engine;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;
import org.grails.datastore.gorm.neo4j.engine.CypherEngine;
import org.grails.datastore.gorm.neo4j.engine.CypherResult;
import org.grails.datastore.gorm.neo4j.engine.JdbcCypherResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcCypherEngine
implements CypherEngine {
    private static Logger log = LoggerFactory.getLogger(JdbcCypherEngine.class);
    private final DataSource dataSource;
    private ThreadLocal<Connection> connectionThreadLocal = new ThreadLocal();

    public JdbcCypherEngine(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    private Connection getOrInitConnectionThreadLocal() {
        Connection connection = this.connectionThreadLocal.get();
        if (connection == null) {
            try {
                connection = this.dataSource.getConnection();
                this.connectionThreadLocal.set(connection);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return connection;
    }

    @Override
    public CypherResult execute(String cypher, List params) {
        try {
            Connection connection = this.getOrInitConnectionThreadLocal();
            this.logCypher(cypher, params);
            PreparedStatement ps = connection.prepareStatement(cypher);
            for (int i = 0; i < params.size(); ++i) {
                ps.setObject(i + 1, params.get(i));
            }
            ResultSet rs = ps.executeQuery();
            return new JdbcCypherResult(rs);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void logCypher(String cypher, Object params) {
        log.info("running cypher {}", (Object)cypher);
        if (params != null) {
            log.info("   with params {}", params);
        }
    }

    @Override
    public CypherResult execute(String cypher) {
        try {
            Connection connection = this.getOrInitConnectionThreadLocal();
            this.logCypher(cypher, null);
            Statement statement = connection.createStatement();
            ResultSet rs = statement.executeQuery(cypher);
            return new JdbcCypherResult(rs);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void beginTx() {
        if (this.connectionThreadLocal.get() == null) {
            log.info("beginTx");
            this.getOrInitConnectionThreadLocal();
        }
    }

    @Override
    public void commit() {
        Connection connection = this.connectionThreadLocal.get();
        if (connection != null) {
            try {
                log.info("commit");
                connection.commit();
                connection.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.connectionThreadLocal.remove();
            }
        }
    }

    @Override
    public void rollback() {
        Connection connection = this.connectionThreadLocal.get();
        if (connection != null) {
            try {
                log.info("rollback");
                connection.rollback();
                connection.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.connectionThreadLocal.remove();
            }
        }
    }
}

